/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#include<konoha/konoha_dev.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

/* ======================================================================== */
/* [struct] */

void knh_tstruct_ginit_(void)
{
	Ctx *ctx = NULL;
	KNH_TSTRUCT(ctx, 0, 0, "Tuple0", NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT(ctx, STRUCT_Tuple1, sizeof(knh_Tuple1),
		"Tuple1",
		knh_Tuple1_struct_init,
		knh_Tuple1_struct_copy, 
		knh_Tuple1_struct_compare, 
		knh_Tuple1_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Tuple2, sizeof(knh_Tuple2),
		"Tuple2",
		knh_Tuple2_struct_init,
		knh_Tuple2_struct_copy, 
		knh_Tuple2_struct_compare, 
		knh_Tuple2_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Tuple3, sizeof(knh_Tuple3),
		"Tuple3",
		knh_Tuple3_struct_init,
		knh_Tuple3_struct_copy, 
		knh_Tuple3_struct_compare, 
		knh_Tuple3_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Tuple4, sizeof(knh_Tuple4),
		"Tuple4",
		knh_Tuple4_struct_init,
		knh_Tuple4_struct_copy, 
		knh_Tuple4_struct_compare, 
		knh_Tuple4_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Tuple5, sizeof(knh_Tuple5),
		"Tuple5",
		knh_Tuple5_struct_init,
		knh_Tuple5_struct_copy, 
		knh_Tuple5_struct_compare, 
		knh_Tuple5_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Tuple6, sizeof(knh_Tuple6),
		"Tuple6",
		knh_Tuple6_struct_init,
		knh_Tuple6_struct_copy, 
		knh_Tuple6_struct_compare, 
		knh_Tuple6_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Tuple7, sizeof(knh_Tuple7),
		"Tuple7",
		knh_Tuple7_struct_init,
		knh_Tuple7_struct_copy, 
		knh_Tuple7_struct_compare, 
		knh_Tuple7_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Tuple8, sizeof(knh_Tuple8),
		"Tuple8",
		knh_Tuple8_struct_init,
		knh_Tuple8_struct_copy, 
		knh_Tuple8_struct_compare, 
		knh_Tuple8_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Tuple9, sizeof(knh_Tuple9),
		"Tuple9",
		knh_Tuple9_struct_init,
		knh_Tuple9_struct_copy, 
		knh_Tuple9_struct_compare, 
		knh_Tuple9_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Tuple10, sizeof(knh_Tuple10),
		"Tuple10",
		knh_Tuple10_struct_init,
		knh_Tuple10_struct_copy, 
		knh_Tuple10_struct_compare, 
		knh_Tuple10_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Tuple11, sizeof(knh_Tuple11),
		"Tuple11",
		knh_Tuple11_struct_init,
		knh_Tuple11_struct_copy, 
		knh_Tuple11_struct_compare, 
		knh_Tuple11_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Tuple12, sizeof(knh_Tuple12),
		"Tuple12",
		knh_Tuple12_struct_init,
		knh_Tuple12_struct_copy, 
		knh_Tuple12_struct_compare, 
		knh_Tuple12_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Tuple13, sizeof(knh_Tuple13),
		"Tuple13",
		knh_Tuple13_struct_init,
		knh_Tuple13_struct_copy, 
		knh_Tuple13_struct_compare, 
		knh_Tuple13_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Tuple14, sizeof(knh_Tuple14),
		"Tuple14",
		knh_Tuple14_struct_init,
		knh_Tuple14_struct_copy, 
		knh_Tuple14_struct_compare, 
		knh_Tuple14_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Tuple15, sizeof(knh_Tuple15),
		"Tuple15",
		knh_Tuple15_struct_init,
		knh_Tuple15_struct_copy, 
		knh_Tuple15_struct_compare, 
		knh_Tuple15_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Prototype, sizeof(knh_Prototype),
		"Prototype",
		knh_Prototype_struct_init,
		knh_Prototype_struct_copy, 
		knh_Prototype_struct_compare, 
		knh_Prototype_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Nue, sizeof(knh_Nue),
		"Nue",
		knh_Nue_struct_init,
		knh_Nue_struct_copy, 
		knh_Nue_struct_compare, 
		knh_Nue_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Bool, sizeof(knh_Bool),
		"Bool",
		knh_Bool_struct_init,
		knh_Bool_struct_copy, 
		knh_Bool_struct_compare, 
		knh_Bool_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Int, sizeof(knh_Int),
		"Int",
		knh_Int_struct_init,
		knh_Int_struct_copy, 
		knh_Int_struct_compare, 
		knh_Int_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Int64, sizeof(knh_Int64),
		"Int64",
		knh_Int64_struct_init,
		knh_Int64_struct_copy, 
		knh_Int64_struct_compare, 
		knh_Int64_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Float, sizeof(knh_Float),
		"Float",
		knh_Float_struct_init,
		knh_Float_struct_copy, 
		knh_Float_struct_compare, 
		knh_Float_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_String, sizeof(knh_String),
		"String",
		knh_String_struct_init,
		knh_String_struct_copy, 
		knh_String_struct_compare, 
		knh_String_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Bytes, sizeof(knh_Bytes),
		"Bytes",
		knh_Bytes_struct_init,
		knh_Bytes_struct_copy, 
		knh_Bytes_struct_compare, 
		knh_Bytes_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Regex, sizeof(knh_Regex),
		"Regex",
		knh_Regex_struct_init,
		knh_Regex_struct_copy, 
		knh_Regex_struct_compare, 
		knh_Regex_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Array, sizeof(knh_Array),
		"Array",
		knh_Array_struct_init,
		knh_Array_struct_copy, 
		knh_Array_struct_compare, 
		knh_Array_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_HashMap, sizeof(knh_HashMap),
		"HashMap",
		knh_HashMap_struct_init,
		knh_HashMap_struct_copy, 
		knh_HashMap_struct_compare, 
		knh_HashMap_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_HashSet, sizeof(knh_HashSet),
		"HashSet",
		knh_HashSet_struct_init,
		knh_HashSet_struct_copy, 
		knh_HashSet_struct_compare, 
		knh_HashSet_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_DictMap, sizeof(knh_DictMap),
		"DictMap",
		knh_DictMap_struct_init,
		knh_DictMap_struct_copy, 
		knh_DictMap_struct_compare, 
		knh_DictMap_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_DictSet, sizeof(knh_DictSet),
		"DictSet",
		knh_DictSet_struct_init,
		knh_DictSet_struct_copy, 
		knh_DictSet_struct_compare, 
		knh_DictSet_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Iterator, sizeof(knh_Iterator),
		"Iterator",
		knh_Iterator_struct_init,
		knh_Iterator_struct_copy, 
		knh_Iterator_struct_compare, 
		knh_Iterator_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_DictIdx, sizeof(knh_DictIdx),
		"DictIdx",
		knh_DictIdx_struct_init,
		knh_DictIdx_struct_copy, 
		knh_DictIdx_struct_compare, 
		knh_DictIdx_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Class, sizeof(knh_Class),
		"Class",
		knh_Class_struct_init,
		knh_Class_struct_copy, 
		knh_Class_struct_compare, 
		knh_Class_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_ClassStruct, sizeof(knh_ClassStruct),
		"ClassStruct",
		knh_ClassStruct_struct_init,
		knh_ClassStruct_struct_copy, 
		knh_ClassStruct_struct_compare, 
		knh_ClassStruct_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_MethodField, sizeof(knh_MethodField),
		"MethodField",
		knh_MethodField_struct_init,
		knh_MethodField_struct_copy, 
		knh_MethodField_struct_compare, 
		knh_MethodField_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Method, sizeof(knh_Method),
		"Method",
		knh_Method_struct_init,
		knh_Method_struct_copy, 
		knh_Method_struct_compare, 
		knh_Method_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_MapMap, sizeof(knh_MapMap),
		"MapMap",
		knh_MapMap_struct_init,
		knh_MapMap_struct_copy, 
		knh_MapMap_struct_compare, 
		knh_MapMap_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_ClassRel, sizeof(knh_ClassRel),
		"ClassRel",
		knh_ClassRel_struct_init,
		knh_ClassRel_struct_copy, 
		knh_ClassRel_struct_compare, 
		knh_ClassRel_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_IntUnit, sizeof(knh_IntUnit),
		"IntUnit",
		knh_IntUnit_struct_init,
		knh_IntUnit_struct_copy, 
		knh_IntUnit_struct_compare, 
		knh_IntUnit_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_FloatUnit, sizeof(knh_FloatUnit),
		"FloatUnit",
		knh_FloatUnit_struct_init,
		knh_FloatUnit_struct_copy, 
		knh_FloatUnit_struct_compare, 
		knh_FloatUnit_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Vocabulary, sizeof(knh_Vocabulary),
		"Vocabulary",
		knh_Vocabulary_struct_init,
		knh_Vocabulary_struct_copy, 
		knh_Vocabulary_struct_compare, 
		knh_Vocabulary_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_AffineConv, sizeof(knh_AffineConv),
		"AffineConv",
		knh_AffineConv_struct_init,
		knh_AffineConv_struct_copy, 
		knh_AffineConv_struct_compare, 
		knh_AffineConv_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_StreamStat, sizeof(knh_StreamStat),
		"StreamStat",
		knh_StreamStat_struct_init,
		knh_StreamStat_struct_copy, 
		knh_StreamStat_struct_compare, 
		knh_StreamStat_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_InputStream, sizeof(knh_InputStream),
		"InputStream",
		knh_InputStream_struct_init,
		knh_InputStream_struct_copy, 
		knh_InputStream_struct_compare, 
		knh_InputStream_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_OutputStream, sizeof(knh_OutputStream),
		"OutputStream",
		knh_OutputStream_struct_init,
		knh_OutputStream_struct_copy, 
		knh_OutputStream_struct_compare, 
		knh_OutputStream_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Writer, sizeof(knh_Writer),
		"Writer",
		knh_Writer_struct_init,
		knh_Writer_struct_copy, 
		knh_Writer_struct_compare, 
		knh_Writer_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_MovableText, sizeof(knh_MovableText),
		"MovableText",
		knh_MovableText_struct_init,
		knh_MovableText_struct_copy, 
		knh_MovableText_struct_compare, 
		knh_MovableText_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Exception, sizeof(knh_Exception),
		"Exception",
		knh_Exception_struct_init,
		knh_Exception_struct_copy, 
		knh_Exception_struct_compare, 
		knh_Exception_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Runtime, sizeof(knh_Runtime),
		"Runtime",
		knh_Runtime_struct_init,
		knh_Runtime_struct_copy, 
		knh_Runtime_struct_compare, 
		knh_Runtime_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Context, sizeof(knh_Context),
		"Context",
		knh_Context_struct_init,
		knh_Context_struct_copy, 
		knh_Context_struct_compare, 
		knh_Context_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_ExceptionHandler, sizeof(knh_ExceptionHandler),
		"ExceptionHandler",
		knh_ExceptionHandler_struct_init,
		knh_ExceptionHandler_struct_copy, 
		knh_ExceptionHandler_struct_compare, 
		knh_ExceptionHandler_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Mutex, sizeof(knh_Mutex),
		"Mutex",
		knh_Mutex_struct_init,
		knh_Mutex_struct_copy, 
		knh_Mutex_struct_compare, 
		knh_Mutex_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Amazon, sizeof(knh_Amazon),
		"Amazon",
		knh_Amazon_struct_init,
		knh_Amazon_struct_copy, 
		knh_Amazon_struct_compare, 
		knh_Amazon_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Token, sizeof(knh_Token),
		"Token",
		knh_Token_struct_init,
		knh_Token_struct_copy, 
		knh_Token_struct_compare, 
		knh_Token_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Stmt, sizeof(knh_Stmt),
		"Stmt",
		knh_Stmt_struct_init,
		knh_Stmt_struct_copy, 
		knh_Stmt_struct_compare, 
		knh_Stmt_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_Cmpl, sizeof(knh_Cmpl),
		"Cmpl",
		knh_Cmpl_struct_init,
		knh_Cmpl_struct_copy, 
		knh_Cmpl_struct_compare, 
		knh_Cmpl_struct_traverse);
	KNH_TSTRUCT(ctx, STRUCT_VirtualMachineCode, sizeof(knh_VirtualMachineCode),
		"VirtualMachineCode",
		knh_VirtualMachineCode_struct_init,
		knh_VirtualMachineCode_struct_copy, 
		knh_VirtualMachineCode_struct_compare, 
		knh_VirtualMachineCode_struct_traverse);
}

/* ======================================================================== */
/* [class] */

void knh_tclass_ginit_(void)
{
	Ctx *ctx = NULL;
	KNH_TCLASS(ctx, CF_Object, new_String__STEXT(ctx, CLASS_String__class, "Object"),
		CLASS_Object, STRUCT_Object, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Tuple1, new_String__STEXT(ctx, CLASS_String__class, "Tuple1"),
		CLASS_Tuple1, STRUCT_Tuple1, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Tuple2, new_String__STEXT(ctx, CLASS_String__class, "Tuple2"),
		CLASS_Tuple2, STRUCT_Tuple2, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Tuple3, new_String__STEXT(ctx, CLASS_String__class, "Tuple3"),
		CLASS_Tuple3, STRUCT_Tuple3, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Tuple4, new_String__STEXT(ctx, CLASS_String__class, "Tuple4"),
		CLASS_Tuple4, STRUCT_Tuple4, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Tuple5, new_String__STEXT(ctx, CLASS_String__class, "Tuple5"),
		CLASS_Tuple5, STRUCT_Tuple5, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Tuple6, new_String__STEXT(ctx, CLASS_String__class, "Tuple6"),
		CLASS_Tuple6, STRUCT_Tuple6, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Tuple7, new_String__STEXT(ctx, CLASS_String__class, "Tuple7"),
		CLASS_Tuple7, STRUCT_Tuple7, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Tuple8, new_String__STEXT(ctx, CLASS_String__class, "Tuple8"),
		CLASS_Tuple8, STRUCT_Tuple8, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Tuple9, new_String__STEXT(ctx, CLASS_String__class, "Tuple9"),
		CLASS_Tuple9, STRUCT_Tuple9, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Tuple10, new_String__STEXT(ctx, CLASS_String__class, "Tuple10"),
		CLASS_Tuple10, STRUCT_Tuple10, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Tuple11, new_String__STEXT(ctx, CLASS_String__class, "Tuple11"),
		CLASS_Tuple11, STRUCT_Tuple11, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Tuple12, new_String__STEXT(ctx, CLASS_String__class, "Tuple12"),
		CLASS_Tuple12, STRUCT_Tuple12, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Tuple13, new_String__STEXT(ctx, CLASS_String__class, "Tuple13"),
		CLASS_Tuple13, STRUCT_Tuple13, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Tuple14, new_String__STEXT(ctx, CLASS_String__class, "Tuple14"),
		CLASS_Tuple14, STRUCT_Tuple14, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Tuple15, new_String__STEXT(ctx, CLASS_String__class, "Tuple15"),
		CLASS_Tuple15, STRUCT_Tuple15, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Prototype, new_String__STEXT(ctx, CLASS_String__class, "Prototype"),
		CLASS_Prototype, STRUCT_Prototype, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Nue, new_String__STEXT(ctx, CLASS_String__class, "Nue"),
		CLASS_Nue, STRUCT_Nue, CLASS_Object,
		Null,knh_Nue_fvalue, 
		0);
	KNH_TCLASS(ctx, CF_Bool, new_String__STEXT(ctx, CLASS_String__class, "Bool"),
		CLASS_Bool, STRUCT_Bool, CLASS_Object,
		Null,knh_Bool_fvalue, 
		0);
	KNH_TCLASS(ctx, CF_Int, new_String__STEXT(ctx, CLASS_String__class, "Int"),
		CLASS_Int, STRUCT_Int, CLASS_Object,
		knh_Int_spec(ctx),NULL, 
		0);
	KNH_TCLASS(ctx, CF_Int64, new_String__STEXT(ctx, CLASS_String__class, "Int64"),
		CLASS_Int64, STRUCT_Int64, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Float, new_String__STEXT(ctx, CLASS_String__class, "Float"),
		CLASS_Float, STRUCT_Float, CLASS_Object,
		knh_Float_spec(ctx),NULL, 
		0);
	KNH_TCLASS(ctx, CF_String, new_String__STEXT(ctx, CLASS_String__class, "String"),
		CLASS_String, STRUCT_String, CLASS_Object,
		knh_String_spec(ctx),NULL, 
		0);
	KNH_TCLASS(ctx, CF_Bytes, new_String__STEXT(ctx, CLASS_String__class, "Bytes"),
		CLASS_Bytes, STRUCT_Bytes, CLASS_Object,
		Null,knh_Bytes_fvalue, 
		0);
	KNH_TCLASS(ctx, CF_Regex, new_String__STEXT(ctx, CLASS_String__class, "Regex"),
		CLASS_Regex, STRUCT_Regex, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Array, new_String__STEXT(ctx, CLASS_String__class, "Array"),
		CLASS_Array, STRUCT_Array, CLASS_Object,
		Null,knh_Array_fvalue, 
		0);
	KNH_TCLASS(ctx, CF_HashMap, new_String__STEXT(ctx, CLASS_String__class, "HashMap"),
		CLASS_HashMap, STRUCT_HashMap, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_HashSet, new_String__STEXT(ctx, CLASS_String__class, "HashSet"),
		CLASS_HashSet, STRUCT_HashSet, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_DictMap, new_String__STEXT(ctx, CLASS_String__class, "DictMap"),
		CLASS_DictMap, STRUCT_DictMap, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_DictSet, new_String__STEXT(ctx, CLASS_String__class, "DictSet"),
		CLASS_DictSet, STRUCT_DictSet, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Iterator, new_String__STEXT(ctx, CLASS_String__class, "Iterator"),
		CLASS_Iterator, STRUCT_Iterator, CLASS_Object,
		Null,knh_Iterator_fvalue, 
		0);
	KNH_TCLASS(ctx, CF_DictIdx, new_String__STEXT(ctx, CLASS_String__class, "DictIdx"),
		CLASS_DictIdx, STRUCT_DictIdx, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Class, new_String__STEXT(ctx, CLASS_String__class, "Class"),
		CLASS_Class, STRUCT_Class, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_ClassStruct, new_String__STEXT(ctx, CLASS_String__class, "ClassStruct"),
		CLASS_ClassStruct, STRUCT_ClassStruct, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_MethodField, new_String__STEXT(ctx, CLASS_String__class, "MethodField"),
		CLASS_MethodField, STRUCT_MethodField, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Method, new_String__STEXT(ctx, CLASS_String__class, "Method"),
		CLASS_Method, STRUCT_Method, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_MapMap, new_String__STEXT(ctx, CLASS_String__class, "MapMap"),
		CLASS_MapMap, STRUCT_MapMap, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_ClassRel, new_String__STEXT(ctx, CLASS_String__class, "ClassRel"),
		CLASS_ClassRel, STRUCT_ClassRel, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_IntUnit, new_String__STEXT(ctx, CLASS_String__class, "IntUnit"),
		CLASS_IntUnit, STRUCT_IntUnit, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_FloatUnit, new_String__STEXT(ctx, CLASS_String__class, "FloatUnit"),
		CLASS_FloatUnit, STRUCT_FloatUnit, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Vocabulary, new_String__STEXT(ctx, CLASS_String__class, "Vocabulary"),
		CLASS_Vocabulary, STRUCT_Vocabulary, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_AffineConv, new_String__STEXT(ctx, CLASS_String__class, "AffineConv"),
		CLASS_AffineConv, STRUCT_AffineConv, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_StreamStat, new_String__STEXT(ctx, CLASS_String__class, "StreamStat"),
		CLASS_StreamStat, STRUCT_StreamStat, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_InputStream, new_String__STEXT(ctx, CLASS_String__class, "InputStream"),
		CLASS_InputStream, STRUCT_InputStream, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_OutputStream, new_String__STEXT(ctx, CLASS_String__class, "OutputStream"),
		CLASS_OutputStream, STRUCT_OutputStream, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Writer, new_String__STEXT(ctx, CLASS_String__class, "Writer"),
		CLASS_Writer, STRUCT_Writer, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_MovableText, new_String__STEXT(ctx, CLASS_String__class, "MovableText"),
		CLASS_MovableText, STRUCT_MovableText, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Exception, new_String__STEXT(ctx, CLASS_String__class, "Exception"),
		CLASS_Exception, STRUCT_Exception, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Runtime, new_String__STEXT(ctx, CLASS_String__class, "Runtime"),
		CLASS_Runtime, STRUCT_Runtime, CLASS_Object,
		Null,knh_Runtime_fvalue, 
		0);
	KNH_TCLASS(ctx, CF_Context, new_String__STEXT(ctx, CLASS_String__class, "Context"),
		CLASS_Context, STRUCT_Context, CLASS_Object,
		Null,knh_Context_fvalue, 
		0);
	KNH_TCLASS(ctx, CF_ExceptionHandler, new_String__STEXT(ctx, CLASS_String__class, "ExceptionHandler"),
		CLASS_ExceptionHandler, STRUCT_ExceptionHandler, CLASS_Object,
		Null,knh_ExceptionHandler_fvalue, 
		0);
	KNH_TCLASS(ctx, CF_Mutex, new_String__STEXT(ctx, CLASS_String__class, "Mutex"),
		CLASS_Mutex, STRUCT_Mutex, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Amazon, new_String__STEXT(ctx, CLASS_String__class, "Amazon"),
		CLASS_Amazon, STRUCT_Amazon, CLASS_Object,
		Null,knh_Amazon_fvalue, 
		0);
	KNH_TCLASS(ctx, CF_Token, new_String__STEXT(ctx, CLASS_String__class, "konohac.Token"),
		CLASS_Token, STRUCT_Token, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Stmt, new_String__STEXT(ctx, CLASS_String__class, "konohac.Stmt"),
		CLASS_Stmt, STRUCT_Stmt, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Cmpl, new_String__STEXT(ctx, CLASS_String__class, "konohac.Cmpl"),
		CLASS_Cmpl, STRUCT_Cmpl, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_VirtualMachineCode, new_String__STEXT(ctx, CLASS_String__class, "konohac.VirtualMachineCode"),
		CLASS_VirtualMachineCode, STRUCT_VirtualMachineCode, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_Closure, new_String__STEXT(ctx, CLASS_String__class, "Closure"),
		CLASS_Closure, STRUCT_Closure, CLASS_Object,
		Null,NULL, 
		0);
	KNH_TCLASS(ctx, CF_System, new_String__STEXT(ctx, CLASS_String__class, "System"),
		CLASS_System, STRUCT_System, CLASS_Object,
		Null,knh_System_fvalue, 
		0);
	KNH_TCLASS(ctx, CF_NameSpace, new_String__STEXT(ctx, CLASS_String__class, "NameSpace"),
		CLASS_NameSpace, STRUCT_NameSpace, CLASS_Object,
		Null,NULL, 
		0);
}

/* ------------------------------------------------------------------------ */

void knh__Object_getClass(Ctx *ctx, Object **sf); 
void knh__Object_compare(Ctx *ctx, Object **sf); 
void knh__Object_opEq(Ctx *ctx, Object **sf); 
void knh__Object_opNeq(Ctx *ctx, Object **sf); 
void knh__Object_opLt(Ctx *ctx, Object **sf); 
void knh__Object_opLte(Ctx *ctx, Object **sf); 
void knh__Object_opGt(Ctx *ctx, Object **sf); 
void knh__Object_opGte(Ctx *ctx, Object **sf); 
void knh__Object_opNot(Ctx *ctx, Object **sf); 
void knh__Object_opSeq(Ctx *ctx, Object **sf); 
void knh__Object_opIsMapTo(Ctx *ctx, Object **sf); 
void knh__Object__s(Ctx *ctx, Object **sf); 
void knh__Object__dump(Ctx *ctx, Object **sf); 
void knh__Object__empty(Ctx *ctx, Object **sf); 
void knh__Object__refc(Ctx *ctx, Object **sf); 
void knh__Object__addr(Ctx *ctx, Object **sf); 
void knh__Object_opInstanceof(Ctx *ctx, Object **sf); 
void knh__Prototype__dump(Ctx *ctx, Object **sf); 
void knh__Nue__s(Ctx *ctx, Object **sf); 
void knh__Bool__s(Ctx *ctx, Object **sf); 
void knh__Int_opAdd(Ctx *ctx, Object **sf); 
void knh__Int_opSub(Ctx *ctx, Object **sf); 
void knh__Int_opMul(Ctx *ctx, Object **sf); 
void knh__Int_opDiv(Ctx *ctx, Object **sf); 
void knh__Int_opMod(Ctx *ctx, Object **sf); 
void knh__Int_opEq(Ctx *ctx, Object **sf); 
void knh__Int_opBitAnd(Ctx *ctx, Object **sf); 
void knh__Int_opBitOr(Ctx *ctx, Object **sf); 
void knh__Int_opLShift(Ctx *ctx, Object **sf); 
void knh__Int_opRShift(Ctx *ctx, Object **sf); 
void knh__Int_opBitXor(Ctx *ctx, Object **sf); 
void knh__Int_opBitNot(Ctx *ctx, Object **sf); 
void knh__Int__s(Ctx *ctx, Object **sf); 
void knh__Int__x(Ctx *ctx, Object **sf); 
void knh__Int__bits(Ctx *ctx, Object **sf); 
void knh__Int64__dump(Ctx *ctx, Object **sf); 
void knh__Float_opAdd(Ctx *ctx, Object **sf); 
void knh__Float_opSub(Ctx *ctx, Object **sf); 
void knh__Float_opMul(Ctx *ctx, Object **sf); 
void knh__Float_opDiv(Ctx *ctx, Object **sf); 
void knh__Float__s(Ctx *ctx, Object **sf); 
void knh__Float__dump(Ctx *ctx, Object **sf); 
void knh__String_equals(Ctx *ctx, Object **sf); 
void knh__String_startsWith(Ctx *ctx, Object **sf); 
void knh__String_endsWith(Ctx *ctx, Object **sf); 
void knh__String_getSize(Ctx *ctx, Object **sf); 
void knh__String_opAdd(Ctx *ctx, Object **sf); 
void knh__String_opMul(Ctx *ctx, Object **sf); 
void knh__String__s(Ctx *ctx, Object **sf); 
void knh__String__dump(Ctx *ctx, Object **sf); 
void knh__Bytes_new(Ctx *ctx, Object **sf); 
void knh__Bytes_clear(Ctx *ctx, Object **sf); 
void knh__Bytes_write(Ctx *ctx, Object **sf); 
void knh__Regex_match(Ctx *ctx, Object **sf); 
void knh__Regex__s(Ctx *ctx, Object **sf); 
void knh__Regex__dump(Ctx *ctx, Object **sf); 
void knh__Array_new(Ctx *ctx, Object **sf); 
void knh__Array_new__array(Ctx *ctx, Object **sf); 
void knh__Array_new__init(Ctx *ctx, Object **sf); 
void knh__Array_get__fast(Ctx *ctx, Object **sf); 
void knh__Array_set__fast(Ctx *ctx, Object **sf); 
void knh__Array_get(Ctx *ctx, Object **sf); 
void knh__Array_set(Ctx *ctx, Object **sf); 
void knh__Array_add__fast(Ctx *ctx, Object **sf); 
void knh__Array_add(Ctx *ctx, Object **sf); 
void knh__Array_pop(Ctx *ctx, Object **sf); 
void knh__Array_slice(Ctx *ctx, Object **sf); 
void knh__Array_clear(Ctx *ctx, Object **sf); 
void knh__Array__dump(Ctx *ctx, Object **sf); 
void knh__HashMap_new(Ctx *ctx, Object **sf); 
void knh__HashMap_new__init(Ctx *ctx, Object **sf); 
void knh__HashMap_get(Ctx *ctx, Object **sf); 
void knh__HashMap_set(Ctx *ctx, Object **sf); 
void knh__HashMap_remove(Ctx *ctx, Object **sf); 
void knh__HashMap_opIn(Ctx *ctx, Object **sf); 
void knh__HashMap_keys(Ctx *ctx, Object **sf); 
void knh__HashMap__dump(Ctx *ctx, Object **sf); 
void knh__HashSet_new(Ctx *ctx, Object **sf); 
void knh__HashSet_get(Ctx *ctx, Object **sf); 
void knh__HashSet_opIn(Ctx *ctx, Object **sf); 
void knh__HashSet_set(Ctx *ctx, Object **sf); 
void knh__HashSet_add(Ctx *ctx, Object **sf); 
void knh__HashSet_remove(Ctx *ctx, Object **sf); 
void knh__HashSet__dump(Ctx *ctx, Object **sf); 
void knh__DictMap_new(Ctx *ctx, Object **sf); 
void knh__DictMap_new__init(Ctx *ctx, Object **sf); 
void knh__DictMap_get(Ctx *ctx, Object **sf); 
void knh__DictMap_append(Ctx *ctx, Object **sf); 
void knh__DictMap_set(Ctx *ctx, Object **sf); 
void knh__DictMap_remove(Ctx *ctx, Object **sf); 
void knh__DictMap_clear(Ctx *ctx, Object **sf); 
void knh__DictMap__dump(Ctx *ctx, Object **sf); 
void knh__DictSet_new(Ctx *ctx, Object **sf); 
void knh__DictSet_get(Ctx *ctx, Object **sf); 
void knh__DictSet_opIn(Ctx *ctx, Object **sf); 
void knh__DictSet_set(Ctx *ctx, Object **sf); 
void knh__DictSet_add(Ctx *ctx, Object **sf); 
void knh__DictSet_clear(Ctx *ctx, Object **sf); 
void knh__DictSet__dump(Ctx *ctx, Object **sf); 
void knh__Iterator__dump(Ctx *ctx, Object **sf); 
void knh__DictIdx_index(Ctx *ctx, Object **sf); 
void knh__DictIdx_add__fast(Ctx *ctx, Object **sf); 
void knh__DictIdx_add(Ctx *ctx, Object **sf); 
void knh__DictIdx_get__fast(Ctx *ctx, Object **sf); 
void knh__DictIdx_get(Ctx *ctx, Object **sf); 
void knh__DictIdx_clear(Ctx *ctx, Object **sf); 
void knh__DictIdx__dump(Ctx *ctx, Object **sf); 
void knh__Class__s(Ctx *ctx, Object **sf); 
void knh__Class__dump(Ctx *ctx, Object **sf); 
void knh__Class_isSingleton(Ctx *ctx, Object **sf); 
void knh__Method__code(Ctx *ctx, Object **sf); 
void knh__Method_isAbstract(Ctx *ctx, Object **sf); 
void knh__Method_getName(Ctx *ctx, Object **sf); 
void knh__Method_getURN(Ctx *ctx, Object **sf); 
void knh__Method__s(Ctx *ctx, Object **sf); 
void knh__Method__dump(Ctx *ctx, Object **sf); 
void knh__MapMap__dump(Ctx *ctx, Object **sf); 
void knh__ClassRel__dump(Ctx *ctx, Object **sf); 
void knh__InputStream_close(Ctx *ctx, Object **sf); 
void knh__InputStream__dump(Ctx *ctx, Object **sf); 
void knh__OutputStream_write(Ctx *ctx, Object **sf); 
void knh__OutputStream_flush(Ctx *ctx, Object **sf); 
void knh__OutputStream_close(Ctx *ctx, Object **sf); 
void knh__OutputStream__dump(Ctx *ctx, Object **sf); 
void knh__Writer_write(Ctx *ctx, Object **sf); 
void knh__Writer_flush(Ctx *ctx, Object **sf); 
void knh__Writer_writeLine(Ctx *ctx, Object **sf); 
void knh__Writer_writeTab(Ctx *ctx, Object **sf); 
void knh__MovableText__s(Ctx *ctx, Object **sf); 
void knh__MovableText__dump(Ctx *ctx, Object **sf); 
void knh__Exception_new(Ctx *ctx, Object **sf); 
void knh__Exception__s(Ctx *ctx, Object **sf); 
void knh__Exception__dump(Ctx *ctx, Object **sf); 
void knh__Context_getProperty(Ctx *ctx, Object **sf); 
void knh__Context_setProperty(Ctx *ctx, Object **sf); 
void knh__Context__dump(Ctx *ctx, Object **sf); 
void knh__Context_getRuntime(Ctx *ctx, Object **sf); 
void knh__Mutex__dump(Ctx *ctx, Object **sf); 
void knh__Amazon_placeOrder(Ctx *ctx, Object **sf); 
void knh__Token__s(Ctx *ctx, Object **sf); 
void knh__Token__dump(Ctx *ctx, Object **sf); 
void knh__Stmt__s(Ctx *ctx, Object **sf); 
void knh__Stmt__dump(Ctx *ctx, Object **sf); 
void knh__VirtualMachineCode__dump(Ctx *ctx, Object **sf); 
void knh__System_getProperty(Ctx *ctx, Object **sf); 
void knh__System_setProperty(Ctx *ctx, Object **sf); 
void knh__System__dump(Ctx *ctx, Object **sf); 
void knh__NameSpace_setClass(Ctx *ctx, Object **sf); 
void knh__NameSpace_getClass(Ctx *ctx, Object **sf); 
/* ------------------------------------------------------------------------ */

void knh_tmethod_ginit_(void)
{
	Ctx *ctx = NULL;
	KNH_TFIELDN(ctx, FIELDN_, new_String__STEXT(ctx, CLASS_String__field, ""));
	KNH_TFIELDN(ctx, FIELDN_this, new_String__STEXT(ctx, CLASS_String__field, "this"));
	KNH_TFIELDN(ctx, FIELDN_vargs, new_String__STEXT(ctx, CLASS_String__field, "vargs"));
	KNH_TFIELDN(ctx, FIELDN_w, new_String__STEXT(ctx, CLASS_String__field, "w"));
	KNH_TFIELDN(ctx, FIELDN_m, new_String__STEXT(ctx, CLASS_String__field, "m"));
	KNH_TFIELDN(ctx, FIELDN_uname, new_String__STEXT(ctx, CLASS_String__field, "uname"));
	KNH_TFIELDN(ctx, FIELDN_order, new_String__STEXT(ctx, CLASS_String__field, "order"));
	KNH_TFIELDN(ctx, FIELDN_init, new_String__STEXT(ctx, CLASS_String__field, "init"));
	KNH_TFIELDN(ctx, FIELDN_value, new_String__STEXT(ctx, CLASS_String__field, "value"));
	KNH_TFIELDN(ctx, FIELDN_index, new_String__STEXT(ctx, CLASS_String__field, "index"));
	KNH_TFIELDN(ctx, FIELDN_start, new_String__STEXT(ctx, CLASS_String__field, "start"));
	KNH_TFIELDN(ctx, FIELDN_end, new_String__STEXT(ctx, CLASS_String__field, "end"));
	KNH_TFIELDN(ctx, FIELDN_initialCapacity, new_String__STEXT(ctx, CLASS_String__field, "initialCapacity"));
	KNH_TFIELDN(ctx, FIELDN_v, new_String__STEXT(ctx, CLASS_String__field, "v"));
	KNH_TFIELDN(ctx, FIELDN_mn, new_String__STEXT(ctx, CLASS_String__field, "mn"));
	KNH_TFIELDN(ctx, FIELDN_key, new_String__STEXT(ctx, CLASS_String__field, "key"));
	KNH_TFIELDN(ctx, FIELDN_offset, new_String__STEXT(ctx, CLASS_String__field, "offset"));
	KNH_TFIELDN(ctx, FIELDN_term, new_String__STEXT(ctx, CLASS_String__field, "term"));
	KNH_TFIELDN(ctx, FIELDN_e, new_String__STEXT(ctx, CLASS_String__field, "e"));
	KNH_TFIELDN(ctx, FIELDN_msg, new_String__STEXT(ctx, CLASS_String__field, "msg"));
	KNH_TFIELDN(ctx, FIELDN_bag, new_String__STEXT(ctx, CLASS_String__field, "bag"));
	KNH_TFIELDN(ctx, FIELDN_n, new_String__STEXT(ctx, CLASS_String__field, "n"));
	KNH_TFIELDN(ctx, FIELDN_name, new_String__STEXT(ctx, CLASS_String__field, "name"));
	KNH_TFIELDN(ctx, FIELDN_c, new_String__STEXT(ctx, CLASS_String__field, "c"));
	KNH_TFIELDN(ctx, FIELDN_other, new_String__STEXT(ctx, CLASS_String__field, "other"));
	KNH_TFIELDN(ctx, FIELDN_lv, new_String__STEXT(ctx, CLASS_String__field, "lv"));
	KNH_TFIELDN(ctx, FIELDN_buf, new_String__STEXT(ctx, CLASS_String__field, "buf"));
	KNH_TFIELDN(ctx, FIELDN_s, new_String__STEXT(ctx, CLASS_String__field, "s"));
	KNH_TFIELDN(ctx, FIELDN_run, new_String__STEXT(ctx, CLASS_String__field, "run"));
	KNH_TFIELDN(ctx, FIELDN_dump, new_String__STEXT(ctx, CLASS_String__field, "dump"));
	KNH_TFIELDN(ctx, FIELDN_code, new_String__STEXT(ctx, CLASS_String__field, "code"));
	KNH_TFIELDN(ctx, FIELDN_placeOrder, new_String__STEXT(ctx, CLASS_String__field, "placeOrder"));
	KNH_TFIELDN(ctx, FIELDN_new, new_String__STEXT(ctx, CLASS_String__field, "new"));
	KNH_TFIELDN(ctx, FIELDN_new____array, new_String__STEXT(ctx, CLASS_String__field, "new::array"));
	KNH_TFIELDN(ctx, FIELDN_new____init, new_String__STEXT(ctx, CLASS_String__field, "new::init"));
	KNH_TFIELDN(ctx, FIELDN_____fast, new_String__STEXT(ctx, CLASS_String__field, "::fast"));
	KNH_TFIELDN(ctx, FIELDN_add____fast, new_String__STEXT(ctx, CLASS_String__field, "add::fast"));
	KNH_TFIELDN(ctx, FIELDN_add, new_String__STEXT(ctx, CLASS_String__field, "add"));
	KNH_TFIELDN(ctx, FIELDN_pop, new_String__STEXT(ctx, CLASS_String__field, "pop"));
	KNH_TFIELDN(ctx, FIELDN_slice, new_String__STEXT(ctx, CLASS_String__field, "slice"));
	KNH_TFIELDN(ctx, FIELDN_clear, new_String__STEXT(ctx, CLASS_String__field, "clear"));
	KNH_TFIELDN(ctx, FIELDN_write, new_String__STEXT(ctx, CLASS_String__field, "write"));
	KNH_TFIELDN(ctx, FIELDN_method, new_String__STEXT(ctx, CLASS_String__field, "method"));
	KNH_TFIELDN(ctx, FIELDN_property, new_String__STEXT(ctx, CLASS_String__field, "property"));
	KNH_TFIELDN(ctx, FIELDN_append, new_String__STEXT(ctx, CLASS_String__field, "append"));
	KNH_TFIELDN(ctx, FIELDN_remove, new_String__STEXT(ctx, CLASS_String__field, "remove"));
	KNH_TFIELDN(ctx, FIELDN_opIn, new_String__STEXT(ctx, CLASS_String__field, "opIn"));
	KNH_TFIELDN(ctx, FIELDN_opAdd, new_String__STEXT(ctx, CLASS_String__field, "opAdd"));
	KNH_TFIELDN(ctx, FIELDN_opSub, new_String__STEXT(ctx, CLASS_String__field, "opSub"));
	KNH_TFIELDN(ctx, FIELDN_opMul, new_String__STEXT(ctx, CLASS_String__field, "opMul"));
	KNH_TFIELDN(ctx, FIELDN_opDiv, new_String__STEXT(ctx, CLASS_String__field, "opDiv"));
	KNH_TFIELDN(ctx, FIELDN_keys, new_String__STEXT(ctx, CLASS_String__field, "keys"));
	KNH_TFIELDN(ctx, FIELDN_close, new_String__STEXT(ctx, CLASS_String__field, "close"));
	KNH_TFIELDN(ctx, FIELDN_opMod, new_String__STEXT(ctx, CLASS_String__field, "opMod"));
	KNH_TFIELDN(ctx, FIELDN_opEq, new_String__STEXT(ctx, CLASS_String__field, "opEq"));
	KNH_TFIELDN(ctx, FIELDN_opBitAnd, new_String__STEXT(ctx, CLASS_String__field, "opBitAnd"));
	KNH_TFIELDN(ctx, FIELDN_opBitOr, new_String__STEXT(ctx, CLASS_String__field, "opBitOr"));
	KNH_TFIELDN(ctx, FIELDN_opLShift, new_String__STEXT(ctx, CLASS_String__field, "opLShift"));
	KNH_TFIELDN(ctx, FIELDN_opRShift, new_String__STEXT(ctx, CLASS_String__field, "opRShift"));
	KNH_TFIELDN(ctx, FIELDN_opBitXor, new_String__STEXT(ctx, CLASS_String__field, "opBitXor"));
	KNH_TFIELDN(ctx, FIELDN_opBitNot, new_String__STEXT(ctx, CLASS_String__field, "opBitNot"));
	KNH_TFIELDN(ctx, FIELDN_x, new_String__STEXT(ctx, CLASS_String__field, "x"));
	KNH_TFIELDN(ctx, FIELDN_bits, new_String__STEXT(ctx, CLASS_String__field, "bits"));
	KNH_TFIELDN(ctx, FIELDN_isAbstract, new_String__STEXT(ctx, CLASS_String__field, "isAbstract"));
	KNH_TFIELDN(ctx, FIELDN_uRN, new_String__STEXT(ctx, CLASS_String__field, "uRN"));
	KNH_TFIELDN(ctx, FIELDN_class, new_String__STEXT(ctx, CLASS_String__field, "class"));
	KNH_TFIELDN(ctx, FIELDN_compare, new_String__STEXT(ctx, CLASS_String__field, "compare"));
	KNH_TFIELDN(ctx, FIELDN_opNeq, new_String__STEXT(ctx, CLASS_String__field, "opNeq"));
	KNH_TFIELDN(ctx, FIELDN_opLt, new_String__STEXT(ctx, CLASS_String__field, "opLt"));
	KNH_TFIELDN(ctx, FIELDN_opLte, new_String__STEXT(ctx, CLASS_String__field, "opLte"));
	KNH_TFIELDN(ctx, FIELDN_opGt, new_String__STEXT(ctx, CLASS_String__field, "opGt"));
	KNH_TFIELDN(ctx, FIELDN_opGte, new_String__STEXT(ctx, CLASS_String__field, "opGte"));
	KNH_TFIELDN(ctx, FIELDN_opNot, new_String__STEXT(ctx, CLASS_String__field, "opNot"));
	KNH_TFIELDN(ctx, FIELDN_opSeq, new_String__STEXT(ctx, CLASS_String__field, "opSeq"));
	KNH_TFIELDN(ctx, FIELDN_opIsMapTo, new_String__STEXT(ctx, CLASS_String__field, "opIsMapTo"));
	KNH_TFIELDN(ctx, FIELDN_save, new_String__STEXT(ctx, CLASS_String__field, "save"));
	KNH_TFIELDN(ctx, FIELDN_empty, new_String__STEXT(ctx, CLASS_String__field, "empty"));
	KNH_TFIELDN(ctx, FIELDN_refc, new_String__STEXT(ctx, CLASS_String__field, "refc"));
	KNH_TFIELDN(ctx, FIELDN_addr, new_String__STEXT(ctx, CLASS_String__field, "addr"));
	KNH_TFIELDN(ctx, FIELDN_flush, new_String__STEXT(ctx, CLASS_String__field, "flush"));
	KNH_TFIELDN(ctx, FIELDN_match, new_String__STEXT(ctx, CLASS_String__field, "match"));
	KNH_TFIELDN(ctx, FIELDN_equals, new_String__STEXT(ctx, CLASS_String__field, "equals"));
	KNH_TFIELDN(ctx, FIELDN_startsWith, new_String__STEXT(ctx, CLASS_String__field, "startsWith"));
	KNH_TFIELDN(ctx, FIELDN_endsWith, new_String__STEXT(ctx, CLASS_String__field, "endsWith"));
	KNH_TFIELDN(ctx, FIELDN_size, new_String__STEXT(ctx, CLASS_String__field, "size"));
	KNH_TFIELDN(ctx, FIELDN_writeLine, new_String__STEXT(ctx, CLASS_String__field, "writeLine"));
	KNH_TFIELDN(ctx, FIELDN_writeTab, new_String__STEXT(ctx, CLASS_String__field, "writeTab"));
	KNH_TFIELDN(ctx, FIELDN_runtime, new_String__STEXT(ctx, CLASS_String__field, "runtime"));
	KNH_TFIELDN(ctx, FIELDN_isSingleton, new_String__STEXT(ctx, CLASS_String__field, "isSingleton"));
	KNH_TFIELDN(ctx, FIELDN_opInstanceof, new_String__STEXT(ctx, CLASS_String__field, "opInstanceof"));
/* ------------------------------------------------------------------------ */

	/* knh_Object */
	TMETHOD(ctx, 0, knh__Object_getClass,
		CLASS_Class, CLASS_Object, METHODN_getClass, 
		0);

	TMETHOD(ctx, 0, knh__Object_compare,
		CLASS_Int, CLASS_Object, METHODN_compare, 
		1, TYPE_Any, FIELDN_other);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Object_opEq,
		TYPE_Bool, CLASS_Object, METHODN_opEq, 
		1, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Object_opNeq,
		TYPE_Bool, CLASS_Object, METHODN_opNeq, 
		1, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Object_opLt,
		TYPE_Bool, CLASS_Object, METHODN_opLt, 
		1, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Object_opLte,
		TYPE_Bool, CLASS_Object, METHODN_opLte, 
		1, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Object_opGt,
		TYPE_Bool, CLASS_Object, METHODN_opGt, 
		1, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Object_opGte,
		TYPE_Bool, CLASS_Object, METHODN_opGte, 
		1, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Object_opNot,
		TYPE_Bool, CLASS_Object, METHODN_opNot, 
		0);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Object_opSeq,
		TYPE_Bool, CLASS_Object, METHODN_opSeq, 
		1, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Object_opIsMapTo,
		TYPE_Bool, CLASS_Object, METHODN_opIsMapTo, 
		1, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, 0, knh__Object__s,
		TYPE_void, CLASS_Object, METHODN__s, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__Object__dump,
		TYPE_void, CLASS_Object, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__Object__empty,
		TYPE_void, CLASS_Object, METHODN__empty, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__Object__refc,
		TYPE_void, CLASS_Object, METHODN__refc, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__Object__addr,
		TYPE_void, CLASS_Object, METHODN__addr, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__Object_opInstanceof,
		TYPE_Bool, CLASS_Object, METHODN_opInstanceof, 
		1, TYPE_Class, FIELDN_c);

	TMAPMAP(ctx, 0|KNH_FLAG_MMF_TOTAL, knh_Object_Iterator, TYPE_Object, TYPE_Iterator, Null);
	TMAPMAP(ctx, 0|KNH_FLAG_MMF_TOTAL, knh_Object_String, TYPE_Object, TYPE_String, Null);
	/* knh_Tuple1 */
	/* knh_Tuple2 */
	/* knh_Tuple3 */
	/* knh_Tuple4 */
	/* knh_Tuple5 */
	/* knh_Tuple6 */
	/* knh_Tuple7 */
	/* knh_Tuple8 */
	/* knh_Tuple9 */
	/* knh_Tuple10 */
	/* knh_Tuple11 */
	/* knh_Tuple12 */
	/* knh_Tuple13 */
	/* knh_Tuple14 */
	/* knh_Tuple15 */
	/* knh_Prototype */
	TMETHOD(ctx, 0, knh__Prototype__dump,
		TYPE_void, CLASS_Prototype, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	/* knh_Nue */
	TMETHOD(ctx, 0, knh__Nue__s,
		TYPE_void, CLASS_Nue, METHODN__s, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMAPMAP(ctx, KNH_FLAG_MMF_STATIC|KNH_FLAG_MMF_TOTAL, knh_Nue_String, TYPE_Nue, TYPE_String, Null);
	/* knh_Bool */
	TMETHOD(ctx, 0, knh__Bool__s,
		TYPE_void, CLASS_Bool, METHODN__s, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMAPMAP(ctx, KNH_FLAG_MMF_STATIC|KNH_FLAG_MMF_TOTAL, knh_Bool_String, TYPE_Bool, TYPE_String, Null);
	/* knh_Int */
	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Int_opAdd,
		CLASS_Int, CLASS_Int, METHODN_opAdd, 
		1, CLASS_Int, FIELDN_v);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Int_opSub,
		CLASS_Int, CLASS_Int, METHODN_opSub, 
		1, CLASS_Int, FIELDN_n);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Int_opMul,
		CLASS_Int, CLASS_Int, METHODN_opMul, 
		1, CLASS_Int, FIELDN_n);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Int_opDiv,
		CLASS_Int, CLASS_Int, METHODN_opDiv, 
		1, CLASS_Int, FIELDN_n);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Int_opMod,
		CLASS_Int, CLASS_Int, METHODN_opMod, 
		1, CLASS_Int, FIELDN_n);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Int_opEq,
		TYPE_Bool, CLASS_Int, METHODN_opEq, 
		1, CLASS_Int, FIELDN_value);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Int_opBitAnd,
		CLASS_Int, CLASS_Int, METHODN_opBitAnd, 
		1, CLASS_Int, FIELDN_v);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Int_opBitOr,
		CLASS_Int, CLASS_Int, METHODN_opBitOr, 
		1, CLASS_Int, FIELDN_v);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Int_opLShift,
		CLASS_Int, CLASS_Int, METHODN_opLShift, 
		1, CLASS_Int, FIELDN_n);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Int_opRShift,
		CLASS_Int, CLASS_Int, METHODN_opRShift, 
		1, CLASS_Int, FIELDN_n);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Int_opBitXor,
		CLASS_Int, CLASS_Int, METHODN_opBitXor, 
		1, CLASS_Int, FIELDN_n);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Int_opBitNot,
		CLASS_Int, CLASS_Int, METHODN_opBitNot, 
		0);

	TMETHOD(ctx, 0, knh__Int__s,
		TYPE_void, CLASS_Int, METHODN__s, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__Int__x,
		TYPE_void, CLASS_Int, METHODN__x, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__Int__bits,
		TYPE_void, CLASS_Int, METHODN__bits, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMAPMAP(ctx, KNH_FLAG_MMF_STATIC, knh_Int_Float, TYPE_Int, TYPE_Float, Null);
	TMAPMAP(ctx, KNH_FLAG_MMF_STATIC|KNH_FLAG_MMF_TOTAL, knh_Int_String, TYPE_Int, TYPE_String, Null);
	/* knh_Int64 */
	TMETHOD(ctx, 0, knh__Int64__dump,
		TYPE_void, CLASS_Int64, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	/* knh_Float */
	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Float_opAdd,
		CLASS_Float, CLASS_Float, METHODN_opAdd, 
		1, CLASS_Float, FIELDN_v);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Float_opSub,
		CLASS_Float, CLASS_Float, METHODN_opSub, 
		1, CLASS_Float, FIELDN_n);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Float_opMul,
		CLASS_Float, CLASS_Float, METHODN_opMul, 
		1, CLASS_Float, FIELDN_n);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__Float_opDiv,
		CLASS_Float, CLASS_Float, METHODN_opDiv, 
		1, CLASS_Float, FIELDN_n);

	TMETHOD(ctx, 0, knh__Float__s,
		TYPE_void, CLASS_Float, METHODN__s, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__Float__dump,
		TYPE_void, CLASS_Float, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMAPMAP(ctx, KNH_FLAG_MMF_STATIC, knh_Float_String, TYPE_Float, TYPE_String, Null);
	TMAPMAP(ctx, KNH_FLAG_MMF_STATIC, knh_Float_Int, TYPE_Float, TYPE_Int, Null);
	/* knh_String */
	TMETHOD(ctx, 0, knh__String_equals,
		TYPE_Bool, CLASS_String, METHODN_equals, 
		1, CLASS_String, FIELDN_s);

	TMETHOD(ctx, 0, knh__String_startsWith,
		TYPE_Bool, CLASS_String, METHODN_startsWith, 
		1, CLASS_String, FIELDN_s);

	TMETHOD(ctx, 0, knh__String_endsWith,
		TYPE_Bool, CLASS_String, METHODN_endsWith, 
		1, CLASS_String, FIELDN_s);

	TMETHOD(ctx, 0, knh__String_getSize,
		CLASS_Int, CLASS_String, METHODN_getSize, 
		0);

	TMETHOD(ctx, KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC, knh__String_opAdd,
		CLASS_String, CLASS_String, METHODN_opAdd, 
		1, TYPE_Any, FIELDN_v);

	TMETHOD(ctx, KNH_FLAG_MF_STATIC, knh__String_opMul,
		CLASS_String, CLASS_String, METHODN_opMul, 
		1, CLASS_Int, FIELDN_n);

	TMETHOD(ctx, 0, knh__String__s,
		TYPE_void, CLASS_String, METHODN__s, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__String__dump,
		TYPE_void, CLASS_String, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMAPMAP(ctx, 0|KNH_FLAG_MMF_TOTAL, knh_String_Bytes, TYPE_String, TYPE_Bytes, Null);
	TMAPMAP(ctx, KNH_FLAG_MMF_STATIC, knh_String_Float, TYPE_String, TYPE_Float, Null);
	TMAPMAP(ctx, KNH_FLAG_MMF_STATIC, knh_String_Int, TYPE_String, TYPE_Int, Null);
	/* knh_Bytes */
	TMETHOD(ctx, 0, knh__Bytes_new,
		CLASS_Bytes, CLASS_Bytes, METHODN_new, 
		1, TYPE_Int, FIELDN_initialCapacity);

	TMETHOD(ctx, 0, knh__Bytes_clear,
		TYPE_void, CLASS_Bytes, METHODN_clear, 
		0);

	TMETHOD(ctx, 0, knh__Bytes_write,
		TYPE_void, CLASS_Bytes, METHODN_write, 
		1, TYPE_Object, FIELDN_v);

	TMAPMAP(ctx, 0, knh_Bytes_String, TYPE_Bytes, TYPE_String, Null);
	/* knh_Regex */
	TMETHOD(ctx, 0, knh__Regex_match,
		TYPE_Bool, CLASS_Regex, METHODN_match, 
		1, TYPE_String, FIELDN_s);

	TMETHOD(ctx, 0, knh__Regex__s,
		TYPE_void, CLASS_Regex, METHODN__s, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__Regex__dump,
		TYPE_void, CLASS_Regex, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	/* knh_Array */
	TMETHOD(ctx, 0, knh__Array_new,
		CLASS_Array, CLASS_Array, METHODN_new, 
		1, TYPE_Int, FIELDN_init);

	TMETHOD(ctx, 0, knh__Array_new__array,
		CLASS_Array, CLASS_Array, METHODN_new__array, 
		2, TYPE_Int, FIELDN_init, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, KNH_FLAG_MF_VARARGS, knh__Array_new__init,
		CLASS_Array, CLASS_Array, METHODN_new__init, 
		1, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, 0, knh__Array_get__fast,
		TYPE_Any, CLASS_Array, METHODN_get__fast, 
		1, CLASS_Int, FIELDN_index);

	TMETHOD(ctx, 0, knh__Array_set__fast,
		TYPE_void, CLASS_Array, METHODN_set__fast, 
		2, CLASS_Int, FIELDN_index, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, 0, knh__Array_get,
		TYPE_Any, CLASS_Array, METHODN_get, 
		1, CLASS_Int, FIELDN_index);

	TMETHOD(ctx, 0, knh__Array_set,
		TYPE_void, CLASS_Array, METHODN_set, 
		2, CLASS_Int, FIELDN_index, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, 0, knh__Array_add__fast,
		TYPE_void, CLASS_Array, METHODN_add__fast, 
		1, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, 0, knh__Array_add,
		TYPE_void, CLASS_Array, METHODN_add, 
		1, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, 0, knh__Array_pop,
		TYPE_Any, CLASS_Array, METHODN_pop, 
		0);

	TMETHOD(ctx, 0, knh__Array_slice,
		CLASS_Array, CLASS_Array, METHODN_slice, 
		2, TYPE_Int, FIELDN_start, TYPE_Int, FIELDN_end);

	TMETHOD(ctx, 0, knh__Array_clear,
		TYPE_void, CLASS_Array, METHODN_clear, 
		0);

	TMETHOD(ctx, 0, knh__Array__dump,
		TYPE_void, CLASS_Array, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMAPMAP(ctx, 0|KNH_FLAG_MMF_TOTAL, knh_Array_Iterator, TYPE_Array, TYPE_Iterator, Null);
	TMAPMAP(ctx, 0|KNH_FLAG_MMF_TOTAL, knh_Array_Tuple, TYPE_Array, TYPE_Tuple, Null);
	/* knh_HashMap */
	TMETHOD(ctx, 0, knh__HashMap_new,
		CLASS_HashMap, CLASS_HashMap, METHODN_new, 
		1, TYPE_Int, FIELDN_initialCapacity);

	TMETHOD(ctx, KNH_FLAG_MF_VARARGS, knh__HashMap_new__init,
		CLASS_HashMap, CLASS_HashMap, METHODN_new__init, 
		1, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, 0, knh__HashMap_get,
		TYPE_Any, CLASS_HashMap, METHODN_get, 
		1, TYPE_Any, FIELDN_key);

	TMETHOD(ctx, 0, knh__HashMap_set,
		TYPE_void, CLASS_HashMap, METHODN_set, 
		2, CLASS_Any, FIELDN_key, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, 0, knh__HashMap_remove,
		TYPE_void, CLASS_HashMap, METHODN_remove, 
		1, TYPE_Any, FIELDN_key);

	TMETHOD(ctx, 0, knh__HashMap_opIn,
		TYPE_Bool, CLASS_HashMap, METHODN_opIn, 
		1, TYPE_Any, FIELDN_key);

	TMETHOD(ctx, 0, knh__HashMap_keys,
		CLASS_Iterator, CLASS_HashMap, METHODN_keys, 
		0);

	TMETHOD(ctx, 0, knh__HashMap__dump,
		TYPE_void, CLASS_HashMap, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMAPMAP(ctx, 0|KNH_FLAG_MMF_TOTAL, knh_HashMap_Iterator, TYPE_HashMap, TYPE_Iterator, Null);
	TMAPMAP(ctx, 0|KNH_FLAG_MMF_TOTAL, knh_HashMap_Tuple2__, TYPE_HashMap, TYPE_Tuple2__, Null);
	/* knh_HashSet */
	TMETHOD(ctx, 0, knh__HashSet_new,
		CLASS_HashSet, CLASS_HashSet, METHODN_new, 
		1, TYPE_Int, FIELDN_initialCapacity);

	TMETHOD(ctx, 0, knh__HashSet_get,
		CLASS_Int, CLASS_HashSet, METHODN_get, 
		1, TYPE_Any, FIELDN_key);

	TMETHOD(ctx, 0, knh__HashSet_opIn,
		TYPE_Bool, CLASS_HashSet, METHODN_opIn, 
		1, TYPE_Any, FIELDN_key);

	TMETHOD(ctx, 0, knh__HashSet_set,
		TYPE_void, CLASS_HashSet, METHODN_set, 
		2, TYPE_Any, FIELDN_key, CLASS_Int, FIELDN_value);

	TMETHOD(ctx, 0, knh__HashSet_add,
		TYPE_void, CLASS_HashSet, METHODN_add, 
		1, TYPE_Any, FIELDN_key);

	TMETHOD(ctx, 0, knh__HashSet_remove,
		TYPE_void, CLASS_HashSet, METHODN_remove, 
		1, TYPE_Any, FIELDN_key);

	TMETHOD(ctx, 0, knh__HashSet__dump,
		TYPE_void, CLASS_HashSet, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMAPMAP(ctx, 0|KNH_FLAG_MMF_TOTAL, knh_HashSet_Iterator, TYPE_HashSet, TYPE_Iterator, Null);
	/* knh_DictMap */
	TMETHOD(ctx, 0, knh__DictMap_new,
		CLASS_DictMap, CLASS_DictMap, METHODN_new, 
		1, TYPE_Int, FIELDN_initialCapacity);

	TMETHOD(ctx, KNH_FLAG_MF_VARARGS, knh__DictMap_new__init,
		CLASS_DictMap, CLASS_DictMap, METHODN_new__init, 
		1, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, 0, knh__DictMap_get,
		TYPE_Any, CLASS_DictMap, METHODN_get, 
		1, CLASS_String, FIELDN_key);

	TMETHOD(ctx, 0, knh__DictMap_append,
		TYPE_void, CLASS_DictMap, METHODN_append, 
		2, CLASS_String, FIELDN_key, CLASS_Any, FIELDN_value);

	TMETHOD(ctx, 0, knh__DictMap_set,
		TYPE_void, CLASS_DictMap, METHODN_set, 
		2, CLASS_String, FIELDN_key, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, 0, knh__DictMap_remove,
		TYPE_void, CLASS_DictMap, METHODN_remove, 
		1, CLASS_String, FIELDN_key);

	TMETHOD(ctx, 0, knh__DictMap_clear,
		TYPE_void, CLASS_DictMap, METHODN_clear, 
		0);

	TMETHOD(ctx, 0, knh__DictMap__dump,
		TYPE_void, CLASS_DictMap, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMAPMAP(ctx, 0|KNH_FLAG_MMF_TOTAL, knh_DictMap_Iterator, TYPE_DictMap, TYPE_Iterator, Null);
	/* knh_DictSet */
	TMETHOD(ctx, 0, knh__DictSet_new,
		CLASS_DictSet, CLASS_DictSet, METHODN_new, 
		1, TYPE_Int, FIELDN_initialCapacity);

	TMETHOD(ctx, 0, knh__DictSet_get,
		CLASS_Int, CLASS_DictSet, METHODN_get, 
		1, CLASS_String, FIELDN_key);

	TMETHOD(ctx, 0, knh__DictSet_opIn,
		TYPE_Bool, CLASS_DictSet, METHODN_opIn, 
		1, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, 0, knh__DictSet_set,
		TYPE_void, CLASS_DictSet, METHODN_set, 
		2, CLASS_String, FIELDN_key, CLASS_Int, FIELDN_value);

	TMETHOD(ctx, 0, knh__DictSet_add,
		TYPE_void, CLASS_DictSet, METHODN_add, 
		1, CLASS_String, FIELDN_key);

	TMETHOD(ctx, 0, knh__DictSet_clear,
		TYPE_void, CLASS_DictSet, METHODN_clear, 
		0);

	TMETHOD(ctx, 0, knh__DictSet__dump,
		TYPE_void, CLASS_DictSet, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMAPMAP(ctx, 0|KNH_FLAG_MMF_TOTAL, knh_DictSet_Iterator, TYPE_DictSet, TYPE_Iterator, Null);
	/* knh_Iterator */
	TMETHOD(ctx, 0, knh__Iterator__dump,
		TYPE_void, CLASS_Iterator, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMAPMAP(ctx, 0|KNH_FLAG_MMF_TOTAL, knh_Iterator_Array, TYPE_Iterator, TYPE_Array, Null);
	/* knh_DictIdx */
	TMETHOD(ctx, 0, knh__DictIdx_index,
		CLASS_Int, CLASS_DictIdx, METHODN_index, 
		1, CLASS_String, FIELDN_term);

	TMETHOD(ctx, 0, knh__DictIdx_add__fast,
		CLASS_Int, CLASS_DictIdx, METHODN_add__fast, 
		1, CLASS_String, FIELDN_term);

	TMETHOD(ctx, 0, knh__DictIdx_add,
		CLASS_Int, CLASS_DictIdx, METHODN_add, 
		1, CLASS_String, FIELDN_term);

	TMETHOD(ctx, 0, knh__DictIdx_get__fast,
		TYPE_String, CLASS_DictIdx, METHODN_get__fast, 
		1, CLASS_Int, FIELDN_index);

	TMETHOD(ctx, 0, knh__DictIdx_get,
		TYPE_String, CLASS_DictIdx, METHODN_get, 
		1, CLASS_Int, FIELDN_index);

	TMETHOD(ctx, 0, knh__DictIdx_clear,
		TYPE_void, CLASS_DictIdx, METHODN_clear, 
		0);

	TMETHOD(ctx, 0, knh__DictIdx__dump,
		TYPE_void, CLASS_DictIdx, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	/* knh_Class */
	TMETHOD(ctx, 0, knh__Class__s,
		TYPE_void, CLASS_Class, METHODN__s, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__Class__dump,
		TYPE_void, CLASS_Class, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__Class_isSingleton,
		TYPE_Bool, CLASS_Class, METHODN_isSingleton, 
		0);

	/* knh_ClassStruct */
	/* knh_MethodField */
	/* knh_Method */
	TMETHOD(ctx, 0, knh__Method__code,
		TYPE_void, CLASS_Method, METHODN__code, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__Method_isAbstract,
		TYPE_Bool, CLASS_Method, METHODN_isAbstract, 
		0);

	TMETHOD(ctx, 0, knh__Method_getName,
		CLASS_String, CLASS_Method, METHODN_getName, 
		0);

	TMETHOD(ctx, 0, knh__Method_getURN,
		CLASS_String, CLASS_Method, METHODN_getURN, 
		0);

	TMETHOD(ctx, 0, knh__Method__s,
		TYPE_void, CLASS_Method, METHODN__s, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__Method__dump,
		TYPE_void, CLASS_Method, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	/* knh_MapMap */
	TMETHOD(ctx, 0, knh__MapMap__dump,
		TYPE_void, CLASS_MapMap, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	/* knh_ClassRel */
	TMETHOD(ctx, 0, knh__ClassRel__dump,
		TYPE_void, CLASS_ClassRel, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	/* knh_IntUnit */
	/* knh_FloatUnit */
	/* knh_Vocabulary */
	/* knh_AffineConv */
	/* knh_StreamStat */
	/* knh_InputStream */
	TMETHOD(ctx, 0, knh__InputStream_close,
		TYPE_void, CLASS_InputStream, METHODN_close, 
		0);

	TMETHOD(ctx, 0, knh__InputStream__dump,
		TYPE_void, CLASS_InputStream, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	/* knh_OutputStream */
	TMETHOD(ctx, 0, knh__OutputStream_write,
		TYPE_void, CLASS_OutputStream, METHODN_write, 
		1, TYPE_Object, FIELDN_buf);

	TMETHOD(ctx, 0, knh__OutputStream_flush,
		TYPE_void, CLASS_OutputStream, METHODN_flush, 
		0);

	TMETHOD(ctx, 0, knh__OutputStream_close,
		TYPE_void, CLASS_OutputStream, METHODN_close, 
		0);

	TMETHOD(ctx, 0, knh__OutputStream__dump,
		TYPE_void, CLASS_OutputStream, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	/* knh_Writer */
	TMETHOD(ctx, 0, knh__Writer_write,
		TYPE_void, CLASS_Writer, METHODN_write, 
		1, TYPE_String, FIELDN_s);

	TMETHOD(ctx, 0, knh__Writer_flush,
		TYPE_void, CLASS_Writer, METHODN_flush, 
		0);

	TMETHOD(ctx, 0, knh__Writer_writeLine,
		TYPE_void, CLASS_Writer, METHODN_writeLine, 
		1, TYPE_String, FIELDN_s);

	TMETHOD(ctx, 0, knh__Writer_writeTab,
		TYPE_void, CLASS_Writer, METHODN_writeTab, 
		1, TYPE_Int, FIELDN_n);

	/* knh_MovableText */
	TMETHOD(ctx, 0, knh__MovableText__s,
		TYPE_void, CLASS_MovableText, METHODN__s, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__MovableText__dump,
		TYPE_void, CLASS_MovableText, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	/* knh_Exception */
	TMETHOD(ctx, 0, knh__Exception_new,
		CLASS_Exception, CLASS_Exception, METHODN_new, 
		3, CLASS_String, FIELDN_e, TYPE_String, FIELDN_msg, TYPE_Object, FIELDN_bag);

	TMETHOD(ctx, 0, knh__Exception__s,
		TYPE_void, CLASS_Exception, METHODN__s, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__Exception__dump,
		TYPE_void, CLASS_Exception, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	/* knh_Runtime */
	/* knh_Context */
	TMETHOD(ctx, 0, knh__Context_getProperty,
		TYPE_Any, CLASS_Context, METHODN_getProperty, 
		1, CLASS_String, FIELDN_key);

	TMETHOD(ctx, 0, knh__Context_setProperty,
		TYPE_void, CLASS_Context, METHODN_setProperty, 
		2, CLASS_String, FIELDN_key, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, 0, knh__Context__dump,
		TYPE_void, CLASS_Context, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__Context_getRuntime,
		CLASS_Runtime, CLASS_Context, METHODN_getRuntime, 
		0);

	/* knh_ExceptionHandler */
	/* knh_Mutex */
	TMETHOD(ctx, 0, knh__Mutex__dump,
		TYPE_void, CLASS_Mutex, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	/* knh_Amazon */
	TMETHOD(ctx, 0, knh__Amazon_placeOrder,
		TYPE_void, CLASS_Amazon, METHODN_placeOrder, 
		2, TYPE_String, FIELDN_uname, TYPE_String, FIELDN_order);

	/* knh_Token */
	TMETHOD(ctx, 0, knh__Token__s,
		TYPE_void, CLASS_Token, METHODN__s, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__Token__dump,
		TYPE_void, CLASS_Token, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	/* knh_Stmt */
	TMETHOD(ctx, 0, knh__Stmt__s,
		TYPE_void, CLASS_Stmt, METHODN__s, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	TMETHOD(ctx, 0, knh__Stmt__dump,
		TYPE_void, CLASS_Stmt, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	/* knh_Cmpl */
	/* knh_VirtualMachineCode */
	TMETHOD(ctx, 0, knh__VirtualMachineCode__dump,
		TYPE_void, CLASS_VirtualMachineCode, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	/* knh_Closure */
	/* knh_System */
	TMETHOD(ctx, 0, knh__System_getProperty,
		TYPE_Any, CLASS_System, METHODN_getProperty, 
		1, CLASS_String, FIELDN_key);

	TMETHOD(ctx, 0, knh__System_setProperty,
		TYPE_void, CLASS_System, METHODN_setProperty, 
		2, CLASS_String, FIELDN_key, TYPE_Any, FIELDN_value);

	TMETHOD(ctx, 0, knh__System__dump,
		TYPE_void, CLASS_System, METHODN__dump, 
		2, TYPE_Writer, FIELDN_w, TYPE_Any, FIELDN_m);

	/* knh_NameSpace */
	TMETHOD(ctx, 0, knh__NameSpace_setClass,
		TYPE_void, CLASS_NameSpace, METHODN_setClass, 
		2, TYPE_String, FIELDN_name, TYPE_Class, FIELDN_c);

	TMETHOD(ctx, 0, knh__NameSpace_getClass,
		TYPE_Class, CLASS_NameSpace, METHODN_getClass, 
		1, TYPE_String, FIELDN_name);

}

#ifdef __cplusplus
}
#endif
