/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#include<konoha/konoha_dev.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

/* ------------------------------------------------------------------------ */

#ifndef ISA_Amazon
#define ISA_Amazon(ctx, o)   IS_Amazon(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Amazon
knh_Amazon* knh_Amazon_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Amazon(ctx, b));
	return (knh_Amazon*)b;
}

/* ------------------------------------------------------------------------ */

knh_Amazon* knh_Amazon_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Amazon(ctx, b));
	return (knh_Amazon*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Counter
#define ISA_Counter(ctx, o)   IS_Counter(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Counter
knh_Counter* knh_Counter_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Counter(ctx, b));
	return (knh_Counter*)b;
}

/* ------------------------------------------------------------------------ */

knh_Counter* knh_Counter_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Counter(ctx, b));
	return (knh_Counter*)b;
}
#endif

#ifndef BEFORE_knh__Amazon_placeOrder
#define BEFORE_knh__Amazon_placeOrder
#endif
#ifndef AFTER_knh__Amazon_placeOrder
#define AFTER_knh__Amazon_placeOrder
#endif

METHOD knh__Amazon_placeOrder(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Amazon_placeOrder;
	Amazon* b = KNH_CAST_AmazonOrNull(ctx, sf[0]);
	String* uname = KNH_CAST_StringOrNull(ctx, sf[1]);
	String* order = KNH_CAST_StringOrNull(ctx, sf[2]);

	knh_Amazon_placeOrder(ctx, b, uname, order);

	BEFORE_knh__Amazon_placeOrder;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Counter__s
#define BEFORE_knh__Counter__s
#endif
#ifndef AFTER_knh__Counter__s
#define AFTER_knh__Counter__s
#endif

METHOD knh__Counter__s(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Counter__s;
	Counter* b = KNH_CAST_CounterOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Counter__s(ctx, b, w, m);

	BEFORE_knh__Counter__s;
	KNH_SETr_void(ctx, sf);
}


#ifdef __cplusplus
}
#endif
