#!/usr/bin/python
import os, os.path, sys
from pygenlib2  import *

#############

class Source :
	def __init__(self, bdir):
		self.bdir = bdir
		self.cfiles = {}
		self.settings = {}
		self.macros = []
		self.lastfpath = ''
		self.hfiles = {}
		self.cfuncs = {}
		self.tfieldn = []
		self.tfield = {}
		self.tmethodn = []
		self.tmethod = {}
		self.tmapmap = {}
	###
	
	def kpath(self, fpath):
		if fpath.startswith(self.bdir+'/'):
			return fpath[len(bdir)+1:]
		return fpath
	###

######

# /* @field TYPE Class.name (ctype cname) */

class Field :
	def __init__(self, package, anno, data):
		self.package = package
		self.anno = anno
		
		self.flag = parse_flag('KNH_FLAG_CFF', anno)
		t = anno.replace('.', ' ').replace('(', ' ').replace(')',' ').split()
		self.ftype = t[1]
		self.cname = t[2]
		self.fname = t[3]

###

######

class Param :
	def __init__(self, type, name, value = None):
		self.type = type
		self.name = name
		self.value = value

def parse_params(ptext, data):
	params = []
	ptext = ptext[ptext.find('(')+1:]
	ptext = ptext[:ptext.find(')')]
	if len(ptext) == 0: return params
	for a in ptext.split(','):
		a = a.replace('=', ' ')
		t = a.split()
		if len(t) == 3:
			if data != None and t[1] not in data.tfieldn: 
				data.tfieldn.append(t[1])
			params.append(Param(t[0], t[1], t[2]))
		elif len(t) == 2:
			if data != None and t[1] not in data.tfieldn: 
				data.tfieldn.append(t[1])
			params.append(Param(t[0], t[1]))
		else:
			if data != None and t[0] not in data.tfieldn: 
				data.tfieldn.append(t[0])
			params.append(Param('any', t[0]))
	return params

MT_PARAMS = [Param('Object', 'w'), Param('any', 'm')]

class Method :
	def __init__(self, package, anno, functype, data):
		self.package = package
		self.anno = anno
		self.functype = functype
		
		self.flag = parse_flag('KNH_FLAG_MF', anno)
		pre, args = anno.split('(')
		t = pre.replace('.',' ').split()
		self.rtype = t[1]
		self.cname = t[2]
		self.mname = t[3]
		if not self.mname in data.tmethodn:
			data.tmethodn.append(self.mname)
		self.methodfunc = None
		if self.mname.startswith('%'):
			self.params = MT_PARAMS
			self.optfunc = parse_funcname(self.functype)
			self.methodfunc = 'knh_fmethod_movableText'
		else:
			self.params = parse_params(anno, data)
			funcname = parse_funcname(self.functype)
			loc = funcname.find('_')
			if funcname[loc+1] == '_':
				self.methodfunc = funcname
				self.optfunc = 'NULL'
		#

def read_method(package, anno, functype, data):
	print package, anno, functype
	mtd = Method(package, anno, functype, data)
	l = safedict(data.tmethod, package, [])
	l.append(mtd)

#####

class MapMap :
    def __init__(self, package, anno, funcname, data) :
    	self.package = package
    	self.anno = anno
    	self.funcname = funcname
        
        self.flag = parse_flag('KNH_FLAG_MMF', anno)
        t = anno.split()
        self.fcname = t[1]
        self.tcname = t[2]

        if self.tcname.endswith('..') or self.tcname == 'Bool':
            self.tcname += '!'
        if self.tcname.endswith('!'):
            self.tcname = self.tcname.replace('!', '')
            self.flag += '|KNH_FLAG_MMF_TOTAL'
        
        self.mapfunc = funcname

def read_mapmap(package, anno, funcname, data):
	print package, anno, funcname
	map = MapMap(package, anno, funcname, data)
	l = safedict(data.tmapmap, package, [])
	l.append(map)

####

def read_source_cblock(fpath, zone, text, data):
	functype = parse_functype(text)
	if functype == None: return

	hfiles = safedict(data.hfiles, fpath_packagename(fpath), [])
	if(data.lastfpath != fpath):
		data.lastfpath = fpath;
		hfiles.append('/* %s */' % fpath)
	hfiles.append(functype + ';')
	
	funcname = parse_funcname(functype)
	data.cfuncs[funcname] = text

	if text.find('/* @map') > 0:
		read_mapmap(fpath_packagename(fpath), parse_annotation(text, '@map'), funcname, data)

	if text.find('/* @method') > 0:
		read_method(fpath_packagename(fpath), parse_annotation(text, '@method'), functype, data)
###

def read_source_c(fpath, data):
	f = open(fpath)

	# header part
	pp = 0
	cline = None
	for ln in f:
		if ln.startswith('#endif') and pp == 1:
			break
		if ln.startswith('#ifdef __cplusplus'):
			cline = ''
			pp = 1
			continue
	
	# body part
	zone = '[config]'
	text = ''

	pp = 0
	for ln in f: 
		if ln.startswith('//'): continue
		if ln.startswith('#endif') and pp == 1: break
		if ln.startswith('#ifdef __cplusplus'): 
			pp = 1
			continue
		
		if ln.startswith('/* ['):
			zone = ln.split()[1]
			continue

		if ln.startswith('/* ===') or ln.startswith('/* ---'):
			if len(text) > 0 :
				read_source_cblock(fpath, zone, text, data)
				text = ''
				continue
			
		if ln.startswith("#define _") :
			ln = linetrim(ln.replace('#define _', '#define '))
			if not ln.endswith('\\') :
				data.macros.append(ln)
				continue
			p = ln + '\n'	
			for ln in f:
				ln = linetrim(ln)
				p += (ln + '\n')
				if not ln.endswith('\\'): break
			###
			data.macros.append(p)
			continue
		if pp == 0: text += ln
	###
	if len(text) > 0 :
		read_source_cblock(fpath, zone, text, data)
	f.close()
###

def read_source_k(fpath, data):
	f = open(fpath)
	settings = {}
	exec(f)
	data.settings[data.kpath(fpath)] = settings
###

def read_source(dir, data):
	fpath = dir + '/config.k'
	if os.path.isfile(fpath):
		read_source_k(fpath, data)

	fl = os.listdir(dir)
	for fn in fl:
		if fn.startswith('.'): continue
		if fn.startswith('_'): continue
		fpath = dir + '/' + fn
		if fn.endswith('.c'): 
			read_source_c(fpath, data)
		if os.path.isdir(fpath):
			read_source(fpath, data)

#############

if __name__ == '__main__':
	if len(sys.argv) == 1: bdir = '..'
	else: bdir = sys.args[1]
	data = Source(bdir)
	read_source(bdir, data)

