/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#include<konoha/konoha_dev.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

/* ------------------------------------------------------------------------ */

#ifndef ISA_Object
#define ISA_Object(ctx, o)   IS_Object(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Object
knh_Object* knh_Object_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Object(ctx, b));
	return (knh_Object*)b;
}

/* ------------------------------------------------------------------------ */

knh_Object* knh_Object_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Object(ctx, b));
	return (knh_Object*)b;
}
#endif

/* ------------------------------------------------------------------------ */

/* @method Bool! Object.isRelease() */


#ifndef BEFORE_knh__Object_isRelease
#define BEFORE_knh__Object_isRelease
#endif
#ifndef AFTER_knh__Object_isRelease
#define AFTER_knh__Object_isRelease
#endif

METHOD knh__Object_isRelease(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Object_isRelease;
	if(knh_Object_isRelease(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Object_isRelease;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Object.isRelease() */


#ifndef BEFORE_knh__Object_isDebug
#define BEFORE_knh__Object_isDebug
#endif
#ifndef AFTER_knh__Object_isDebug
#define AFTER_knh__Object_isDebug
#endif

METHOD knh__Object_isDebug(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Object_isDebug;
	if(knh_Object_isDebug(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Object_isDebug;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Object.isImmutable() */


#ifndef BEFORE_knh__Object_isImmutable
#define BEFORE_knh__Object_isImmutable
#endif
#ifndef AFTER_knh__Object_isImmutable
#define AFTER_knh__Object_isImmutable
#endif

METHOD knh__Object_isImmutable(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Object_isImmutable;
	if(knh_Object_isImmutable(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Object_isImmutable;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Object.hasMetaData() */


#ifndef BEFORE_knh__Object_hasMetaData
#define BEFORE_knh__Object_hasMetaData
#endif
#ifndef AFTER_knh__Object_hasMetaData
#define AFTER_knh__Object_hasMetaData
#endif

METHOD knh__Object_hasMetaData(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Object_hasMetaData;
	if(knh_Object_hasMetaData(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Object_hasMetaData;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Object.isSynchronized() */


#ifndef BEFORE_knh__Object_isSynchronized
#define BEFORE_knh__Object_isSynchronized
#endif
#ifndef AFTER_knh__Object_isSynchronized
#define AFTER_knh__Object_isSynchronized
#endif

METHOD knh__Object_isSynchronized(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Object_isSynchronized;
	if(knh_Object_isSynchronized(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Object_isSynchronized;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Object.isModified() */


#ifndef BEFORE_knh__Object_isModified
#define BEFORE_knh__Object_isModified
#endif
#ifndef AFTER_knh__Object_isModified
#define AFTER_knh__Object_isModified
#endif

METHOD knh__Object_isModified(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Object_isModified;
	if(knh_Object_isModified(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Object_isModified;
}

/* ------------------------------------------------------------------------ */

/* @method void Object.setModified(Bool b) */


#ifndef BEFORE_knh__Object_setModified
#define BEFORE_knh__Object_setModified
#endif
#ifndef AFTER_knh__Object_setModified
#define AFTER_knh__Object_setModified
#endif

METHOD knh__Object_setModified(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Object_setModified;
	if(IS_TRUE(sfp[1])) {
		knh_Object_head(sfp[0])->flag |= KNH_FLAG_OF_MODIFIED;
	}else{
		knh_Object_head(sfp[0])->flag &= ~(KNH_FLAG_OF_MODIFIED);
	}
	AFTER_knh__Object_setModified;
}

/* ------------------------------------------------------------------------ */

#ifndef ISA_Tuple1
#define ISA_Tuple1(ctx, o)   IS_Tuple1(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Tuple1
knh_Tuple1* knh_Tuple1_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Tuple1(ctx, b));
	return (knh_Tuple1*)b;
}

/* ------------------------------------------------------------------------ */

knh_Tuple1* knh_Tuple1_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Tuple1(ctx, b));
	return (knh_Tuple1*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Tuple2
#define ISA_Tuple2(ctx, o)   IS_Tuple2(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Tuple2
knh_Tuple2* knh_Tuple2_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Tuple2(ctx, b));
	return (knh_Tuple2*)b;
}

/* ------------------------------------------------------------------------ */

knh_Tuple2* knh_Tuple2_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Tuple2(ctx, b));
	return (knh_Tuple2*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Tuple3
#define ISA_Tuple3(ctx, o)   IS_Tuple3(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Tuple3
knh_Tuple3* knh_Tuple3_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Tuple3(ctx, b));
	return (knh_Tuple3*)b;
}

/* ------------------------------------------------------------------------ */

knh_Tuple3* knh_Tuple3_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Tuple3(ctx, b));
	return (knh_Tuple3*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Tuple4
#define ISA_Tuple4(ctx, o)   IS_Tuple4(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Tuple4
knh_Tuple4* knh_Tuple4_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Tuple4(ctx, b));
	return (knh_Tuple4*)b;
}

/* ------------------------------------------------------------------------ */

knh_Tuple4* knh_Tuple4_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Tuple4(ctx, b));
	return (knh_Tuple4*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Tuple5
#define ISA_Tuple5(ctx, o)   IS_Tuple5(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Tuple5
knh_Tuple5* knh_Tuple5_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Tuple5(ctx, b));
	return (knh_Tuple5*)b;
}

/* ------------------------------------------------------------------------ */

knh_Tuple5* knh_Tuple5_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Tuple5(ctx, b));
	return (knh_Tuple5*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Tuple6
#define ISA_Tuple6(ctx, o)   IS_Tuple6(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Tuple6
knh_Tuple6* knh_Tuple6_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Tuple6(ctx, b));
	return (knh_Tuple6*)b;
}

/* ------------------------------------------------------------------------ */

knh_Tuple6* knh_Tuple6_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Tuple6(ctx, b));
	return (knh_Tuple6*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Tuple7
#define ISA_Tuple7(ctx, o)   IS_Tuple7(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Tuple7
knh_Tuple7* knh_Tuple7_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Tuple7(ctx, b));
	return (knh_Tuple7*)b;
}

/* ------------------------------------------------------------------------ */

knh_Tuple7* knh_Tuple7_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Tuple7(ctx, b));
	return (knh_Tuple7*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Tuple8
#define ISA_Tuple8(ctx, o)   IS_Tuple8(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Tuple8
knh_Tuple8* knh_Tuple8_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Tuple8(ctx, b));
	return (knh_Tuple8*)b;
}

/* ------------------------------------------------------------------------ */

knh_Tuple8* knh_Tuple8_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Tuple8(ctx, b));
	return (knh_Tuple8*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Tuple9
#define ISA_Tuple9(ctx, o)   IS_Tuple9(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Tuple9
knh_Tuple9* knh_Tuple9_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Tuple9(ctx, b));
	return (knh_Tuple9*)b;
}

/* ------------------------------------------------------------------------ */

knh_Tuple9* knh_Tuple9_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Tuple9(ctx, b));
	return (knh_Tuple9*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Tuple10
#define ISA_Tuple10(ctx, o)   IS_Tuple10(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Tuple10
knh_Tuple10* knh_Tuple10_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Tuple10(ctx, b));
	return (knh_Tuple10*)b;
}

/* ------------------------------------------------------------------------ */

knh_Tuple10* knh_Tuple10_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Tuple10(ctx, b));
	return (knh_Tuple10*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Tuple11
#define ISA_Tuple11(ctx, o)   IS_Tuple11(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Tuple11
knh_Tuple11* knh_Tuple11_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Tuple11(ctx, b));
	return (knh_Tuple11*)b;
}

/* ------------------------------------------------------------------------ */

knh_Tuple11* knh_Tuple11_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Tuple11(ctx, b));
	return (knh_Tuple11*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Tuple12
#define ISA_Tuple12(ctx, o)   IS_Tuple12(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Tuple12
knh_Tuple12* knh_Tuple12_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Tuple12(ctx, b));
	return (knh_Tuple12*)b;
}

/* ------------------------------------------------------------------------ */

knh_Tuple12* knh_Tuple12_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Tuple12(ctx, b));
	return (knh_Tuple12*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Tuple13
#define ISA_Tuple13(ctx, o)   IS_Tuple13(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Tuple13
knh_Tuple13* knh_Tuple13_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Tuple13(ctx, b));
	return (knh_Tuple13*)b;
}

/* ------------------------------------------------------------------------ */

knh_Tuple13* knh_Tuple13_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Tuple13(ctx, b));
	return (knh_Tuple13*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Tuple14
#define ISA_Tuple14(ctx, o)   IS_Tuple14(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Tuple14
knh_Tuple14* knh_Tuple14_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Tuple14(ctx, b));
	return (knh_Tuple14*)b;
}

/* ------------------------------------------------------------------------ */

knh_Tuple14* knh_Tuple14_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Tuple14(ctx, b));
	return (knh_Tuple14*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Tuple15
#define ISA_Tuple15(ctx, o)   IS_Tuple15(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Tuple15
knh_Tuple15* knh_Tuple15_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Tuple15(ctx, b));
	return (knh_Tuple15*)b;
}

/* ------------------------------------------------------------------------ */

knh_Tuple15* knh_Tuple15_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Tuple15(ctx, b));
	return (knh_Tuple15*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Prototype
#define ISA_Prototype(ctx, o)   IS_Prototype(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Prototype
knh_Prototype* knh_Prototype_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Prototype(ctx, b));
	return (knh_Prototype*)b;
}

/* ------------------------------------------------------------------------ */

knh_Prototype* knh_Prototype_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Prototype(ctx, b));
	return (knh_Prototype*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Nue
#define ISA_Nue(ctx, o)   IS_Nue(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Nue
knh_Nue* knh_Nue_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Nue(ctx, b));
	return (knh_Nue*)b;
}

/* ------------------------------------------------------------------------ */

knh_Nue* knh_Nue_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Nue(ctx, b));
	return (knh_Nue*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Bool
#define ISA_Bool(ctx, o)   IS_Bool(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Bool
knh_Bool* knh_Bool_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Bool(ctx, b));
	return (knh_Bool*)b;
}

/* ------------------------------------------------------------------------ */

knh_Bool* knh_Bool_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Bool(ctx, b));
	return (knh_Bool*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Int
#define ISA_Int(ctx, o)   IS_Int(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Int
knh_Int* knh_Int_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Int(ctx, b));
	return (knh_Int*)b;
}

/* ------------------------------------------------------------------------ */

knh_Int* knh_Int_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Int(ctx, b));
	return (knh_Int*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Int64
#define ISA_Int64(ctx, o)   IS_Int64(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Int64
knh_Int64* knh_Int64_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Int64(ctx, b));
	return (knh_Int64*)b;
}

/* ------------------------------------------------------------------------ */

knh_Int64* knh_Int64_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Int64(ctx, b));
	return (knh_Int64*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Float
#define ISA_Float(ctx, o)   IS_Float(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Float
knh_Float* knh_Float_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Float(ctx, b));
	return (knh_Float*)b;
}

/* ------------------------------------------------------------------------ */

knh_Float* knh_Float_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Float(ctx, b));
	return (knh_Float*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_String
#define ISA_String(ctx, o)   IS_String(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_String
knh_String* knh_String_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_String(ctx, b));
	return (knh_String*)b;
}

/* ------------------------------------------------------------------------ */

knh_String* knh_String_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_String(ctx, b));
	return (knh_String*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Regex
#define ISA_Regex(ctx, o)   IS_Regex(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Regex
knh_Regex* knh_Regex_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Regex(ctx, b));
	return (knh_Regex*)b;
}

/* ------------------------------------------------------------------------ */

knh_Regex* knh_Regex_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Regex(ctx, b));
	return (knh_Regex*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Bytes
#define ISA_Bytes(ctx, o)   IS_Bytes(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Bytes
knh_Bytes* knh_Bytes_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Bytes(ctx, b));
	return (knh_Bytes*)b;
}

/* ------------------------------------------------------------------------ */

knh_Bytes* knh_Bytes_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Bytes(ctx, b));
	return (knh_Bytes*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_BytesConv
#define ISA_BytesConv(ctx, o)   IS_BytesConv(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_BytesConv
knh_BytesConv* knh_BytesConv_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_BytesConv(ctx, b));
	return (knh_BytesConv*)b;
}

/* ------------------------------------------------------------------------ */

knh_BytesConv* knh_BytesConv_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_BytesConv(ctx, b));
	return (knh_BytesConv*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Array
#define ISA_Array(ctx, o)   IS_Array(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Array
knh_Array* knh_Array_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Array(ctx, b));
	return (knh_Array*)b;
}

/* ------------------------------------------------------------------------ */

knh_Array* knh_Array_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Array(ctx, b));
	return (knh_Array*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_HashMap
#define ISA_HashMap(ctx, o)   IS_HashMap(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_HashMap
knh_HashMap* knh_HashMap_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_HashMap(ctx, b));
	return (knh_HashMap*)b;
}

/* ------------------------------------------------------------------------ */

knh_HashMap* knh_HashMap_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_HashMap(ctx, b));
	return (knh_HashMap*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_HashSet
#define ISA_HashSet(ctx, o)   IS_HashSet(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_HashSet
knh_HashSet* knh_HashSet_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_HashSet(ctx, b));
	return (knh_HashSet*)b;
}

/* ------------------------------------------------------------------------ */

knh_HashSet* knh_HashSet_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_HashSet(ctx, b));
	return (knh_HashSet*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_DictMap
#define ISA_DictMap(ctx, o)   IS_DictMap(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_DictMap
knh_DictMap* knh_DictMap_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_DictMap(ctx, b));
	return (knh_DictMap*)b;
}

/* ------------------------------------------------------------------------ */

knh_DictMap* knh_DictMap_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_DictMap(ctx, b));
	return (knh_DictMap*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_DictSet
#define ISA_DictSet(ctx, o)   IS_DictSet(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_DictSet
knh_DictSet* knh_DictSet_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_DictSet(ctx, b));
	return (knh_DictSet*)b;
}

/* ------------------------------------------------------------------------ */

knh_DictSet* knh_DictSet_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_DictSet(ctx, b));
	return (knh_DictSet*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Iterator
#define ISA_Iterator(ctx, o)   IS_Iterator(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Iterator
knh_Iterator* knh_Iterator_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Iterator(ctx, b));
	return (knh_Iterator*)b;
}

/* ------------------------------------------------------------------------ */

knh_Iterator* knh_Iterator_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Iterator(ctx, b));
	return (knh_Iterator*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_DictIdx
#define ISA_DictIdx(ctx, o)   IS_DictIdx(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_DictIdx
knh_DictIdx* knh_DictIdx_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_DictIdx(ctx, b));
	return (knh_DictIdx*)b;
}

/* ------------------------------------------------------------------------ */

knh_DictIdx* knh_DictIdx_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_DictIdx(ctx, b));
	return (knh_DictIdx*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Class
#define ISA_Class(ctx, o)   IS_Class(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Class
knh_Class* knh_Class_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Class(ctx, b));
	return (knh_Class*)b;
}

/* ------------------------------------------------------------------------ */

knh_Class* knh_Class_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Class(ctx, b));
	return (knh_Class*)b;
}
#endif

/* ------------------------------------------------------------------------ */

/* @method Bool! Class.isRelease() */


#ifndef BEFORE_knh__Class_isRelease
#define BEFORE_knh__Class_isRelease
#endif
#ifndef AFTER_knh__Class_isRelease
#define AFTER_knh__Class_isRelease
#endif

METHOD knh__Class_isRelease(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Class_isRelease;
	if(knh_Class_isRelease(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Class_isRelease;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Class.isRelease() */


#ifndef BEFORE_knh__Class_isDebug
#define BEFORE_knh__Class_isDebug
#endif
#ifndef AFTER_knh__Class_isDebug
#define AFTER_knh__Class_isDebug
#endif

METHOD knh__Class_isDebug(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Class_isDebug;
	if(knh_Class_isDebug(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Class_isDebug;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Class.isImmutable() */


#ifndef BEFORE_knh__Class_isImmutable
#define BEFORE_knh__Class_isImmutable
#endif
#ifndef AFTER_knh__Class_isImmutable
#define AFTER_knh__Class_isImmutable
#endif

METHOD knh__Class_isImmutable(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Class_isImmutable;
	if(knh_Class_isImmutable(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Class_isImmutable;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Class.isMetaExtensible() */


#ifndef BEFORE_knh__Class_isMetaExtensible
#define BEFORE_knh__Class_isMetaExtensible
#endif
#ifndef AFTER_knh__Class_isMetaExtensible
#define AFTER_knh__Class_isMetaExtensible
#endif

METHOD knh__Class_isMetaExtensible(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Class_isMetaExtensible;
	if(knh_Class_isMetaExtensible(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Class_isMetaExtensible;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Class.isPrivate() */


#ifndef BEFORE_knh__Class_isPrivate
#define BEFORE_knh__Class_isPrivate
#endif
#ifndef AFTER_knh__Class_isPrivate
#define AFTER_knh__Class_isPrivate
#endif

METHOD knh__Class_isPrivate(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Class_isPrivate;
	if(knh_Class_isPrivate(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Class_isPrivate;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Class.isPrivate() */


#ifndef BEFORE_knh__Class_isPublic
#define BEFORE_knh__Class_isPublic
#endif
#ifndef AFTER_knh__Class_isPublic
#define AFTER_knh__Class_isPublic
#endif

METHOD knh__Class_isPublic(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Class_isPublic;
	if(knh_Class_isPublic(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Class_isPublic;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Class.isFinal() */


#ifndef BEFORE_knh__Class_isFinal
#define BEFORE_knh__Class_isFinal
#endif
#ifndef AFTER_knh__Class_isFinal
#define AFTER_knh__Class_isFinal
#endif

METHOD knh__Class_isFinal(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Class_isFinal;
	if(knh_Class_isFinal(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Class_isFinal;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Class.isSystem() */


#ifndef BEFORE_knh__Class_isSystem
#define BEFORE_knh__Class_isSystem
#endif
#ifndef AFTER_knh__Class_isSystem
#define AFTER_knh__Class_isSystem
#endif

METHOD knh__Class_isSystem(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Class_isSystem;
	if(knh_Class_isSystem(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Class_isSystem;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Class.isNA() */


#ifndef BEFORE_knh__Class_isNA
#define BEFORE_knh__Class_isNA
#endif
#ifndef AFTER_knh__Class_isNA
#define AFTER_knh__Class_isNA
#endif

METHOD knh__Class_isNA(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Class_isNA;
	if(knh_Class_isNA(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Class_isNA;
}

/* ------------------------------------------------------------------------ */

#ifndef ISA_ClassStruct
#define ISA_ClassStruct(ctx, o)   IS_ClassStruct(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_ClassStruct
knh_ClassStruct* knh_ClassStruct_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_ClassStruct(ctx, b));
	return (knh_ClassStruct*)b;
}

/* ------------------------------------------------------------------------ */

knh_ClassStruct* knh_ClassStruct_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_ClassStruct(ctx, b));
	return (knh_ClassStruct*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_MethodField
#define ISA_MethodField(ctx, o)   IS_MethodField(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_MethodField
knh_MethodField* knh_MethodField_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_MethodField(ctx, b));
	return (knh_MethodField*)b;
}

/* ------------------------------------------------------------------------ */

knh_MethodField* knh_MethodField_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_MethodField(ctx, b));
	return (knh_MethodField*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Method
#define ISA_Method(ctx, o)   IS_Method(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Method
knh_Method* knh_Method_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Method(ctx, b));
	return (knh_Method*)b;
}

/* ------------------------------------------------------------------------ */

knh_Method* knh_Method_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Method(ctx, b));
	return (knh_Method*)b;
}
#endif

/* ------------------------------------------------------------------------ */

/* @method Bool! Method.isPublic() */


#ifndef BEFORE_knh__Method_isPublic
#define BEFORE_knh__Method_isPublic
#endif
#ifndef AFTER_knh__Method_isPublic
#define AFTER_knh__Method_isPublic
#endif

METHOD knh__Method_isPublic(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Method_isPublic;
	if(knh_Method_isPublic(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Method_isPublic;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Method.isPublic() */


#ifndef BEFORE_knh__Method_isPrivate
#define BEFORE_knh__Method_isPrivate
#endif
#ifndef AFTER_knh__Method_isPrivate
#define AFTER_knh__Method_isPrivate
#endif

METHOD knh__Method_isPrivate(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Method_isPrivate;
	if(knh_Method_isPrivate(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Method_isPrivate;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Method.isVirtual() */


#ifndef BEFORE_knh__Method_isVirtual
#define BEFORE_knh__Method_isVirtual
#endif
#ifndef AFTER_knh__Method_isVirtual
#define AFTER_knh__Method_isVirtual
#endif

METHOD knh__Method_isVirtual(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Method_isVirtual;
	if(knh_Method_isVirtual(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Method_isVirtual;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Method.isVirtual() */


#ifndef BEFORE_knh__Method_isFinal
#define BEFORE_knh__Method_isFinal
#endif
#ifndef AFTER_knh__Method_isFinal
#define AFTER_knh__Method_isFinal
#endif

METHOD knh__Method_isFinal(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Method_isFinal;
	if(knh_Method_isFinal(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Method_isFinal;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Method.isStatic() */


#ifndef BEFORE_knh__Method_isStatic
#define BEFORE_knh__Method_isStatic
#endif
#ifndef AFTER_knh__Method_isStatic
#define AFTER_knh__Method_isStatic
#endif

METHOD knh__Method_isStatic(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Method_isStatic;
	if(knh_Method_isStatic(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Method_isStatic;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Method.isClass() */


#ifndef BEFORE_knh__Method_isClass
#define BEFORE_knh__Method_isClass
#endif
#ifndef AFTER_knh__Method_isClass
#define AFTER_knh__Method_isClass
#endif

METHOD knh__Method_isClass(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Method_isClass;
	if(knh_Method_isClass(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Method_isClass;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Method.isVarArgs() */


#ifndef BEFORE_knh__Method_isVarArgs
#define BEFORE_knh__Method_isVarArgs
#endif
#ifndef AFTER_knh__Method_isVarArgs
#define AFTER_knh__Method_isVarArgs
#endif

METHOD knh__Method_isVarArgs(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Method_isVarArgs;
	if(knh_Method_isVarArgs(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Method_isVarArgs;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Method.isAspect() */


#ifndef BEFORE_knh__Method_isAspect
#define BEFORE_knh__Method_isAspect
#endif
#ifndef AFTER_knh__Method_isAspect
#define AFTER_knh__Method_isAspect
#endif

METHOD knh__Method_isAspect(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Method_isAspect;
	if(knh_Method_isAspect(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Method_isAspect;
}

/* ------------------------------------------------------------------------ */

#ifndef ISA_MapMap
#define ISA_MapMap(ctx, o)   IS_MapMap(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_MapMap
knh_MapMap* knh_MapMap_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_MapMap(ctx, b));
	return (knh_MapMap*)b;
}

/* ------------------------------------------------------------------------ */

knh_MapMap* knh_MapMap_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_MapMap(ctx, b));
	return (knh_MapMap*)b;
}
#endif

/* ------------------------------------------------------------------------ */

/* @method Bool! MapMap.isInterface() */


#ifndef BEFORE_knh__MapMap_isInterface
#define BEFORE_knh__MapMap_isInterface
#endif
#ifndef AFTER_knh__MapMap_isInterface
#define AFTER_knh__MapMap_isInterface
#endif

METHOD knh__MapMap_isInterface(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__MapMap_isInterface;
	if(knh_MapMap_isInterface(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__MapMap_isInterface;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! MapMap.isSignificant() */


#ifndef BEFORE_knh__MapMap_isSignificant
#define BEFORE_knh__MapMap_isSignificant
#endif
#ifndef AFTER_knh__MapMap_isSignificant
#define AFTER_knh__MapMap_isSignificant
#endif

METHOD knh__MapMap_isSignificant(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__MapMap_isSignificant;
	if(knh_MapMap_isSignificant(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__MapMap_isSignificant;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! MapMap.isSynonym() */


#ifndef BEFORE_knh__MapMap_isSynonym
#define BEFORE_knh__MapMap_isSynonym
#endif
#ifndef AFTER_knh__MapMap_isSynonym
#define AFTER_knh__MapMap_isSynonym
#endif

METHOD knh__MapMap_isSynonym(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__MapMap_isSynonym;
	if(knh_MapMap_isSynonym(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__MapMap_isSynonym;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! MapMap.isLossLess() */


#ifndef BEFORE_knh__MapMap_isLossLess
#define BEFORE_knh__MapMap_isLossLess
#endif
#ifndef AFTER_knh__MapMap_isLossLess
#define AFTER_knh__MapMap_isLossLess
#endif

METHOD knh__MapMap_isLossLess(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__MapMap_isLossLess;
	if(knh_MapMap_isLossLess(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__MapMap_isLossLess;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! MapMap.isTotal() */


#ifndef BEFORE_knh__MapMap_isTotal
#define BEFORE_knh__MapMap_isTotal
#endif
#ifndef AFTER_knh__MapMap_isTotal
#define AFTER_knh__MapMap_isTotal
#endif

METHOD knh__MapMap_isTotal(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__MapMap_isTotal;
	if(knh_MapMap_isTotal(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__MapMap_isTotal;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! MapMap.isTotal() */


#ifndef BEFORE_knh__MapMap_isPartial
#define BEFORE_knh__MapMap_isPartial
#endif
#ifndef AFTER_knh__MapMap_isPartial
#define AFTER_knh__MapMap_isPartial
#endif

METHOD knh__MapMap_isPartial(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__MapMap_isPartial;
	if(knh_MapMap_isPartial(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__MapMap_isPartial;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! MapMap.isStatic() */


#ifndef BEFORE_knh__MapMap_isStatic
#define BEFORE_knh__MapMap_isStatic
#endif
#ifndef AFTER_knh__MapMap_isStatic
#define AFTER_knh__MapMap_isStatic
#endif

METHOD knh__MapMap_isStatic(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__MapMap_isStatic;
	if(knh_MapMap_isStatic(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__MapMap_isStatic;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! MapMap.isStatic() */


#ifndef BEFORE_knh__MapMap_isTemporal
#define BEFORE_knh__MapMap_isTemporal
#endif
#ifndef AFTER_knh__MapMap_isTemporal
#define AFTER_knh__MapMap_isTemporal
#endif

METHOD knh__MapMap_isTemporal(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__MapMap_isTemporal;
	if(knh_MapMap_isTemporal(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__MapMap_isTemporal;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! MapMap.isLocal() */


#ifndef BEFORE_knh__MapMap_isLocal
#define BEFORE_knh__MapMap_isLocal
#endif
#ifndef AFTER_knh__MapMap_isLocal
#define AFTER_knh__MapMap_isLocal
#endif

METHOD knh__MapMap_isLocal(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__MapMap_isLocal;
	if(knh_MapMap_isLocal(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__MapMap_isLocal;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! MapMap.isDerived() */


#ifndef BEFORE_knh__MapMap_isDerived
#define BEFORE_knh__MapMap_isDerived
#endif
#ifndef AFTER_knh__MapMap_isDerived
#define AFTER_knh__MapMap_isDerived
#endif

METHOD knh__MapMap_isDerived(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__MapMap_isDerived;
	if(knh_MapMap_isDerived(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__MapMap_isDerived;
}

/* ------------------------------------------------------------------------ */

#ifndef ISA_ClassRel
#define ISA_ClassRel(ctx, o)   IS_ClassRel(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_ClassRel
knh_ClassRel* knh_ClassRel_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_ClassRel(ctx, b));
	return (knh_ClassRel*)b;
}

/* ------------------------------------------------------------------------ */

knh_ClassRel* knh_ClassRel_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_ClassRel(ctx, b));
	return (knh_ClassRel*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Closure
#define ISA_Closure(ctx, o)   IS_Closure(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Closure
knh_Closure* knh_Closure_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Closure(ctx, b));
	return (knh_Closure*)b;
}

/* ------------------------------------------------------------------------ */

knh_Closure* knh_Closure_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Closure(ctx, b));
	return (knh_Closure*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_IntUnit
#define ISA_IntUnit(ctx, o)   IS_IntUnit(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_IntUnit
knh_IntUnit* knh_IntUnit_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_IntUnit(ctx, b));
	return (knh_IntUnit*)b;
}

/* ------------------------------------------------------------------------ */

knh_IntUnit* knh_IntUnit_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_IntUnit(ctx, b));
	return (knh_IntUnit*)b;
}
#endif

/* ------------------------------------------------------------------------ */

/* @method Bool! IntUnit.isUnsigned() */


#ifndef BEFORE_knh__IntUnit_isUnsigned
#define BEFORE_knh__IntUnit_isUnsigned
#endif
#ifndef AFTER_knh__IntUnit_isUnsigned
#define AFTER_knh__IntUnit_isUnsigned
#endif

METHOD knh__IntUnit_isUnsigned(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__IntUnit_isUnsigned;
	if(knh_IntUnit_isUnsigned(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__IntUnit_isUnsigned;
}

/* ------------------------------------------------------------------------ */

#ifndef ISA_FloatUnit
#define ISA_FloatUnit(ctx, o)   IS_FloatUnit(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_FloatUnit
knh_FloatUnit* knh_FloatUnit_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_FloatUnit(ctx, b));
	return (knh_FloatUnit*)b;
}

/* ------------------------------------------------------------------------ */

knh_FloatUnit* knh_FloatUnit_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_FloatUnit(ctx, b));
	return (knh_FloatUnit*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Vocabulary
#define ISA_Vocabulary(ctx, o)   IS_Vocabulary(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Vocabulary
knh_Vocabulary* knh_Vocabulary_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Vocabulary(ctx, b));
	return (knh_Vocabulary*)b;
}

/* ------------------------------------------------------------------------ */

knh_Vocabulary* knh_Vocabulary_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Vocabulary(ctx, b));
	return (knh_Vocabulary*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_AffineConv
#define ISA_AffineConv(ctx, o)   IS_AffineConv(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_AffineConv
knh_AffineConv* knh_AffineConv_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_AffineConv(ctx, b));
	return (knh_AffineConv*)b;
}

/* ------------------------------------------------------------------------ */

knh_AffineConv* knh_AffineConv_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_AffineConv(ctx, b));
	return (knh_AffineConv*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_InputStream
#define ISA_InputStream(ctx, o)   IS_InputStream(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_InputStream
knh_InputStream* knh_InputStream_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_InputStream(ctx, b));
	return (knh_InputStream*)b;
}

/* ------------------------------------------------------------------------ */

knh_InputStream* knh_InputStream_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_InputStream(ctx, b));
	return (knh_InputStream*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_OutputStream
#define ISA_OutputStream(ctx, o)   IS_OutputStream(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_OutputStream
knh_OutputStream* knh_OutputStream_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_OutputStream(ctx, b));
	return (knh_OutputStream*)b;
}

/* ------------------------------------------------------------------------ */

knh_OutputStream* knh_OutputStream_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_OutputStream(ctx, b));
	return (knh_OutputStream*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Socket
#define ISA_Socket(ctx, o)   IS_Socket(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Socket
knh_Socket* knh_Socket_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Socket(ctx, b));
	return (knh_Socket*)b;
}

/* ------------------------------------------------------------------------ */

knh_Socket* knh_Socket_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Socket(ctx, b));
	return (knh_Socket*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Connection
#define ISA_Connection(ctx, o)   IS_Connection(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Connection
knh_Connection* knh_Connection_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Connection(ctx, b));
	return (knh_Connection*)b;
}

/* ------------------------------------------------------------------------ */

knh_Connection* knh_Connection_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Connection(ctx, b));
	return (knh_Connection*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_ResultSet
#define ISA_ResultSet(ctx, o)   IS_ResultSet(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_ResultSet
knh_ResultSet* knh_ResultSet_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_ResultSet(ctx, b));
	return (knh_ResultSet*)b;
}

/* ------------------------------------------------------------------------ */

knh_ResultSet* knh_ResultSet_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_ResultSet(ctx, b));
	return (knh_ResultSet*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Exception
#define ISA_Exception(ctx, o)   IS_Exception(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Exception
knh_Exception* knh_Exception_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Exception(ctx, b));
	return (knh_Exception*)b;
}

/* ------------------------------------------------------------------------ */

knh_Exception* knh_Exception_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Exception(ctx, b));
	return (knh_Exception*)b;
}
#endif

/* ------------------------------------------------------------------------ */

/* @method Bool! Exception.isFatal() */


#ifndef BEFORE_knh__Exception_isFatal
#define BEFORE_knh__Exception_isFatal
#endif
#ifndef AFTER_knh__Exception_isFatal
#define AFTER_knh__Exception_isFatal
#endif

METHOD knh__Exception_isFatal(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Exception_isFatal;
	if(knh_Exception_isFatal(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Exception_isFatal;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Exception.isLogging() */


#ifndef BEFORE_knh__Exception_isLogging
#define BEFORE_knh__Exception_isLogging
#endif
#ifndef AFTER_knh__Exception_isLogging
#define AFTER_knh__Exception_isLogging
#endif

METHOD knh__Exception_isLogging(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Exception_isLogging;
	if(knh_Exception_isLogging(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Exception_isLogging;
}

/* ------------------------------------------------------------------------ */

/* @method Bool! Exception.isGenerated() */


#ifndef BEFORE_knh__Exception_isGenerated
#define BEFORE_knh__Exception_isGenerated
#endif
#ifndef AFTER_knh__Exception_isGenerated
#define AFTER_knh__Exception_isGenerated
#endif

METHOD knh__Exception_isGenerated(Ctx *ctx, Object **sfp)
{
	BEFORE_knh__Exception_isGenerated;
	if(knh_Exception_isGenerated(sfp[0])) {
		VM_RET(ctx, KNH_TRUE);
	}else{
		VM_RET(ctx, KNH_FALSE);
	}
	AFTER_knh__Exception_isGenerated;
}

/* ------------------------------------------------------------------------ */

#ifndef ISA_ExceptionHandler
#define ISA_ExceptionHandler(ctx, o)   IS_ExceptionHandler(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_ExceptionHandler
knh_ExceptionHandler* knh_ExceptionHandler_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_ExceptionHandler(ctx, b));
	return (knh_ExceptionHandler*)b;
}

/* ------------------------------------------------------------------------ */

knh_ExceptionHandler* knh_ExceptionHandler_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_ExceptionHandler(ctx, b));
	return (knh_ExceptionHandler*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Mutex
#define ISA_Mutex(ctx, o)   IS_Mutex(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Mutex
knh_Mutex* knh_Mutex_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Mutex(ctx, b));
	return (knh_Mutex*)b;
}

/* ------------------------------------------------------------------------ */

knh_Mutex* knh_Mutex_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Mutex(ctx, b));
	return (knh_Mutex*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_System
#define ISA_System(ctx, o)   IS_System(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_System
knh_System* knh_System_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_System(ctx, b));
	return (knh_System*)b;
}

/* ------------------------------------------------------------------------ */

knh_System* knh_System_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_System(ctx, b));
	return (knh_System*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_NameSpace
#define ISA_NameSpace(ctx, o)   IS_NameSpace(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_NameSpace
knh_NameSpace* knh_NameSpace_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_NameSpace(ctx, b));
	return (knh_NameSpace*)b;
}

/* ------------------------------------------------------------------------ */

knh_NameSpace* knh_NameSpace_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_NameSpace(ctx, b));
	return (knh_NameSpace*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Runtime
#define ISA_Runtime(ctx, o)   IS_Runtime(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Runtime
knh_Runtime* knh_Runtime_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Runtime(ctx, b));
	return (knh_Runtime*)b;
}

/* ------------------------------------------------------------------------ */

knh_Runtime* knh_Runtime_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Runtime(ctx, b));
	return (knh_Runtime*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Context
#define ISA_Context(ctx, o)   IS_Context(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Context
knh_Context* knh_Context_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Context(ctx, b));
	return (knh_Context*)b;
}

/* ------------------------------------------------------------------------ */

knh_Context* knh_Context_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Context(ctx, b));
	return (knh_Context*)b;
}
#endif

#ifndef BEFORE_knh__Array_add__fast
#define BEFORE_knh__Array_add__fast
#endif
#ifndef AFTER_knh__Array_add__fast
#define AFTER_knh__Array_add__fast
#endif

METHOD knh__Array_add__fast(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Array_add__fast;
	Array* b = KNH_CAST_ArrayOrNull(ctx, sf[0]);
	Any* value = KNH_CAST_ObjectOrNull(ctx, sf[1]);

	knh_Array_add__fast(ctx, b, value);

	BEFORE_knh__Array_add__fast;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Array_add
#define BEFORE_knh__Array_add
#endif
#ifndef AFTER_knh__Array_add
#define AFTER_knh__Array_add
#endif

METHOD knh__Array_add(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Array_add;
	Array* b = KNH_CAST_ArrayOrNull(ctx, sf[0]);
	Any* value = KNH_CAST_ObjectOrNull(ctx, sf[1]);

	knh_Array_add(ctx, b, value);

	BEFORE_knh__Array_add;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Array_pop
#define BEFORE_knh__Array_pop
#endif
#ifndef AFTER_knh__Array_pop
#define AFTER_knh__Array_pop
#endif

METHOD knh__Array_pop(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Array_pop;
	Array* b = KNH_CAST_ArrayOrNull(ctx, sf[0]);

	Any* _rval_ = knh_Array_pop(ctx, b);

	BEFORE_knh__Array_pop;
	KNH_SETr(ctx, sf, KNH_CAST_ObjectOrNull(ctx, _rval_));
}


#ifndef BEFORE_knh__Array_slice
#define BEFORE_knh__Array_slice
#endif
#ifndef AFTER_knh__Array_slice
#define AFTER_knh__Array_slice
#endif

METHOD knh__Array_slice(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Array_slice;
	Array* b = KNH_CAST_ArrayOrNull(ctx, sf[0]);
	knh_int_t start = knh_Int_value((Int*)sf[1]);
	knh_int_t end = knh_Int_value((Int*)sf[2]);

	Array* _rval_ = knh_Array_slice(ctx, b, start, end);

	BEFORE_knh__Array_slice;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_Array(ctx, _rval_));
}


#ifndef BEFORE_knh__Array_clear
#define BEFORE_knh__Array_clear
#endif
#ifndef AFTER_knh__Array_clear
#define AFTER_knh__Array_clear
#endif

METHOD knh__Array_clear(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Array_clear;
	Array* b = KNH_CAST_ArrayOrNull(ctx, sf[0]);

	knh_Array_clear(ctx, b);

	BEFORE_knh__Array_clear;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Array__dump
#define BEFORE_knh__Array__dump
#endif
#ifndef AFTER_knh__Array__dump
#define AFTER_knh__Array__dump
#endif

METHOD knh__Array__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Array__dump;
	Array* b = KNH_CAST_ArrayOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Array__dump(ctx, b, w, m);

	BEFORE_knh__Array__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Class__s
#define BEFORE_knh__Class__s
#endif
#ifndef AFTER_knh__Class__s
#define AFTER_knh__Class__s
#endif

METHOD knh__Class__s(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Class__s;
	knh_type_t type = knh_Class_type((Class*)sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Class__s(ctx, type, w, m);

	BEFORE_knh__Class__s;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Class__dump
#define BEFORE_knh__Class__dump
#endif
#ifndef AFTER_knh__Class__dump
#define AFTER_knh__Class__dump
#endif

METHOD knh__Class__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Class__dump;
	knh_type_t type = knh_Class_type((Class*)sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Class__dump(ctx, type, w, m);

	BEFORE_knh__Class__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__ClassRel__dump
#define BEFORE_knh__ClassRel__dump
#endif
#ifndef AFTER_knh__ClassRel__dump
#define AFTER_knh__ClassRel__dump
#endif

METHOD knh__ClassRel__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__ClassRel__dump;
	ClassRel* b = KNH_CAST_ClassRelOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_ClassRel__dump(ctx, b, w, m);

	BEFORE_knh__ClassRel__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Connection_close
#define BEFORE_knh__Connection_close
#endif
#ifndef AFTER_knh__Connection_close
#define AFTER_knh__Connection_close
#endif

METHOD knh__Connection_close(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Connection_close;
	Connection* b = KNH_CAST_ConnectionOrNull(ctx, sf[0]);

	knh_Connection_close(ctx, b);

	BEFORE_knh__Connection_close;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Context_getProperty
#define BEFORE_knh__Context_getProperty
#endif
#ifndef AFTER_knh__Context_getProperty
#define AFTER_knh__Context_getProperty
#endif

METHOD knh__Context_getProperty(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Context_getProperty;
	Context* b = KNH_CAST_ContextOrNull(ctx, sf[0]);
	knh_bytes_t key = knh_Object_tobytes(ctx, sf[1]);

	Any* _rval_ = knh_Context_getProperty(ctx, b, key);

	BEFORE_knh__Context_getProperty;
	KNH_SETr(ctx, sf, KNH_CAST_ObjectOrNull(ctx, _rval_));
}


#ifndef BEFORE_knh__Context_setProperty
#define BEFORE_knh__Context_setProperty
#endif
#ifndef AFTER_knh__Context_setProperty
#define AFTER_knh__Context_setProperty
#endif

METHOD knh__Context_setProperty(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Context_setProperty;
	Context* b = KNH_CAST_ContextOrNull(ctx, sf[0]);
	String* key = KNH_CAST_String(ctx, sf[1]);
	Any* value = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Context_setProperty(ctx, b, key, value);

	BEFORE_knh__Context_setProperty;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Context__dump
#define BEFORE_knh__Context__dump
#endif
#ifndef AFTER_knh__Context__dump
#define AFTER_knh__Context__dump
#endif

METHOD knh__Context__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Context__dump;
	Context* b = KNH_CAST_ContextOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Context__dump(ctx, b, w, m);

	BEFORE_knh__Context__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__DictIdx_index
#define BEFORE_knh__DictIdx_index
#endif
#ifndef AFTER_knh__DictIdx_index
#define AFTER_knh__DictIdx_index
#endif

METHOD knh__DictIdx_index(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictIdx_index;
	DictIdx* b = KNH_CAST_DictIdxOrNull(ctx, sf[0]);
	knh_bytes_t v = knh_Object_tobytes(ctx, sf[1]);

	knh_index_t _rval_ = knh_DictIdx_index(ctx, b, v);

	BEFORE_knh__DictIdx_index;
	KNH_SAFE_SETr(ctx, sf, new_Int(ctx, _rval_));
}


#ifndef BEFORE_knh__DictIdx_add__fast
#define BEFORE_knh__DictIdx_add__fast
#endif
#ifndef AFTER_knh__DictIdx_add__fast
#define AFTER_knh__DictIdx_add__fast
#endif

METHOD knh__DictIdx_add__fast(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictIdx_add__fast;
	DictIdx* b = KNH_CAST_DictIdxOrNull(ctx, sf[0]);
	String* term = KNH_CAST_String(ctx, sf[1]);

	knh_index_t _rval_ = knh_DictIdx_add__fast(ctx, b, term);

	BEFORE_knh__DictIdx_add__fast;
	KNH_SAFE_SETr(ctx, sf, new_Int(ctx, _rval_));
}


#ifndef BEFORE_knh__DictIdx_add
#define BEFORE_knh__DictIdx_add
#endif
#ifndef AFTER_knh__DictIdx_add
#define AFTER_knh__DictIdx_add
#endif

METHOD knh__DictIdx_add(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictIdx_add;
	DictIdx* b = KNH_CAST_DictIdxOrNull(ctx, sf[0]);
	String* term = KNH_CAST_String(ctx, sf[1]);

	knh_index_t _rval_ = knh_DictIdx_add(ctx, b, term);

	BEFORE_knh__DictIdx_add;
	KNH_SAFE_SETr(ctx, sf, new_Int(ctx, _rval_));
}


#ifndef BEFORE_knh__DictIdx_get__fast
#define BEFORE_knh__DictIdx_get__fast
#endif
#ifndef AFTER_knh__DictIdx_get__fast
#define AFTER_knh__DictIdx_get__fast
#endif

METHOD knh__DictIdx_get__fast(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictIdx_get__fast;
	DictIdx* b = KNH_CAST_DictIdxOrNull(ctx, sf[0]);
	knh_int_t termid = knh_Int_value((Int*)sf[1]);

	String* _rval_ = knh_DictIdx_get__fast(b, termid);

	BEFORE_knh__DictIdx_get__fast;
	KNH_SETr(ctx, sf, KNH_CAST_StringOrNull(ctx, _rval_));
}


#ifndef BEFORE_knh__DictIdx_get
#define BEFORE_knh__DictIdx_get
#endif
#ifndef AFTER_knh__DictIdx_get
#define AFTER_knh__DictIdx_get
#endif

METHOD knh__DictIdx_get(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictIdx_get;
	DictIdx* b = KNH_CAST_DictIdxOrNull(ctx, sf[0]);
	knh_int_t termid = knh_Int_value((Int*)sf[1]);

	String* _rval_ = knh_DictIdx_get(b, termid);

	BEFORE_knh__DictIdx_get;
	KNH_SETr(ctx, sf, KNH_CAST_StringOrNull(ctx, _rval_));
}


#ifndef BEFORE_knh__DictIdx_clear
#define BEFORE_knh__DictIdx_clear
#endif
#ifndef AFTER_knh__DictIdx_clear
#define AFTER_knh__DictIdx_clear
#endif

METHOD knh__DictIdx_clear(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictIdx_clear;
	DictIdx* b = KNH_CAST_DictIdxOrNull(ctx, sf[0]);

	knh_DictIdx_clear(ctx, b);

	BEFORE_knh__DictIdx_clear;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__DictIdx__dump
#define BEFORE_knh__DictIdx__dump
#endif
#ifndef AFTER_knh__DictIdx__dump
#define AFTER_knh__DictIdx__dump
#endif

METHOD knh__DictIdx__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictIdx__dump;
	DictIdx* b = KNH_CAST_DictIdxOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_DictIdx__dump(ctx, b, w, m);

	BEFORE_knh__DictIdx__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__DictMap_new
#define BEFORE_knh__DictMap_new
#endif
#ifndef AFTER_knh__DictMap_new
#define AFTER_knh__DictMap_new
#endif

METHOD knh__DictMap_new(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictMap_new;
	DictMap* b = KNH_CAST_DictMapOrNull(ctx, sf[0]);
	knh_int_t initialCapacity = knh_Int_value((Int*)sf[1]);

	DictMap* _rval_ = knh_DictMap_new(ctx, b, initialCapacity);

	BEFORE_knh__DictMap_new;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_DictMap(ctx, _rval_));
}


#ifndef BEFORE_knh__DictMap_new__init
#define BEFORE_knh__DictMap_new__init
#endif
#ifndef AFTER_knh__DictMap_new__init
#define AFTER_knh__DictMap_new__init
#endif

METHOD knh__DictMap_new__init(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictMap_new__init;
	DictMap* b = KNH_CAST_DictMapOrNull(ctx, sf[0]);
	knh_vargc_t ac = knh_stackf_argc(ctx, &(sf[1]));
	Any** a = (Any**)&(sf[1]);

	DictMap* _rval_ = knh_DictMap_new__init(ctx, b, ac, a);

	BEFORE_knh__DictMap_new__init;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_DictMap(ctx, _rval_));
}


#ifndef BEFORE_knh__DictMap_get
#define BEFORE_knh__DictMap_get
#endif
#ifndef AFTER_knh__DictMap_get
#define AFTER_knh__DictMap_get
#endif

METHOD knh__DictMap_get(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictMap_get;
	DictMap* b = KNH_CAST_DictMapOrNull(ctx, sf[0]);
	String* key = KNH_CAST_String(ctx, sf[1]);

	Any* _rval_ = knh_DictMap_get(ctx, b, key);

	BEFORE_knh__DictMap_get;
	KNH_SETr(ctx, sf, KNH_CAST_ObjectOrNull(ctx, _rval_));
}


#ifndef BEFORE_knh__DictMap_append
#define BEFORE_knh__DictMap_append
#endif
#ifndef AFTER_knh__DictMap_append
#define AFTER_knh__DictMap_append
#endif

METHOD knh__DictMap_append(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictMap_append;
	DictMap* b = KNH_CAST_DictMapOrNull(ctx, sf[0]);
	String* key = KNH_CAST_String(ctx, sf[1]);
	Any* value = KNH_CAST_Object(ctx, sf[2]);

	knh_DictMap_append(ctx, b, key, value);

	BEFORE_knh__DictMap_append;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__DictMap_set
#define BEFORE_knh__DictMap_set
#endif
#ifndef AFTER_knh__DictMap_set
#define AFTER_knh__DictMap_set
#endif

METHOD knh__DictMap_set(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictMap_set;
	DictMap* b = KNH_CAST_DictMapOrNull(ctx, sf[0]);
	String* key = KNH_CAST_String(ctx, sf[1]);
	Any* value = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_DictMap_set(ctx, b, key, value);

	BEFORE_knh__DictMap_set;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__DictMap_remove
#define BEFORE_knh__DictMap_remove
#endif
#ifndef AFTER_knh__DictMap_remove
#define AFTER_knh__DictMap_remove
#endif

METHOD knh__DictMap_remove(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictMap_remove;
	DictMap* b = KNH_CAST_DictMapOrNull(ctx, sf[0]);
	String* key = KNH_CAST_String(ctx, sf[1]);

	knh_DictMap_remove(ctx, b, key);

	BEFORE_knh__DictMap_remove;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__DictMap_clear
#define BEFORE_knh__DictMap_clear
#endif
#ifndef AFTER_knh__DictMap_clear
#define AFTER_knh__DictMap_clear
#endif

METHOD knh__DictMap_clear(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictMap_clear;
	DictMap* b = KNH_CAST_DictMapOrNull(ctx, sf[0]);

	knh_DictMap_clear(ctx, b);

	BEFORE_knh__DictMap_clear;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__DictMap__dump
#define BEFORE_knh__DictMap__dump
#endif
#ifndef AFTER_knh__DictMap__dump
#define AFTER_knh__DictMap__dump
#endif

METHOD knh__DictMap__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictMap__dump;
	DictMap* b = KNH_CAST_DictMapOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_DictMap__dump(ctx, b, w, m);

	BEFORE_knh__DictMap__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__DictSet_new
#define BEFORE_knh__DictSet_new
#endif
#ifndef AFTER_knh__DictSet_new
#define AFTER_knh__DictSet_new
#endif

METHOD knh__DictSet_new(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictSet_new;
	DictSet* b = KNH_CAST_DictSetOrNull(ctx, sf[0]);
	knh_int_t initialCapacity = IS_NULL(sf[1]) ? (knh_int_t)0 : knh_Int_value((Int*)sf[1]);

	DictSet* _rval_ = knh_DictSet_new(ctx, b, initialCapacity);

	BEFORE_knh__DictSet_new;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_DictSet(ctx, _rval_));
}


#ifndef BEFORE_knh__DictSet_get
#define BEFORE_knh__DictSet_get
#endif
#ifndef AFTER_knh__DictSet_get
#define AFTER_knh__DictSet_get
#endif

METHOD knh__DictSet_get(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictSet_get;
	DictSet* b = KNH_CAST_DictSetOrNull(ctx, sf[0]);
	String* key = KNH_CAST_String(ctx, sf[1]);

	knh_int_t _rval_ = knh_DictSet_get(b, key);

	BEFORE_knh__DictSet_get;
	KNH_SAFE_SETr(ctx, sf, new_Int(ctx, _rval_));
}


#ifndef BEFORE_knh__DictSet_opIn
#define BEFORE_knh__DictSet_opIn
#endif
#ifndef AFTER_knh__DictSet_opIn
#define AFTER_knh__DictSet_opIn
#endif

METHOD knh__DictSet_opIn(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictSet_opIn;
	DictSet* b = KNH_CAST_DictSetOrNull(ctx, sf[0]);
	Any* value = KNH_CAST_ObjectOrNull(ctx, sf[1]);

	knh_bool_t _rval_ = knh_DictSet_opIn(ctx, b, value);

	BEFORE_knh__DictSet_opIn;
	KNH_SETr(ctx, sf, new_Bool(ctx, _rval_));
}


#ifndef BEFORE_knh__DictSet_set
#define BEFORE_knh__DictSet_set
#endif
#ifndef AFTER_knh__DictSet_set
#define AFTER_knh__DictSet_set
#endif

METHOD knh__DictSet_set(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictSet_set;
	DictSet* b = KNH_CAST_DictSetOrNull(ctx, sf[0]);
	String* key = KNH_CAST_String(ctx, sf[1]);
	knh_uint_t value = (knh_uint_t)knh_Int_value((Int*)sf[2]);

	knh_DictSet_set(ctx, b, key, value);

	BEFORE_knh__DictSet_set;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__DictSet_add
#define BEFORE_knh__DictSet_add
#endif
#ifndef AFTER_knh__DictSet_add
#define AFTER_knh__DictSet_add
#endif

METHOD knh__DictSet_add(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictSet_add;
	DictSet* b = KNH_CAST_DictSetOrNull(ctx, sf[0]);
	String* key = KNH_CAST_String(ctx, sf[1]);

	knh_DictSet_add(ctx, b, key);

	BEFORE_knh__DictSet_add;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__DictSet_clear
#define BEFORE_knh__DictSet_clear
#endif
#ifndef AFTER_knh__DictSet_clear
#define AFTER_knh__DictSet_clear
#endif

METHOD knh__DictSet_clear(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictSet_clear;
	DictSet* b = KNH_CAST_DictSetOrNull(ctx, sf[0]);

	knh_DictSet_clear(ctx, b);

	BEFORE_knh__DictSet_clear;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__DictSet__dump
#define BEFORE_knh__DictSet__dump
#endif
#ifndef AFTER_knh__DictSet__dump
#define AFTER_knh__DictSet__dump
#endif

METHOD knh__DictSet__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__DictSet__dump;
	DictSet* b = KNH_CAST_DictSetOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_DictSet__dump(ctx, b, w, m);

	BEFORE_knh__DictSet__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Exception_new
#define BEFORE_knh__Exception_new
#endif
#ifndef AFTER_knh__Exception_new
#define AFTER_knh__Exception_new
#endif

METHOD knh__Exception_new(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Exception_new;
	Exception* b = KNH_CAST_ExceptionOrNull(ctx, sf[0]);
	String* e = KNH_CAST_String(ctx, sf[1]);
	String* msg = KNH_CAST_StringOrNull(ctx, sf[2]);
	Any* bag = KNH_CAST_ObjectOrNull(ctx, sf[3]);

	Exception* _rval_ = knh_Exception_new(ctx, b, e, msg, bag);

	BEFORE_knh__Exception_new;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_Exception(ctx, _rval_));
}


#ifndef BEFORE_knh__Exception__s
#define BEFORE_knh__Exception__s
#endif
#ifndef AFTER_knh__Exception__s
#define AFTER_knh__Exception__s
#endif

METHOD knh__Exception__s(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Exception__s;
	Exception* b = KNH_CAST_ExceptionOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Exception__s(ctx, b, w, m);

	BEFORE_knh__Exception__s;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Exception__dump
#define BEFORE_knh__Exception__dump
#endif
#ifndef AFTER_knh__Exception__dump
#define AFTER_knh__Exception__dump
#endif

METHOD knh__Exception__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Exception__dump;
	Exception* b = KNH_CAST_ExceptionOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Exception__dump(ctx, b, w, m);

	BEFORE_knh__Exception__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__HashMap_new
#define BEFORE_knh__HashMap_new
#endif
#ifndef AFTER_knh__HashMap_new
#define AFTER_knh__HashMap_new
#endif

METHOD knh__HashMap_new(Ctx *ctx, Object **sf)
{
	BEFORE_knh__HashMap_new;
	HashMap* b = KNH_CAST_HashMapOrNull(ctx, sf[0]);
	size_t initialCapacity = IS_NULL(sf[1]) ? (size_t)0 : (size_t)knh_Int_value((Int*)sf[1]);

	HashMap* _rval_ = knh_HashMap_new(ctx, b, initialCapacity);

	BEFORE_knh__HashMap_new;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_HashMap(ctx, _rval_));
}


#ifndef BEFORE_knh__HashMap_new__init
#define BEFORE_knh__HashMap_new__init
#endif
#ifndef AFTER_knh__HashMap_new__init
#define AFTER_knh__HashMap_new__init
#endif

METHOD knh__HashMap_new__init(Ctx *ctx, Object **sf)
{
	BEFORE_knh__HashMap_new__init;
	HashMap* b = KNH_CAST_HashMapOrNull(ctx, sf[0]);
	knh_vargc_t ac = knh_stackf_argc(ctx, &(sf[1]));
	Any** a = (Any**)&(sf[1]);

	HashMap* _rval_ = knh_HashMap_new__init(ctx, b, ac, a);

	BEFORE_knh__HashMap_new__init;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_HashMap(ctx, _rval_));
}


#ifndef BEFORE_knh__HashMap_get
#define BEFORE_knh__HashMap_get
#endif
#ifndef AFTER_knh__HashMap_get
#define AFTER_knh__HashMap_get
#endif

METHOD knh__HashMap_get(Ctx *ctx, Object **sf)
{
	BEFORE_knh__HashMap_get;
	HashMap* b = KNH_CAST_HashMapOrNull(ctx, sf[0]);
	knh_hcode_t key = knh_Object_hcode(ctx,sf[1]);
	Any* kobj = KNH_CAST_ObjectOrNull(ctx, sf[1]);

	Any* _rval_ = knh_HashMap_get(ctx, b, key, kobj);

	BEFORE_knh__HashMap_get;
	KNH_SETr(ctx, sf, KNH_CAST_ObjectOrNull(ctx, _rval_));
}


#ifndef BEFORE_knh__HashMap_set
#define BEFORE_knh__HashMap_set
#endif
#ifndef AFTER_knh__HashMap_set
#define AFTER_knh__HashMap_set
#endif

METHOD knh__HashMap_set(Ctx *ctx, Object **sf)
{
	BEFORE_knh__HashMap_set;
	HashMap* b = KNH_CAST_HashMapOrNull(ctx, sf[0]);
	knh_hcode_t key = knh_Object_hcode(ctx,sf[1]);
	Any* kobj = KNH_CAST_Object(ctx, sf[1]);
	Any* value = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_HashMap_set(ctx, b, key, kobj, value);

	BEFORE_knh__HashMap_set;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__HashMap_remove
#define BEFORE_knh__HashMap_remove
#endif
#ifndef AFTER_knh__HashMap_remove
#define AFTER_knh__HashMap_remove
#endif

METHOD knh__HashMap_remove(Ctx *ctx, Object **sf)
{
	BEFORE_knh__HashMap_remove;
	HashMap* b = KNH_CAST_HashMapOrNull(ctx, sf[0]);
	knh_hcode_t key = knh_Object_hcode(ctx,sf[1]);
	Any* kobj = KNH_CAST_ObjectOrNull(ctx, sf[1]);

	knh_HashMap_remove(ctx, b, key, kobj);

	BEFORE_knh__HashMap_remove;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__HashMap_opIn
#define BEFORE_knh__HashMap_opIn
#endif
#ifndef AFTER_knh__HashMap_opIn
#define AFTER_knh__HashMap_opIn
#endif

METHOD knh__HashMap_opIn(Ctx *ctx, Object **sf)
{
	BEFORE_knh__HashMap_opIn;
	HashMap* b = KNH_CAST_HashMapOrNull(ctx, sf[0]);
	knh_hcode_t key = knh_Object_hcode(ctx,sf[1]);
	Any* keyobj = KNH_CAST_ObjectOrNull(ctx, sf[1]);

	knh_bool_t _rval_ = knh_HashMap_opIn(ctx, b, key, keyobj);

	BEFORE_knh__HashMap_opIn;
	KNH_SETr(ctx, sf, new_Bool(ctx, _rval_));
}


#ifndef BEFORE_knh__HashMap_keys
#define BEFORE_knh__HashMap_keys
#endif
#ifndef AFTER_knh__HashMap_keys
#define AFTER_knh__HashMap_keys
#endif

METHOD knh__HashMap_keys(Ctx *ctx, Object **sf)
{
	BEFORE_knh__HashMap_keys;
	HashMap* b = KNH_CAST_HashMapOrNull(ctx, sf[0]);

	Iterator* _rval_ = knh_HashMap_keys(ctx, b);

	BEFORE_knh__HashMap_keys;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_Iterator(ctx, _rval_));
}


#ifndef BEFORE_knh__HashMap__dump
#define BEFORE_knh__HashMap__dump
#endif
#ifndef AFTER_knh__HashMap__dump
#define AFTER_knh__HashMap__dump
#endif

METHOD knh__HashMap__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__HashMap__dump;
	HashMap* b = KNH_CAST_HashMapOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_HashMap__dump(ctx, b, w, m);

	BEFORE_knh__HashMap__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__HashSet_new
#define BEFORE_knh__HashSet_new
#endif
#ifndef AFTER_knh__HashSet_new
#define AFTER_knh__HashSet_new
#endif

METHOD knh__HashSet_new(Ctx *ctx, Object **sf)
{
	BEFORE_knh__HashSet_new;
	HashSet* b = KNH_CAST_HashSetOrNull(ctx, sf[0]);
	size_t initialCapacity = IS_NULL(sf[1]) ? (size_t)0 : (size_t)knh_Int_value((Int*)sf[1]);

	HashSet* _rval_ = knh_HashSet_new(ctx, b, initialCapacity);

	BEFORE_knh__HashSet_new;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_HashSet(ctx, _rval_));
}


#ifndef BEFORE_knh__HashSet_get
#define BEFORE_knh__HashSet_get
#endif
#ifndef AFTER_knh__HashSet_get
#define AFTER_knh__HashSet_get
#endif

METHOD knh__HashSet_get(Ctx *ctx, Object **sf)
{
	BEFORE_knh__HashSet_get;
	HashSet* b = KNH_CAST_HashSetOrNull(ctx, sf[0]);
	knh_hcode_t key = knh_Object_hcode(ctx,sf[1]);
	Any* keyobj = KNH_CAST_ObjectOrNull(ctx, sf[1]);

	knh_uint_t _rval_ = knh_HashSet_get(ctx, b, key, keyobj);

	BEFORE_knh__HashSet_get;
	KNH_SAFE_SETr(ctx, sf, new_Int(ctx, _rval_));
}


#ifndef BEFORE_knh__HashSet_opIn
#define BEFORE_knh__HashSet_opIn
#endif
#ifndef AFTER_knh__HashSet_opIn
#define AFTER_knh__HashSet_opIn
#endif

METHOD knh__HashSet_opIn(Ctx *ctx, Object **sf)
{
	BEFORE_knh__HashSet_opIn;
	HashSet* b = KNH_CAST_HashSetOrNull(ctx, sf[0]);
	knh_hcode_t key = knh_Object_hcode(ctx,sf[1]);
	Any* keyobj = KNH_CAST_ObjectOrNull(ctx, sf[1]);

	knh_bool_t _rval_ = knh_HashSet_opIn(ctx, b, key, keyobj);

	BEFORE_knh__HashSet_opIn;
	KNH_SETr(ctx, sf, new_Bool(ctx, _rval_));
}


#ifndef BEFORE_knh__HashSet_set
#define BEFORE_knh__HashSet_set
#endif
#ifndef AFTER_knh__HashSet_set
#define AFTER_knh__HashSet_set
#endif

METHOD knh__HashSet_set(Ctx *ctx, Object **sf)
{
	BEFORE_knh__HashSet_set;
	HashSet* b = KNH_CAST_HashSetOrNull(ctx, sf[0]);
	knh_hcode_t key = knh_Object_hcode(ctx,sf[1]);
	Any* keyobj = KNH_CAST_ObjectOrNull(ctx, sf[1]);
	knh_uint_t value = (knh_uint_t)knh_Int_value((Int*)sf[2]);

	knh_HashSet_set(ctx, b, key, keyobj, value);

	BEFORE_knh__HashSet_set;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__HashSet_add
#define BEFORE_knh__HashSet_add
#endif
#ifndef AFTER_knh__HashSet_add
#define AFTER_knh__HashSet_add
#endif

METHOD knh__HashSet_add(Ctx *ctx, Object **sf)
{
	BEFORE_knh__HashSet_add;
	HashSet* b = KNH_CAST_HashSetOrNull(ctx, sf[0]);
	knh_hcode_t key = knh_Object_hcode(ctx,sf[1]);
	Any* keyobj = KNH_CAST_ObjectOrNull(ctx, sf[1]);

	knh_HashSet_add(ctx, b, key, keyobj);

	BEFORE_knh__HashSet_add;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__HashSet_remove
#define BEFORE_knh__HashSet_remove
#endif
#ifndef AFTER_knh__HashSet_remove
#define AFTER_knh__HashSet_remove
#endif

METHOD knh__HashSet_remove(Ctx *ctx, Object **sf)
{
	BEFORE_knh__HashSet_remove;
	HashSet* b = KNH_CAST_HashSetOrNull(ctx, sf[0]);
	knh_hcode_t key = knh_Object_hcode(ctx,sf[1]);
	Any* keyobj = KNH_CAST_ObjectOrNull(ctx, sf[1]);

	knh_HashSet_remove(ctx, b, key, keyobj);

	BEFORE_knh__HashSet_remove;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__HashSet__dump
#define BEFORE_knh__HashSet__dump
#endif
#ifndef AFTER_knh__HashSet__dump
#define AFTER_knh__HashSet__dump
#endif

METHOD knh__HashSet__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__HashSet__dump;
	HashSet* b = KNH_CAST_HashSetOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_HashSet__dump(ctx, b, w, m);

	BEFORE_knh__HashSet__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__InputStream_readLine
#define BEFORE_knh__InputStream_readLine
#endif
#ifndef AFTER_knh__InputStream_readLine
#define AFTER_knh__InputStream_readLine
#endif

METHOD knh__InputStream_readLine(Ctx *ctx, Object **sf)
{
	BEFORE_knh__InputStream_readLine;
	InputStream* b = KNH_CAST_InputStreamOrNull(ctx, sf[0]);

	String* _rval_ = knh_InputStream_readLine(ctx, b);

	BEFORE_knh__InputStream_readLine;
	KNH_SETr(ctx, sf, KNH_CAST_StringOrNull(ctx, _rval_));
}


#ifndef BEFORE_knh__InputStream_close
#define BEFORE_knh__InputStream_close
#endif
#ifndef AFTER_knh__InputStream_close
#define AFTER_knh__InputStream_close
#endif

METHOD knh__InputStream_close(Ctx *ctx, Object **sf)
{
	BEFORE_knh__InputStream_close;
	InputStream* b = KNH_CAST_InputStreamOrNull(ctx, sf[0]);

	knh_InputStream_close(ctx, b);

	BEFORE_knh__InputStream_close;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__InputStream__dump
#define BEFORE_knh__InputStream__dump
#endif
#ifndef AFTER_knh__InputStream__dump
#define AFTER_knh__InputStream__dump
#endif

METHOD knh__InputStream__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__InputStream__dump;
	InputStream* b = KNH_CAST_InputStreamOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_InputStream__dump(ctx, b, w, m);

	BEFORE_knh__InputStream__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Int64__dump
#define BEFORE_knh__Int64__dump
#endif
#ifndef AFTER_knh__Int64__dump
#define AFTER_knh__Int64__dump
#endif

METHOD knh__Int64__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Int64__dump;
	Int64* b = KNH_CAST_Int64OrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Int64__dump(ctx, b, w, m);

	BEFORE_knh__Int64__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Iterator__dump
#define BEFORE_knh__Iterator__dump
#endif
#ifndef AFTER_knh__Iterator__dump
#define AFTER_knh__Iterator__dump
#endif

METHOD knh__Iterator__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Iterator__dump;
	Iterator* b = KNH_CAST_IteratorOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Iterator__dump(ctx, b, w, m);

	BEFORE_knh__Iterator__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__MapMap__dump
#define BEFORE_knh__MapMap__dump
#endif
#ifndef AFTER_knh__MapMap__dump
#define AFTER_knh__MapMap__dump
#endif

METHOD knh__MapMap__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__MapMap__dump;
	MapMap* b = KNH_CAST_MapMapOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_MapMap__dump(ctx, b, w, m);

	BEFORE_knh__MapMap__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Method_isAbstract
#define BEFORE_knh__Method_isAbstract
#endif
#ifndef AFTER_knh__Method_isAbstract
#define AFTER_knh__Method_isAbstract
#endif

METHOD knh__Method_isAbstract(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Method_isAbstract;
	Method* b = KNH_CAST_MethodOrNull(ctx, sf[0]);

	knh_bool_t _rval_ = knh_Method_isAbstract(b);

	BEFORE_knh__Method_isAbstract;
	KNH_SETr(ctx, sf, new_Bool(ctx, _rval_));
}


#ifndef BEFORE_knh__Method_getName
#define BEFORE_knh__Method_getName
#endif
#ifndef AFTER_knh__Method_getName
#define AFTER_knh__Method_getName
#endif

METHOD knh__Method_getName(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Method_getName;
	Method* b = KNH_CAST_MethodOrNull(ctx, sf[0]);

	String* _rval_ = knh_Method_getName(ctx, b);

	BEFORE_knh__Method_getName;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_String(ctx, _rval_));
}


#ifndef BEFORE_knh__Method_getURN
#define BEFORE_knh__Method_getURN
#endif
#ifndef AFTER_knh__Method_getURN
#define AFTER_knh__Method_getURN
#endif

METHOD knh__Method_getURN(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Method_getURN;
	Method* b = KNH_CAST_MethodOrNull(ctx, sf[0]);

	String* _rval_ = knh_Method_getURN(ctx, b);

	BEFORE_knh__Method_getURN;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_String(ctx, _rval_));
}


#ifndef BEFORE_knh__Method__s
#define BEFORE_knh__Method__s
#endif
#ifndef AFTER_knh__Method__s
#define AFTER_knh__Method__s
#endif

METHOD knh__Method__s(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Method__s;
	Method* b = KNH_CAST_MethodOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Method__s(ctx, b, w, m);

	BEFORE_knh__Method__s;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Method__dump
#define BEFORE_knh__Method__dump
#endif
#ifndef AFTER_knh__Method__dump
#define AFTER_knh__Method__dump
#endif

METHOD knh__Method__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Method__dump;
	Method* b = KNH_CAST_MethodOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Method__dump(ctx, b, w, m);

	BEFORE_knh__Method__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Mutex__dump
#define BEFORE_knh__Mutex__dump
#endif
#ifndef AFTER_knh__Mutex__dump
#define AFTER_knh__Mutex__dump
#endif

METHOD knh__Mutex__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Mutex__dump;
	Mutex* b = KNH_CAST_MutexOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Mutex__dump(ctx, b, w, m);

	BEFORE_knh__Mutex__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__NameSpace_setClass
#define BEFORE_knh__NameSpace_setClass
#endif
#ifndef AFTER_knh__NameSpace_setClass
#define AFTER_knh__NameSpace_setClass
#endif

METHOD knh__NameSpace_setClass(Ctx *ctx, Object **sf)
{
	BEFORE_knh__NameSpace_setClass;
	NameSpace* b = KNH_CAST_NameSpaceOrNull(ctx, sf[0]);
	String* name = KNH_CAST_StringOrNull(ctx, sf[1]);
	knh_class_t c = knh_Class_class((Class*)sf[2]);

	knh_NameSpace_setClass(ctx, b, name, c);

	BEFORE_knh__NameSpace_setClass;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__NameSpace_getClass
#define BEFORE_knh__NameSpace_getClass
#endif
#ifndef AFTER_knh__NameSpace_getClass
#define AFTER_knh__NameSpace_getClass
#endif

METHOD knh__NameSpace_getClass(Ctx *ctx, Object **sf)
{
	BEFORE_knh__NameSpace_getClass;
	NameSpace* b = KNH_CAST_NameSpaceOrNull(ctx, sf[0]);
	knh_bytes_t name = knh_Object_tobytes(ctx, sf[1]);

	knh_class_t _rval_ = knh_NameSpace_getClass(ctx, b, name);

	BEFORE_knh__NameSpace_getClass;
	KNH_SETr(ctx, sf, new_Class__type(ctx, _rval_));
}


#ifndef BEFORE_knh__Nue__s
#define BEFORE_knh__Nue__s
#endif
#ifndef AFTER_knh__Nue__s
#define AFTER_knh__Nue__s
#endif

METHOD knh__Nue__s(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Nue__s;
	Nue* b = KNH_CAST_NueOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Nue__s(ctx, b, w, m);

	BEFORE_knh__Nue__s;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Object_getClass
#define BEFORE_knh__Object_getClass
#endif
#ifndef AFTER_knh__Object_getClass
#define AFTER_knh__Object_getClass
#endif

METHOD knh__Object_getClass(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Object_getClass;
	Any* b = KNH_CAST_ObjectOrNull(ctx, sf[0]);

	knh_class_t _rval_ = knh_Object_getClass(b);

	BEFORE_knh__Object_getClass;
	KNH_SAFE_SETr(ctx, sf, new_Class__type(ctx, _rval_));
}


#ifndef BEFORE_knh__Object_compare
#define BEFORE_knh__Object_compare
#endif
#ifndef AFTER_knh__Object_compare
#define AFTER_knh__Object_compare
#endif

METHOD knh__Object_compare(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Object_compare;
	Any* o1 = KNH_CAST_ObjectOrNull(ctx, sf[0]);
	Any* o2 = KNH_CAST_ObjectOrNull(ctx, sf[1]);

	knh_int_t _rval_ = knh_Object_compare(ctx, o1, o2);

	BEFORE_knh__Object_compare;
	KNH_SAFE_SETr(ctx, sf, new_Int(ctx, _rval_));
}


#ifndef BEFORE_knh__Object__s
#define BEFORE_knh__Object__s
#endif
#ifndef AFTER_knh__Object__s
#define AFTER_knh__Object__s
#endif

METHOD knh__Object__s(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Object__s;
	Any* b = KNH_CAST_ObjectOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Object__s(ctx, b, w, m);

	BEFORE_knh__Object__s;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Object__dump
#define BEFORE_knh__Object__dump
#endif
#ifndef AFTER_knh__Object__dump
#define AFTER_knh__Object__dump
#endif

METHOD knh__Object__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Object__dump;
	Any* b = KNH_CAST_ObjectOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Object__dump(ctx, b, w, m);

	BEFORE_knh__Object__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Object__empty
#define BEFORE_knh__Object__empty
#endif
#ifndef AFTER_knh__Object__empty
#define AFTER_knh__Object__empty
#endif

METHOD knh__Object__empty(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Object__empty;
	Any* b = KNH_CAST_ObjectOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Object__empty(ctx, b, w, m);

	BEFORE_knh__Object__empty;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Object__refc
#define BEFORE_knh__Object__refc
#endif
#ifndef AFTER_knh__Object__refc
#define AFTER_knh__Object__refc
#endif

METHOD knh__Object__refc(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Object__refc;
	Any* b = KNH_CAST_ObjectOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Object__refc(ctx, b, w, m);

	BEFORE_knh__Object__refc;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Object__addr
#define BEFORE_knh__Object__addr
#endif
#ifndef AFTER_knh__Object__addr
#define AFTER_knh__Object__addr
#endif

METHOD knh__Object__addr(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Object__addr;
	Any* b = KNH_CAST_ObjectOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Object__addr(ctx, b, w, m);

	BEFORE_knh__Object__addr;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__OutputStream_write
#define BEFORE_knh__OutputStream_write
#endif
#ifndef AFTER_knh__OutputStream_write
#define AFTER_knh__OutputStream_write
#endif

METHOD knh__OutputStream_write(Ctx *ctx, Object **sf)
{
	BEFORE_knh__OutputStream_write;
	OutputStream* b = KNH_CAST_OutputStreamOrNull(ctx, sf[0]);
	knh_bytes_t buf = knh_Bytes_tobytes(sf[1]);

	knh_OutputStream_write(ctx, b, buf);

	BEFORE_knh__OutputStream_write;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__OutputStream_flush
#define BEFORE_knh__OutputStream_flush
#endif
#ifndef AFTER_knh__OutputStream_flush
#define AFTER_knh__OutputStream_flush
#endif

METHOD knh__OutputStream_flush(Ctx *ctx, Object **sf)
{
	BEFORE_knh__OutputStream_flush;
	OutputStream* b = KNH_CAST_OutputStreamOrNull(ctx, sf[0]);

	knh_OutputStream_flush(ctx, b);

	BEFORE_knh__OutputStream_flush;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__OutputStream_close
#define BEFORE_knh__OutputStream_close
#endif
#ifndef AFTER_knh__OutputStream_close
#define AFTER_knh__OutputStream_close
#endif

METHOD knh__OutputStream_close(Ctx *ctx, Object **sf)
{
	BEFORE_knh__OutputStream_close;
	OutputStream* b = KNH_CAST_OutputStreamOrNull(ctx, sf[0]);

	knh_OutputStream_close(ctx, b);

	BEFORE_knh__OutputStream_close;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__OutputStream__dump
#define BEFORE_knh__OutputStream__dump
#endif
#ifndef AFTER_knh__OutputStream__dump
#define AFTER_knh__OutputStream__dump
#endif

METHOD knh__OutputStream__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__OutputStream__dump;
	OutputStream* b = KNH_CAST_OutputStreamOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_OutputStream__dump(ctx, b, w, m);

	BEFORE_knh__OutputStream__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Prototype__dump
#define BEFORE_knh__Prototype__dump
#endif
#ifndef AFTER_knh__Prototype__dump
#define AFTER_knh__Prototype__dump
#endif

METHOD knh__Prototype__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Prototype__dump;
	Prototype* b = KNH_CAST_PrototypeOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Prototype__dump(ctx, b, w, m);

	BEFORE_knh__Prototype__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Regex_match
#define BEFORE_knh__Regex_match
#endif
#ifndef AFTER_knh__Regex_match
#define AFTER_knh__Regex_match
#endif

METHOD knh__Regex_match(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Regex_match;
	Regex* b = KNH_CAST_RegexOrNull(ctx, sf[0]);
	String* s = KNH_CAST_StringOrNull(ctx, sf[1]);

	knh_bool_t _rval_ = knh_Regex_match(ctx, b, s);

	BEFORE_knh__Regex_match;
	KNH_SETr(ctx, sf, new_Bool(ctx, _rval_));
}


#ifndef BEFORE_knh__Regex__s
#define BEFORE_knh__Regex__s
#endif
#ifndef AFTER_knh__Regex__s
#define AFTER_knh__Regex__s
#endif

METHOD knh__Regex__s(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Regex__s;
	Regex* b = KNH_CAST_RegexOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Regex__s(ctx, b, w, m);

	BEFORE_knh__Regex__s;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Regex__dump
#define BEFORE_knh__Regex__dump
#endif
#ifndef AFTER_knh__Regex__dump
#define AFTER_knh__Regex__dump
#endif

METHOD knh__Regex__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Regex__dump;
	Regex* b = KNH_CAST_RegexOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Regex__dump(ctx, b, w, m);

	BEFORE_knh__Regex__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__ResultSet_next
#define BEFORE_knh__ResultSet_next
#endif
#ifndef AFTER_knh__ResultSet_next
#define AFTER_knh__ResultSet_next
#endif

METHOD knh__ResultSet_next(Ctx *ctx, Object **sf)
{
	BEFORE_knh__ResultSet_next;
	ResultSet* b = KNH_CAST_ResultSetOrNull(ctx, sf[0]);

	ResultSet* _rval_ = knh_ResultSet_next(ctx, b);

	BEFORE_knh__ResultSet_next;
	KNH_SETr(ctx, sf, KNH_CAST_ResultSetOrNull(ctx, _rval_));
}


#ifndef BEFORE_knh__ResultSet__dump
#define BEFORE_knh__ResultSet__dump
#endif
#ifndef AFTER_knh__ResultSet__dump
#define AFTER_knh__ResultSet__dump
#endif

METHOD knh__ResultSet__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__ResultSet__dump;
	ResultSet* b = KNH_CAST_ResultSetOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_ResultSet__dump(ctx, b, w, m);

	BEFORE_knh__ResultSet__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Socket_getInputStream
#define BEFORE_knh__Socket_getInputStream
#endif
#ifndef AFTER_knh__Socket_getInputStream
#define AFTER_knh__Socket_getInputStream
#endif

METHOD knh__Socket_getInputStream(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Socket_getInputStream;
	Socket* b = KNH_CAST_SocketOrNull(ctx, sf[0]);

	InputStream* _rval_ = knh_Socket_getInputStream(ctx, b);

	BEFORE_knh__Socket_getInputStream;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_InputStream(ctx, _rval_));
}


#ifndef BEFORE_knh__Socket_getOutputStream
#define BEFORE_knh__Socket_getOutputStream
#endif
#ifndef AFTER_knh__Socket_getOutputStream
#define AFTER_knh__Socket_getOutputStream
#endif

METHOD knh__Socket_getOutputStream(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Socket_getOutputStream;
	Socket* b = KNH_CAST_SocketOrNull(ctx, sf[0]);

	OutputStream* _rval_ = knh_Socket_getOutputStream(ctx, b);

	BEFORE_knh__Socket_getOutputStream;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_OutputStream(ctx, _rval_));
}


#ifndef BEFORE_knh__Socket_close
#define BEFORE_knh__Socket_close
#endif
#ifndef AFTER_knh__Socket_close
#define AFTER_knh__Socket_close
#endif

METHOD knh__Socket_close(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Socket_close;
	Socket* b = KNH_CAST_SocketOrNull(ctx, sf[0]);

	knh_Socket_close(ctx, b);

	BEFORE_knh__Socket_close;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__String_equals
#define BEFORE_knh__String_equals
#endif
#ifndef AFTER_knh__String_equals
#define AFTER_knh__String_equals
#endif

METHOD knh__String_equals(Ctx *ctx, Object **sf)
{
	BEFORE_knh__String_equals;
	String* b = KNH_CAST_StringOrNull(ctx, sf[0]);
	knh_bytes_t s = knh_Object_tobytes(ctx, sf[1]);

	knh_bool_t _rval_ = knh_String_equals(b, s);

	BEFORE_knh__String_equals;
	KNH_SAFE_SETr(ctx, sf, new_Bool(ctx, _rval_));
}


#ifndef BEFORE_knh__String_startsWith
#define BEFORE_knh__String_startsWith
#endif
#ifndef AFTER_knh__String_startsWith
#define AFTER_knh__String_startsWith
#endif

METHOD knh__String_startsWith(Ctx *ctx, Object **sf)
{
	BEFORE_knh__String_startsWith;
	String* b = KNH_CAST_StringOrNull(ctx, sf[0]);
	knh_bytes_t s = knh_Object_tobytes(ctx, sf[1]);

	knh_bool_t _rval_ = knh_String_startsWith(b, s);

	BEFORE_knh__String_startsWith;
	KNH_SAFE_SETr(ctx, sf, new_Bool(ctx, _rval_));
}


#ifndef BEFORE_knh__String_endsWith
#define BEFORE_knh__String_endsWith
#endif
#ifndef AFTER_knh__String_endsWith
#define AFTER_knh__String_endsWith
#endif

METHOD knh__String_endsWith(Ctx *ctx, Object **sf)
{
	BEFORE_knh__String_endsWith;
	String* b = KNH_CAST_StringOrNull(ctx, sf[0]);
	knh_bytes_t s = knh_Object_tobytes(ctx, sf[1]);

	knh_bool_t _rval_ = knh_String_endsWith(b, s);

	BEFORE_knh__String_endsWith;
	KNH_SAFE_SETr(ctx, sf, new_Bool(ctx, _rval_));
}


#ifndef BEFORE_knh__String_getSize
#define BEFORE_knh__String_getSize
#endif
#ifndef AFTER_knh__String_getSize
#define AFTER_knh__String_getSize
#endif

METHOD knh__String_getSize(Ctx *ctx, Object **sf)
{
	BEFORE_knh__String_getSize;
	String* b = KNH_CAST_StringOrNull(ctx, sf[0]);

	size_t _rval_ = knh_String_getSize(b);

	BEFORE_knh__String_getSize;
	KNH_SAFE_SETr(ctx, sf, new_Int(ctx, _rval_));
}


#ifndef BEFORE_knh__String_opMul
#define BEFORE_knh__String_opMul
#endif
#ifndef AFTER_knh__String_opMul
#define AFTER_knh__String_opMul
#endif

METHOD knh__String_opMul(Ctx *ctx, Object **sf)
{
	BEFORE_knh__String_opMul;
	String* b = KNH_CAST_StringOrNull(ctx, sf[0]);
	knh_int_t n = knh_Int_value((Int*)sf[1]);

	String* _rval_ = knh_String_opMul(ctx, b, n);

	BEFORE_knh__String_opMul;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_String(ctx, _rval_));
}


#ifndef BEFORE_knh__String__s
#define BEFORE_knh__String__s
#endif
#ifndef AFTER_knh__String__s
#define AFTER_knh__String__s
#endif

METHOD knh__String__s(Ctx *ctx, Object **sf)
{
	BEFORE_knh__String__s;
	String* b = KNH_CAST_StringOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_String__s(ctx, b, w, m);

	BEFORE_knh__String__s;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__String__dump
#define BEFORE_knh__String__dump
#endif
#ifndef AFTER_knh__String__dump
#define AFTER_knh__String__dump
#endif

METHOD knh__String__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__String__dump;
	String* b = KNH_CAST_StringOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_String__dump(ctx, b, w, m);

	BEFORE_knh__String__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__System_getProperty
#define BEFORE_knh__System_getProperty
#endif
#ifndef AFTER_knh__System_getProperty
#define AFTER_knh__System_getProperty
#endif

METHOD knh__System_getProperty(Ctx *ctx, Object **sf)
{
	BEFORE_knh__System_getProperty;
	System* b = KNH_CAST_SystemOrNull(ctx, sf[0]);
	knh_bytes_t key = knh_Object_tobytes(ctx, sf[1]);

	Any* _rval_ = knh_System_getProperty(ctx, b, key);

	BEFORE_knh__System_getProperty;
	KNH_SETr(ctx, sf, KNH_CAST_ObjectOrNull(ctx, _rval_));
}


#ifndef BEFORE_knh__System_setProperty
#define BEFORE_knh__System_setProperty
#endif
#ifndef AFTER_knh__System_setProperty
#define AFTER_knh__System_setProperty
#endif

METHOD knh__System_setProperty(Ctx *ctx, Object **sf)
{
	BEFORE_knh__System_setProperty;
	System* b = KNH_CAST_SystemOrNull(ctx, sf[0]);
	String* key = KNH_CAST_String(ctx, sf[1]);
	Any* value = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_System_setProperty(ctx, b, key, value);

	BEFORE_knh__System_setProperty;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__System__dump
#define BEFORE_knh__System__dump
#endif
#ifndef AFTER_knh__System__dump
#define AFTER_knh__System__dump
#endif

METHOD knh__System__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__System__dump;
	System* b = KNH_CAST_SystemOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_System__dump(ctx, b, w, m);

	BEFORE_knh__System__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Array_new
#define BEFORE_knh__Array_new
#endif
#ifndef AFTER_knh__Array_new
#define AFTER_knh__Array_new
#endif

METHOD knh__Array_new(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Array_new;
	Array* b = KNH_CAST_ArrayOrNull(ctx, sf[0]);
	knh_int_t init = knh_Int_value((Int*)sf[1]);

	Array* _rval_ = knh_Array_new(ctx, b, init);

	BEFORE_knh__Array_new;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_Array(ctx, _rval_));
}


#ifndef BEFORE_knh__Array_new__array
#define BEFORE_knh__Array_new__array
#endif
#ifndef AFTER_knh__Array_new__array
#define AFTER_knh__Array_new__array
#endif

METHOD knh__Array_new__array(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Array_new__array;
	Array* b = KNH_CAST_ArrayOrNull(ctx, sf[0]);
	knh_int_t init = knh_Int_value((Int*)sf[1]);
	Any* value = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	Array* _rval_ = knh_Array_new__array(ctx, b, init, value);

	BEFORE_knh__Array_new__array;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_Array(ctx, _rval_));
}


#ifndef BEFORE_knh__Array_new__init
#define BEFORE_knh__Array_new__init
#endif
#ifndef AFTER_knh__Array_new__init
#define AFTER_knh__Array_new__init
#endif

METHOD knh__Array_new__init(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Array_new__init;
	Array* b = KNH_CAST_ArrayOrNull(ctx, sf[0]);
	knh_vargc_t n = knh_stackf_argc(ctx, &(sf[1]));
	Any** v = (Any**)&(sf[1]);

	Array* _rval_ = knh_Array_new__init(ctx, b, n, v);

	BEFORE_knh__Array_new__init;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_Array(ctx, _rval_));
}


#ifndef BEFORE_knh__Array_get__fast
#define BEFORE_knh__Array_get__fast
#endif
#ifndef AFTER_knh__Array_get__fast
#define AFTER_knh__Array_get__fast
#endif

METHOD knh__Array_get__fast(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Array_get__fast;
	Array* b = KNH_CAST_ArrayOrNull(ctx, sf[0]);
	size_t index = (size_t)knh_Int_value((Int*)sf[1]);

	Any* _rval_ = knh_Array_get__fast(b, index);

	BEFORE_knh__Array_get__fast;
	KNH_SETr(ctx, sf, KNH_CAST_ObjectOrNull(ctx, _rval_));
}


#ifndef BEFORE_knh__Array_set__fast
#define BEFORE_knh__Array_set__fast
#endif
#ifndef AFTER_knh__Array_set__fast
#define AFTER_knh__Array_set__fast
#endif

METHOD knh__Array_set__fast(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Array_set__fast;
	Array* b = KNH_CAST_ArrayOrNull(ctx, sf[0]);
	size_t index = (size_t)knh_Int_value((Int*)sf[1]);
	Any* value = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Array_set__fast(ctx, b, index, value);

	BEFORE_knh__Array_set__fast;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Array_get
#define BEFORE_knh__Array_get
#endif
#ifndef AFTER_knh__Array_get
#define AFTER_knh__Array_get
#endif

METHOD knh__Array_get(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Array_get;
	Array* b = KNH_CAST_ArrayOrNull(ctx, sf[0]);
	knh_int_t index = knh_Int_value((Int*)sf[1]);

	Any* _rval_ = knh_Array_get(b, index);

	BEFORE_knh__Array_get;
	KNH_SETr(ctx, sf, KNH_CAST_ObjectOrNull(ctx, _rval_));
}


#ifndef BEFORE_knh__Array_set
#define BEFORE_knh__Array_set
#endif
#ifndef AFTER_knh__Array_set
#define AFTER_knh__Array_set
#endif

METHOD knh__Array_set(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Array_set;
	Array* b = KNH_CAST_ArrayOrNull(ctx, sf[0]);
	knh_int_t index = knh_Int_value((Int*)sf[1]);
	Any* value = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Array_set(ctx, b, index, value);

	BEFORE_knh__Array_set;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Bool__s
#define BEFORE_knh__Bool__s
#endif
#ifndef AFTER_knh__Bool__s
#define AFTER_knh__Bool__s
#endif

METHOD knh__Bool__s(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Bool__s;
	Bool* b = KNH_CAST_BoolOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Bool__s(ctx, b, w, m);

	BEFORE_knh__Bool__s;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Bytes_new
#define BEFORE_knh__Bytes_new
#endif
#ifndef AFTER_knh__Bytes_new
#define AFTER_knh__Bytes_new
#endif

METHOD knh__Bytes_new(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Bytes_new;
	Bytes* b = KNH_CAST_BytesOrNull(ctx, sf[0]);
	size_t init = IS_NULL(sf[1]) ? (size_t)256 : (size_t)knh_Int_value((Int*)sf[1]);

	Bytes* _rval_ = knh_Bytes_new(ctx, b, init);

	BEFORE_knh__Bytes_new;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_Bytes(ctx, _rval_));
}


#ifndef BEFORE_knh__Float__s
#define BEFORE_knh__Float__s
#endif
#ifndef AFTER_knh__Float__s
#define AFTER_knh__Float__s
#endif

METHOD knh__Float__s(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Float__s;
	Float* b = KNH_CAST_FloatOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Float__s(ctx, b, w, m);

	BEFORE_knh__Float__s;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Float__dump
#define BEFORE_knh__Float__dump
#endif
#ifndef AFTER_knh__Float__dump
#define AFTER_knh__Float__dump
#endif

METHOD knh__Float__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Float__dump;
	Float* b = KNH_CAST_FloatOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Float__dump(ctx, b, w, m);

	BEFORE_knh__Float__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Int__s
#define BEFORE_knh__Int__s
#endif
#ifndef AFTER_knh__Int__s
#define AFTER_knh__Int__s
#endif

METHOD knh__Int__s(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Int__s;
	Int* b = KNH_CAST_IntOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Int__s(ctx, b, w, m);

	BEFORE_knh__Int__s;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Int__x
#define BEFORE_knh__Int__x
#endif
#ifndef AFTER_knh__Int__x
#define AFTER_knh__Int__x
#endif

METHOD knh__Int__x(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Int__x;
	Int* b = KNH_CAST_IntOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Int__x(ctx, b, w, m);

	BEFORE_knh__Int__x;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Int__bits
#define BEFORE_knh__Int__bits
#endif
#ifndef AFTER_knh__Int__bits
#define AFTER_knh__Int__bits
#endif

METHOD knh__Int__bits(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Int__bits;
	Int* b = KNH_CAST_IntOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Int__bits(ctx, b, w, m);

	BEFORE_knh__Int__bits;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Int__dump
#define BEFORE_knh__Int__dump
#endif
#ifndef AFTER_knh__Int__dump
#define AFTER_knh__Int__dump
#endif

METHOD knh__Int__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Int__dump;
	Int* b = KNH_CAST_IntOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Int__dump(ctx, b, w, m);

	BEFORE_knh__Int__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Context_getRuntime
#define BEFORE_knh__Context_getRuntime
#endif
#ifndef AFTER_knh__Context_getRuntime
#define AFTER_knh__Context_getRuntime
#endif

METHOD knh__Context_getRuntime(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Context_getRuntime;

	Runtime* _rval_ = knh_Context_getRuntime(ctx);

	BEFORE_knh__Context_getRuntime;
	KNH_SAFE_SETr(ctx, sf, KNH_CAST_Runtime(ctx, _rval_));
}


#ifndef BEFORE_knh__Class_isSingleton
#define BEFORE_knh__Class_isSingleton
#endif
#ifndef AFTER_knh__Class_isSingleton
#define AFTER_knh__Class_isSingleton
#endif

METHOD knh__Class_isSingleton(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Class_isSingleton;
	knh_class_t b = knh_Class_class((Class*)sf[0]);

	knh_bool_t _rval_ = knh_Class_isSingleton(b);

	BEFORE_knh__Class_isSingleton;
	KNH_SETr(ctx, sf, new_Bool(ctx, _rval_));
}


#ifndef BEFORE_knh__Object_opInstanceof
#define BEFORE_knh__Object_opInstanceof
#endif
#ifndef AFTER_knh__Object_opInstanceof
#define AFTER_knh__Object_opInstanceof
#endif

METHOD knh__Object_opInstanceof(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Object_opInstanceof;
	Any* b = KNH_CAST_ObjectOrNull(ctx, sf[0]);
	knh_type_t c = knh_Class_type((Class*)sf[1]);

	knh_bool_t _rval_ = knh_Object_opInstanceof(ctx, b, c);

	BEFORE_knh__Object_opInstanceof;
	KNH_SETr(ctx, sf, new_Bool(ctx, _rval_));
}


#ifdef __cplusplus
}
#endif
