/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#include<konoha/konoha_dev.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

/* ------------------------------------------------------------------------ */

#ifndef ISA_Token
#define ISA_Token(ctx, o)   IS_Token(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Token
knh_Token* knh_Token_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Token(ctx, b));
	return (knh_Token*)b;
}

/* ------------------------------------------------------------------------ */

knh_Token* knh_Token_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Token(ctx, b));
	return (knh_Token*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Stmt
#define ISA_Stmt(ctx, o)   IS_Stmt(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Stmt
knh_Stmt* knh_Stmt_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Stmt(ctx, b));
	return (knh_Stmt*)b;
}

/* ------------------------------------------------------------------------ */

knh_Stmt* knh_Stmt_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Stmt(ctx, b));
	return (knh_Stmt*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_Cmpl
#define ISA_Cmpl(ctx, o)   IS_Cmpl(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_Cmpl
knh_Cmpl* knh_Cmpl_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_Cmpl(ctx, b));
	return (knh_Cmpl*)b;
}

/* ------------------------------------------------------------------------ */

knh_Cmpl* knh_Cmpl_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_Cmpl(ctx, b));
	return (knh_Cmpl*)b;
}
#endif

/* ------------------------------------------------------------------------ */

#ifndef ISA_VirtualMachineCode
#define ISA_VirtualMachineCode(ctx, o)   IS_VirtualMachineCode(o)
#endif

/* ------------------------------------------------------------------------ */

#ifdef DEBUG_VirtualMachineCode
knh_VirtualMachineCode* knh_VirtualMachineCode_cast(Ctx *ctx, Object *b)
{
	KNH_ASSERT(ISA_VirtualMachineCode(ctx, b));
	return (knh_VirtualMachineCode*)b;
}

/* ------------------------------------------------------------------------ */

knh_VirtualMachineCode* knh_VirtualMachineCode_castOrNull(Ctx *ctx, Object *b)
{
	KNH_ASSERT(IS_NULL(b) || ISA_VirtualMachineCode(ctx, b));
	return (knh_VirtualMachineCode*)b;
}
#endif

#ifndef BEFORE_knh__Stmt__s
#define BEFORE_knh__Stmt__s
#endif
#ifndef AFTER_knh__Stmt__s
#define AFTER_knh__Stmt__s
#endif

METHOD knh__Stmt__s(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Stmt__s;
	Stmt* b = KNH_CAST_StmtOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Stmt__s(ctx, b, w, m);

	BEFORE_knh__Stmt__s;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Stmt__dump
#define BEFORE_knh__Stmt__dump
#endif
#ifndef AFTER_knh__Stmt__dump
#define AFTER_knh__Stmt__dump
#endif

METHOD knh__Stmt__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Stmt__dump;
	Stmt* b = KNH_CAST_StmtOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Stmt__dump(ctx, b, w, m);

	BEFORE_knh__Stmt__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Token__s
#define BEFORE_knh__Token__s
#endif
#ifndef AFTER_knh__Token__s
#define AFTER_knh__Token__s
#endif

METHOD knh__Token__s(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Token__s;
	Token* b = KNH_CAST_TokenOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Token__s(ctx, b, w, m);

	BEFORE_knh__Token__s;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Token__dump
#define BEFORE_knh__Token__dump
#endif
#ifndef AFTER_knh__Token__dump
#define AFTER_knh__Token__dump
#endif

METHOD knh__Token__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Token__dump;
	Token* b = KNH_CAST_TokenOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Token__dump(ctx, b, w, m);

	BEFORE_knh__Token__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__VirtualMachineCode__dump
#define BEFORE_knh__VirtualMachineCode__dump
#endif
#ifndef AFTER_knh__VirtualMachineCode__dump
#define AFTER_knh__VirtualMachineCode__dump
#endif

METHOD knh__VirtualMachineCode__dump(Ctx *ctx, Object **sf)
{
	BEFORE_knh__VirtualMachineCode__dump;
	VirtualMachineCode* b = KNH_CAST_VirtualMachineCodeOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_VirtualMachineCode__dump(ctx, b, w, m);

	BEFORE_knh__VirtualMachineCode__dump;
	KNH_SETr_void(ctx, sf);
}


#ifndef BEFORE_knh__Method__code
#define BEFORE_knh__Method__code
#endif
#ifndef AFTER_knh__Method__code
#define AFTER_knh__Method__code
#endif

METHOD knh__Method__code(Ctx *ctx, Object **sf)
{
	BEFORE_knh__Method__code;
	Method* b = KNH_CAST_MethodOrNull(ctx, sf[0]);
	OutputStream* w = KNH_CAST_OutputStreamOrNull(ctx, sf[1]);
	Any* m = KNH_CAST_ObjectOrNull(ctx, sf[2]);

	knh_Method__code(ctx, b, w, m);

	BEFORE_knh__Method__code;
	KNH_SETr_void(ctx, sf);
}


#ifdef __cplusplus
}
#endif
