/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#ifndef KONOHA_CLASS__H
#define KONOHA_CLASS__H

#include<konoha/konoha_config.h>
#include<konoha/konoha_t.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */
#define KONOHA_SERIAL_NUMBER            233
/* knh_Tuple1 */
#define STRUCT_Tuple1           ((knh_struct_t)1)
#define STRUCT_IS_Tuple1(o)     (knh_Object_topsid(o) == STRUCT_Tuple1)
#define CLASS_Tuple1            ((knh_class_t)1)
#define CF_Tuple1               ((knh_flag_t)0)
#define OF_Tuple1               KNH_FLAG_CF2OF(CF_Tuple1)
#define TYPE_Tuple1             CLASS_TONULLABLE(CLASS_Tuple1)
#define TYPE_Tuple1__           CLASS_TOPLURAL(CLASS_Tuple1)
#define IS_Tuple1(o)            (knh_Object_cid(o) == CLASS_Tuple1)
#define DEBUG_Tuple1                    1
#define KNH_CAST_Tuple1(ctx,o)          knh_Tuple1_cast(ctx,o)
#define KNH_CAST_Tuple1OrNull(ctx,o)    knh_Tuple1_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Tuple2 */
#define STRUCT_Tuple2           ((knh_struct_t)2)
#define STRUCT_IS_Tuple2(o)     (knh_Object_topsid(o) == STRUCT_Tuple2)
#define CLASS_Tuple2            ((knh_class_t)2)
#define CF_Tuple2               ((knh_flag_t)0)
#define OF_Tuple2               KNH_FLAG_CF2OF(CF_Tuple2)
#define TYPE_Tuple2             CLASS_TONULLABLE(CLASS_Tuple2)
#define TYPE_Tuple2__           CLASS_TOPLURAL(CLASS_Tuple2)
#define IS_Tuple2(o)            (knh_Object_cid(o) == CLASS_Tuple2)
#define DEBUG_Tuple2                    1
#define KNH_CAST_Tuple2(ctx,o)          knh_Tuple2_cast(ctx,o)
#define KNH_CAST_Tuple2OrNull(ctx,o)    knh_Tuple2_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Tuple3 */
#define STRUCT_Tuple3           ((knh_struct_t)3)
#define STRUCT_IS_Tuple3(o)     (knh_Object_topsid(o) == STRUCT_Tuple3)
#define CLASS_Tuple3            ((knh_class_t)3)
#define CF_Tuple3               ((knh_flag_t)0)
#define OF_Tuple3               KNH_FLAG_CF2OF(CF_Tuple3)
#define TYPE_Tuple3             CLASS_TONULLABLE(CLASS_Tuple3)
#define TYPE_Tuple3__           CLASS_TOPLURAL(CLASS_Tuple3)
#define IS_Tuple3(o)            (knh_Object_cid(o) == CLASS_Tuple3)
#define DEBUG_Tuple3                    1
#define KNH_CAST_Tuple3(ctx,o)          knh_Tuple3_cast(ctx,o)
#define KNH_CAST_Tuple3OrNull(ctx,o)    knh_Tuple3_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Tuple4 */
#define STRUCT_Tuple4           ((knh_struct_t)4)
#define STRUCT_IS_Tuple4(o)     (knh_Object_topsid(o) == STRUCT_Tuple4)
#define CLASS_Tuple4            ((knh_class_t)4)
#define CF_Tuple4               ((knh_flag_t)0)
#define OF_Tuple4               KNH_FLAG_CF2OF(CF_Tuple4)
#define TYPE_Tuple4             CLASS_TONULLABLE(CLASS_Tuple4)
#define TYPE_Tuple4__           CLASS_TOPLURAL(CLASS_Tuple4)
#define IS_Tuple4(o)            (knh_Object_cid(o) == CLASS_Tuple4)
#define DEBUG_Tuple4                    1
#define KNH_CAST_Tuple4(ctx,o)          knh_Tuple4_cast(ctx,o)
#define KNH_CAST_Tuple4OrNull(ctx,o)    knh_Tuple4_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Tuple5 */
#define STRUCT_Tuple5           ((knh_struct_t)5)
#define STRUCT_IS_Tuple5(o)     (knh_Object_topsid(o) == STRUCT_Tuple5)
#define CLASS_Tuple5            ((knh_class_t)5)
#define CF_Tuple5               ((knh_flag_t)0)
#define OF_Tuple5               KNH_FLAG_CF2OF(CF_Tuple5)
#define TYPE_Tuple5             CLASS_TONULLABLE(CLASS_Tuple5)
#define TYPE_Tuple5__           CLASS_TOPLURAL(CLASS_Tuple5)
#define IS_Tuple5(o)            (knh_Object_cid(o) == CLASS_Tuple5)
#define DEBUG_Tuple5                    1
#define KNH_CAST_Tuple5(ctx,o)          knh_Tuple5_cast(ctx,o)
#define KNH_CAST_Tuple5OrNull(ctx,o)    knh_Tuple5_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Tuple6 */
#define STRUCT_Tuple6           ((knh_struct_t)6)
#define STRUCT_IS_Tuple6(o)     (knh_Object_topsid(o) == STRUCT_Tuple6)
#define CLASS_Tuple6            ((knh_class_t)6)
#define CF_Tuple6               ((knh_flag_t)0)
#define OF_Tuple6               KNH_FLAG_CF2OF(CF_Tuple6)
#define TYPE_Tuple6             CLASS_TONULLABLE(CLASS_Tuple6)
#define TYPE_Tuple6__           CLASS_TOPLURAL(CLASS_Tuple6)
#define IS_Tuple6(o)            (knh_Object_cid(o) == CLASS_Tuple6)
#define DEBUG_Tuple6                    1
#define KNH_CAST_Tuple6(ctx,o)          knh_Tuple6_cast(ctx,o)
#define KNH_CAST_Tuple6OrNull(ctx,o)    knh_Tuple6_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Tuple7 */
#define STRUCT_Tuple7           ((knh_struct_t)7)
#define STRUCT_IS_Tuple7(o)     (knh_Object_topsid(o) == STRUCT_Tuple7)
#define CLASS_Tuple7            ((knh_class_t)7)
#define CF_Tuple7               ((knh_flag_t)0)
#define OF_Tuple7               KNH_FLAG_CF2OF(CF_Tuple7)
#define TYPE_Tuple7             CLASS_TONULLABLE(CLASS_Tuple7)
#define TYPE_Tuple7__           CLASS_TOPLURAL(CLASS_Tuple7)
#define IS_Tuple7(o)            (knh_Object_cid(o) == CLASS_Tuple7)
#define DEBUG_Tuple7                    1
#define KNH_CAST_Tuple7(ctx,o)          knh_Tuple7_cast(ctx,o)
#define KNH_CAST_Tuple7OrNull(ctx,o)    knh_Tuple7_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Tuple8 */
#define STRUCT_Tuple8           ((knh_struct_t)8)
#define STRUCT_IS_Tuple8(o)     (knh_Object_topsid(o) == STRUCT_Tuple8)
#define CLASS_Tuple8            ((knh_class_t)8)
#define CF_Tuple8               ((knh_flag_t)0)
#define OF_Tuple8               KNH_FLAG_CF2OF(CF_Tuple8)
#define TYPE_Tuple8             CLASS_TONULLABLE(CLASS_Tuple8)
#define TYPE_Tuple8__           CLASS_TOPLURAL(CLASS_Tuple8)
#define IS_Tuple8(o)            (knh_Object_cid(o) == CLASS_Tuple8)
#define DEBUG_Tuple8                    1
#define KNH_CAST_Tuple8(ctx,o)          knh_Tuple8_cast(ctx,o)
#define KNH_CAST_Tuple8OrNull(ctx,o)    knh_Tuple8_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Tuple9 */
#define STRUCT_Tuple9           ((knh_struct_t)9)
#define STRUCT_IS_Tuple9(o)     (knh_Object_topsid(o) == STRUCT_Tuple9)
#define CLASS_Tuple9            ((knh_class_t)9)
#define CF_Tuple9               ((knh_flag_t)0)
#define OF_Tuple9               KNH_FLAG_CF2OF(CF_Tuple9)
#define TYPE_Tuple9             CLASS_TONULLABLE(CLASS_Tuple9)
#define TYPE_Tuple9__           CLASS_TOPLURAL(CLASS_Tuple9)
#define IS_Tuple9(o)            (knh_Object_cid(o) == CLASS_Tuple9)
#define DEBUG_Tuple9                    1
#define KNH_CAST_Tuple9(ctx,o)          knh_Tuple9_cast(ctx,o)
#define KNH_CAST_Tuple9OrNull(ctx,o)    knh_Tuple9_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Tuple10 */
#define STRUCT_Tuple10          ((knh_struct_t)10)
#define STRUCT_IS_Tuple10(o)    (knh_Object_topsid(o) == STRUCT_Tuple10)
#define CLASS_Tuple10           ((knh_class_t)10)
#define CF_Tuple10              ((knh_flag_t)0)
#define OF_Tuple10              KNH_FLAG_CF2OF(CF_Tuple10)
#define TYPE_Tuple10            CLASS_TONULLABLE(CLASS_Tuple10)
#define TYPE_Tuple10__          CLASS_TOPLURAL(CLASS_Tuple10)
#define IS_Tuple10(o)           (knh_Object_cid(o) == CLASS_Tuple10)
#define DEBUG_Tuple10                   1
#define KNH_CAST_Tuple10(ctx,o)         knh_Tuple10_cast(ctx,o)
#define KNH_CAST_Tuple10OrNull(ctx,o)   knh_Tuple10_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Tuple11 */
#define STRUCT_Tuple11          ((knh_struct_t)11)
#define STRUCT_IS_Tuple11(o)    (knh_Object_topsid(o) == STRUCT_Tuple11)
#define CLASS_Tuple11           ((knh_class_t)11)
#define CF_Tuple11              ((knh_flag_t)0)
#define OF_Tuple11              KNH_FLAG_CF2OF(CF_Tuple11)
#define TYPE_Tuple11            CLASS_TONULLABLE(CLASS_Tuple11)
#define TYPE_Tuple11__          CLASS_TOPLURAL(CLASS_Tuple11)
#define IS_Tuple11(o)           (knh_Object_cid(o) == CLASS_Tuple11)
#define DEBUG_Tuple11                   1
#define KNH_CAST_Tuple11(ctx,o)         knh_Tuple11_cast(ctx,o)
#define KNH_CAST_Tuple11OrNull(ctx,o)   knh_Tuple11_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Tuple12 */
#define STRUCT_Tuple12          ((knh_struct_t)12)
#define STRUCT_IS_Tuple12(o)    (knh_Object_topsid(o) == STRUCT_Tuple12)
#define CLASS_Tuple12           ((knh_class_t)12)
#define CF_Tuple12              ((knh_flag_t)0)
#define OF_Tuple12              KNH_FLAG_CF2OF(CF_Tuple12)
#define TYPE_Tuple12            CLASS_TONULLABLE(CLASS_Tuple12)
#define TYPE_Tuple12__          CLASS_TOPLURAL(CLASS_Tuple12)
#define IS_Tuple12(o)           (knh_Object_cid(o) == CLASS_Tuple12)
#define DEBUG_Tuple12                   1
#define KNH_CAST_Tuple12(ctx,o)         knh_Tuple12_cast(ctx,o)
#define KNH_CAST_Tuple12OrNull(ctx,o)   knh_Tuple12_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Tuple13 */
#define STRUCT_Tuple13          ((knh_struct_t)13)
#define STRUCT_IS_Tuple13(o)    (knh_Object_topsid(o) == STRUCT_Tuple13)
#define CLASS_Tuple13           ((knh_class_t)13)
#define CF_Tuple13              ((knh_flag_t)0)
#define OF_Tuple13              KNH_FLAG_CF2OF(CF_Tuple13)
#define TYPE_Tuple13            CLASS_TONULLABLE(CLASS_Tuple13)
#define TYPE_Tuple13__          CLASS_TOPLURAL(CLASS_Tuple13)
#define IS_Tuple13(o)           (knh_Object_cid(o) == CLASS_Tuple13)
#define DEBUG_Tuple13                   1
#define KNH_CAST_Tuple13(ctx,o)         knh_Tuple13_cast(ctx,o)
#define KNH_CAST_Tuple13OrNull(ctx,o)   knh_Tuple13_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Tuple14 */
#define STRUCT_Tuple14          ((knh_struct_t)14)
#define STRUCT_IS_Tuple14(o)    (knh_Object_topsid(o) == STRUCT_Tuple14)
#define CLASS_Tuple14           ((knh_class_t)14)
#define CF_Tuple14              ((knh_flag_t)0)
#define OF_Tuple14              KNH_FLAG_CF2OF(CF_Tuple14)
#define TYPE_Tuple14            CLASS_TONULLABLE(CLASS_Tuple14)
#define TYPE_Tuple14__          CLASS_TOPLURAL(CLASS_Tuple14)
#define IS_Tuple14(o)           (knh_Object_cid(o) == CLASS_Tuple14)
#define DEBUG_Tuple14                   1
#define KNH_CAST_Tuple14(ctx,o)         knh_Tuple14_cast(ctx,o)
#define KNH_CAST_Tuple14OrNull(ctx,o)   knh_Tuple14_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Tuple15 */
#define STRUCT_Tuple15          ((knh_struct_t)15)
#define STRUCT_IS_Tuple15(o)    (knh_Object_topsid(o) == STRUCT_Tuple15)
#define CLASS_Tuple15           ((knh_class_t)15)
#define CF_Tuple15              ((knh_flag_t)0)
#define OF_Tuple15              KNH_FLAG_CF2OF(CF_Tuple15)
#define TYPE_Tuple15            CLASS_TONULLABLE(CLASS_Tuple15)
#define TYPE_Tuple15__          CLASS_TOPLURAL(CLASS_Tuple15)
#define IS_Tuple15(o)           (knh_Object_cid(o) == CLASS_Tuple15)
#define DEBUG_Tuple15                   1
#define KNH_CAST_Tuple15(ctx,o)         knh_Tuple15_cast(ctx,o)
#define KNH_CAST_Tuple15OrNull(ctx,o)   knh_Tuple15_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Prototype */
#define STRUCT_Prototype        ((knh_struct_t)16)
#define STRUCT_IS_Prototype(o)  (knh_Object_topsid(o) == STRUCT_Prototype)
#define CLASS_Prototype         ((knh_class_t)16)
#define CF_Prototype            ((knh_flag_t)0)
#define OF_Prototype            KNH_FLAG_CF2OF(CF_Prototype)
#define TYPE_Prototype          CLASS_TONULLABLE(CLASS_Prototype)
#define TYPE_Prototype__        CLASS_TOPLURAL(CLASS_Prototype)
#define IS_Prototype(o)         (knh_Object_cid(o) == CLASS_Prototype)
#define DEBUG_Prototype                 1
#define KNH_CAST_Prototype(ctx,o)       knh_Prototype_cast(ctx,o)
#define KNH_CAST_PrototypeOrNull(ctx,o) knh_Prototype_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Nue */
#define STRUCT_Nue              ((knh_struct_t)17)
#define STRUCT_IS_Nue(o)        (knh_Object_topsid(o) == STRUCT_Nue)
#define CLASS_Nue               ((knh_class_t)17)
#define CF_Nue                  ((knh_flag_t)0)
#define OF_Nue                  KNH_FLAG_CF2OF(CF_Nue)
#define TYPE_Nue                CLASS_TONULLABLE(CLASS_Nue)
#define TYPE_Nue__              CLASS_TOPLURAL(CLASS_Nue)
#define IS_Nue(o)               (knh_Object_cid(o) == CLASS_Nue)
#define DEBUG_Nue                       1
#define KNH_CAST_Nue(ctx,o)             knh_Nue_cast(ctx,o)
#define KNH_CAST_NueOrNull(ctx,o)       knh_Nue_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Bool */
#define STRUCT_Bool             ((knh_struct_t)18)
#define STRUCT_IS_Bool(o)       (knh_Object_topsid(o) == STRUCT_Bool)
#define CLASS_Bool              ((knh_class_t)18)
#define CF_Bool                 ((knh_flag_t)0)
#define OF_Bool                 KNH_FLAG_CF2OF(CF_Bool)
#define TYPE_Bool               CLASS_TONULLABLE(CLASS_Bool)
#define TYPE_Bool__             CLASS_TOPLURAL(CLASS_Bool)
#define IS_Bool(o)              (knh_Object_cid(o) == CLASS_Bool)
#define DEBUG_Bool                      1
#define KNH_CAST_Bool(ctx,o)            knh_Bool_cast(ctx,o)
#define KNH_CAST_BoolOrNull(ctx,o)      knh_Bool_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Int */
#define STRUCT_Int              ((knh_struct_t)19)
#define STRUCT_IS_Int(o)        (knh_Object_topsid(o) == STRUCT_Int)
#define CLASS_Int               ((knh_class_t)19)
#define CF_Int                  ((knh_flag_t)0)
#define OF_Int                  KNH_FLAG_CF2OF(CF_Int)
#define TYPE_Int                CLASS_TONULLABLE(CLASS_Int)
#define TYPE_Int__              CLASS_TOPLURAL(CLASS_Int)
#define IS_Int(o)               (knh_Object_cid(o) == CLASS_Int)
#define DEBUG_Int                       1
#define KNH_CAST_Int(ctx,o)             knh_Int_cast(ctx,o)
#define KNH_CAST_IntOrNull(ctx,o)       knh_Int_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Int64 */
#define STRUCT_Int64            ((knh_struct_t)20)
#define STRUCT_IS_Int64(o)      (knh_Object_topsid(o) == STRUCT_Int64)
#define CLASS_Int64             ((knh_class_t)20)
#define CF_Int64                ((knh_flag_t)0)
#define OF_Int64                KNH_FLAG_CF2OF(CF_Int64)
#define TYPE_Int64              CLASS_TONULLABLE(CLASS_Int64)
#define TYPE_Int64__            CLASS_TOPLURAL(CLASS_Int64)
#define IS_Int64(o)             (knh_Object_cid(o) == CLASS_Int64)
#define DEBUG_Int64                     1
#define KNH_CAST_Int64(ctx,o)           knh_Int64_cast(ctx,o)
#define KNH_CAST_Int64OrNull(ctx,o)     knh_Int64_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Float */
#define STRUCT_Float            ((knh_struct_t)21)
#define STRUCT_IS_Float(o)      (knh_Object_topsid(o) == STRUCT_Float)
#define CLASS_Float             ((knh_class_t)21)
#define CF_Float                ((knh_flag_t)0)
#define OF_Float                KNH_FLAG_CF2OF(CF_Float)
#define TYPE_Float              CLASS_TONULLABLE(CLASS_Float)
#define TYPE_Float__            CLASS_TOPLURAL(CLASS_Float)
#define IS_Float(o)             (knh_Object_cid(o) == CLASS_Float)
#define DEBUG_Float                     1
#define KNH_CAST_Float(ctx,o)           knh_Float_cast(ctx,o)
#define KNH_CAST_FloatOrNull(ctx,o)     knh_Float_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_String */
#define STRUCT_String           ((knh_struct_t)22)
#define STRUCT_IS_String(o)     (knh_Object_topsid(o) == STRUCT_String)
#define CLASS_String            ((knh_class_t)22)
#define CF_String               ((knh_flag_t)0)
#define OF_String               KNH_FLAG_CF2OF(CF_String)
#define TYPE_String             CLASS_TONULLABLE(CLASS_String)
#define TYPE_String__           CLASS_TOPLURAL(CLASS_String)
#define IS_String(o)            (knh_Object_cid(o) == CLASS_String)
#define DEBUG_String                    1
#define KNH_CAST_String(ctx,o)          knh_String_cast(ctx,o)
#define KNH_CAST_StringOrNull(ctx,o)    knh_String_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Regex */
#define STRUCT_Regex            ((knh_struct_t)23)
#define STRUCT_IS_Regex(o)      (knh_Object_topsid(o) == STRUCT_Regex)
#define CLASS_Regex             ((knh_class_t)23)
#define CF_Regex                ((knh_flag_t)0)
#define OF_Regex                KNH_FLAG_CF2OF(CF_Regex)
#define TYPE_Regex              CLASS_TONULLABLE(CLASS_Regex)
#define TYPE_Regex__            CLASS_TOPLURAL(CLASS_Regex)
#define IS_Regex(o)             (knh_Object_cid(o) == CLASS_Regex)
#define DEBUG_Regex                     1
#define KNH_CAST_Regex(ctx,o)           knh_Regex_cast(ctx,o)
#define KNH_CAST_RegexOrNull(ctx,o)     knh_Regex_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Bytes */
#define STRUCT_Bytes            ((knh_struct_t)24)
#define STRUCT_IS_Bytes(o)      (knh_Object_topsid(o) == STRUCT_Bytes)
#define CLASS_Bytes             ((knh_class_t)24)
#define CF_Bytes                ((knh_flag_t)0)
#define OF_Bytes                KNH_FLAG_CF2OF(CF_Bytes)
#define TYPE_Bytes              CLASS_TONULLABLE(CLASS_Bytes)
#define TYPE_Bytes__            CLASS_TOPLURAL(CLASS_Bytes)
#define IS_Bytes(o)             (knh_Object_cid(o) == CLASS_Bytes)
#define DEBUG_Bytes                     1
#define KNH_CAST_Bytes(ctx,o)           knh_Bytes_cast(ctx,o)
#define KNH_CAST_BytesOrNull(ctx,o)     knh_Bytes_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_BytesConv */
#define STRUCT_BytesConv        ((knh_struct_t)25)
#define STRUCT_IS_BytesConv(o)  (knh_Object_topsid(o) == STRUCT_BytesConv)
#define CLASS_BytesConv         ((knh_class_t)25)
#define CF_BytesConv            ((knh_flag_t)0)
#define OF_BytesConv            KNH_FLAG_CF2OF(CF_BytesConv)
#define TYPE_BytesConv          CLASS_TONULLABLE(CLASS_BytesConv)
#define TYPE_BytesConv__        CLASS_TOPLURAL(CLASS_BytesConv)
#define IS_BytesConv(o)         (knh_Object_cid(o) == CLASS_BytesConv)
#define DEBUG_BytesConv                 1
#define KNH_CAST_BytesConv(ctx,o)       knh_BytesConv_cast(ctx,o)
#define KNH_CAST_BytesConvOrNull(ctx,o) knh_BytesConv_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Array */
#define STRUCT_Array            ((knh_struct_t)26)
#define STRUCT_IS_Array(o)      (knh_Object_topsid(o) == STRUCT_Array)
#define CLASS_Array             ((knh_class_t)26)
#define CF_Array                ((knh_flag_t)0)
#define OF_Array                KNH_FLAG_CF2OF(CF_Array)
#define TYPE_Array              CLASS_TONULLABLE(CLASS_Array)
#define TYPE_Array__            CLASS_TOPLURAL(CLASS_Array)
#define IS_Array(o)             (knh_Object_cid(o) == CLASS_Array)
#define DEBUG_Array                     1
#define KNH_CAST_Array(ctx,o)           knh_Array_cast(ctx,o)
#define KNH_CAST_ArrayOrNull(ctx,o)     knh_Array_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_HashMap */
#define STRUCT_HashMap          ((knh_struct_t)27)
#define STRUCT_IS_HashMap(o)    (knh_Object_topsid(o) == STRUCT_HashMap)
#define CLASS_HashMap           ((knh_class_t)27)
#define CF_HashMap              ((knh_flag_t)0)
#define OF_HashMap              KNH_FLAG_CF2OF(CF_HashMap)
#define TYPE_HashMap            CLASS_TONULLABLE(CLASS_HashMap)
#define TYPE_HashMap__          CLASS_TOPLURAL(CLASS_HashMap)
#define IS_HashMap(o)           (knh_Object_cid(o) == CLASS_HashMap)
#define DEBUG_HashMap                   1
#define KNH_CAST_HashMap(ctx,o)         knh_HashMap_cast(ctx,o)
#define KNH_CAST_HashMapOrNull(ctx,o)   knh_HashMap_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_HashSet */
#define STRUCT_HashSet          ((knh_struct_t)28)
#define STRUCT_IS_HashSet(o)    (knh_Object_topsid(o) == STRUCT_HashSet)
#define CLASS_HashSet           ((knh_class_t)28)
#define CF_HashSet              ((knh_flag_t)0)
#define OF_HashSet              KNH_FLAG_CF2OF(CF_HashSet)
#define TYPE_HashSet            CLASS_TONULLABLE(CLASS_HashSet)
#define TYPE_HashSet__          CLASS_TOPLURAL(CLASS_HashSet)
#define IS_HashSet(o)           (knh_Object_cid(o) == CLASS_HashSet)
#define DEBUG_HashSet                   1
#define KNH_CAST_HashSet(ctx,o)         knh_HashSet_cast(ctx,o)
#define KNH_CAST_HashSetOrNull(ctx,o)   knh_HashSet_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_DictMap */
#define STRUCT_DictMap          ((knh_struct_t)29)
#define STRUCT_IS_DictMap(o)    (knh_Object_topsid(o) == STRUCT_DictMap)
#define CLASS_DictMap           ((knh_class_t)29)
#define CF_DictMap              ((knh_flag_t)0)
#define OF_DictMap              KNH_FLAG_CF2OF(CF_DictMap)
#define TYPE_DictMap            CLASS_TONULLABLE(CLASS_DictMap)
#define TYPE_DictMap__          CLASS_TOPLURAL(CLASS_DictMap)
#define IS_DictMap(o)           (knh_Object_cid(o) == CLASS_DictMap)
#define DEBUG_DictMap                   1
#define KNH_CAST_DictMap(ctx,o)         knh_DictMap_cast(ctx,o)
#define KNH_CAST_DictMapOrNull(ctx,o)   knh_DictMap_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_DictSet */
#define STRUCT_DictSet          ((knh_struct_t)30)
#define STRUCT_IS_DictSet(o)    (knh_Object_topsid(o) == STRUCT_DictSet)
#define CLASS_DictSet           ((knh_class_t)30)
#define CF_DictSet              ((knh_flag_t)0)
#define OF_DictSet              KNH_FLAG_CF2OF(CF_DictSet)
#define TYPE_DictSet            CLASS_TONULLABLE(CLASS_DictSet)
#define TYPE_DictSet__          CLASS_TOPLURAL(CLASS_DictSet)
#define IS_DictSet(o)           (knh_Object_cid(o) == CLASS_DictSet)
#define DEBUG_DictSet                   1
#define KNH_CAST_DictSet(ctx,o)         knh_DictSet_cast(ctx,o)
#define KNH_CAST_DictSetOrNull(ctx,o)   knh_DictSet_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Iterator */
#define STRUCT_Iterator         ((knh_struct_t)31)
#define STRUCT_IS_Iterator(o)   (knh_Object_topsid(o) == STRUCT_Iterator)
#define CLASS_Iterator          ((knh_class_t)31)
#define CF_Iterator             ((knh_flag_t)0)
#define OF_Iterator             KNH_FLAG_CF2OF(CF_Iterator)
#define TYPE_Iterator           CLASS_TONULLABLE(CLASS_Iterator)
#define TYPE_Iterator__         CLASS_TOPLURAL(CLASS_Iterator)
#define IS_Iterator(o)          (knh_Object_cid(o) == CLASS_Iterator)
#define DEBUG_Iterator                  1
#define KNH_CAST_Iterator(ctx,o)        knh_Iterator_cast(ctx,o)
#define KNH_CAST_IteratorOrNull(ctx,o)  knh_Iterator_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_DictIdx */
#define STRUCT_DictIdx          ((knh_struct_t)32)
#define STRUCT_IS_DictIdx(o)    (knh_Object_topsid(o) == STRUCT_DictIdx)
#define CLASS_DictIdx           ((knh_class_t)32)
#define CF_DictIdx              ((knh_flag_t)0)
#define OF_DictIdx              KNH_FLAG_CF2OF(CF_DictIdx)
#define TYPE_DictIdx            CLASS_TONULLABLE(CLASS_DictIdx)
#define TYPE_DictIdx__          CLASS_TOPLURAL(CLASS_DictIdx)
#define IS_DictIdx(o)           (knh_Object_cid(o) == CLASS_DictIdx)
#define DEBUG_DictIdx                   1
#define KNH_CAST_DictIdx(ctx,o)         knh_DictIdx_cast(ctx,o)
#define KNH_CAST_DictIdxOrNull(ctx,o)   knh_DictIdx_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Class */
#define STRUCT_Class            ((knh_struct_t)33)
#define STRUCT_IS_Class(o)      (knh_Object_topsid(o) == STRUCT_Class)
#define CLASS_Class             ((knh_class_t)33)
#define CF_Class                ((knh_flag_t)0)
#define OF_Class                KNH_FLAG_CF2OF(CF_Class)
#define TYPE_Class              CLASS_TONULLABLE(CLASS_Class)
#define TYPE_Class__            CLASS_TOPLURAL(CLASS_Class)
#define IS_Class(o)             (knh_Object_cid(o) == CLASS_Class)
#define DEBUG_Class                     1
#define KNH_CAST_Class(ctx,o)           knh_Class_cast(ctx,o)
#define KNH_CAST_ClassOrNull(ctx,o)     knh_Class_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_ClassStruct */
#define STRUCT_ClassStruct      ((knh_struct_t)34)
#define STRUCT_IS_ClassStruct(o) (knh_Object_topsid(o) == STRUCT_ClassStruct)
#define CLASS_ClassStruct       ((knh_class_t)34)
#define CF_ClassStruct          ((knh_flag_t)0)
#define OF_ClassStruct          KNH_FLAG_CF2OF(CF_ClassStruct)
#define TYPE_ClassStruct        CLASS_TONULLABLE(CLASS_ClassStruct)
#define TYPE_ClassStruct__      CLASS_TOPLURAL(CLASS_ClassStruct)
#define IS_ClassStruct(o)       (knh_Object_cid(o) == CLASS_ClassStruct)
#define DEBUG_ClassStruct               1
#define KNH_CAST_ClassStruct(ctx,o)     knh_ClassStruct_cast(ctx,o)
#define KNH_CAST_ClassStructOrNull(ctx,o) knh_ClassStruct_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_MethodField */
#define STRUCT_MethodField      ((knh_struct_t)35)
#define STRUCT_IS_MethodField(o) (knh_Object_topsid(o) == STRUCT_MethodField)
#define CLASS_MethodField       ((knh_class_t)35)
#define CF_MethodField          ((knh_flag_t)0)
#define OF_MethodField          KNH_FLAG_CF2OF(CF_MethodField)
#define TYPE_MethodField        CLASS_TONULLABLE(CLASS_MethodField)
#define TYPE_MethodField__      CLASS_TOPLURAL(CLASS_MethodField)
#define IS_MethodField(o)       (knh_Object_cid(o) == CLASS_MethodField)
#define DEBUG_MethodField               1
#define KNH_CAST_MethodField(ctx,o)     knh_MethodField_cast(ctx,o)
#define KNH_CAST_MethodFieldOrNull(ctx,o) knh_MethodField_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Method */
#define STRUCT_Method           ((knh_struct_t)36)
#define STRUCT_IS_Method(o)     (knh_Object_topsid(o) == STRUCT_Method)
#define CLASS_Method            ((knh_class_t)36)
#define CF_Method               ((knh_flag_t)0)
#define OF_Method               KNH_FLAG_CF2OF(CF_Method)
#define TYPE_Method             CLASS_TONULLABLE(CLASS_Method)
#define TYPE_Method__           CLASS_TOPLURAL(CLASS_Method)
#define IS_Method(o)            (knh_Object_cid(o) == CLASS_Method)
#define DEBUG_Method                    1
#define KNH_CAST_Method(ctx,o)          knh_Method_cast(ctx,o)
#define KNH_CAST_MethodOrNull(ctx,o)    knh_Method_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_MapMap */
#define STRUCT_MapMap           ((knh_struct_t)37)
#define STRUCT_IS_MapMap(o)     (knh_Object_topsid(o) == STRUCT_MapMap)
#define CLASS_MapMap            ((knh_class_t)37)
#define CF_MapMap               ((knh_flag_t)0)
#define OF_MapMap               KNH_FLAG_CF2OF(CF_MapMap)
#define TYPE_MapMap             CLASS_TONULLABLE(CLASS_MapMap)
#define TYPE_MapMap__           CLASS_TOPLURAL(CLASS_MapMap)
#define IS_MapMap(o)            (knh_Object_cid(o) == CLASS_MapMap)
#define DEBUG_MapMap                    1
#define KNH_CAST_MapMap(ctx,o)          knh_MapMap_cast(ctx,o)
#define KNH_CAST_MapMapOrNull(ctx,o)    knh_MapMap_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_ClassRel */
#define STRUCT_ClassRel         ((knh_struct_t)38)
#define STRUCT_IS_ClassRel(o)   (knh_Object_topsid(o) == STRUCT_ClassRel)
#define CLASS_ClassRel          ((knh_class_t)38)
#define CF_ClassRel             ((knh_flag_t)0)
#define OF_ClassRel             KNH_FLAG_CF2OF(CF_ClassRel)
#define TYPE_ClassRel           CLASS_TONULLABLE(CLASS_ClassRel)
#define TYPE_ClassRel__         CLASS_TOPLURAL(CLASS_ClassRel)
#define IS_ClassRel(o)          (knh_Object_cid(o) == CLASS_ClassRel)
#define DEBUG_ClassRel                  1
#define KNH_CAST_ClassRel(ctx,o)        knh_ClassRel_cast(ctx,o)
#define KNH_CAST_ClassRelOrNull(ctx,o)  knh_ClassRel_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_IntUnit */
#define STRUCT_IntUnit          ((knh_struct_t)39)
#define STRUCT_IS_IntUnit(o)    (knh_Object_topsid(o) == STRUCT_IntUnit)
#define CLASS_IntUnit           ((knh_class_t)39)
#define CF_IntUnit              ((knh_flag_t)0)
#define OF_IntUnit              KNH_FLAG_CF2OF(CF_IntUnit)
#define TYPE_IntUnit            CLASS_TONULLABLE(CLASS_IntUnit)
#define TYPE_IntUnit__          CLASS_TOPLURAL(CLASS_IntUnit)
#define IS_IntUnit(o)           (knh_Object_cid(o) == CLASS_IntUnit)
#define DEBUG_IntUnit                   1
#define KNH_CAST_IntUnit(ctx,o)         knh_IntUnit_cast(ctx,o)
#define KNH_CAST_IntUnitOrNull(ctx,o)   knh_IntUnit_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_FloatUnit */
#define STRUCT_FloatUnit        ((knh_struct_t)40)
#define STRUCT_IS_FloatUnit(o)  (knh_Object_topsid(o) == STRUCT_FloatUnit)
#define CLASS_FloatUnit         ((knh_class_t)40)
#define CF_FloatUnit            ((knh_flag_t)0)
#define OF_FloatUnit            KNH_FLAG_CF2OF(CF_FloatUnit)
#define TYPE_FloatUnit          CLASS_TONULLABLE(CLASS_FloatUnit)
#define TYPE_FloatUnit__        CLASS_TOPLURAL(CLASS_FloatUnit)
#define IS_FloatUnit(o)         (knh_Object_cid(o) == CLASS_FloatUnit)
#define DEBUG_FloatUnit                 1
#define KNH_CAST_FloatUnit(ctx,o)       knh_FloatUnit_cast(ctx,o)
#define KNH_CAST_FloatUnitOrNull(ctx,o) knh_FloatUnit_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Vocabulary */
#define STRUCT_Vocabulary       ((knh_struct_t)41)
#define STRUCT_IS_Vocabulary(o) (knh_Object_topsid(o) == STRUCT_Vocabulary)
#define CLASS_Vocabulary        ((knh_class_t)41)
#define CF_Vocabulary           ((knh_flag_t)0)
#define OF_Vocabulary           KNH_FLAG_CF2OF(CF_Vocabulary)
#define TYPE_Vocabulary         CLASS_TONULLABLE(CLASS_Vocabulary)
#define TYPE_Vocabulary__       CLASS_TOPLURAL(CLASS_Vocabulary)
#define IS_Vocabulary(o)        (knh_Object_cid(o) == CLASS_Vocabulary)
#define DEBUG_Vocabulary                1
#define KNH_CAST_Vocabulary(ctx,o)      knh_Vocabulary_cast(ctx,o)
#define KNH_CAST_VocabularyOrNull(ctx,o) knh_Vocabulary_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_AffineConv */
#define STRUCT_AffineConv       ((knh_struct_t)42)
#define STRUCT_IS_AffineConv(o) (knh_Object_topsid(o) == STRUCT_AffineConv)
#define CLASS_AffineConv        ((knh_class_t)42)
#define CF_AffineConv           ((knh_flag_t)0)
#define OF_AffineConv           KNH_FLAG_CF2OF(CF_AffineConv)
#define TYPE_AffineConv         CLASS_TONULLABLE(CLASS_AffineConv)
#define TYPE_AffineConv__       CLASS_TOPLURAL(CLASS_AffineConv)
#define IS_AffineConv(o)        (knh_Object_cid(o) == CLASS_AffineConv)
#define DEBUG_AffineConv                1
#define KNH_CAST_AffineConv(ctx,o)      knh_AffineConv_cast(ctx,o)
#define KNH_CAST_AffineConvOrNull(ctx,o) knh_AffineConv_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_InputStream */
#define STRUCT_InputStream      ((knh_struct_t)43)
#define STRUCT_IS_InputStream(o) (knh_Object_topsid(o) == STRUCT_InputStream)
#define CLASS_InputStream       ((knh_class_t)43)
#define CF_InputStream          ((knh_flag_t)0)
#define OF_InputStream          KNH_FLAG_CF2OF(CF_InputStream)
#define TYPE_InputStream        CLASS_TONULLABLE(CLASS_InputStream)
#define TYPE_InputStream__      CLASS_TOPLURAL(CLASS_InputStream)
#define IS_InputStream(o)       (knh_Object_cid(o) == CLASS_InputStream)
#define DEBUG_InputStream               1
#define KNH_CAST_InputStream(ctx,o)     knh_InputStream_cast(ctx,o)
#define KNH_CAST_InputStreamOrNull(ctx,o) knh_InputStream_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_OutputStream */
#define STRUCT_OutputStream     ((knh_struct_t)44)
#define STRUCT_IS_OutputStream(o) (knh_Object_topsid(o) == STRUCT_OutputStream)
#define CLASS_OutputStream      ((knh_class_t)44)
#define CF_OutputStream         ((knh_flag_t)0)
#define OF_OutputStream         KNH_FLAG_CF2OF(CF_OutputStream)
#define TYPE_OutputStream       CLASS_TONULLABLE(CLASS_OutputStream)
#define TYPE_OutputStream__     CLASS_TOPLURAL(CLASS_OutputStream)
#define IS_OutputStream(o)      (knh_Object_cid(o) == CLASS_OutputStream)
#define DEBUG_OutputStream              1
#define KNH_CAST_OutputStream(ctx,o)    knh_OutputStream_cast(ctx,o)
#define KNH_CAST_OutputStreamOrNull(ctx,o) knh_OutputStream_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Socket */
#define STRUCT_Socket           ((knh_struct_t)45)
#define STRUCT_IS_Socket(o)     (knh_Object_topsid(o) == STRUCT_Socket)
#define CLASS_Socket            ((knh_class_t)45)
#define CF_Socket               ((knh_flag_t)0)
#define OF_Socket               KNH_FLAG_CF2OF(CF_Socket)
#define TYPE_Socket             CLASS_TONULLABLE(CLASS_Socket)
#define TYPE_Socket__           CLASS_TOPLURAL(CLASS_Socket)
#define IS_Socket(o)            (knh_Object_cid(o) == CLASS_Socket)
#define DEBUG_Socket                    1
#define KNH_CAST_Socket(ctx,o)          knh_Socket_cast(ctx,o)
#define KNH_CAST_SocketOrNull(ctx,o)    knh_Socket_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Connection */
#define STRUCT_Connection       ((knh_struct_t)46)
#define STRUCT_IS_Connection(o) (knh_Object_topsid(o) == STRUCT_Connection)
#define CLASS_Connection        ((knh_class_t)46)
#define CF_Connection           ((knh_flag_t)0)
#define OF_Connection           KNH_FLAG_CF2OF(CF_Connection)
#define TYPE_Connection         CLASS_TONULLABLE(CLASS_Connection)
#define TYPE_Connection__       CLASS_TOPLURAL(CLASS_Connection)
#define IS_Connection(o)        (knh_Object_cid(o) == CLASS_Connection)
#define DEBUG_Connection                1
#define KNH_CAST_Connection(ctx,o)      knh_Connection_cast(ctx,o)
#define KNH_CAST_ConnectionOrNull(ctx,o) knh_Connection_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_ResultSet */
#define STRUCT_ResultSet        ((knh_struct_t)47)
#define STRUCT_IS_ResultSet(o)  (knh_Object_topsid(o) == STRUCT_ResultSet)
#define CLASS_ResultSet         ((knh_class_t)47)
#define CF_ResultSet            ((knh_flag_t)0)
#define OF_ResultSet            KNH_FLAG_CF2OF(CF_ResultSet)
#define TYPE_ResultSet          CLASS_TONULLABLE(CLASS_ResultSet)
#define TYPE_ResultSet__        CLASS_TOPLURAL(CLASS_ResultSet)
#define IS_ResultSet(o)         (knh_Object_cid(o) == CLASS_ResultSet)
#define DEBUG_ResultSet                 1
#define KNH_CAST_ResultSet(ctx,o)       knh_ResultSet_cast(ctx,o)
#define KNH_CAST_ResultSetOrNull(ctx,o) knh_ResultSet_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Exception */
#define STRUCT_Exception        ((knh_struct_t)48)
#define STRUCT_IS_Exception(o)  (knh_Object_topsid(o) == STRUCT_Exception)
#define CLASS_Exception         ((knh_class_t)48)
#define CF_Exception            ((knh_flag_t)0)
#define OF_Exception            KNH_FLAG_CF2OF(CF_Exception)
#define TYPE_Exception          CLASS_TONULLABLE(CLASS_Exception)
#define TYPE_Exception__        CLASS_TOPLURAL(CLASS_Exception)
#define IS_Exception(o)         (knh_Object_cid(o) == CLASS_Exception)
#define DEBUG_Exception                 1
#define KNH_CAST_Exception(ctx,o)       knh_Exception_cast(ctx,o)
#define KNH_CAST_ExceptionOrNull(ctx,o) knh_Exception_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_ExceptionHandler */
#define STRUCT_ExceptionHandler ((knh_struct_t)49)
#define STRUCT_IS_ExceptionHandler(o) (knh_Object_topsid(o) == STRUCT_ExceptionHandler)
#define CLASS_ExceptionHandler  ((knh_class_t)49)
#define CF_ExceptionHandler     ((knh_flag_t)0)
#define OF_ExceptionHandler     KNH_FLAG_CF2OF(CF_ExceptionHandler)
#define TYPE_ExceptionHandler   CLASS_TONULLABLE(CLASS_ExceptionHandler)
#define TYPE_ExceptionHandler__ CLASS_TOPLURAL(CLASS_ExceptionHandler)
#define IS_ExceptionHandler(o)  (knh_Object_cid(o) == CLASS_ExceptionHandler)
#define DEBUG_ExceptionHandler          1
#define KNH_CAST_ExceptionHandler(ctx,o) knh_ExceptionHandler_cast(ctx,o)
#define KNH_CAST_ExceptionHandlerOrNull(ctx,o) knh_ExceptionHandler_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Mutex */
#define STRUCT_Mutex            ((knh_struct_t)50)
#define STRUCT_IS_Mutex(o)      (knh_Object_topsid(o) == STRUCT_Mutex)
#define CLASS_Mutex             ((knh_class_t)50)
#define CF_Mutex                ((knh_flag_t)0)
#define OF_Mutex                KNH_FLAG_CF2OF(CF_Mutex)
#define TYPE_Mutex              CLASS_TONULLABLE(CLASS_Mutex)
#define TYPE_Mutex__            CLASS_TOPLURAL(CLASS_Mutex)
#define IS_Mutex(o)             (knh_Object_cid(o) == CLASS_Mutex)
#define DEBUG_Mutex                     1
#define KNH_CAST_Mutex(ctx,o)           knh_Mutex_cast(ctx,o)
#define KNH_CAST_MutexOrNull(ctx,o)     knh_Mutex_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Runtime */
#define STRUCT_Runtime          ((knh_struct_t)51)
#define STRUCT_IS_Runtime(o)    (knh_Object_topsid(o) == STRUCT_Runtime)
#define CLASS_Runtime           ((knh_class_t)51)
#define CF_Runtime              ((knh_flag_t)0)
#define OF_Runtime              KNH_FLAG_CF2OF(CF_Runtime)
#define TYPE_Runtime            CLASS_TONULLABLE(CLASS_Runtime)
#define TYPE_Runtime__          CLASS_TOPLURAL(CLASS_Runtime)
#define IS_Runtime(o)           (knh_Object_cid(o) == CLASS_Runtime)
#define DEBUG_Runtime                   1
#define KNH_CAST_Runtime(ctx,o)         knh_Runtime_cast(ctx,o)
#define KNH_CAST_RuntimeOrNull(ctx,o)   knh_Runtime_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Context */
#define STRUCT_Context          ((knh_struct_t)52)
#define STRUCT_IS_Context(o)    (knh_Object_topsid(o) == STRUCT_Context)
#define CLASS_Context           ((knh_class_t)52)
#define CF_Context              ((knh_flag_t)0)
#define OF_Context              KNH_FLAG_CF2OF(CF_Context)
#define TYPE_Context            CLASS_TONULLABLE(CLASS_Context)
#define TYPE_Context__          CLASS_TOPLURAL(CLASS_Context)
#define IS_Context(o)           (knh_Object_cid(o) == CLASS_Context)
#define DEBUG_Context                   1
#define KNH_CAST_Context(ctx,o)         knh_Context_cast(ctx,o)
#define KNH_CAST_ContextOrNull(ctx,o)   knh_Context_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Token */
#define STRUCT_Token            ((knh_struct_t)53)
#define STRUCT_IS_Token(o)      (knh_Object_topsid(o) == STRUCT_Token)
#define CLASS_Token             ((knh_class_t)53)
#define CF_Token                ((knh_flag_t)0)
#define OF_Token                KNH_FLAG_CF2OF(CF_Token)
#define TYPE_Token              CLASS_TONULLABLE(CLASS_Token)
#define TYPE_Token__            CLASS_TOPLURAL(CLASS_Token)
#define IS_Token(o)             (knh_Object_cid(o) == CLASS_Token)
#define DEBUG_Token                     1
#define KNH_CAST_Token(ctx,o)           knh_Token_cast(ctx,o)
#define KNH_CAST_TokenOrNull(ctx,o)     knh_Token_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Stmt */
#define STRUCT_Stmt             ((knh_struct_t)54)
#define STRUCT_IS_Stmt(o)       (knh_Object_topsid(o) == STRUCT_Stmt)
#define CLASS_Stmt              ((knh_class_t)54)
#define CF_Stmt                 ((knh_flag_t)0)
#define OF_Stmt                 KNH_FLAG_CF2OF(CF_Stmt)
#define TYPE_Stmt               CLASS_TONULLABLE(CLASS_Stmt)
#define TYPE_Stmt__             CLASS_TOPLURAL(CLASS_Stmt)
#define IS_Stmt(o)              (knh_Object_cid(o) == CLASS_Stmt)
#define DEBUG_Stmt                      1
#define KNH_CAST_Stmt(ctx,o)            knh_Stmt_cast(ctx,o)
#define KNH_CAST_StmtOrNull(ctx,o)      knh_Stmt_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Cmpl */
#define STRUCT_Cmpl             ((knh_struct_t)55)
#define STRUCT_IS_Cmpl(o)       (knh_Object_topsid(o) == STRUCT_Cmpl)
#define CLASS_Cmpl              ((knh_class_t)55)
#define CF_Cmpl                 ((knh_flag_t)0)
#define OF_Cmpl                 KNH_FLAG_CF2OF(CF_Cmpl)
#define TYPE_Cmpl               CLASS_TONULLABLE(CLASS_Cmpl)
#define TYPE_Cmpl__             CLASS_TOPLURAL(CLASS_Cmpl)
#define IS_Cmpl(o)              (knh_Object_cid(o) == CLASS_Cmpl)
#define DEBUG_Cmpl                      1
#define KNH_CAST_Cmpl(ctx,o)            knh_Cmpl_cast(ctx,o)
#define KNH_CAST_CmplOrNull(ctx,o)      knh_Cmpl_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_VirtualMachineCode */
#define STRUCT_VirtualMachineCode ((knh_struct_t)56)
#define STRUCT_IS_VirtualMachineCode(o) (knh_Object_topsid(o) == STRUCT_VirtualMachineCode)
#define CLASS_VirtualMachineCode ((knh_class_t)56)
#define CF_VirtualMachineCode   ((knh_flag_t)0)
#define OF_VirtualMachineCode   KNH_FLAG_CF2OF(CF_VirtualMachineCode)
#define TYPE_VirtualMachineCode CLASS_TONULLABLE(CLASS_VirtualMachineCode)
#define TYPE_VirtualMachineCode__ CLASS_TOPLURAL(CLASS_VirtualMachineCode)
#define IS_VirtualMachineCode(o) (knh_Object_cid(o) == CLASS_VirtualMachineCode)
#define DEBUG_VirtualMachineCode        1
#define KNH_CAST_VirtualMachineCode(ctx,o) knh_VirtualMachineCode_cast(ctx,o)
#define KNH_CAST_VirtualMachineCodeOrNull(ctx,o) knh_VirtualMachineCode_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Amazon */
#define STRUCT_Amazon           ((knh_struct_t)57)
#define STRUCT_IS_Amazon(o)     (knh_Object_topsid(o) == STRUCT_Amazon)
#define CLASS_Amazon            ((knh_class_t)57)
#define CF_Amazon               ((knh_flag_t)0)
#define OF_Amazon               KNH_FLAG_CF2OF(CF_Amazon)
#define TYPE_Amazon             CLASS_TONULLABLE(CLASS_Amazon)
#define TYPE_Amazon__           CLASS_TOPLURAL(CLASS_Amazon)
#define IS_Amazon(o)            (knh_Object_cid(o) == CLASS_Amazon)
#define DEBUG_Amazon                    1
#define KNH_CAST_Amazon(ctx,o)          knh_Amazon_cast(ctx,o)
#define KNH_CAST_AmazonOrNull(ctx,o)    knh_Amazon_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_Counter */
#define STRUCT_Counter          ((knh_struct_t)58)
#define STRUCT_IS_Counter(o)    (knh_Object_topsid(o) == STRUCT_Counter)
#define CLASS_Counter           ((knh_class_t)58)
#define CF_Counter              ((knh_flag_t)0)
#define OF_Counter              KNH_FLAG_CF2OF(CF_Counter)
#define TYPE_Counter            CLASS_TONULLABLE(CLASS_Counter)
#define TYPE_Counter__          CLASS_TOPLURAL(CLASS_Counter)
#define IS_Counter(o)           (knh_Object_cid(o) == CLASS_Counter)
#define DEBUG_Counter                   1
#define KNH_CAST_Counter(ctx,o)         knh_Counter_cast(ctx,o)
#define KNH_CAST_CounterOrNull(ctx,o)   knh_Counter_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */

/* ======================================================================== */
/* knh_Closure */
#define STRUCT_Closure          (knh_struct_t)(sizeof(knh_Closure)/sizeof(Object*))
#define CLASS_Closure           ((knh_class_t)KONOHA_TSTRUCT_SIZE+0)
#define CF_Closure              ((knh_flag_t)0)
#define OF_Closure              KNH_FLAG_CF2OF(CF_Closure)
#define TYPE_Closure            CLASS_TONULLABLE(CLASS_Closure)
#define TYPE_Closure__          CLASS_TOPLURAL(CLASS_Closure)
#define IS_Closure(o)           (knh_Object_cid(o) == CLASS_Closure)
#define DEBUG_Closure                   1
#define KNH_CAST_Closure(ctx,o)         knh_Closure_cast(ctx,o)
#define KNH_CAST_ClosureOrNull(ctx,o)   knh_Closure_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_System */
#define STRUCT_System           (knh_struct_t)(sizeof(knh_System)/sizeof(Object*))
#define CLASS_System            ((knh_class_t)KONOHA_TSTRUCT_SIZE+1)
#define CF_System               ((knh_flag_t)0)
#define OF_System               KNH_FLAG_CF2OF(CF_System)
#define TYPE_System             CLASS_TONULLABLE(CLASS_System)
#define TYPE_System__           CLASS_TOPLURAL(CLASS_System)
#define IS_System(o)            (knh_Object_cid(o) == CLASS_System)
#define DEBUG_System                    1
#define KNH_CAST_System(ctx,o)          knh_System_cast(ctx,o)
#define KNH_CAST_SystemOrNull(ctx,o)    knh_System_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */
/* knh_NameSpace */
#define STRUCT_NameSpace        (knh_struct_t)(sizeof(knh_NameSpace)/sizeof(Object*))
#define CLASS_NameSpace         ((knh_class_t)KONOHA_TSTRUCT_SIZE+2)
#define CF_NameSpace            ((knh_flag_t)0)
#define OF_NameSpace            KNH_FLAG_CF2OF(CF_NameSpace)
#define TYPE_NameSpace          CLASS_TONULLABLE(CLASS_NameSpace)
#define TYPE_NameSpace__        CLASS_TOPLURAL(CLASS_NameSpace)
#define IS_NameSpace(o)         (knh_Object_cid(o) == CLASS_NameSpace)
#define DEBUG_NameSpace                 1
#define KNH_CAST_NameSpace(ctx,o)       knh_NameSpace_cast(ctx,o)
#define KNH_CAST_NameSpaceOrNull(ctx,o) knh_NameSpace_castOrNull(ctx,o)

/* ------------------------------------------------------------------------ */

/* ======================================================================== */
/* @STRUCT/CLASS 59 3 */

/* ======================================================================== */

/* ======================================================================== */
/* FIELDN, METHODN */
#define FIELDN_                         ((knh_fieldn_t)0)
#define METHODN_                        ((knh_methodn_t)0)
#define METHODN__                       ((knh_methodn_t)0|KNH_FLAG_MN_MOVTEXT)
#define METHODN_get                     ((knh_methodn_t)0|KNH_FLAG_MN_GETTER)
#define METHODN_set                     ((knh_methodn_t)0|KNH_FLAG_MN_SETTER)
#define FIELDN_this                     ((knh_fieldn_t)1)
#define METHODN_this                    ((knh_methodn_t)1)
#define METHODN__this                   ((knh_methodn_t)1|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getThis                 ((knh_methodn_t)1|KNH_FLAG_MN_GETTER)
#define METHODN_setThis                 ((knh_methodn_t)1|KNH_FLAG_MN_SETTER)
#define FIELDN_vargs                    ((knh_fieldn_t)2)
#define METHODN_vargs                   ((knh_methodn_t)2)
#define METHODN__vargs                  ((knh_methodn_t)2|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getVargs                ((knh_methodn_t)2|KNH_FLAG_MN_GETTER)
#define METHODN_setVargs                ((knh_methodn_t)2|KNH_FLAG_MN_SETTER)
#define FIELDN_uname                    ((knh_fieldn_t)3)
#define METHODN_uname                   ((knh_methodn_t)3)
#define METHODN__uname                  ((knh_methodn_t)3|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getUname                ((knh_methodn_t)3|KNH_FLAG_MN_GETTER)
#define METHODN_setUname                ((knh_methodn_t)3|KNH_FLAG_MN_SETTER)
#define FIELDN_order                    ((knh_fieldn_t)4)
#define METHODN_order                   ((knh_methodn_t)4)
#define METHODN__order                  ((knh_methodn_t)4|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOrder                ((knh_methodn_t)4|KNH_FLAG_MN_GETTER)
#define METHODN_setOrder                ((knh_methodn_t)4|KNH_FLAG_MN_SETTER)
#define FIELDN_w                        ((knh_fieldn_t)5)
#define METHODN_w                       ((knh_methodn_t)5)
#define METHODN__w                      ((knh_methodn_t)5|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getW                    ((knh_methodn_t)5|KNH_FLAG_MN_GETTER)
#define METHODN_setW                    ((knh_methodn_t)5|KNH_FLAG_MN_SETTER)
#define FIELDN_m                        ((knh_fieldn_t)6)
#define METHODN_m                       ((knh_methodn_t)6)
#define METHODN__m                      ((knh_methodn_t)6|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getM                    ((knh_methodn_t)6|KNH_FLAG_MN_GETTER)
#define METHODN_setM                    ((knh_methodn_t)6|KNH_FLAG_MN_SETTER)
#define FIELDN_value                    ((knh_fieldn_t)7)
#define METHODN_value                   ((knh_methodn_t)7)
#define METHODN__value                  ((knh_methodn_t)7|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getValue                ((knh_methodn_t)7|KNH_FLAG_MN_GETTER)
#define METHODN_setValue                ((knh_methodn_t)7|KNH_FLAG_MN_SETTER)
#define FIELDN_start                    ((knh_fieldn_t)8)
#define METHODN_start                   ((knh_methodn_t)8)
#define METHODN__start                  ((knh_methodn_t)8|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getStart                ((knh_methodn_t)8|KNH_FLAG_MN_GETTER)
#define METHODN_setStart                ((knh_methodn_t)8|KNH_FLAG_MN_SETTER)
#define FIELDN_end                      ((knh_fieldn_t)9)
#define METHODN_end                     ((knh_methodn_t)9)
#define METHODN__end                    ((knh_methodn_t)9|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getEnd                  ((knh_methodn_t)9|KNH_FLAG_MN_GETTER)
#define METHODN_setEnd                  ((knh_methodn_t)9|KNH_FLAG_MN_SETTER)
#define FIELDN_mn                       ((knh_fieldn_t)10)
#define METHODN_mn                      ((knh_methodn_t)10)
#define METHODN__mn                     ((knh_methodn_t)10|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getMn                   ((knh_methodn_t)10|KNH_FLAG_MN_GETTER)
#define METHODN_setMn                   ((knh_methodn_t)10|KNH_FLAG_MN_SETTER)
#define FIELDN_key                      ((knh_fieldn_t)11)
#define METHODN_key                     ((knh_methodn_t)11)
#define METHODN__key                    ((knh_methodn_t)11|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getKey                  ((knh_methodn_t)11|KNH_FLAG_MN_GETTER)
#define METHODN_setKey                  ((knh_methodn_t)11|KNH_FLAG_MN_SETTER)
#define FIELDN_initialCapacity          ((knh_fieldn_t)12)
#define METHODN_initialCapacity         ((knh_methodn_t)12)
#define METHODN__initialCapacity        ((knh_methodn_t)12|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getInitialCapacity      ((knh_methodn_t)12|KNH_FLAG_MN_GETTER)
#define METHODN_setInitialCapacity      ((knh_methodn_t)12|KNH_FLAG_MN_SETTER)
#define FIELDN_offset                   ((knh_fieldn_t)13)
#define METHODN_offset                  ((knh_methodn_t)13)
#define METHODN__offset                 ((knh_methodn_t)13|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOffset               ((knh_methodn_t)13|KNH_FLAG_MN_GETTER)
#define METHODN_setOffset               ((knh_methodn_t)13|KNH_FLAG_MN_SETTER)
#define FIELDN_term                     ((knh_fieldn_t)14)
#define METHODN_term                    ((knh_methodn_t)14)
#define METHODN__term                   ((knh_methodn_t)14|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getTerm                 ((knh_methodn_t)14|KNH_FLAG_MN_GETTER)
#define METHODN_setTerm                 ((knh_methodn_t)14|KNH_FLAG_MN_SETTER)
#define FIELDN_index                    ((knh_fieldn_t)15)
#define METHODN_index                   ((knh_methodn_t)15)
#define METHODN__index                  ((knh_methodn_t)15|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIndex                ((knh_methodn_t)15|KNH_FLAG_MN_GETTER)
#define METHODN_setIndex                ((knh_methodn_t)15|KNH_FLAG_MN_SETTER)
#define FIELDN_e                        ((knh_fieldn_t)16)
#define METHODN_e                       ((knh_methodn_t)16)
#define METHODN__e                      ((knh_methodn_t)16|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getE                    ((knh_methodn_t)16|KNH_FLAG_MN_GETTER)
#define METHODN_setE                    ((knh_methodn_t)16|KNH_FLAG_MN_SETTER)
#define FIELDN_msg                      ((knh_fieldn_t)17)
#define METHODN_msg                     ((knh_methodn_t)17)
#define METHODN__msg                    ((knh_methodn_t)17|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getMsg                  ((knh_methodn_t)17|KNH_FLAG_MN_GETTER)
#define METHODN_setMsg                  ((knh_methodn_t)17|KNH_FLAG_MN_SETTER)
#define FIELDN_bag                      ((knh_fieldn_t)18)
#define METHODN_bag                     ((knh_methodn_t)18)
#define METHODN__bag                    ((knh_methodn_t)18|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getBag                  ((knh_methodn_t)18|KNH_FLAG_MN_GETTER)
#define METHODN_setBag                  ((knh_methodn_t)18|KNH_FLAG_MN_SETTER)
#define FIELDN_urn                      ((knh_fieldn_t)19)
#define METHODN_urn                     ((knh_methodn_t)19)
#define METHODN__urn                    ((knh_methodn_t)19|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getUrn                  ((knh_methodn_t)19|KNH_FLAG_MN_GETTER)
#define METHODN_setUrn                  ((knh_methodn_t)19|KNH_FLAG_MN_SETTER)
#define FIELDN_v                        ((knh_fieldn_t)20)
#define METHODN_v                       ((knh_methodn_t)20)
#define METHODN__v                      ((knh_methodn_t)20|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getV                    ((knh_methodn_t)20|KNH_FLAG_MN_GETTER)
#define METHODN_setV                    ((knh_methodn_t)20|KNH_FLAG_MN_SETTER)
#define FIELDN_name                     ((knh_fieldn_t)21)
#define METHODN_name                    ((knh_methodn_t)21)
#define METHODN__name                   ((knh_methodn_t)21|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getName                 ((knh_methodn_t)21|KNH_FLAG_MN_GETTER)
#define METHODN_setName                 ((knh_methodn_t)21|KNH_FLAG_MN_SETTER)
#define FIELDN_c                        ((knh_fieldn_t)22)
#define METHODN_c                       ((knh_methodn_t)22)
#define METHODN__c                      ((knh_methodn_t)22|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getC                    ((knh_methodn_t)22|KNH_FLAG_MN_GETTER)
#define METHODN_setC                    ((knh_methodn_t)22|KNH_FLAG_MN_SETTER)
#define FIELDN_other                    ((knh_fieldn_t)23)
#define METHODN_other                   ((knh_methodn_t)23)
#define METHODN__other                  ((knh_methodn_t)23|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOther                ((knh_methodn_t)23|KNH_FLAG_MN_GETTER)
#define METHODN_setOther                ((knh_methodn_t)23|KNH_FLAG_MN_SETTER)
#define FIELDN_lv                       ((knh_fieldn_t)24)
#define METHODN_lv                      ((knh_methodn_t)24)
#define METHODN__lv                     ((knh_methodn_t)24|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getLv                   ((knh_methodn_t)24|KNH_FLAG_MN_GETTER)
#define METHODN_setLv                   ((knh_methodn_t)24|KNH_FLAG_MN_SETTER)
#define FIELDN_buf                      ((knh_fieldn_t)25)
#define METHODN_buf                     ((knh_methodn_t)25)
#define METHODN__buf                    ((knh_methodn_t)25|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getBuf                  ((knh_methodn_t)25|KNH_FLAG_MN_GETTER)
#define METHODN_setBuf                  ((knh_methodn_t)25|KNH_FLAG_MN_SETTER)
#define FIELDN_s                        ((knh_fieldn_t)26)
#define METHODN_s                       ((knh_methodn_t)26)
#define METHODN__s                      ((knh_methodn_t)26|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getS                    ((knh_methodn_t)26|KNH_FLAG_MN_GETTER)
#define METHODN_setS                    ((knh_methodn_t)26|KNH_FLAG_MN_SETTER)
#define FIELDN_n                        ((knh_fieldn_t)27)
#define METHODN_n                       ((knh_methodn_t)27)
#define METHODN__n                      ((knh_methodn_t)27|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getN                    ((knh_methodn_t)27|KNH_FLAG_MN_GETTER)
#define METHODN_setN                    ((knh_methodn_t)27|KNH_FLAG_MN_SETTER)
#define FIELDN_init                     ((knh_fieldn_t)28)
#define METHODN_init                    ((knh_methodn_t)28)
#define METHODN__init                   ((knh_methodn_t)28|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getInit                 ((knh_methodn_t)28|KNH_FLAG_MN_GETTER)
#define METHODN_setInit                 ((knh_methodn_t)28|KNH_FLAG_MN_SETTER)
#define FIELDN_another                  ((knh_fieldn_t)29)
#define METHODN_another                 ((knh_methodn_t)29)
#define METHODN__another                ((knh_methodn_t)29|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getAnother              ((knh_methodn_t)29|KNH_FLAG_MN_GETTER)
#define METHODN_setAnother              ((knh_methodn_t)29|KNH_FLAG_MN_SETTER)
#define FIELDN_query                    ((knh_fieldn_t)30)
#define METHODN_query                   ((knh_methodn_t)30)
#define METHODN__query                  ((knh_methodn_t)30|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getQuery                ((knh_methodn_t)30|KNH_FLAG_MN_GETTER)
#define METHODN_setQuery                ((knh_methodn_t)30|KNH_FLAG_MN_SETTER)
#define FIELDN_input                    ((knh_fieldn_t)31)
#define METHODN_input                   ((knh_methodn_t)31)
#define METHODN__input                  ((knh_methodn_t)31|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getInput                ((knh_methodn_t)31|KNH_FLAG_MN_GETTER)
#define METHODN_setInput                ((knh_methodn_t)31|KNH_FLAG_MN_SETTER)
#define FIELDN_out                      ((knh_fieldn_t)32)
#define METHODN_out                     ((knh_methodn_t)32)
#define METHODN__out                    ((knh_methodn_t)32|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOut                  ((knh_methodn_t)32|KNH_FLAG_MN_GETTER)
#define METHODN_setOut                  ((knh_methodn_t)32|KNH_FLAG_MN_SETTER)
#define FIELDN_run                      ((knh_fieldn_t)33)
#define METHODN_run                     ((knh_methodn_t)33)
#define METHODN__run                    ((knh_methodn_t)33|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getRun                  ((knh_methodn_t)33|KNH_FLAG_MN_GETTER)
#define METHODN_setRun                  ((knh_methodn_t)33|KNH_FLAG_MN_SETTER)
#define FIELDN_placeOrder               ((knh_fieldn_t)34)
#define METHODN_placeOrder              ((knh_methodn_t)34)
#define METHODN__placeOrder             ((knh_methodn_t)34|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getPlaceOrder           ((knh_methodn_t)34|KNH_FLAG_MN_GETTER)
#define METHODN_setPlaceOrder           ((knh_methodn_t)34|KNH_FLAG_MN_SETTER)
#define FIELDN_new                      ((knh_fieldn_t)35)
#define METHODN_new                     ((knh_methodn_t)35)
#define METHODN__new                    ((knh_methodn_t)35|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getNew                  ((knh_methodn_t)35|KNH_FLAG_MN_GETTER)
#define METHODN_setNew                  ((knh_methodn_t)35|KNH_FLAG_MN_SETTER)
#define FIELDN_count                    ((knh_fieldn_t)36)
#define METHODN_count                   ((knh_methodn_t)36)
#define METHODN__count                  ((knh_methodn_t)36|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getCount                ((knh_methodn_t)36|KNH_FLAG_MN_GETTER)
#define METHODN_setCount                ((knh_methodn_t)36|KNH_FLAG_MN_SETTER)
#define FIELDN_reset                    ((knh_fieldn_t)37)
#define METHODN_reset                   ((knh_methodn_t)37)
#define METHODN__reset                  ((knh_methodn_t)37|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getReset                ((knh_methodn_t)37|KNH_FLAG_MN_GETTER)
#define METHODN_setReset                ((knh_methodn_t)37|KNH_FLAG_MN_SETTER)
#define FIELDN_dump                     ((knh_fieldn_t)38)
#define METHODN_dump                    ((knh_methodn_t)38)
#define METHODN__dump                   ((knh_methodn_t)38|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getDump                 ((knh_methodn_t)38|KNH_FLAG_MN_GETTER)
#define METHODN_setDump                 ((knh_methodn_t)38|KNH_FLAG_MN_SETTER)
#define FIELDN_code                     ((knh_fieldn_t)39)
#define METHODN_code                    ((knh_methodn_t)39)
#define METHODN__code                   ((knh_methodn_t)39|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getCode                 ((knh_methodn_t)39|KNH_FLAG_MN_GETTER)
#define METHODN_setCode                 ((knh_methodn_t)39|KNH_FLAG_MN_SETTER)
#define FIELDN_add____fast              ((knh_fieldn_t)40)
#define METHODN_add__fast               ((knh_methodn_t)40)
#define METHODN__add__fast              ((knh_methodn_t)40|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getAdd__fast            ((knh_methodn_t)40|KNH_FLAG_MN_GETTER)
#define METHODN_setAdd__fast            ((knh_methodn_t)40|KNH_FLAG_MN_SETTER)
#define FIELDN_add                      ((knh_fieldn_t)41)
#define METHODN_add                     ((knh_methodn_t)41)
#define METHODN__add                    ((knh_methodn_t)41|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getAdd                  ((knh_methodn_t)41|KNH_FLAG_MN_GETTER)
#define METHODN_setAdd                  ((knh_methodn_t)41|KNH_FLAG_MN_SETTER)
#define FIELDN_pop                      ((knh_fieldn_t)42)
#define METHODN_pop                     ((knh_methodn_t)42)
#define METHODN__pop                    ((knh_methodn_t)42|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getPop                  ((knh_methodn_t)42|KNH_FLAG_MN_GETTER)
#define METHODN_setPop                  ((knh_methodn_t)42|KNH_FLAG_MN_SETTER)
#define FIELDN_slice                    ((knh_fieldn_t)43)
#define METHODN_slice                   ((knh_methodn_t)43)
#define METHODN__slice                  ((knh_methodn_t)43|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getSlice                ((knh_methodn_t)43|KNH_FLAG_MN_GETTER)
#define METHODN_setSlice                ((knh_methodn_t)43|KNH_FLAG_MN_SETTER)
#define FIELDN_clear                    ((knh_fieldn_t)44)
#define METHODN_clear                   ((knh_methodn_t)44)
#define METHODN__clear                  ((knh_methodn_t)44|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getClear                ((knh_methodn_t)44|KNH_FLAG_MN_GETTER)
#define METHODN_setClear                ((knh_methodn_t)44|KNH_FLAG_MN_SETTER)
#define FIELDN_method                   ((knh_fieldn_t)45)
#define METHODN_method                  ((knh_methodn_t)45)
#define METHODN__method                 ((knh_methodn_t)45|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getMethod               ((knh_methodn_t)45|KNH_FLAG_MN_GETTER)
#define METHODN_setMethod               ((knh_methodn_t)45|KNH_FLAG_MN_SETTER)
#define FIELDN_close                    ((knh_fieldn_t)46)
#define METHODN_close                   ((knh_methodn_t)46)
#define METHODN__close                  ((knh_methodn_t)46|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getClose                ((knh_methodn_t)46|KNH_FLAG_MN_GETTER)
#define METHODN_setClose                ((knh_methodn_t)46|KNH_FLAG_MN_SETTER)
#define FIELDN_property                 ((knh_fieldn_t)47)
#define METHODN_property                ((knh_methodn_t)47)
#define METHODN__property               ((knh_methodn_t)47|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getProperty             ((knh_methodn_t)47|KNH_FLAG_MN_GETTER)
#define METHODN_setProperty             ((knh_methodn_t)47|KNH_FLAG_MN_SETTER)
#define FIELDN_____fast                 ((knh_fieldn_t)48)
#define METHODN___fast                  ((knh_methodn_t)48)
#define METHODN____fast                 ((knh_methodn_t)48|KNH_FLAG_MN_MOVTEXT)
#define METHODN_get__fast               ((knh_methodn_t)48|KNH_FLAG_MN_GETTER)
#define METHODN_set__fast               ((knh_methodn_t)48|KNH_FLAG_MN_SETTER)
#define FIELDN_new____init              ((knh_fieldn_t)49)
#define METHODN_new__init               ((knh_methodn_t)49)
#define METHODN__new__init              ((knh_methodn_t)49|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getNew__init            ((knh_methodn_t)49|KNH_FLAG_MN_GETTER)
#define METHODN_setNew__init            ((knh_methodn_t)49|KNH_FLAG_MN_SETTER)
#define FIELDN_append                   ((knh_fieldn_t)50)
#define METHODN_append                  ((knh_methodn_t)50)
#define METHODN__append                 ((knh_methodn_t)50|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getAppend               ((knh_methodn_t)50|KNH_FLAG_MN_GETTER)
#define METHODN_setAppend               ((knh_methodn_t)50|KNH_FLAG_MN_SETTER)
#define FIELDN_remove                   ((knh_fieldn_t)51)
#define METHODN_remove                  ((knh_methodn_t)51)
#define METHODN__remove                 ((knh_methodn_t)51|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getRemove               ((knh_methodn_t)51|KNH_FLAG_MN_GETTER)
#define METHODN_setRemove               ((knh_methodn_t)51|KNH_FLAG_MN_SETTER)
#define FIELDN_opIn                     ((knh_fieldn_t)52)
#define METHODN_opIn                    ((knh_methodn_t)52)
#define METHODN__opIn                   ((knh_methodn_t)52|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpIn                 ((knh_methodn_t)52|KNH_FLAG_MN_GETTER)
#define METHODN_setOpIn                 ((knh_methodn_t)52|KNH_FLAG_MN_SETTER)
#define FIELDN_keys                     ((knh_fieldn_t)53)
#define METHODN_keys                    ((knh_methodn_t)53)
#define METHODN__keys                   ((knh_methodn_t)53|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getKeys                 ((knh_methodn_t)53|KNH_FLAG_MN_GETTER)
#define METHODN_setKeys                 ((knh_methodn_t)53|KNH_FLAG_MN_SETTER)
#define FIELDN_readLine                 ((knh_fieldn_t)54)
#define METHODN_readLine                ((knh_methodn_t)54)
#define METHODN__readLine               ((knh_methodn_t)54|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getReadLine             ((knh_methodn_t)54|KNH_FLAG_MN_GETTER)
#define METHODN_setReadLine             ((knh_methodn_t)54|KNH_FLAG_MN_SETTER)
#define FIELDN_opAdd                    ((knh_fieldn_t)55)
#define METHODN_opAdd                   ((knh_methodn_t)55)
#define METHODN__opAdd                  ((knh_methodn_t)55|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpAdd                ((knh_methodn_t)55|KNH_FLAG_MN_GETTER)
#define METHODN_setOpAdd                ((knh_methodn_t)55|KNH_FLAG_MN_SETTER)
#define FIELDN_isAbstract               ((knh_fieldn_t)56)
#define METHODN_isAbstract              ((knh_methodn_t)56)
#define METHODN__isAbstract             ((knh_methodn_t)56|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsAbstract           ((knh_methodn_t)56|KNH_FLAG_MN_GETTER)
#define METHODN_setIsAbstract           ((knh_methodn_t)56|KNH_FLAG_MN_SETTER)
#define FIELDN_uRN                      ((knh_fieldn_t)57)
#define METHODN_uRN                     ((knh_methodn_t)57)
#define METHODN__uRN                    ((knh_methodn_t)57|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getURN                  ((knh_methodn_t)57|KNH_FLAG_MN_GETTER)
#define METHODN_setURN                  ((knh_methodn_t)57|KNH_FLAG_MN_SETTER)
#define FIELDN_class                    ((knh_fieldn_t)58)
#define METHODN_class                   ((knh_methodn_t)58)
#define METHODN__class                  ((knh_methodn_t)58|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getClass                ((knh_methodn_t)58|KNH_FLAG_MN_GETTER)
#define METHODN_setClass                ((knh_methodn_t)58|KNH_FLAG_MN_SETTER)
#define FIELDN_compare                  ((knh_fieldn_t)59)
#define METHODN_compare                 ((knh_methodn_t)59)
#define METHODN__compare                ((knh_methodn_t)59|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getCompare              ((knh_methodn_t)59|KNH_FLAG_MN_GETTER)
#define METHODN_setCompare              ((knh_methodn_t)59|KNH_FLAG_MN_SETTER)
#define FIELDN_opEq                     ((knh_fieldn_t)60)
#define METHODN_opEq                    ((knh_methodn_t)60)
#define METHODN__opEq                   ((knh_methodn_t)60|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpEq                 ((knh_methodn_t)60|KNH_FLAG_MN_GETTER)
#define METHODN_setOpEq                 ((knh_methodn_t)60|KNH_FLAG_MN_SETTER)
#define FIELDN_opNeq                    ((knh_fieldn_t)61)
#define METHODN_opNeq                   ((knh_methodn_t)61)
#define METHODN__opNeq                  ((knh_methodn_t)61|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpNeq                ((knh_methodn_t)61|KNH_FLAG_MN_GETTER)
#define METHODN_setOpNeq                ((knh_methodn_t)61|KNH_FLAG_MN_SETTER)
#define FIELDN_opLt                     ((knh_fieldn_t)62)
#define METHODN_opLt                    ((knh_methodn_t)62)
#define METHODN__opLt                   ((knh_methodn_t)62|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpLt                 ((knh_methodn_t)62|KNH_FLAG_MN_GETTER)
#define METHODN_setOpLt                 ((knh_methodn_t)62|KNH_FLAG_MN_SETTER)
#define FIELDN_opLte                    ((knh_fieldn_t)63)
#define METHODN_opLte                   ((knh_methodn_t)63)
#define METHODN__opLte                  ((knh_methodn_t)63|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpLte                ((knh_methodn_t)63|KNH_FLAG_MN_GETTER)
#define METHODN_setOpLte                ((knh_methodn_t)63|KNH_FLAG_MN_SETTER)
#define FIELDN_opGt                     ((knh_fieldn_t)64)
#define METHODN_opGt                    ((knh_methodn_t)64)
#define METHODN__opGt                   ((knh_methodn_t)64|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpGt                 ((knh_methodn_t)64|KNH_FLAG_MN_GETTER)
#define METHODN_setOpGt                 ((knh_methodn_t)64|KNH_FLAG_MN_SETTER)
#define FIELDN_opGte                    ((knh_fieldn_t)65)
#define METHODN_opGte                   ((knh_methodn_t)65)
#define METHODN__opGte                  ((knh_methodn_t)65|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpGte                ((knh_methodn_t)65|KNH_FLAG_MN_GETTER)
#define METHODN_setOpGte                ((knh_methodn_t)65|KNH_FLAG_MN_SETTER)
#define FIELDN_opNot                    ((knh_fieldn_t)66)
#define METHODN_opNot                   ((knh_methodn_t)66)
#define METHODN__opNot                  ((knh_methodn_t)66|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpNot                ((knh_methodn_t)66|KNH_FLAG_MN_GETTER)
#define METHODN_setOpNot                ((knh_methodn_t)66|KNH_FLAG_MN_SETTER)
#define FIELDN_opSeq                    ((knh_fieldn_t)67)
#define METHODN_opSeq                   ((knh_methodn_t)67)
#define METHODN__opSeq                  ((knh_methodn_t)67|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpSeq                ((knh_methodn_t)67|KNH_FLAG_MN_GETTER)
#define METHODN_setOpSeq                ((knh_methodn_t)67|KNH_FLAG_MN_SETTER)
#define FIELDN_opIsMapTo                ((knh_fieldn_t)68)
#define METHODN_opIsMapTo               ((knh_methodn_t)68)
#define METHODN__opIsMapTo              ((knh_methodn_t)68|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpIsMapTo            ((knh_methodn_t)68|KNH_FLAG_MN_GETTER)
#define METHODN_setOpIsMapTo            ((knh_methodn_t)68|KNH_FLAG_MN_SETTER)
#define FIELDN_save                     ((knh_fieldn_t)69)
#define METHODN_save                    ((knh_methodn_t)69)
#define METHODN__save                   ((knh_methodn_t)69|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getSave                 ((knh_methodn_t)69|KNH_FLAG_MN_GETTER)
#define METHODN_setSave                 ((knh_methodn_t)69|KNH_FLAG_MN_SETTER)
#define FIELDN_empty                    ((knh_fieldn_t)70)
#define METHODN_empty                   ((knh_methodn_t)70)
#define METHODN__empty                  ((knh_methodn_t)70|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getEmpty                ((knh_methodn_t)70|KNH_FLAG_MN_GETTER)
#define METHODN_setEmpty                ((knh_methodn_t)70|KNH_FLAG_MN_SETTER)
#define FIELDN_refc                     ((knh_fieldn_t)71)
#define METHODN_refc                    ((knh_methodn_t)71)
#define METHODN__refc                   ((knh_methodn_t)71|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getRefc                 ((knh_methodn_t)71|KNH_FLAG_MN_GETTER)
#define METHODN_setRefc                 ((knh_methodn_t)71|KNH_FLAG_MN_SETTER)
#define FIELDN_addr                     ((knh_fieldn_t)72)
#define METHODN_addr                    ((knh_methodn_t)72)
#define METHODN__addr                   ((knh_methodn_t)72|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getAddr                 ((knh_methodn_t)72|KNH_FLAG_MN_GETTER)
#define METHODN_setAddr                 ((knh_methodn_t)72|KNH_FLAG_MN_SETTER)
#define FIELDN_write                    ((knh_fieldn_t)73)
#define METHODN_write                   ((knh_methodn_t)73)
#define METHODN__write                  ((knh_methodn_t)73|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getWrite                ((knh_methodn_t)73|KNH_FLAG_MN_GETTER)
#define METHODN_setWrite                ((knh_methodn_t)73|KNH_FLAG_MN_SETTER)
#define FIELDN_flush                    ((knh_fieldn_t)74)
#define METHODN_flush                   ((knh_methodn_t)74)
#define METHODN__flush                  ((knh_methodn_t)74|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getFlush                ((knh_methodn_t)74|KNH_FLAG_MN_GETTER)
#define METHODN_setFlush                ((knh_methodn_t)74|KNH_FLAG_MN_SETTER)
#define FIELDN_match                    ((knh_fieldn_t)75)
#define METHODN_match                   ((knh_methodn_t)75)
#define METHODN__match                  ((knh_methodn_t)75|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getMatch                ((knh_methodn_t)75|KNH_FLAG_MN_GETTER)
#define METHODN_setMatch                ((knh_methodn_t)75|KNH_FLAG_MN_SETTER)
#define FIELDN_next                     ((knh_fieldn_t)76)
#define METHODN_next                    ((knh_methodn_t)76)
#define METHODN__next                   ((knh_methodn_t)76|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getNext                 ((knh_methodn_t)76|KNH_FLAG_MN_GETTER)
#define METHODN_setNext                 ((knh_methodn_t)76|KNH_FLAG_MN_SETTER)
#define FIELDN_inputStream              ((knh_fieldn_t)77)
#define METHODN_inputStream             ((knh_methodn_t)77)
#define METHODN__inputStream            ((knh_methodn_t)77|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getInputStream          ((knh_methodn_t)77|KNH_FLAG_MN_GETTER)
#define METHODN_setInputStream          ((knh_methodn_t)77|KNH_FLAG_MN_SETTER)
#define FIELDN_outputStream             ((knh_fieldn_t)78)
#define METHODN_outputStream            ((knh_methodn_t)78)
#define METHODN__outputStream           ((knh_methodn_t)78|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOutputStream         ((knh_methodn_t)78|KNH_FLAG_MN_GETTER)
#define METHODN_setOutputStream         ((knh_methodn_t)78|KNH_FLAG_MN_SETTER)
#define FIELDN_equals                   ((knh_fieldn_t)79)
#define METHODN_equals                  ((knh_methodn_t)79)
#define METHODN__equals                 ((knh_methodn_t)79|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getEquals               ((knh_methodn_t)79|KNH_FLAG_MN_GETTER)
#define METHODN_setEquals               ((knh_methodn_t)79|KNH_FLAG_MN_SETTER)
#define FIELDN_startsWith               ((knh_fieldn_t)80)
#define METHODN_startsWith              ((knh_methodn_t)80)
#define METHODN__startsWith             ((knh_methodn_t)80|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getStartsWith           ((knh_methodn_t)80|KNH_FLAG_MN_GETTER)
#define METHODN_setStartsWith           ((knh_methodn_t)80|KNH_FLAG_MN_SETTER)
#define FIELDN_endsWith                 ((knh_fieldn_t)81)
#define METHODN_endsWith                ((knh_methodn_t)81)
#define METHODN__endsWith               ((knh_methodn_t)81|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getEndsWith             ((knh_methodn_t)81|KNH_FLAG_MN_GETTER)
#define METHODN_setEndsWith             ((knh_methodn_t)81|KNH_FLAG_MN_SETTER)
#define FIELDN_size                     ((knh_fieldn_t)82)
#define METHODN_size                    ((knh_methodn_t)82)
#define METHODN__size                   ((knh_methodn_t)82|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getSize                 ((knh_methodn_t)82|KNH_FLAG_MN_GETTER)
#define METHODN_setSize                 ((knh_methodn_t)82|KNH_FLAG_MN_SETTER)
#define FIELDN_opMul                    ((knh_fieldn_t)83)
#define METHODN_opMul                   ((knh_methodn_t)83)
#define METHODN__opMul                  ((knh_methodn_t)83|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpMul                ((knh_methodn_t)83|KNH_FLAG_MN_GETTER)
#define METHODN_setOpMul                ((knh_methodn_t)83|KNH_FLAG_MN_SETTER)
#define FIELDN_new____array             ((knh_fieldn_t)84)
#define METHODN_new__array              ((knh_methodn_t)84)
#define METHODN__new__array             ((knh_methodn_t)84|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getNew__array           ((knh_methodn_t)84|KNH_FLAG_MN_GETTER)
#define METHODN_setNew__array           ((knh_methodn_t)84|KNH_FLAG_MN_SETTER)
#define FIELDN_opSub                    ((knh_fieldn_t)85)
#define METHODN_opSub                   ((knh_methodn_t)85)
#define METHODN__opSub                  ((knh_methodn_t)85|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpSub                ((knh_methodn_t)85|KNH_FLAG_MN_GETTER)
#define METHODN_setOpSub                ((knh_methodn_t)85|KNH_FLAG_MN_SETTER)
#define FIELDN_opDiv                    ((knh_fieldn_t)86)
#define METHODN_opDiv                   ((knh_methodn_t)86)
#define METHODN__opDiv                  ((knh_methodn_t)86|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpDiv                ((knh_methodn_t)86|KNH_FLAG_MN_GETTER)
#define METHODN_setOpDiv                ((knh_methodn_t)86|KNH_FLAG_MN_SETTER)
#define FIELDN_random                   ((knh_fieldn_t)87)
#define METHODN_random                  ((knh_methodn_t)87)
#define METHODN__random                 ((knh_methodn_t)87|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getRandom               ((knh_methodn_t)87|KNH_FLAG_MN_GETTER)
#define METHODN_setRandom               ((knh_methodn_t)87|KNH_FLAG_MN_SETTER)
#define FIELDN_opMod                    ((knh_fieldn_t)88)
#define METHODN_opMod                   ((knh_methodn_t)88)
#define METHODN__opMod                  ((knh_methodn_t)88|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpMod                ((knh_methodn_t)88|KNH_FLAG_MN_GETTER)
#define METHODN_setOpMod                ((knh_methodn_t)88|KNH_FLAG_MN_SETTER)
#define FIELDN_opLogicalAnd             ((knh_fieldn_t)89)
#define METHODN_opLogicalAnd            ((knh_methodn_t)89)
#define METHODN__opLogicalAnd           ((knh_methodn_t)89|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpLogicalAnd         ((knh_methodn_t)89|KNH_FLAG_MN_GETTER)
#define METHODN_setOpLogicalAnd         ((knh_methodn_t)89|KNH_FLAG_MN_SETTER)
#define FIELDN_opLogicalOr              ((knh_fieldn_t)90)
#define METHODN_opLogicalOr             ((knh_methodn_t)90)
#define METHODN__opLogicalOr            ((knh_methodn_t)90|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpLogicalOr          ((knh_methodn_t)90|KNH_FLAG_MN_GETTER)
#define METHODN_setOpLogicalOr          ((knh_methodn_t)90|KNH_FLAG_MN_SETTER)
#define FIELDN_opLogicalXor             ((knh_fieldn_t)91)
#define METHODN_opLogicalXor            ((knh_methodn_t)91)
#define METHODN__opLogicalXor           ((knh_methodn_t)91|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpLogicalXor         ((knh_methodn_t)91|KNH_FLAG_MN_GETTER)
#define METHODN_setOpLogicalXor         ((knh_methodn_t)91|KNH_FLAG_MN_SETTER)
#define FIELDN_opLogicalNot             ((knh_fieldn_t)92)
#define METHODN_opLogicalNot            ((knh_methodn_t)92)
#define METHODN__opLogicalNot           ((knh_methodn_t)92|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpLogicalNot         ((knh_methodn_t)92|KNH_FLAG_MN_GETTER)
#define METHODN_setOpLogicalNot         ((knh_methodn_t)92|KNH_FLAG_MN_SETTER)
#define FIELDN_opLShift                 ((knh_fieldn_t)93)
#define METHODN_opLShift                ((knh_methodn_t)93)
#define METHODN__opLShift               ((knh_methodn_t)93|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpLShift             ((knh_methodn_t)93|KNH_FLAG_MN_GETTER)
#define METHODN_setOpLShift             ((knh_methodn_t)93|KNH_FLAG_MN_SETTER)
#define FIELDN_opRShift                 ((knh_fieldn_t)94)
#define METHODN_opRShift                ((knh_methodn_t)94)
#define METHODN__opRShift               ((knh_methodn_t)94|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpRShift             ((knh_methodn_t)94|KNH_FLAG_MN_GETTER)
#define METHODN_setOpRShift             ((knh_methodn_t)94|KNH_FLAG_MN_SETTER)
#define FIELDN_x                        ((knh_fieldn_t)95)
#define METHODN_x                       ((knh_methodn_t)95)
#define METHODN__x                      ((knh_methodn_t)95|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getX                    ((knh_methodn_t)95|KNH_FLAG_MN_GETTER)
#define METHODN_setX                    ((knh_methodn_t)95|KNH_FLAG_MN_SETTER)
#define FIELDN_bits                     ((knh_fieldn_t)96)
#define METHODN_bits                    ((knh_methodn_t)96)
#define METHODN__bits                   ((knh_methodn_t)96|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getBits                 ((knh_methodn_t)96|KNH_FLAG_MN_GETTER)
#define METHODN_setBits                 ((knh_methodn_t)96|KNH_FLAG_MN_SETTER)
#define FIELDN_in                       ((knh_fieldn_t)97)
#define METHODN_in                      ((knh_methodn_t)97)
#define METHODN__in                     ((knh_methodn_t)97|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIn                   ((knh_methodn_t)97|KNH_FLAG_MN_GETTER)
#define METHODN_setIn                   ((knh_methodn_t)97|KNH_FLAG_MN_SETTER)
#define FIELDN_err                      ((knh_fieldn_t)98)
#define METHODN_err                     ((knh_methodn_t)98)
#define METHODN__err                    ((knh_methodn_t)98|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getErr                  ((knh_methodn_t)98|KNH_FLAG_MN_GETTER)
#define METHODN_setErr                  ((knh_methodn_t)98|KNH_FLAG_MN_SETTER)
#define FIELDN_runtime                  ((knh_fieldn_t)99)
#define METHODN_runtime                 ((knh_methodn_t)99)
#define METHODN__runtime                ((knh_methodn_t)99|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getRuntime              ((knh_methodn_t)99|KNH_FLAG_MN_GETTER)
#define METHODN_setRuntime              ((knh_methodn_t)99|KNH_FLAG_MN_SETTER)
#define FIELDN_isSingleton              ((knh_fieldn_t)100)
#define METHODN_isSingleton             ((knh_methodn_t)100)
#define METHODN__isSingleton            ((knh_methodn_t)100|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsSingleton          ((knh_methodn_t)100|KNH_FLAG_MN_GETTER)
#define METHODN_setIsSingleton          ((knh_methodn_t)100|KNH_FLAG_MN_SETTER)
#define FIELDN_opInstanceof             ((knh_fieldn_t)101)
#define METHODN_opInstanceof            ((knh_methodn_t)101)
#define METHODN__opInstanceof           ((knh_methodn_t)101|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpInstanceof         ((knh_methodn_t)101|KNH_FLAG_MN_GETTER)
#define METHODN_setOpInstanceof         ((knh_methodn_t)101|KNH_FLAG_MN_SETTER)

#ifdef __cplusplus
}
#endif

/* ======================================================================== */

#endif/*KONOHA_CLASS__H*/
