/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

 
/* ************************************************************************ */

#ifdef KONOHA_PACKAGE

#include<math.h>    /* @LD -lm */
#include<konoha/konoha_dev.h>

#ifdef __cplusplus 
extern "C" {
#endif


/* ======================================================================== */
/* [info] */

const char *package_version()
{
	return "1.0";
}

/* ------------------------------------------------------------------------ */

const char *package_copyright()
{
	/* Why don't you add your name ? */
	return "Copyright (c) 2007, Kimio Kuramitsu, Konoha Software Foundation";
}

/* ------------------------------------------------------------------------ */

typedef void (*f_test)(void);

const char *package_license(f_test f)
{
	f();
	knh_show_used_memory();
#ifdef KONOHA_UNDER_GPL
	return "GNU Public License " KONOHA_UNDER_GPL;
#else
	return "Konoha Software Foundation License 1.0";
#endif
}

/* ------------------------------------------------------------------------ */

const char *package_homepage()
{
	return "http://konoha.sourceforge.jp/";
}

/* ======================================================================== */
/* [struct] */


/* ======================================================================== */
/* [class] */

static Object *staticMath = NULL;

/* ------------------------------------------------------------------------ */

Object *knh_Math_defaultValue(Ctx *ctx, knh_class_t cid)
{
	if(staticMath == NULL) {
		staticMath = knh_Object_malloc(ctx, cid);
		TGLOBAL(staticMath);
	}
	return staticMath;
}


/* ------------------------------------------------------------------------ */

void load_Math(Ctx *ctx, knh_flag_t flag, String *name)
{
	KNH_TCLASS(ctx, 
		flag,          /* NO NEED TO CHANGE */
		name,          /* NO NEED TO CHANGE */
		CLASS_newid,   /* NO NEED TO CHANGE */
		STRUCT_Object, /* struct id */
		CLASS_Object,  /* super class id */
		KNH_NULL,
		knh_Math_defaultValue, 
		0);
}

/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */
/* @method Float! Math.sin(Float! *v) */

METHOD knh__Math_sin(Ctx *ctx, Object **sfp)
{
#if defined(KNH_FLOAT_TYPE__LONG_DOUBLE)
	Float *v = new_Float(ctx, (knh_float_t)sinl((long double)knh_Number_tofloat(sfp[1])));
#elif defined(KNH_FLOAT_TYPE__FLOAT)
	Float *v = new_Float(ctx, (knh_float_t)sinf((float)knh_Number_tofloat(sfp[1])));
#else
	Float *v = new_Float(ctx, (knh_float_t)sin((double)knh_Number_tofloat(sfp[1])));
#endif
	VM_RET(ctx, v);
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif

#endif/*KONOHA_PACKAGE*/
