#!/usr/bin/python
import os, sys
from pygenlib2  import *

# ---------------------------------------------------------------------------

def write_flag_h(f, c, fb, n):
	if c == None: return
	if fb.index == None:
		write_define(f, fb.KNH_FLAG, 'KNH_FLAG%d' % n, 40)
	else:
		write_define(f, fb.KNH_FLAG, 'KNH_FLAG_OF_LOCAL%s' % fb.index, 40)

	args = 'o'
	if fb.fmt.find('[n]') > 0: args = 'o,n'
	funcbase = c.funcbase
	if c.cname == 'Class': 
		funcbase = funcbase.replace('Class', 'class')
	ff = fb.options[0]
	if ff != '*':  
		f.write('''
#define %s_%s%s(%s)  \\
\t((%s & %s) == %s)
''' % (funcbase, ff, fb.pname, args, fb.fmt % 'o', fb.KNH_FLAG, fb.KNH_FLAG))
		if fb.nname != None:
			f.write('''
#define %s_%s%s(%s)   \\
\t((%s & %s) != %s)
''' % (funcbase, ff, fb.nname, args, fb.fmt % 'o', fb.KNH_FLAG, fb.KNH_FLAG))
	ff = fb.options[1]
	if ff != '*':  
		f.write('''
#define %s_%s%s(%s,b)  \\
\tif(b) %s |= %s; else %s &= ~(%s);

''' % (funcbase, ff, fb.pname, args, fb.fmt % 'o', fb.KNH_FLAG, fb.fmt % 'o', fb.KNH_FLAG))
		if fb.nname != None:
			f.write('''
#define %s_%s%s(%s,b)  \\
\tif(b) %s &= ~(%s); else %s |= %s;

''' % (funcbase, ff, fb.nname, args, fb.fmt % 'o', fb.KNH_FLAG, fb.fmt % 'o', fb.KNH_FLAG))
	
####################################################################################################################

def write_class0_h(f, c, n):
	if(c.struct_name != '0'):
		write_ifndefine(f, c.cname.replace(':', '_'), c.struct_name, 32)
	write_define(f, 'IS_%s(o)' % c.cname, '(knh_Object_cid(o) == %s)' % CLASS_cname(c.cname), 32)
	write_define(f, TYPE_cname(c.cname), 'CLASS_TONULLABLE(%s)' % CLASS_cname(c.cname), 32)
	write_define(f, TYPE_cname(c.cname+'..'), 'CLASS_TOPLURAL(%s)' % CLASS_cname(c.cname), 32)
	write_define(f, 'KNH_CFLAG_%s' % c.cname, '((knh_flag_t)%s)' % c.flag, 32)
	write_define(f, 'KNH_FLAG_%s' % c.cname, 'KNH_FLAG_CF2OF(KNH_FLAG_%s)' % c.cname, 32)

def write_struct_h(f, c, n):
	write_section(f, c.cname)
	write_define(f, STRUCT_cname(c.cname), '((knh_struct_t)%d)' % n, 32)
	write_define(f, CLASS_cname(c.cname), '((knh_class_t)%d)' % n, 32)
	write_define(f, 'STRUCT_IS_%s(o)' % c.cname, '(knh_Object_topsid(o) == %s)' % STRUCT_cname(c.cname), 32)
	write_class0_h(f, c, n)

def write_class_h(f, c, n):
	write_section(f, c.cname)
	if(c.struct_name == '0'):
		write_define(f, STRUCT_cname(c.cname), '((knh_struct_t)0)', 32)
	else:
		write_define(f, STRUCT_cname(c.cname), '(knh_struct_t)(sizeof(%s)/sizeof(Object*))' % c.struct_name, 32)
	write_define(f, CLASS_cname(c.cname), '((knh_class_t)KONOHA_TSTRUCT_SIZE+%d)' % n, 32)
	write_class0_h(f, c, n)

def write_fieldn_h(f, data):
    c = 0
    for n in data.FIELDN_LIST:
        write_define(f, FIELDN_name(n.replace(':', '__')), '((knh_fieldn_t)%d)' % c)
        write_define(f, METHODN_mname(n), '((knh_methodn_t)%d)' % c)
        write_define(f, METHODN_mname('%' + n), '((knh_methodn_t)%d|KNH_FLAG_MN_MOVTEXT)' % c)
        if(len(n) > 0):
            n = n[0].upper() + n[1:]
        write_define(f, METHODN_mname('get' + n), '((knh_methodn_t)%d|KNH_FLAG_MN_GETTER)' % c)
        write_define(f, METHODN_mname('set' + n), '((knh_methodn_t)%d|KNH_FLAG_MN_SETTER)' % c)
        c += 1



def gen_name_h(bdir, data):
	fname = '%s/include/konoha/gen/konoha_name_.h' % bdir
	f = open_h(fname, ['<konoha/konoha_config.h>', '<konoha/konoha_t.h>'])
	#write_define(f, 'KONOHA_SERIAL_NUMBER', '%d' % get_serial_number())

	write_chapter(f, '[flag]')
	fc = ''
	fn = 0
	c = None
	for flag in data.FLAG_LIST:
		if flag.cname != fc:
			fc = flag.cname
			fn = 0
			if data.CLASS_MAP.has_key(fc):
				c = data.CLASS_MAP[fc]
			write_section(f, fc)
		write_flag_h(f, c, flag, fn)
		fn += 1

	write_chapter(f, '[class]')
	sn = 0
	cn = 1
	for p in data.PACKAGE_LIST:
		p = data.package(p)
		write_section(f, p.package)
		for c in p.CLASS_LIST:
			if c.cname == 'Object': continue
			c.set_flag(data)
			if c.isTuple() :
				write_class_h(f, c, cn)
				write_line(f)
				cn += 1
			else:
				write_struct_h(f, c, sn)
				write_line(f)
				sn += 1

	write_chapter(f, '[field]')
	write_fieldn_h(f, data)

	write_chapter(f, '[macros]')
	for m in data.MACROS:
		write_println(f, m)

	close_h(f, fname)

# ---------------------------------------------------------------------------
# ---------------------------------------------------------------------------
# ---------------------------------------------------------------------------

def write_flag_c(f, c, fb, data):
	if c == None: return
	funcbase = c.funcbase
	a1 = 'sfp[0]'
	if c.cname == 'Class': 
		funcbase = funcbase.replace('Class', 'class')
		a1 = 'knh_Class_cid(sfp[0])'
	methodbase = c.methodbase

	ff = fb.options[2]
	if ff != '*':
		ffn = ff + fb.pname
		functype = 'METHOD %s_%s(Ctx *ctx, Object **sfp)' % (methodbase, ffn)
		Method(c.package, '@method Bool! %s.%s()' % (c.cname, ffn), functype, data)
		f.write('''
METHOD %s_%s(Ctx *ctx, Object **sfp)
{
\tif(%s_%s(%s)) {
\t\tMETHOD_RETURN(ctx, sfp, KNH_TRUE);
\t}else{
\t\tMETHOD_RETURN(ctx, sfp, KNH_FALSE);
\t}
}
''' % (methodbase, ffn, funcbase, ffn, a1))
		if fb.nname != None:
			ffn = ff + fb.nname
			functype = 'METHOD %s_%s(Ctx *ctx, Object **sfp)' % (methodbase, ffn)
			Method(c.package, '@method Bool! %s.%s()' % (c.cname, ffn), functype, data)
			f.write('''
METHOD %s_%s(Ctx *ctx, Object **sfp)
{
\tif(%s_%s(%s)) {
\t\tMETHOD_RETURN(ctx, sfp, KNH_FALSE);
\t}else{
\t\tMETHOD_RETURN(ctx, sfp, KNH_TRUE);
\t}
}
''' % (methodbase, ffn, funcbase, ffn, a1))
	#
	ff = fb.options[3]
	if ff != '*':
		ffn = ff + fb.pname
		functype = 'METHOD %s_%s(Ctx *ctx, Object **sfp)' % (methodbase, ffn)
		Method(c.package, '@method void %s.%s(Bool b)' % (c.cname, ffn), functype, data)
		f.write('''
METHOD %s_%s(Ctx *ctx, Object **sfp)
{
\t%s_%s(%s, IS_TRUE(sfp[1]));
\tMETHOD_RETURN(ctx, sfp, KNH_VOID);
}
''' % (methodbase, ffn, funcbase, ffn, a1))
		if fb.nname != None:
			ffn = ff + fb.nname
			functype = 'METHOD %s_%s(Ctx *ctx, Object **sfp)' % (methodbase, ffn)
			Method(c.package, '@method void %s.%s(Bool b)' % (c.cname, ffn), functype, data)
			f.write('''
METHOD %s_%s(Ctx *ctx, Object **sfp)
{
\t%s_%s(%s, IS_TRUE(sfp[1]));
\tMETHOD_RETURN(ctx, sfp, KNH_VOID);
}
''' % (methodbase, ffn, funcbase, ffn, a1))

def write_struct_c(f, c):
	if c.cname == 'Object':
		f.write('''
\tKNH_TSTRUCT(ctx, 0, 0, "Tuple0", NULL, NULL, NULL, NULL); ''')
	else:
		f.write('''
\tKNH_TSTRUCT(ctx, %s, sizeof(%s),
\t\t"%s",
\t\t%s_struct_init,
\t\t%s_struct_copy, 
\t\t%s_struct_compare, 
\t\t%s_struct_traverse);''' % (STRUCT_cname(c.cname), c.struct_name, c.cname, c.funcbase, c.funcbase, c.funcbase, c.funcbase))

def write_class_c(f, c, data):
	f.write('''
\tKNH_TCLASS(ctx, KNH_CFLAG_%s, new_String__STEXT(ctx, CLASS_String, "%s"),
\t\t%s, %s, %s,''' % (c.cname, c.fullname, CLASS_cname(c.cname), STRUCT_cname(c.cname), CLASS_cname(c.super_cname)))
	spec = '%s_spec' % (c.funcbase)
	if not data.FUNC_MAP.has_key(spec):
		spec = 'KNH_NULL'
	else:
		spec += '(ctx)'
	fvalue = '%s_finitValue' % (c.funcbase)
	if not data.FUNC_MAP.has_key(fvalue) :
		fvalue = '%s_fvalue' % (c.funcbase)
		if not data.FUNC_MAP.has_key(fvalue) : fvalue = 'NULL'
	f.write('''
\t\t%s,%s); ''' % (spec, fvalue))

def gen_package_c(bdir, p, data):
	fname = '%s/gen/%s_.h' % (bdir, p.name())
	f = open_c(fname, ['<konoha/konoha_dev.h>'])
	write_chapter(f, '[flag]')
	for c in p.CLASS_LIST:
		for fb in data.FLAG_LIST:
			if fb.cname == c.cname:
				write_flag_c(f, c, fb, data)

	write_chapter(f, '[method]')

	write_chapter(f, '[package]')
	write('''
void knh_package_%s(Ctx *ctx)
{
''' % p.name())


	write('''
}
''')

	close_c(f, fname)
	
	
# ---------------------------------------------------------------------------
def gen_class(bdir):
	PM = {}
	for cname in TCLASSALL:
		c = CLASSTBL[cname]
		pkgn = c.pkgn
		if not PM.has_key(pkgn):
			PM[pkgn] = []
		PM[pkgn].append(c)
					
	for pkgn in PM.keys():
		gen = FileGen(bdir, 'class/%s' % pkgn)
		
		for c in PM[pkgn]:
			c.write_typedef(gen.fh)
			write_line(gen.fh)
		write_dline(gen.fh)

		for c in PM[pkgn]:
			c.write_prototype(gen.fh)
			c.write_CAST(gen.fc)
			c.write_flag(gen)
			write_line(gen.fh)
		
		read_CFILE(gen, '%s/class/%s' % (bdir, pkgn))
		read_CFILE(gen, '%s/api/%s' % (bdir, pkgn), API_LEVEL)
		#read_CFILE(gen, '%s/gen/class/%s' % (bdir, pkgn))
		if pkgn == 'konoha': 
			read_CFILE(gen, '%s/class/konoha/vm' % bdir)
		gen.close()
	#

# ---------------------------------------------------------------------------

def gen_class_c(bdir):
	fname = '%s/gen/konoha_class_.c' % bdir
	f = open_c(fname, ['<konoha/konoha_dev.h>'])
	write_init_struct(f)
	write_init_class(f)
	close_c(f, fname)

# ---------------------------------------------------------------------------

