#!/usr/bin/python
import os, os.path, sys
from pygenlib2  import *
from gen_hfile import *

#############

class Package :
	def __init__(self, package):
		self.package = package
		self.LDLIBS = []
		self.CFILES = []
		self.H = []
		self.C = []
		self.CLASS_LIST = []
		self.METHOD_LIST = []
		self.MAPMAP_LIST = []
		
class Source :
	def __init__(self, bdir):
		self.bdir = bdir
		self.lastfpath = ''
		self.MACROS = []
		self.PACKAGE_LIST = ['konoha']
		self.PACKAGE_MAP = {}
		self.FUNC_MAP = {}
		self.FLAG_LIST = []
		self.FLAG_MAP = {}
		self.FIELDN_LIST = []
		self.FIELDN_MAP = {}
		self.CLASS_MAP = {}
		self.METHOD_MAP = {}
		self.MAPMAP_MAP = {}
	###
	
	def kpath(self, fpath):
		if fpath.startswith(self.bdir+'/'):
			return fpath[len(bdir)+1:]
		return fpath
	###

	def package(self, package):
		if not self.PACKAGE_MAP.has_key(package):
			verbose_print("reading package %s .." % package)
			self.PACKAGE_MAP[package] = Package(package)
		return self.PACKAGE_MAP[package]

	def add_file(self, package, fpath):
		if fpath.startswith(self.bdir+'/'):
			fpath = fpath[len(bdir)+1:]
		self.package(package).FILE_LIST.append(fpath) 
		
	def add_library(self, lib):
		self.package(lib.package).LDLIBS.append(lib) 
	
	def add_flag(self, f):
		self.FLAG_LIST.append(f)
		self.FLAG_MAP[f.id] = f
	
	def add_class(self, c):
		if self.CLASS_MAP.has_key(c.id):
			print "DEBUG duplicated class name: %s" % c.id
			return
		self.CLASS_MAP[c.id] = c
		self.package(c.package).CLASS_LIST.append(c) 

	def add_fieldn(self, fn):
		if fn.startswith('%'): 
			fn = fn[1:]
		elif fn.startswith('get') or fn.startswith("set") :
			fn = fn[3:]
			if len(fn) > 0 : fn = fn[0].lower() + fn[1:]
		if self.FIELDN_MAP.has_key(fn):
			return
		self.FIELDN_MAP[fn] = True
		self.FIELDN_LIST.append(fn)

	def add_field(self, f):
		self.FIELD_LIST.append(f)
		self.FIELD_MAP[f.id] = f

	def add_method(self, mtd):
		if self.METHOD_MAP.has_key(mtd.id):
			print "DEBUG duplicated method name: %s" % mtd.id
			return
		self.METHOD_MAP[mtd.id] = mtd
		self.package(mtd.package).METHOD_LIST.append(mtd)
		self.add_fieldn(mtd.mn)
		for p in mtd.params:
			self.add_fieldn(p.name)
			
	def add_mapmap(self, mm):
		if self.MAPMAP_MAP.has_key(mm.id):
			print "DEBUG duplicated mapmap name: %s" % mm.id
			return
		self.MAPMAP_MAP[mm.id] = mm
		self.package(mm.package).METHOD_LIST.append(mm)
		
######

def parse_options(t, n):
	if len(t) <= n: return []
	return t[n:]

######

# /* @using socket -lsocket */

class Library:
	def __init__(self, package, anno, data):
		self.package = package
		self.anno = anno
		t = anno.split()
		self.name = t[1]
		self.options = parse_options(t, 2)
		data.add_library(self)
		
# /* @field TYPE Class.name ctype.cname @Options */

class Field :
	def __init__(self, package, anno, data):
		self.package = package
		self.anno = anno
		
		t = anno.split()
		self.type =  t[1]
		self.id = t[2]
		self.cname, self.fn = t[2].split('.')
		if t[3].find(".") > 0 : 
			self.ctype, self.cname = t[3].split('.')
		else:
			self.ctype = t[1]
			self.cname = t[3]
		self.options = parse_options(t, 4)
		###
		data.add_field(self)
		###
###

# /* @flag Nue.Release!Debug NUE:1 knh_Object_head(%s)->flag 'is:set:*:*' */

class Flag:
	def __init__(self, package, anno, data):
		#print anno
		self.package = package
		self.anno = anno

		t = anno.split()
		p = t[1].replace('!', '.').split('.')
		self.cname = p[0]
		self.pname = p[1]
		self.id = '%s.%s' % (p[0], p[1])
		if len(p) == 2:
			self.nname = None
		else:
			self.nname = p[2]
		if t[2].find(':') > 0:
			t[2], self.index = t[2].split(':')
		else:
			self.index = None
		self.KNH_FLAG = 'KNH_FLAG_%s_%s' % (t[2], self.pname.upper())
		self.fmt = t[3]
		self.options = t[4].replace('\'', '').split(':')
		###
		data.add_flag(self)
		###
###

# /* @class[OPT] Class Object knh_ @Option */

class Class :
	def __init__(self, package, anno, data):
		self.package = package
		self.anno = anno

		t = anno.split()
		self.cname = t[1]
		self.id = t[1]
		self.supcname = t[2]
		self.struct_name = t[3]
		self.options = parse_options(t, 4)
		if self.struct_name.endswith('_'):
			self.struct_name += self.cname
		self.funcbase = self.struct_name
		if self.struct_name == '0':
			self.funcbase = 'knh_%s' % self.cname
		self.methodbase = self.funcbase.replace('_', '__')
		###
		data.add_class(self)
		###

	def isTuple(self):
		if self.struct_name == '0' or '@Tuple' in self.options:
			return True
		return False
	
	def set_flag(self, data):
		flag = ''
		for o in self.options:
			key = self.cname + '.' + o[1:]
			if data.FLAG_MAP.has_key(key):
				flag += ('|' + FLAG_MAP[key].KNH_FLAG)
		if len(flag) == 0:
			self.flag = '0'
		else:
			self.flag = flag[1:]
	###
######

class Param :
	def __init__(self, type, name, value = None):
		self.type = type
		self.name = name
		self.value = value

def parse_params(ptext):
	params = []
	ptext = ptext[ptext.find('(')+1:]
	ptext = ptext[:ptext.find(')')]
	if len(ptext) == 0: return params
	for a in ptext.split(','):
		a = a.replace('=', ' ')
		t = a.split()
		if len(t) == 3:
			params.append(Param(t[0], t[1], t[2]))
		elif len(t) == 2:
			params.append(Param(t[0], t[1]))
		else:
			params.append(Param('any', t[0]))
	return params

MT_PARAMS = [Param('Object', 'w'), Param('any', 'm')]

class Method :
	def __init__(self, package, anno, functype, data):
		self.package = package
		self.anno = anno
		self.functype = functype
		
		pre, args = anno.split('(')
		t = pre.replace('.',' ').split()
		self.rtype = t[1]
		self.cname = t[2]
		self.mn = t[3]
		self.id = '%s.%s' % (self.cname, self.mn)
		self.options = parse_options(t, 4)
		self.methodfunc = None
		if self.mn.startswith('%'):
			self.params = MT_PARAMS
			self.optfunc = parse_funcname(self.functype)
			self.methodfunc = 'knh_fmethod_movableText'
		else:
			self.params = parse_params(anno)
			funcname = parse_funcname(self.functype)
			loc = funcname.find('_')
			if funcname[loc+1] == '_':
				self.methodfunc = funcname
				self.optfunc = 'NULL'
		###
		data.add_method(self)
		###

#####

class MapMap :
    def __init__(self, package, anno, funcname, data) :
    	self.package = package
    	self.anno = anno
    	self.funcname = funcname
        
        t = anno.split()
        self.fcname = t[1]
        self.tcname = t[2]
        self.id = '%s->%s' % (self.fcname, self.tcname)
        self.options = parse_options(t, 3)
        self.mapfunc = funcname
        if self.tcname.endswith('!') or self.tcname.endswith('..') or self.tcname == 'Bool':
        	self.options.append('@Total')
        #
        data.add_mapmap(self)
        #
###


def read_source_cblock(fpath, package, zone, text, data):
	functype = parse_functype(text)
	if functype == None: return
	
	if(data.lastfpath != fpath):
		data.lastfpath = fpath;
		data.package(package).H.append('/* %s */' % fpath)
	data.package(package).H.append(functype + ';')
	
	funcname = parse_funcname(functype)
	data.FUNC_MAP[funcname] = text

	if text.find('/* @map') != -1: MapMap(package, parse_anno(text, '@map'), funcname, data)
	if text.find('/* @method') != -1: Method(package, parse_anno(text, '@method'), functype, data)
###

def read_lineanno(package, line, data):
	if line.find('/* @using') != -1:
		Library(package, parse_anno(line, '@using'), data)
		return line
	if line.find('/* @flag') != -1:
		Flag(package, parse_anno(line, '@flag'), data)
		return line
	if line.find('/* @field') != -1:
		Field(package, parse_anno(line, '@field'), data)
		return line
	if line.find('/* @class') != -1:
		Class(package, parse_anno(line, '@class'), data)
		return line
	return line


def read_source_h(fpath, package, data):
	print fpath, package
	f = open(fpath)
	if package == None: package = parse_package(fpath)
	for ln in f:
		ln = read_lineanno(package, ln, data)
	f.close()

def read_source_c(fpath, data):
	f = open(fpath)
	package = parse_package(fpath)
	
	# header part
	pp = 0
	cline = None
	for ln in f:
		ln = read_lineanno(package, ln, data)
		if ln.startswith('#endif') and pp == 1:
			break
		if ln.startswith('#ifdef __cplusplus'):
			cline = ''
			pp = 1
			continue
	
	# body part
	zone = '[config]'
	text = ''

	pp = 0
	for ln in f: 
		if ln.startswith('//'): continue
		ln = read_lineanno(package, ln, data)
		if ln.startswith('#endif') and pp == 1: break
		if ln.startswith('#ifdef __cplusplus'): 
			pp = 1
			continue
		
		if ln.startswith('/* ['):
			zone = ln.split()[1]
			continue

		if ln.startswith('/* ===') or ln.startswith('/* ---'):
			if len(text) > 0 :
				read_source_cblock(fpath, package, zone, text, data)
				text = ''
				continue
			
		if ln.startswith("#define _") :
			ln = linetrim(ln.replace('#define _', '#define '))
			if not ln.endswith('\\') :
				data.MACROS.append(ln)
				continue
			p = ln + '\n'	
			for ln in f:
				ln = linetrim(ln)
				p += (ln + '\n')
				if not ln.endswith('\\'): break
			###
			data.MACROS.append(p)
			continue
		if pp == 0: text += ln
	###
	if len(text) > 0 :
		read_source_cblock(fpath, package, zone, text, data)
	f.close()
###

def read_source_k(fpath, data):
	f = open(fpath)
	settings = {}
	exec(f)
	data.settings[data.kpath(fpath)] = settings
###

def read_include_class(dir, data):
	dir = dir + '/include/konoha/class'
	fl = os.listdir(dir)
	for fn in fl:
		if fn.endswith('_.h'): continue
		if fn.endswith('.h'): 
			read_source_h(dir + '/' + fn, fn.replace('.h', ''), data)

def read_source(dir, data):
	fl = os.listdir(dir)
	for fn in fl:
		if fn.startswith('.'): continue
		if fn.startswith('_'): continue
		fpath = dir + '/' + fn
		if fn.endswith('.c'): 
			read_source_c(fpath, data)
		if fn.endswith('.h') and dir.find('/include/konoha') == -1: 
			read_source_h(fpath, None, data)
		if os.path.isdir(fpath):
			read_source(fpath, data)

#############

if __name__ == '__main__':
	if len(sys.argv) == 1: bdir = '..'
	else: bdir = sys.args[1]
	data = Source(bdir)
	read_include_class(bdir, data)
	read_source(bdir, data)
	gen_name_h(bdir, data)

