/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */
/* [constructor] */

/* ------------------------------------------------------------------------ */
/* @method HashMap! HashMap.new(Int initialCapacity=0) */

INLINE
HashMap *knh_HashMap_new(Ctx *ctx, HashMap *b, size_t initialCapacity)
{
	if(initialCapacity > DP(b)->capacity) {
		knh_HashMap_resize(ctx, b, (size_t)initialCapacity);
	}
	return b;
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS] HashMap! HashMap.new::init(Any value) */

HashMap* knh_HashMap_new__init(Ctx *ctx, HashMap *b, knh_vargc_t ac, knh_sfp_t *a)
{
	knh_int_t i;
	for(i = 0; i < ac; i += 2) {
		if(IS_NULL(a[i].o) || IS_NULL(a[i+1].o)) break;
		knh_HashMap_set(ctx, b, knh_Object_hashCode(a[i].o), a[i].o, a[i+1].o);
	}
	return b;
}

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */
/* @method Boolean HashMap.opIn(Any1 key) */

INLINE
knh_bool_t knh_HashMap_opIn(Ctx *ctx, HashMap *b, knh_hcode_t key, Any *keyobj)
{
	if(keyobj != NULL && IS_NULL(keyobj)) return 0;
	return IS_NOTNULL(knh_HashMap_get(ctx, b, key, keyobj));
}

/* ======================================================================== */
/* [movabletext] */

/* ------------------------------------------------------------------------ */
/* @method void HashMap.%dump(OutputStream w, Any m) */

void knh_HashMap__dump(Ctx *ctx, HashMap *b, OutputStream *w, Any *m)
{
//	knh_hashmape_t *cur, *next;
//	size_t c = 0, i;
//	knh_fputc(ctx, w, '[');
//	for(i = 0; i < DP(b)->capacity; i++) {
//		cur = DP(b)->array[i];
//		while(cur != NULL) {
//			next = cur->next;
//			if(c > 0) knh_print_delim(ctx,w);
//			if(!knh_ucheck_todump(lv, c)) {
//				knh_print_dots(ctx, w);
//				break;
//			}
//			knh_Tuple2__dump(ctx, cur->h.keyobj, cur->value, w, lv+1);
//			c++;
//			cur = next;
//		}
//	}
//	knh_fputc(ctx, w, ']');
}

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [mapping] */

static knh_hashmape_t *knh_HashMape_next(Ctx *ctx, Iterator *it)
{
	HashMap *b = (HashMap *)knh_Iterator_source(it);
	knh_hashmape_t *cur = (knh_hashmape_t*)knh_Iterator_ref(it);
	if(cur != NULL) {
		DP(it)->ref = cur->next;
		return cur;
	}
	size_t pos = knh_Iterator_pos(it); 
	for(; pos < DP(b)->capacity; pos++) {
		cur = DP(b)->array[pos];
		if(cur != NULL) {
			knh_Iterator_setpos(it, pos+1);
			DP(it)->ref = cur->next;
			return cur;
		}
	}
	return NULL;
}

/* ------------------------------------------------------------------------ */

Object* knh_HashMap_key_next(Ctx *ctx, Iterator *it)
{
	knh_hashmape_t *cur = knh_HashMape_next(ctx, it);
	if(cur == NULL) return KNH_NULL;
	return cur->h.keyobj;
}

/* ------------------------------------------------------------------------ */
/* @method Iterator! HashMap.keys() */

Iterator *knh_HashMap_keys(Ctx *ctx, HashMap *b)
{
	return new_Iterator(ctx, knh_tClass[b->h.cid].p1, (Object*)b, knh_HashMap_key_next);
}

/* ------------------------------------------------------------------------ */
/* @map HashMap Iterator! */

Iterator* knh_HashMap_Iterator(Ctx *ctx, HashMap *b, Mapper *mpr)
{
	return new_Iterator(ctx, knh_tClass[b->h.cid].p1, b, knh_HashMap_key_next);
}

///* ------------------------------------------------------------------------ */
//
//Object *knh_HashMap_tuple2_next(Ctx *ctx, Iterator *it) 
//{
//	knh_hashmape_t *cur = knh_HashMape_next(ctx, it);
//	if(cur == NULL) return KNH_NULL;
//	return knh_Tuple2_new(ctx, cur->h.keyobj, cur->value);
//}
//
///* ------------------------------------------------------------------------ */
//
///* @map HashMap Tuple2..! */
//
//
//Object* knh_HashMap_Tuple2__(Ctx *ctx, Object *self, MapMap *map)
//{
//	return new_Iterator(ctx, CLASS_Tuple2, self, knh_HashMap_tuple2_next);	
//}

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [movabletext] */

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
