/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [constructor] */

///* ------------------------------------------------------------------------ */
///* @method InputStream! InputStream.new(String! urn) */
//
//InputStream *knh_InputStream_new(Ctx *ctx, InputStream *b, knh_bytes_t urn)
//{
//	return b;
//}

/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */
/* @method void InputStream.setEncoding(String enc) */

void knh_InputStream_setEncoding(Ctx *ctx, InputStream *o, String *enc)
{
	if(IS_NULL(enc)) {
		KNH_SETv(ctx, DP(o)->enc, TS_ENCODING);
		KNH_SETv(ctx, DP(o)->bconv, KNH_NULL);
	}
	else if(knh_bytes_strcasecmp(knh_String_tobytes(enc), STEXT(KONOHA_ENCODING)) == 0) {
		KNH_SETv(ctx, DP(o)->enc, TS_ENCODING);
		KNH_SETv(ctx, DP(o)->bconv, KNH_NULL);
	}
	else {
		BytesConv *bin = new_BytesConv__in(ctx, knh_String_tochar(enc));
		if(IS_NULL(bin)) {
			KNH_SETv(ctx, DP(o)->enc, TS_ENCODING);
			KNH_WARNING(ctx, "unsupported character encoding: %s", knh_String_tochar(enc));
		}
		else {
			KNH_SETv(ctx, DP(o)->enc, enc);
		}
		KNH_SETv(ctx, DP(o)->bconv, bin);
	}
}

/* ======================================================================== */
/* [movabletext] */

/* @method void InputStream.%dump(OutputStream w, Any m) */

void knh_InputStream__dump(Ctx *ctx, InputStream *b, OutputStream *w, Any *m)
{
	TODO();
}

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [mapping] */

/* ======================================================================== */
/* [iterators] */

static
Object* knh_InputStream_line_next(Ctx *ctx, Iterator *it)
{
	InputStream *b = (InputStream*)knh_Iterator_source(it);
	int ch;
	knh_wbuf_t cb = knh_Context_wbuf(ctx);

	while((ch = knh_InputStream_getc(ctx, b)) != EOF) {
		if(ch == 13) continue;
		if(ch == 10) {
			return (Object*)new_String__wbufconv(ctx, cb, DP(b)->bconv);
		}
		knh_Bytes_putc(ctx, cb.ba, ch);
	}
	if(knh_wbuf_size(cb) != 0) {
		return (Object*)new_String__wbufconv(ctx, cb, DP(b)->bconv);
	}
	return KNH_VOID;
}

/* ------------------------------------------------------------------------ */
/* @map InputStream String.. */

Iterator* knh_InputStream_String__(Ctx *ctx, InputStream *o, Mapper *mpr)
{
	return new_Iterator(ctx, CLASS_String, o, knh_InputStream_line_next);
}

/* ======================================================================== */
/* [movabletext] */

/* ------------------------------------------------------------------------ */
/* @method void InputStream.%k(OutputStream w, Any m) */

void knh_InputStream__k(Ctx *ctx, InputStream *o, OutputStream *w, Any *m)
{
	knh_putc(ctx, w, '\'');
	knh_print(ctx, w, knh_String_tobytes(DP(o)->urn));
	knh_putc(ctx, w, '\'');
}


/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
