/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif


#define _KNH_SMARTcid(o, alt)   (IS_Class(o)) ? (o)->cid : (alt)
	
/* ======================================================================== */
/* [constructor] */

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */
/* @method[STATIC|SMART] Int! IntX.opAdd:2(Int! n, Class c) */

METHOD knh__IntX_opAdd__2(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_IntX(ctx, 
			KNH_SMARTcid(sfp[2].c, CLASS_Int), 
			((sfp[0].i)->value + (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC|SMART] Int! IntX.opSub:2(Int! n, Class c) */

METHOD knh__IntX_opSub__2(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_IntX(ctx, 
			KNH_SMARTcid(sfp[2].c, CLASS_Int), 
			((sfp[0].i)->value - (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC|SMART] Int! IntX.opMul:2(Int! n, Class c) */

METHOD knh__IntX_opMul__2(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_IntX(ctx, 
			KNH_SMARTcid(sfp[2].c, CLASS_Int), 
			((sfp[0].i)->value * (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC|SMART] Int! IntX.opDiv:2(Int! n, Class c) */

METHOD knh__IntX_opDiv__2(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_IntX(ctx, 
			KNH_SMARTcid(sfp[2].c, CLASS_Int), 
			((sfp[0].i)->value / (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS|STATIC|SMART] Int! IntX.opAdd(Int! v) */

METHOD knh__IntX_opAdd(Ctx *ctx, knh_sfp_t *sfp)
{
	TODO_THROW(ctx);
//	Int *o;
//	knh_vargc_t ac = knh_sfp_argc(ctx, sfp + 1);
//	knh_sfp_t *v = sfp + 1;
//	knh_int_t i, n = o->value;
//	for(i =0; i < ac - 1; i++) {
//		n += v[i].i->value;
//	}
//	if(IS_Class(v[ac-1].c)) {
//		o = new_IntX(ctx, v[ac-1].c->cid, n);
//	}
//	else {
//		n += v[ac-1].i->value;
//		o = new_Int__NNctx(ctx, n);
//	}
//	METHOD_RETURN(ctx, sfp, o);
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS|STATIC|SMART] Int! IntX.opSub(Int! n) */

METHOD knh__IntX_opSub(Ctx *ctx, knh_sfp_t *sfp)
{
	TODO_THROW(ctx);
//	Int *o;
//	knh_vargc_t ac = knh_sfp_argc(ctx, sfp + 1);
//	knh_sfp_t *v = sfp + 1;
//	knh_int_t i, n = o->value;
//	for(i =0; i < ac - 1; i++) {
//		n -= v[i].i->value;
//	}
//	if(IS_Class(v[ac-1].c)) {
//		o = new_IntX(ctx, v[ac-1].c->cid, n);
//	}
//	else {
//		n -= v[ac-1].i->value;
//		o = new_Int__NNctx(ctx, n);
//	}
//	METHOD_RETURN(ctx, sfp, o);
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS|STATIC|SMART] Int! IntX.opMul(Int! n) */

METHOD knh__IntX_opMul(Ctx *ctx, knh_sfp_t *sfp)
{
	TODO_THROW(ctx);
//	Int *o;
//	knh_vargc_t ac = knh_sfp_argc(ctx, sfp + 1);
//	knh_sfp_t *v = sfp + 1;
//	knh_int_t i, n = o->value;
//	for(i =0; i < ac - 1; i++) {
//		n *= v[i].i->value;
//	}
//	if(IS_Class(v[ac-1].c)) {
//		o = new_IntX(ctx, v[ac-1].c->cid, n);
//	}
//	else {
//		n *= v[ac-1].i->value;
//		o = new_Int__NNctx(ctx, n);
//	}
//	METHOD_RETURN(ctx, sfp, o);
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS|STATIC|SMART] Int! IntX.opDiv(Int! n) */

METHOD knh__IntX_opDiv(Ctx *ctx, knh_sfp_t *sfp)
{
	TODO_THROW(ctx);
//	Int *o;
//	knh_vargc_t ac = knh_sfp_argc(ctx, sfp + 1);
//	knh_sfp_t *v = sfp + 1;
//	knh_int_t i, n = o->value;
//	for(i =0; i < ac - 1; i++) {
//		n /= v[i].i->value;
//	}
//	if(IS_Class(v[ac-1].c)) {
//		o = new_IntX(ctx, v[ac-1].c->cid, n);
//	}
//	else {
//		n /= v[ac-1].i->value;
//		o = new_Int__NNctx(ctx, n);
//	}
//	METHOD_RETURN(ctx, sfp, o);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Int! IntX.opMod(Int! n) */

METHOD knh__IntX_opMod(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_IntX(ctx, 
			KNH_SMARTcid(sfp[2].c, CLASS_Int), 
			((sfp[0].i)->value % (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Boolean IntX.opEq(Int! value) */

METHOD knh__IntX_opEq(Ctx *ctx, knh_sfp_t *sfp)
{
	if((sfp[0].i)->value == (sfp[1].i)->value) {
		METHOD_RETURN(ctx, sfp, KNH_TRUE);
	}
	else {
		METHOD_RETURN(ctx, sfp, KNH_FALSE);
	}
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Boolean IntX.opNeq(Int! value) */

METHOD knh__IntX_opNeq(Ctx *ctx, knh_sfp_t *sfp)
{
	if((sfp[0].i)->value != (sfp[1].i)->value) {
		METHOD_RETURN(ctx, sfp, KNH_TRUE);
	}
	else {
		METHOD_RETURN(ctx, sfp, KNH_FALSE);
	}
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Boolean! IntX.opLt(Int! value) */

METHOD knh__IntX_opLt(Ctx *ctx, knh_sfp_t *sfp)
{
	if((sfp[0].i)->value < (sfp[1].i)->value) {
		METHOD_RETURN(ctx, sfp, KNH_TRUE);
	}
	else {
		METHOD_RETURN(ctx, sfp, KNH_FALSE);
	}
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Boolean! IntX.opLte(Int! value) */

METHOD knh__IntX_opLte(Ctx *ctx, knh_sfp_t *sfp)
{
	if((sfp[0].i)->value <= (sfp[1].i)->value) {
		METHOD_RETURN(ctx, sfp, KNH_TRUE);
	}
	else {
		METHOD_RETURN(ctx, sfp, KNH_FALSE);
	}
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Boolean! IntX.opGt(Int! value) */

METHOD knh__IntX_opGt(Ctx *ctx, knh_sfp_t *sfp)
{
	if((sfp[0].i)->value > (sfp[1].i)->value) {
		METHOD_RETURN(ctx, sfp, KNH_TRUE);
	}
	else {
		METHOD_RETURN(ctx, sfp, KNH_FALSE);
	}
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Boolean! IntX.opGte(Int! value) */

METHOD knh__IntX_opGte(Ctx *ctx, knh_sfp_t *sfp)
{
	if((sfp[0].i)->value >= (sfp[1].i)->value) {
		METHOD_RETURN(ctx, sfp, KNH_TRUE);
	}
	else {
		METHOD_RETURN(ctx, sfp, KNH_FALSE);
	}
}


/* ------------------------------------------------------------------------ */
/* @method[STATIC] Int! IntX.opLogicalAnd(Int! v) */

METHOD knh__IntX_opLogicalAnd(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int(ctx, ((sfp[0].i)->value & (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */

/* @method[STATIC] Int! IntX.opLogicalOr(Int! v) */

METHOD knh__IntX_opLogicalOr(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int(ctx, ((sfp[0].i)->value | (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Int! IntX.opLogicalXor(Int! n) */

METHOD knh__IntX_opLogicalXor(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int(ctx, ((sfp[0].i)->value ^ (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Int! IntX.opLogicalNot() */

METHOD knh__IntX_opLogicalNot(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int(ctx, ~((sfp[0].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */

/* @method[STATIC] Int! IntX.opLShift(Int! n) */

METHOD knh__IntX_opLShift(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int(ctx, ((sfp[0].i)->value << (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */

/* @method[STATIC] Int! IntX.opRShift(Int! n) */

METHOD knh__IntX_opRShift(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int(ctx, ((sfp[0].i)->value >> (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}


/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [mapping] */

///* ------------------------------------------------------------------------ */
///* @map[STATIC] String Int */
//
//Object* knh_String_IntX(Ctx *ctx, Object *self, Mapper *map)
//{
//	knh_bytes_t t = knh_String_tobytes(self);
////	if(!knh_byte_isNumber(t)) {
////		return_Null(ctx, "Format!!: %s", t.buf);
////	}
//	return new_IntX(ctx, knh_bytes_toint(t));
//}
//
///* ------------------------------------------------------------------------ */
///* @map[STATIC] IntX String! */
//
//Object* knh_IntX_String(Ctx *ctx, Object *self, Mapper *map)
//{
//	IntX *b = (IntX*)self;
//	char buf[KNH_INTUNIT_BUFSIZ];
//	knh_IntXUnit_format(knh_tclass_getIntXUnit(ctx, knh_Object_cid(b)), buf, b->value);
//	return new_StringX__fast(ctx, CLASS_String, B(buf));
//}

/* ------------------------------------------------------------------------ */

/* ======================================================================== */
/* [movabletext] */

/* ------------------------------------------------------------------------ */
/* @method void IntX.%s(OutputStream w, Any m) */

void knh_IntX__s(Ctx *ctx, Int *b, OutputStream *w, Any *m)
{
	knh_write__i(ctx, w, b->value);
}

/* ------------------------------------------------------------------------ */
/* @method void IntX.%x(OutputStream w, Any m) */

void knh_IntX__x(Ctx *ctx, Int *b, OutputStream *w, Any *m)
{
	knh_write__x(ctx, w, b->value);
}

/* ------------------------------------------------------------------------ */
/* @method void IntX.%bits(OutputStream w, Any m) */

void knh_IntX__bits(Ctx *ctx, Int *b, OutputStream *w, Any *m)
{
	knh_uint_t i, flag = 1 << ((sizeof(knh_int_t) * 8)- 1);
	for(i = 0; i < (sizeof(knh_int_t) * 8); i++) {
		if(i > 0 && i % 8 == 0) {
			knh_putc(ctx, w, ' ');
		}
		if((flag & b->value) == flag) {
			knh_putc(ctx, w, '1');
		}else{
			knh_putc(ctx, w, '0');
		}
		flag >>= 1;
	}
}

/* ------------------------------------------------------------------------ */
/* @method void IntX.%dump(OutputStream w, Any m) */

void knh_IntX__dump(Ctx *ctx, Int *b, OutputStream *w, Any *m)
{
	IntUnit *u = (IntUnit*)knh_tClass[b->h.cid].cspec;
	knh_write__i(ctx, w, b->value);
	{
		knh_bytes_t tag = knh_String_tobytes(DP(u)->spec.tag);
		if(tag.len > 0) {
			knh_putc(ctx, w, '[');
			knh_write(ctx, w, tag);
			knh_putc(ctx, w, ']');
		}
	}
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
