/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#ifndef KONOHAC__H
#define KONOHAC__H

#include<konoha/konoha_config.h>
#include<konoha/konoha_t.h>
#include<konoha/gen/konoha_t_.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

/* ======================================================================== */
/* [prototype] */

/* ../class/konohac/knh_Compiler.c */
void knh_Compiler_struct_init(Ctx *ctx, knh_Compiler *b, int init, Object *cs);
void knh_Compiler_struct_traverse(Ctx *ctx, knh_Compiler *b, f_traverse gc);
Compiler* knh_Context_getCompiler(Ctx *ctx);
void knh_Compiler_setNameSpace(Ctx *ctx, Compiler *cpr, String *nsname);
NameSpace *knh_Compiler_getNameSpace(Ctx *ctx, Compiler *cpr, String *nsname);
Script *knh_Compiler_getScript(Ctx *ctx, Compiler *o);
void knh_Stmt_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns);
void knh_Stmt_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_Stmt_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t t, int level);
void knh_Stmt_names(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_Stmt_cmpls(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_konohac_compile(Ctx *ctx, String *nsname, Stmt *stmt_head, int isrun);
void knh_Compiler_startCompilation(Ctx *ctx, Compiler *cpr, Stmt *stmt);
void knh_Compiler_clear(Ctx *ctx, Compiler *cpr);
void knh_Compiler_stopCompilation(Ctx *ctx, Compiler *cpr);
void knh_Compiler_endCompilation(Ctx *ctx, Compiler *cpr);
void *knh_Compiler_asmmalloc(Ctx *ctx, Compiler *cpr, size_t size);
/* ../class/konohac/knh_konohac.c */
Stmt *knh_konohac_parse(Ctx *ctx, InputStream *in);
void knh_konohac_eval(Ctx *ctx, String *nsname, InputStream *in);
/* ../class/konohac/knh_parser_StmtEXPR.c */
Stmt* new_StmtLETEXPR(Ctx *ctx, knh_tokens_t *tc);
void knh_Stmt_add_EXPR(Ctx *ctx, Stmt *stmt_b, knh_tokens_t *tc);
Token *new_TokenCLASSN(Ctx *ctx, Token *tk, knh_bytes_t name);
Token *new_TokenCONSTN(Ctx *ctx, Token *tk, knh_bytes_t name);
Stmt* new_StmtFUNCEXPR(Ctx *ctx, knh_tokens_t *tc);
Stmt *new_StmtINSTMT(Ctx *ctx, Token *tk);
Term *new_TermPEXPR(Ctx *ctx, Token *tk);
void knh_Stmt_add_PEXPR(Ctx *ctx, Stmt *stmt_b, knh_tokens_t *tc);
Term *new_TermEXPR(Ctx *ctx, knh_tokens_t *tc, int lr);
void knh_Stmt_add_EXPRs(Ctx *ctx, Stmt *stmt_b, knh_tokens_t *tc);
/* ../class/konohac/knh_parser_StmtSTMT.c */
knh_bool_t knh_Token_isVARN(Token *tk);
knh_bool_t knh_Token_isNSNAME(Token *tk);
knh_bool_t knh_Token_isNSCLASSN(Token *tk);
knh_bool_t knh_Token_isCLASSN(Token *tk);
knh_bool_t knh_Token_isMETHODN(Token *tk);
knh_bool_t knh_Token_isCLASSTN(Token *tk);
knh_bool_t knh_Token_isCURN(Token *tk);
knh_bool_t knh_Token_isEXPTN(Token *tk);
knh_bool_t knh_Token_isANY(Token *tk);
void knh_Stmt_add_SEMICOLON(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_ASIS(Ctx *ctx, Stmt *o);
void knh_Stmt_add_STEXT(Ctx *ctx, Stmt *o, knh_tokens_t *tc, knh_bytes_t stext);
void knh_Stmt_add_WITH(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
Stmt *new_StmtUENUM(Ctx *ctx, knh_tokens_t *tc);
Stmt *new_StmtUVOCAB(Ctx *ctx, knh_tokens_t *tc);
Stmt *new_StmtUFUNC(Ctx *ctx, knh_tokens_t *tc);
Stmt *new_StmtUMAPMAP(Ctx *ctx, knh_tokens_t *tc);
Stmt *new_StmtUSING(Ctx *ctx, knh_tokens_t *tc);
void knh_Stmt_add_EXTENDS(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_ANY_(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_ELSE(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_CLASSTNs(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_PSTMT3(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_STMT1(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_CATCH(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_CMETHOD(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_PARAMs(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
Stmt *new_StmtMETHOD(Ctx *ctx, knh_tokens_t *tc);
void knh_Stmt_add_PEACH(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
/* ../class/konohac/knh_parser_Token.c */
	 void knh_Token_parse(Ctx *ctx, Token *tk, InputStream *in);
String *new_String__NAME(Ctx *ctx, knh_bytes_t tname);
Token *new_Token__name(Ctx *ctx, knh_flag_t flag, knh_fileid_t fileid, knh_line_t line, knh_bytes_t t);
knh_token_t knh_char_totoken(int ch);
/* ../class/konohac/knh_perror.c */
void knh_perrata(Ctx *ctx, knh_fileid_t fileid, int line, char *oldt, char *newt);
void knh_Token_perrata(Ctx *ctx, Token *o, char *newtoken);
void knh_perror(Ctx *ctx, knh_fileid_t fileid, int line, int pe, char *msg);
void knh_Token_perror(Ctx *ctx, Token *o, int pe);
void knh_tokens_perror(Ctx *ctx, knh_tokens_t *tc, int pe);
void knh_Stmt_perror(Ctx *ctx, Stmt *b, knh_tokens_t *tc, int pe);
Stmt *new_StmtERR(Ctx *ctx, knh_tokens_t *tc);
void knh_Compiler_perror(Ctx *ctx, Compiler *cpr, int pe, char *msg);
void knh_notice_TypeInf(Ctx *ctx, knh_fileid_t fileid, int line, char *msg, knh_type_t type);
/* ../class/konohac/knh_Stmt.c */
void knh_Stmt_struct_init(Ctx *ctx, knh_Stmt *b, int init, Object *cs);
void knh_Stmt_struct_traverse(Ctx *ctx, knh_Stmt *b, f_traverse gc);
Stmt* new_Stmt(Ctx *ctx, knh_flag_t flag, knh_stmt_t stt);
Stmt* new_StmtDONE(Ctx *ctx);
void knh_Stmt_done(Ctx *ctx, Stmt *o);
void knh_Stmt_add(Ctx *ctx, Stmt *o, Term *tm);
void knh_Stmt_add_ERR(Ctx *ctx, Stmt *o, Token *tk);
Stmt *knh_Stmt_tail(Stmt *o);
void knh_Stmt_tail_append(Ctx *ctx, Stmt *o, Stmt *stmt);
void knh_Stmt__s(Ctx *ctx, Stmt *o, OutputStream *w, Any *m);
void knh_Stmt__dump(Ctx *ctx, Stmt *o, OutputStream *w, Any *m);
/* ../class/konohac/knh_Stmt_const.c */
Term* knh_Stmt_const(Ctx *ctx, Stmt *b, knh_class_t reqc, NameSpace *ns);
/* ../class/konohac/knh_StmtCLASS.c */
void knh_class_addInterface(Ctx *ctx, knh_class_t cid, knh_class_t icid);
void knh_StmtCLASS_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtCLASS_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtCLASS_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
/* ../class/konohac/knh_StmtDEBUG.c */
	 void knh_Stmt_toERR(Ctx *ctx, Stmt *stmt, String *msg);
	 void knh_StmtERR_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
	 void knh_StmtPRINT_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtASSERT_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
/* ../class/konohac/knh_StmtDECLLET.c */
Stmt *new_StmtDONE_type(Ctx *ctx, knh_type_t type);
void knh_Token_setSFPIDX(Token *tk, int idx, knh_type_t type);
void knh_TokenNAME_typing(Ctx *ctx, Token *tk, Compiler *cpr);
void knh_StmtDECL_toLET(Ctx *ctx, Stmt *stmt);
void knh_StmtDECL_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtLET_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtLET_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtLETMULTI_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
knh_fieldn_t knh_tName_getFieldnOnStack(Ctx *ctx, int level);
void knh_StmtFOREACH_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtFOREACH_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
/* ../class/konohac/knh_StmtEXPR.c */
void knh_Stmt_setType(Stmt *stmt, knh_type_t type);
knh_bool_t knh_Term_isTyped(Term *tm);
knh_type_t knh_Term_get_type(Term *tm);
knh_type_t knh_Term_get_cid(Term *tm);
Term *knh_StmtCALL1_typing(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_class_t reqc);
knh_methodn_t knh_Token_tomethodn(Ctx *ctx, Token *o);
Term *knh_StmtOP_typing(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_class_t reqc);
Term *knh_Stmt_typing(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_class_t reqc);
void knh_Stmt_terms_typing(Ctx *ctx, Stmt *stmt, size_t n, Compiler *cpr, NameSpace *ns, knh_class_t reqc);
void KNH_ASM_THROWERR__T(Ctx *ctx, Compiler *cpr, char *text);
void KNH_ASM_THROWERR__S(Ctx *ctx, Compiler *cpr, String *msg);
void knh_Stmt_terms_cmpl_(Ctx *ctx, Stmt *stmt, int n, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level, int push);
void knh_StmtCALL1_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtCALL_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtOP_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtNEW_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtMT_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtMAPCAST_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
/* ../class/konohac/knh_StmtIFLOOP.c */
knh_short_t knh_Compiler_labelId(Ctx *ctx, Compiler *cpr, knh_bytes_t label);
void KNH_ASM_LABEL__b(Ctx *ctx, Compiler *cpr, knh_bytes_t t);
String *knh_Compiler_lstack_label(Ctx *ctx, Compiler *cpr);
void knh_Stmt_cmpl_beforeLABEL(Ctx *ctx, Stmt *stmt, Compiler *cpr, int level);
void knh_Stmt_cmpl_afterLABEL(Ctx *ctx, Stmt *stmt, Compiler *cpr, int level);
void knh_StmtIF_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns,int level);
void knh_StmtIF_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtALT_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtAND_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtOR_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtTRINARY_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtWHILE_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtWHILE_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtDO_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtDO_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtCONTINUE_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtBREAK_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtGOTO_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtFOR_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtFOR_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
/* ../class/konohac/knh_StmtMETA.c */
knh_bool_t knh_Stmt_hasMeta(Stmt *o);
void knh_StmtMETA_add_prestmt(Ctx *ctx, Stmt *o, knh_tokens_t *tc, int start);
void knh_StmtMETA_add(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_StmtMETA_dump(Ctx *ctx, Stmt *o, OutputStream *w, Any *m);
knh_flag_t knh_Stmt_metaflag__class(Ctx *ctx, Stmt *b);
knh_flag_t knh_Stmt_metaflag__method(Ctx *ctx, Stmt *b);
knh_flag_t knh_Stmt_metaflag__field(Ctx *ctx, Stmt *b);
knh_flag_t knh_Stmt_metaflag__new(Ctx *ctx, Stmt *b);
knh_bool_t knh_StmtMETA_istime(Stmt *o);
knh_flag_t knh_StmtMETA_flagPRINT(Ctx *ctx, Stmt *o);
knh_bool_t knh_StmtMETA_isHistoric(Stmt *o);
knh_bool_t knh_StmtMETA_isOverride(Stmt *o);
/* ../class/konohac/knh_StmtMETHOD.c */
void knh_Compiler_initDecl(Ctx *ctx, Compiler *cpr);
void knh_Stmt_run(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns);
void knh_StmtMETHOD_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtMETHOD_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtRETURN_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtFORMAT_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtFORMAT_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
/* ../class/konohac/knh_StmtUSING.c */
void knh_StmtUIMPORT_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtUALIAS_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtUVOCAB_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtUENUM_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtUUNIT_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtUFUNC_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtUMAPMAP_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtUALIAS(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
/* ../class/konohac/knh_Term.c */
knh_type_t knh_Term_type(Term *tm);
Token *knh_Term_firstToken(Term *tm);
int knh_Term_isASIS(Term *tm);
int knh_Term_isCONST(Term *tm);
Object *knh_Term_constValue(Ctx *ctx, Term *tm, knh_class_t reqc);
Object *knh_Term_constValueNULL(Ctx *ctx, Term *tm, knh_class_t reqc);
int knh_Term_isERR(Term *tm);
void knh_Token_setERR(Ctx *ctx, Token *tk, String *msg);
/* ../class/konohac/knh_Token.c */
void knh_Token_struct_init(Ctx *ctx, knh_Token *b, int init, Object *cs);
void knh_Token_struct_traverse(Ctx *ctx, knh_Token *b, f_traverse gc);
Token* new_Token(Ctx *ctx, knh_flag_t flag, knh_fileid_t fileid, knh_line_t line, knh_token_t tt);
Token *new_Token__text(Ctx *ctx, Token *ftk, knh_bytes_t text);
void knh_Token_setFL(Token *o, Any *fln);
Token *new_TokenASIS(Ctx *ctx, Any *fln);
Token *new_TokenCID(Ctx *ctx, Any *fln, knh_class_t cid);
Token *new_TokenMN(Ctx *ctx, Any *fln, knh_methodn_t mn);
Token *new_TokenFN(Ctx *ctx, Any *fln, knh_fieldn_t fn);
Token *new_Token__S(Ctx *ctx, Token *ftk, knh_token_t tt, String *t);
void knh_Token_tc(Token *o, knh_tokens_t *tc);
void knh_Token_tokens_add(Ctx *ctx, Token *o, Token *tk);
void knh_Token_tokens_empty(Ctx *ctx, Token *o);
char *knh_Token_tochar(Token *o);
knh_bytes_t knh_Token_tobytes(Token *o);
void knh_Token__s(Ctx *ctx, Token *o, OutputStream *w, Any *m);
void knh_Token__dump(Ctx *ctx, Token *o, OutputStream *w, Any *m);
/* ../class/konohac/knh_Token_const.c */
Token* new_TokenCONST(Ctx *ctx, Any *fln, Any *data);
void knh_Token_setCONST(Ctx *ctx, Token *o, Any *data);
void knh_Token_toCONST(Token *o);
knh_type_t knh_Token_totype(Ctx *ctx, Token *o, knh_class_t defc, NameSpace *ns);
knh_class_t knh_Token_toclass(Ctx *ctx, Token *o, knh_class_t defc, NameSpace *ns);
int knh_Token_isLCONSTN(Token *tk);
void knh_Token_setLCONST(Ctx *ctx, Token *tk, NameSpace *ns);
knh_bool_t knh_Token_isSystemVariable(Token *tk);
void knh_Token_constSystemVariable(Ctx *ctx, Token *tk, Compiler *cpr);
Token *knh_Token_const(Ctx *ctx, Token *o, knh_class_t reqc, NameSpace *ns);
/* ../class/konohac/knh_tokens_t.c */
Token* knh_tokens_curToken(knh_tokens_t *tc);
Token* knh_tokens_prevToken(knh_tokens_t *tc);
	 int knh_tokens_count(knh_tokens_t *tc, knh_token_t tt);
	 void knh_tokens_nextStmt(knh_tokens_t *tc);
	 void knh_tokens_stepFirstStmt(Ctx *ctx, knh_tokens_t *tc, knh_tokens_t *sub, int needsSEMICOLON);
void knh_tokens_ignore(Ctx *ctx, knh_tokens_t *tc);
	 void knh_tokens_stepFirstEXPR(Ctx *ctx, knh_tokens_t *tc, knh_token_t tt, knh_tokens_t *sub);
	 void knh_tokens_stepFirstEMPTYEXPR(Ctx *ctx, knh_tokens_t *tc, knh_token_t tt, knh_tokens_t *sub);
	 void knh_tokens_stepFirstComma(Ctx *ctx, knh_tokens_t *tc, knh_tokens_t *sub);
String *knh_tokens_toString(Ctx *ctx, knh_tokens_t *tc);
/* ../class/konohac/knh_VirtualMachineCode.c */
void knh_VirtualMachineCode_struct_init(Ctx *ctx, knh_VirtualMachineCode *b, int init, Object *cs);
void knh_VirtualMachineCode_struct_copy(Ctx *ctx, knh_VirtualMachineCode *b, knh_VirtualMachineCode *b2);
void knh_VirtualMachineCode_struct_traverse(Ctx *ctx, knh_VirtualMachineCode *b, f_traverse gc);
VirtualMachineCode* new_VirtualMachineCode(Ctx *ctx, knh_fileid_t fileid, knh_bytes_t elf, knh_bytes_t dwarf);
void knh_Method_setVirtualMachineCode(Ctx *ctx, Method *mtd, VirtualMachineCode *code);
knh_bytes_t knh_VirtualMachineCode_tobytes(VirtualMachineCode *o);
/* ======================================================================== */

#ifdef __cplusplus
}
#endif

/* ======================================================================== */

#endif/*KONOHAC__H*/
