/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#include<konoha/konoha_dev.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

/* ======================================================================== */
/* [prototype] */

void knh_konoha_initapis(Ctx *ctx);
void knh_konohac_initapis(Ctx *ctx);
void knh_naruto_initapis(Ctx *ctx);
/* ======================================================================== */
/* [init] */


void knh_tString_init0(void)
{
	DEBUG_ASSERT(knh_tString != NULL);

	KNH_INITv(knh_tString[TSN_EMPTY], new_String__T(NULL, ""));
	KNH_INITv(knh_tString[TSN_TAB], new_String__T(NULL, "\t"));
	KNH_INITv(knh_tString[TSN_LF], new_String__T(NULL, "\n"));
	KNH_INITv(knh_tString[TSN_SPC], new_String__T(NULL, " "));
	KNH_INITv(knh_tString[TSN_EOL], new_String__T(NULL, "EOL"));
	KNH_INITv(knh_tString[TSN_BEGIN], new_String__T(NULL, "BEGIN"));
	KNH_INITv(knh_tString[TSN_END], new_String__T(NULL, "END"));
	KNH_INITv(knh_tString[TSN_void], new_String__T(NULL, "void"));
	KNH_INITv(knh_tString[TSN_true], new_String__T(NULL, "true"));
	KNH_INITv(knh_tString[TSN_false], new_String__T(NULL, "false"));
	KNH_INITv(knh_tString[TSN_null], new_String__T(NULL, "null"));
	KNH_INITv(knh_tString[TSN_main], new_String__T(NULL, "main"));
	KNH_INITv(knh_tString[TSN_ENCODING], new_String__T(NULL, ""KONOHA_ENCODING""));
	KNH_INITv(knh_tString[TSN_DEVNULL], new_String__T(NULL, "/dev/null"));
	KNH_INITv(knh_tString[TSN_DEVSTDIN], new_String__T(NULL, "/dev/stdin"));
	KNH_INITv(knh_tString[TSN_DEVSTDERR], new_String__T(NULL, "/dev/stderr"));
	KNH_INITv(knh_tString[TSN_DEVSTDOUT], new_String__T(NULL, "/dev/stdout"));
	KNH_INITv(knh_tString[TSN_ATlabel], new_String__T(NULL, "@label"));
	KNH_INITv(knh_tString[TSN_TYPEERR], new_String__T(NULL, "Type!!"));
	KNH_INITv(knh_tString[TSN_NULLERR], new_String__T(NULL, "Null!!"));
	KNH_INITv(knh_tString[TSN_SYNTAXERR], new_String__T(NULL, "Syntax!!"));
}
static INLINE
knh_struct_t
KNH_TSTRUCT_Object(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(Object*),
	int (*fcompareTo)(Object*, Object*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Any(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(Any*),
	int (*fcompareTo)(Any*, Any*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_This(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(This*),
	int (*fcompareTo)(This*, This*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Any1(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(Any1*),
	int (*fcompareTo)(Any1*, Any1*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Any2(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(Any2*),
	int (*fcompareTo)(Any2*, Any2*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Nue(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(Nue*),
	int (*fcompareTo)(Nue*, Nue*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Boolean(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(Boolean*),
	int (*fcompareTo)(Boolean*, Boolean*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Number(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(Number*),
	int (*fcompareTo)(Number*, Number*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Int(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(Int*),
	int (*fcompareTo)(Int*, Int*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_IntX(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(IntX*),
	int (*fcompareTo)(IntX*, IntX*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Int64(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(Int64*),
	int (*fcompareTo)(Int64*, Int64*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Int64X(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(Int64X*),
	int (*fcompareTo)(Int64X*, Int64X*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Float(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(Float*),
	int (*fcompareTo)(Float*, Float*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_FloatX(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(FloatX*),
	int (*fcompareTo)(FloatX*, FloatX*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_String(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(String*),
	int (*fcompareTo)(String*, String*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_StringX(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(StringX*),
	int (*fcompareTo)(StringX*, StringX*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Bytes(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(Bytes*),
	int (*fcompareTo)(Bytes*, Bytes*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Tuple2(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(Tuple2*),
	int (*fcompareTo)(Tuple2*, Tuple2*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Range(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(Range*),
	int (*fcompareTo)(Range*, Range*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Array(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(Array*),
	int (*fcompareTo)(Array*, Array*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_DictMap2(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(DictMap2*),
	int (*fcompareTo)(DictMap2*, DictMap2*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_DictSet2(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(DictSet2*),
	int (*fcompareTo)(DictSet2*, DictSet2*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_DictMap(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_DictMap*, int, Object*),
	void (*fcopy)(Ctx*, knh_DictMap*, knh_DictMap*),
	void (*fgc)(Ctx*, knh_DictMap*, f_traverse),
	knh_hcode_t (*fhashCode)(DictMap*),
	int (*fcompareTo)(DictMap*, DictMap*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_DictSet(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_DictSet*, int, Object*),
	void (*fcopy)(Ctx*, knh_DictSet*, knh_DictSet*),
	void (*fgc)(Ctx*, knh_DictSet*, f_traverse),
	knh_hcode_t (*fhashCode)(DictSet*),
	int (*fcompareTo)(DictSet*, DictSet*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_HashMap(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_HashMap*, int, Object*),
	void (*fcopy)(Ctx*, knh_HashMap*, knh_HashMap*),
	void (*fgc)(Ctx*, knh_HashMap*, f_traverse),
	knh_hcode_t (*fhashCode)(HashMap*),
	int (*fcompareTo)(HashMap*, HashMap*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_HashSet(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_HashSet*, int, Object*),
	void (*fcopy)(Ctx*, knh_HashSet*, knh_HashSet*),
	void (*fgc)(Ctx*, knh_HashSet*, f_traverse),
	knh_hcode_t (*fhashCode)(HashSet*),
	int (*fcompareTo)(HashSet*, HashSet*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Iterator(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_Iterator*, int, Object*),
	void (*fcopy)(Ctx*, knh_Iterator*, knh_Iterator*),
	void (*fgc)(Ctx*, knh_Iterator*, f_traverse),
	knh_hcode_t (*fhashCode)(Iterator*),
	int (*fcompareTo)(Iterator*, Iterator*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_DictIdx(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_DictIdx*, int, Object*),
	void (*fcopy)(Ctx*, knh_DictIdx*, knh_DictIdx*),
	void (*fgc)(Ctx*, knh_DictIdx*, f_traverse),
	knh_hcode_t (*fhashCode)(DictIdx*),
	int (*fcompareTo)(DictIdx*, DictIdx*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Class(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(Class*),
	int (*fcompareTo)(Class*, Class*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_ClassStruct(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_ClassStruct*, int, Object*),
	void (*fcopy)(Ctx*, knh_ClassStruct*, knh_ClassStruct*),
	void (*fgc)(Ctx*, knh_ClassStruct*, f_traverse),
	knh_hcode_t (*fhashCode)(ClassStruct*),
	int (*fcompareTo)(ClassStruct*, ClassStruct*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_MethodField(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_MethodField*, int, Object*),
	void (*fcopy)(Ctx*, knh_MethodField*, knh_MethodField*),
	void (*fgc)(Ctx*, knh_MethodField*, f_traverse),
	knh_hcode_t (*fhashCode)(MethodField*),
	int (*fcompareTo)(MethodField*, MethodField*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Method(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_Method*, int, Object*),
	void (*fcopy)(Ctx*, knh_Method*, knh_Method*),
	void (*fgc)(Ctx*, knh_Method*, f_traverse),
	knh_hcode_t (*fhashCode)(Method*),
	int (*fcompareTo)(Method*, Method*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Mapper(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_Mapper*, int, Object*),
	void (*fcopy)(Ctx*, knh_Mapper*, knh_Mapper*),
	void (*fgc)(Ctx*, knh_Mapper*, f_traverse),
	knh_hcode_t (*fhashCode)(Mapper*),
	int (*fcompareTo)(Mapper*, Mapper*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_ClassMap(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_ClassMap*, int, Object*),
	void (*fcopy)(Ctx*, knh_ClassMap*, knh_ClassMap*),
	void (*fgc)(Ctx*, knh_ClassMap*, f_traverse),
	knh_hcode_t (*fhashCode)(ClassMap*),
	int (*fcompareTo)(ClassMap*, ClassMap*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_AffineConv(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_AffineConv*, int, Object*),
	void (*fcopy)(Ctx*, knh_AffineConv*, knh_AffineConv*),
	void (*fgc)(Ctx*, knh_AffineConv*, f_traverse),
	knh_hcode_t (*fhashCode)(AffineConv*),
	int (*fcompareTo)(AffineConv*, AffineConv*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_IntUnit(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_IntUnit*, int, Object*),
	void (*fcopy)(Ctx*, knh_IntUnit*, knh_IntUnit*),
	void (*fgc)(Ctx*, knh_IntUnit*, f_traverse),
	knh_hcode_t (*fhashCode)(IntUnit*),
	int (*fcompareTo)(IntUnit*, IntUnit*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_FloatUnit(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_FloatUnit*, int, Object*),
	void (*fcopy)(Ctx*, knh_FloatUnit*, knh_FloatUnit*),
	void (*fgc)(Ctx*, knh_FloatUnit*, f_traverse),
	knh_hcode_t (*fhashCode)(FloatUnit*),
	int (*fcompareTo)(FloatUnit*, FloatUnit*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_BytesConv(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_BytesConv*, int, Object*),
	void (*fcopy)(Ctx*, knh_BytesConv*, knh_BytesConv*),
	void (*fgc)(Ctx*, knh_BytesConv*, f_traverse),
	knh_hcode_t (*fhashCode)(BytesConv*),
	int (*fcompareTo)(BytesConv*, BytesConv*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_StringUnit(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_StringUnit*, int, Object*),
	void (*fcopy)(Ctx*, knh_StringUnit*, knh_StringUnit*),
	void (*fgc)(Ctx*, knh_StringUnit*, f_traverse),
	knh_hcode_t (*fhashCode)(StringUnit*),
	int (*fcompareTo)(StringUnit*, StringUnit*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_InputStream(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_InputStream*, int, Object*),
	void (*fcopy)(Ctx*, knh_InputStream*, knh_InputStream*),
	void (*fgc)(Ctx*, knh_InputStream*, f_traverse),
	knh_hcode_t (*fhashCode)(InputStream*),
	int (*fcompareTo)(InputStream*, InputStream*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_OutputStream(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_OutputStream*, int, Object*),
	void (*fcopy)(Ctx*, knh_OutputStream*, knh_OutputStream*),
	void (*fgc)(Ctx*, knh_OutputStream*, f_traverse),
	knh_hcode_t (*fhashCode)(OutputStream*),
	int (*fcompareTo)(OutputStream*, OutputStream*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_ResultSet(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_ResultSet*, int, Object*),
	void (*fcopy)(Ctx*, knh_ResultSet*, knh_ResultSet*),
	void (*fgc)(Ctx*, knh_ResultSet*, f_traverse),
	knh_hcode_t (*fhashCode)(ResultSet*),
	int (*fcompareTo)(ResultSet*, ResultSet*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Connection(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_Connection*, int, Object*),
	void (*fcopy)(Ctx*, knh_Connection*, knh_Connection*),
	void (*fgc)(Ctx*, knh_Connection*, f_traverse),
	knh_hcode_t (*fhashCode)(Connection*),
	int (*fcompareTo)(Connection*, Connection*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Exception(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_Exception*, int, Object*),
	void (*fcopy)(Ctx*, knh_Exception*, knh_Exception*),
	void (*fgc)(Ctx*, knh_Exception*, f_traverse),
	knh_hcode_t (*fhashCode)(Exception*),
	int (*fcompareTo)(Exception*, Exception*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_ExceptionHandler(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_ExceptionHandler*, int, Object*),
	void (*fcopy)(Ctx*, knh_ExceptionHandler*, knh_ExceptionHandler*),
	void (*fgc)(Ctx*, knh_ExceptionHandler*, f_traverse),
	knh_hcode_t (*fhashCode)(ExceptionHandler*),
	int (*fcompareTo)(ExceptionHandler*, ExceptionHandler*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Script(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(Script*),
	int (*fcompareTo)(Script*, Script*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Runtime(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_Runtime*, int, Object*),
	void (*fcopy)(Ctx*, knh_Runtime*, knh_Runtime*),
	void (*fgc)(Ctx*, knh_Runtime*, f_traverse),
	knh_hcode_t (*fhashCode)(Runtime*),
	int (*fcompareTo)(Runtime*, Runtime*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Context(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void *finit, void *fcopy, void *fgc,
	knh_hcode_t (*fhashCode)(Context*),
	int (*fcompareTo)(Context*, Context*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, finit, fcopy, fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Token(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_Token*, int, Object*),
	void (*fcopy)(Ctx*, knh_Token*, knh_Token*),
	void (*fgc)(Ctx*, knh_Token*, f_traverse),
	knh_hcode_t (*fhashCode)(Token*),
	int (*fcompareTo)(Token*, Token*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Stmt(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_Stmt*, int, Object*),
	void (*fcopy)(Ctx*, knh_Stmt*, knh_Stmt*),
	void (*fgc)(Ctx*, knh_Stmt*, f_traverse),
	knh_hcode_t (*fhashCode)(Stmt*),
	int (*fcompareTo)(Stmt*, Stmt*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Compiler(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_Compiler*, int, Object*),
	void (*fcopy)(Ctx*, knh_Compiler*, knh_Compiler*),
	void (*fgc)(Ctx*, knh_Compiler*, f_traverse),
	knh_hcode_t (*fhashCode)(Compiler*),
	int (*fcompareTo)(Compiler*, Compiler*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_VirtualMachineCode(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_VirtualMachineCode*, int, Object*),
	void (*fcopy)(Ctx*, knh_VirtualMachineCode*, knh_VirtualMachineCode*),
	void (*fgc)(Ctx*, knh_VirtualMachineCode*, f_traverse),
	knh_hcode_t (*fhashCode)(VirtualMachineCode*),
	int (*fcompareTo)(VirtualMachineCode*, VirtualMachineCode*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Counter(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_Counter*, int, Object*),
	void (*fcopy)(Ctx*, knh_Counter*, knh_Counter*),
	void (*fgc)(Ctx*, knh_Counter*, f_traverse),
	knh_hcode_t (*fhashCode)(Counter*),
	int (*fcompareTo)(Counter*, Counter*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Amazon(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_Amazon*, int, Object*),
	void (*fcopy)(Ctx*, knh_Amazon*, knh_Amazon*),
	void (*fgc)(Ctx*, knh_Amazon*, f_traverse),
	knh_hcode_t (*fhashCode)(Amazon*),
	int (*fcompareTo)(Amazon*, Amazon*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

void konoha_class_init0(Ctx *ctx)
{
/* ------------------------------------------------------------------------ */
/* konoha */

	KNH_TSTRUCT_Object(ctx, STRUCT_Object, 0, "Object", NULL, NULL, NULL, knh_Object_hashCode, knh_Object_compareTo); 
	KNH_TSTRUCT_Any(ctx, STRUCT_Any, 0, "Any", NULL, NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT_This(ctx, STRUCT_This, 0, "This", NULL, NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT_Any1(ctx, STRUCT_Any1, 0, "Any1", NULL, NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT_Any2(ctx, STRUCT_Any2, 0, "Any2", NULL, NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT_Nue(ctx, STRUCT_Nue, 0, "Nue", NULL, NULL, NULL, NULL, knh_Nue_compareTo); 
	KNH_TSTRUCT_Boolean(ctx, STRUCT_Boolean, 0, "Boolean", NULL, NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT_Number(ctx, STRUCT_Number, 0, "Number", NULL, NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT_Int(ctx, STRUCT_Int, 0, "Int", NULL, NULL, NULL, knh_Int_hashCode, knh_Int_compareTo); 
	KNH_TSTRUCT_IntX(ctx, STRUCT_IntX, 0, "IntX", NULL, NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT_Int64(ctx, STRUCT_Int64, 0, "Int64", NULL, NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT_Int64X(ctx, STRUCT_Int64X, 0, "Int64X", NULL, NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT_Float(ctx, STRUCT_Float, 0, "Float", NULL, NULL, NULL, NULL, knh_Float_compareTo); 
	KNH_TSTRUCT_FloatX(ctx, STRUCT_FloatX, 0, "FloatX", NULL, NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT_String(ctx, STRUCT_String, 0, "String", NULL, NULL, NULL, knh_String_hashCode, knh_String_compareTo); 
	KNH_TSTRUCT_StringX(ctx, STRUCT_StringX, 0, "StringX", NULL, NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT_Bytes(ctx, STRUCT_Bytes, 0, "Bytes", NULL, NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT_Tuple2(ctx, STRUCT_Tuple2, 0, "Tuple2", NULL, NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT_Range(ctx, STRUCT_Range, 0, "Range", NULL, NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT_Array(ctx, STRUCT_Array, 0, "Array", NULL, NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT_DictMap2(ctx, STRUCT_DictMap2, 0, "DictMap2", NULL, NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT_DictSet2(ctx, STRUCT_DictSet2, 0, "DictSet2", NULL, NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT_DictMap(ctx, STRUCT_DictMap, sizeof(knh_DictMap),
		"DictMap",
		knh_DictMap_struct_init,
		knh_DictMap_struct_copy, 
//		knh_DictMap_struct_compare, 
		knh_DictMap_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_DictSet(ctx, STRUCT_DictSet, sizeof(knh_DictSet),
		"DictSet",
		knh_DictSet_struct_init,
		knh_DictSet_struct_copy, 
//		knh_DictSet_struct_compare, 
		knh_DictSet_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_HashMap(ctx, STRUCT_HashMap, sizeof(knh_HashMap),
		"HashMap",
		knh_HashMap_struct_init,
		knh_HashMap_struct_copy, 
//		knh_HashMap_struct_compare, 
		knh_HashMap_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_HashSet(ctx, STRUCT_HashSet, sizeof(knh_HashSet),
		"HashSet",
		knh_HashSet_struct_init,
		knh_HashSet_struct_copy, 
//		knh_HashSet_struct_compare, 
		knh_HashSet_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_Iterator(ctx, STRUCT_Iterator, sizeof(knh_Iterator),
		"Iterator",
		knh_Iterator_struct_init,
		knh_Iterator_struct_copy, 
//		knh_Iterator_struct_compare, 
		knh_Iterator_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_DictIdx(ctx, STRUCT_DictIdx, sizeof(knh_DictIdx),
		"DictIdx",
		knh_DictIdx_struct_init,
		knh_DictIdx_struct_copy, 
//		knh_DictIdx_struct_compare, 
		knh_DictIdx_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_Class(ctx, STRUCT_Class, 0, "Class", NULL, NULL, NULL, knh_Class_hashCode, knh_Class_compareTo); 
	KNH_TSTRUCT_ClassStruct(ctx, STRUCT_ClassStruct, sizeof(knh_ClassStruct),
		"ClassStruct",
		knh_ClassStruct_struct_init,
		knh_ClassStruct_struct_copy, 
//		knh_ClassStruct_struct_compare, 
		knh_ClassStruct_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_MethodField(ctx, STRUCT_MethodField, sizeof(knh_MethodField),
		"MethodField",
		knh_MethodField_struct_init,
		knh_MethodField_struct_copy, 
//		knh_MethodField_struct_compare, 
		knh_MethodField_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_Method(ctx, STRUCT_Method, sizeof(knh_Method),
		"Method",
		knh_Method_struct_init,
		knh_Method_struct_copy, 
//		knh_Method_struct_compare, 
		knh_Method_struct_traverse,
		knh_Method_hashCode,
		knh_Method_compareTo);
	KNH_TSTRUCT_Mapper(ctx, STRUCT_Mapper, sizeof(knh_Mapper),
		"Mapper",
		knh_Mapper_struct_init,
		knh_Mapper_struct_copy, 
//		knh_Mapper_struct_compare, 
		knh_Mapper_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_ClassMap(ctx, STRUCT_ClassMap, sizeof(knh_ClassMap),
		"ClassMap",
		knh_ClassMap_struct_init,
		knh_ClassMap_struct_copy, 
//		knh_ClassMap_struct_compare, 
		knh_ClassMap_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_AffineConv(ctx, STRUCT_AffineConv, sizeof(knh_AffineConv),
		"AffineConv",
		knh_AffineConv_struct_init,
		knh_AffineConv_struct_copy, 
//		knh_AffineConv_struct_compare, 
		knh_AffineConv_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_IntUnit(ctx, STRUCT_IntUnit, sizeof(knh_IntUnit),
		"IntUnit",
		knh_IntUnit_struct_init,
		knh_IntUnit_struct_copy, 
//		knh_IntUnit_struct_compare, 
		knh_IntUnit_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_FloatUnit(ctx, STRUCT_FloatUnit, sizeof(knh_FloatUnit),
		"FloatUnit",
		knh_FloatUnit_struct_init,
		knh_FloatUnit_struct_copy, 
//		knh_FloatUnit_struct_compare, 
		knh_FloatUnit_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_BytesConv(ctx, STRUCT_BytesConv, sizeof(knh_BytesConv),
		"BytesConv",
		knh_BytesConv_struct_init,
		knh_BytesConv_struct_copy, 
//		knh_BytesConv_struct_compare, 
		knh_BytesConv_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_StringUnit(ctx, STRUCT_StringUnit, sizeof(knh_StringUnit),
		"StringUnit",
		knh_StringUnit_struct_init,
		knh_StringUnit_struct_copy, 
//		knh_StringUnit_struct_compare, 
		knh_StringUnit_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_InputStream(ctx, STRUCT_InputStream, sizeof(knh_InputStream),
		"InputStream",
		knh_InputStream_struct_init,
		knh_InputStream_struct_copy, 
//		knh_InputStream_struct_compare, 
		knh_InputStream_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_OutputStream(ctx, STRUCT_OutputStream, sizeof(knh_OutputStream),
		"OutputStream",
		knh_OutputStream_struct_init,
		knh_OutputStream_struct_copy, 
//		knh_OutputStream_struct_compare, 
		knh_OutputStream_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_ResultSet(ctx, STRUCT_ResultSet, sizeof(knh_ResultSet),
		"ResultSet",
		knh_ResultSet_struct_init,
		knh_ResultSet_struct_copy, 
//		knh_ResultSet_struct_compare, 
		knh_ResultSet_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_Connection(ctx, STRUCT_Connection, sizeof(knh_Connection),
		"Connection",
		knh_Connection_struct_init,
		knh_Connection_struct_copy, 
//		knh_Connection_struct_compare, 
		knh_Connection_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_Exception(ctx, STRUCT_Exception, sizeof(knh_Exception),
		"Exception",
		knh_Exception_struct_init,
		knh_Exception_struct_copy, 
//		knh_Exception_struct_compare, 
		knh_Exception_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_ExceptionHandler(ctx, STRUCT_ExceptionHandler, sizeof(knh_ExceptionHandler),
		"ExceptionHandler",
		knh_ExceptionHandler_struct_init,
		knh_ExceptionHandler_struct_copy, 
//		knh_ExceptionHandler_struct_compare, 
		knh_ExceptionHandler_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_Script(ctx, STRUCT_Script, 0, "Script", NULL, NULL, NULL, NULL, NULL); 
	KNH_TSTRUCT_Runtime(ctx, STRUCT_Runtime, sizeof(knh_Runtime),
		"Runtime",
		knh_Runtime_struct_init,
		knh_Runtime_struct_copy, 
//		knh_Runtime_struct_compare, 
		knh_Runtime_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_Context(ctx, STRUCT_Context, 0, "Context", NULL, NULL, NULL, NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Object, "konoha.Object",
		CLASS_Object, STRUCT_Object, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Any, "konoha.Any",
		CLASS_Any, STRUCT_Any, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_This, "konoha.This",
		CLASS_This, STRUCT_This, CLASS_Any,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Any1, "konoha.Any1",
		CLASS_Any1, STRUCT_Any1, CLASS_Any,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Any2, "konoha.Any2",
		CLASS_Any2, STRUCT_Any2, CLASS_Any,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Nue, "konoha.Nue",
		CLASS_Nue, STRUCT_Nue, CLASS_Object,
		KNH_NULL, knh_Nue_fdefault); 
	KNH_TCLASS__T(ctx, CFLAG_Boolean, "konoha.Boolean",
		CLASS_Boolean, STRUCT_Boolean, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Number, "konoha.Number",
		CLASS_Number, STRUCT_Number, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Int, "konoha.Int",
		CLASS_Int, STRUCT_Int, CLASS_Number,
		knh_Int_cspec(ctx), knh_Int_fdefault); 
	KNH_TCLASS__T(ctx, CFLAG_IntX, "konoha.IntX",
		CLASS_IntX, STRUCT_IntX, CLASS_Number,
		KNH_NULL, knh_IntX_fdefault); 
	KNH_TCLASS__T(ctx, CFLAG_Int64, "konoha.Int64",
		CLASS_Int64, STRUCT_Int64, CLASS_Number,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Int64X, "konoha.Int64X",
		CLASS_Int64X, STRUCT_Int64X, CLASS_Number,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Float, "konoha.Float",
		CLASS_Float, STRUCT_Float, CLASS_Number,
		knh_Float_cspec(ctx), knh_Float_fdefault); 
	KNH_TCLASS__T(ctx, CFLAG_FloatX, "konoha.FloatX",
		CLASS_FloatX, STRUCT_FloatX, CLASS_Number,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_String, "konoha.String",
		CLASS_String, STRUCT_String, CLASS_Object,
		knh_String_cspec(ctx), knh_String_fdefault); 
	KNH_TCLASS__T(ctx, CFLAG_StringX, "konoha.StringX",
		CLASS_StringX, STRUCT_StringX, CLASS_String,
		KNH_NULL, knh_StringX_fdefault); 
	KNH_TCLASS__T(ctx, CFLAG_Bytes, "konoha.Bytes",
		CLASS_Bytes, STRUCT_Bytes, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Tuple2, "konoha.Tuple2",
		CLASS_Tuple2, STRUCT_Tuple2, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Range, "konoha.Range",
		CLASS_Range, STRUCT_Range, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Array, "konoha.Array",
		CLASS_Array, STRUCT_Array, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS_PARAM(ctx, CLASS_Array, CLASS_Any, CLASS_Nue);
	KNH_TCLASS__T(ctx, CFLAG_DictMap2, "konoha.DictMap2",
		CLASS_DictMap2, STRUCT_DictMap2, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_DictSet2, "konoha.DictSet2",
		CLASS_DictSet2, STRUCT_DictSet2, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_DictMap, "konoha.DictMap",
		CLASS_DictMap, STRUCT_DictMap, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS_PARAM(ctx, CLASS_DictMap, CLASS_Any, CLASS_Any);
	KNH_TCLASS__T(ctx, CFLAG_DictSet, "konoha.DictSet",
		CLASS_DictSet, STRUCT_DictSet, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS_PARAM(ctx, CLASS_DictSet, CLASS_Any, CLASS_Nue);
	KNH_TCLASS__T(ctx, CFLAG_HashMap, "konoha.HashMap",
		CLASS_HashMap, STRUCT_HashMap, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS_PARAM(ctx, CLASS_HashMap, CLASS_Any, CLASS_Any);
	KNH_TCLASS__T(ctx, CFLAG_HashSet, "konoha.HashSet",
		CLASS_HashSet, STRUCT_HashSet, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS_PARAM(ctx, CLASS_HashSet, CLASS_Any, CLASS_Nue);
	KNH_TCLASS__T(ctx, CFLAG_Iterator, "konoha.Iterator",
		CLASS_Iterator, STRUCT_Iterator, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS_PARAM(ctx, CLASS_Iterator, CLASS_Any, CLASS_Nue);
	KNH_TCLASS__T(ctx, CFLAG_DictIdx, "konoha.DictIdx",
		CLASS_DictIdx, STRUCT_DictIdx, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Class, "konoha.Class",
		CLASS_Class, STRUCT_Class, CLASS_Object,
		KNH_NULL, knh_Class_fdefault); 
	KNH_TCLASS__T(ctx, CFLAG_ClassStruct, "konoha.ClassStruct",
		CLASS_ClassStruct, STRUCT_ClassStruct, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_MethodField, "konoha.MethodField",
		CLASS_MethodField, STRUCT_MethodField, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Method, "konoha.Method",
		CLASS_Method, STRUCT_Method, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Mapper, "konoha.Mapper",
		CLASS_Mapper, STRUCT_Mapper, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_ClassMap, "konoha.ClassMap",
		CLASS_ClassMap, STRUCT_ClassMap, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_AffineConv, "konoha.AffineConv",
		CLASS_AffineConv, STRUCT_AffineConv, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_IntUnit, "konoha.IntUnit",
		CLASS_IntUnit, STRUCT_IntUnit, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_FloatUnit, "konoha.FloatUnit",
		CLASS_FloatUnit, STRUCT_FloatUnit, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_BytesConv, "konoha.BytesConv",
		CLASS_BytesConv, STRUCT_BytesConv, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_StringUnit, "konoha.StringUnit",
		CLASS_StringUnit, STRUCT_StringUnit, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_InputStream, "konoha.InputStream",
		CLASS_InputStream, STRUCT_InputStream, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_OutputStream, "konoha.OutputStream",
		CLASS_OutputStream, STRUCT_OutputStream, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_ResultSet, "konoha.ResultSet",
		CLASS_ResultSet, STRUCT_ResultSet, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Connection, "konoha.Connection",
		CLASS_Connection, STRUCT_Connection, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Exception, "konoha.Exception",
		CLASS_Exception, STRUCT_Exception, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_ExceptionHandler, "konoha.ExceptionHandler",
		CLASS_ExceptionHandler, STRUCT_ExceptionHandler, CLASS_Object,
		KNH_NULL, knh_ExceptionHandler_fdefault); 
	KNH_TCLASS__T(ctx, CFLAG_Script, "konoha.Script",
		CLASS_Script, STRUCT_Script, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_NameSpace, "konoha.NameSpace",
		CLASS_NameSpace, STRUCT_NameSpace, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_System, "konoha.System",
		CLASS_System, STRUCT_System, CLASS_Object,
		KNH_NULL, knh_System_fdefault); 
	KNH_TCLASS__T(ctx, CFLAG_Runtime, "konoha.Runtime",
		CLASS_Runtime, STRUCT_Runtime, CLASS_Object,
		KNH_NULL, knh_Runtime_fdefault); 
	KNH_TCLASS__T(ctx, CFLAG_Context, "konoha.Context",
		CLASS_Context, STRUCT_Context, CLASS_Object,
		KNH_NULL, knh_Context_fdefault); 
/* ------------------------------------------------------------------------ */
/* konohac */

	KNH_TSTRUCT_Token(ctx, STRUCT_Token, sizeof(knh_Token),
		"Token",
		knh_Token_struct_init,
		knh_Token_struct_copy, 
//		knh_Token_struct_compare, 
		knh_Token_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_Stmt(ctx, STRUCT_Stmt, sizeof(knh_Stmt),
		"Stmt",
		knh_Stmt_struct_init,
		knh_Stmt_struct_copy, 
//		knh_Stmt_struct_compare, 
		knh_Stmt_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_Compiler(ctx, STRUCT_Compiler, sizeof(knh_Compiler),
		"Compiler",
		knh_Compiler_struct_init,
		knh_Compiler_struct_copy, 
//		knh_Compiler_struct_compare, 
		knh_Compiler_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_VirtualMachineCode(ctx, STRUCT_VirtualMachineCode, sizeof(knh_VirtualMachineCode),
		"VirtualMachineCode",
		knh_VirtualMachineCode_struct_init,
		knh_VirtualMachineCode_struct_copy, 
//		knh_VirtualMachineCode_struct_compare, 
		knh_VirtualMachineCode_struct_traverse,
		NULL,
		NULL);
	KNH_TCLASS__T(ctx, CFLAG_Token, "konohac.Token",
		CLASS_Token, STRUCT_Token, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Stmt, "konohac.Stmt",
		CLASS_Stmt, STRUCT_Stmt, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Compiler, "konohac.Compiler",
		CLASS_Compiler, STRUCT_Compiler, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_VirtualMachineCode, "konohac.VirtualMachineCode",
		CLASS_VirtualMachineCode, STRUCT_VirtualMachineCode, CLASS_Object,
		KNH_NULL, NULL); 
/* ------------------------------------------------------------------------ */
/* naruto */

	KNH_TSTRUCT_Counter(ctx, STRUCT_Counter, sizeof(knh_Counter),
		"Counter",
		knh_Counter_struct_init,
		knh_Counter_struct_copy, 
//		knh_Counter_struct_compare, 
		knh_Counter_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_Amazon(ctx, STRUCT_Amazon, sizeof(knh_Amazon),
		"Amazon",
		knh_Amazon_struct_init,
		knh_Amazon_struct_copy, 
//		knh_Amazon_struct_compare, 
		knh_Amazon_struct_traverse,
		NULL,
		NULL);
	KNH_TCLASS__T(ctx, CFLAG_Counter, "naruto.Counter",
		CLASS_Counter, STRUCT_Counter, CLASS_Object,
		KNH_NULL, NULL); 
	KNH_TCLASS__T(ctx, CFLAG_Amazon, "naruto.Amazon",
		CLASS_Amazon, STRUCT_Amazon, CLASS_Object,
		KNH_NULL, NULL); 
/* ------------------------------------------------------------------------ */
/* +math */

/* ------------------------------------------------------------------------ */
/* +mysql */

	KNH_ACLASS(ctx, ACLASS_String, CLASS_String);
	KNH_ICLASS(ctx, ICLASS_String, CLASS_String);
	KNH_XCLASS(ctx, CLASS_String__urn, CLASS_String, NULL);
	KNH_TFUNC__T(ctx, "String:toLower", bconv__toLower);
	KNH_TFUNC__T(ctx, "String:toUpper", bconv__toUpper);
	KNH_TFIELDN__T(ctx, FIELDN_, "");
	KNH_TFIELDN__T(ctx, FIELDN___fast, ":fast");
	KNH_TFIELDN__T(ctx, FIELDN_abs, "abs");
	KNH_TFIELDN__T(ctx, FIELDN_add, "add");
	KNH_TFIELDN__T(ctx, FIELDN_add__fast, "add:fast");
	KNH_TFIELDN__T(ctx, FIELDN_addr, "addr");
	KNH_TFIELDN__T(ctx, FIELDN_another, "another");
	KNH_TFIELDN__T(ctx, FIELDN_append, "append");
	KNH_TFIELDN__T(ctx, FIELDN_autoFlush, "autoFlush");
	KNH_TFIELDN__T(ctx, FIELDN_b, "b");
	KNH_TFIELDN__T(ctx, FIELDN_bits, "bits");
	KNH_TFIELDN__T(ctx, FIELDN_buf, "buf");
	KNH_TFIELDN__T(ctx, FIELDN_c, "c");
	KNH_TFIELDN__T(ctx, FIELDN_class, "class");
	KNH_TFIELDN__T(ctx, FIELDN_clear, "clear");
	KNH_TFIELDN__T(ctx, FIELDN_close, "close");
	KNH_TFIELDN__T(ctx, FIELDN_compareTo, "compareTo");
	KNH_TFIELDN__T(ctx, FIELDN_default, "default");
	KNH_TFIELDN__T(ctx, FIELDN_delim, "delim");
	KNH_TFIELDN__T(ctx, FIELDN_dump, "dump");
	KNH_TFIELDN__T(ctx, FIELDN_e, "e");
	KNH_TFIELDN__T(ctx, FIELDN_empty, "empty");
	KNH_TFIELDN__T(ctx, FIELDN_enc, "enc");
	KNH_TFIELDN__T(ctx, FIELDN_encoding, "encoding");
	KNH_TFIELDN__T(ctx, FIELDN_endsWith, "endsWith");
	KNH_TFIELDN__T(ctx, FIELDN_equals, "equals");
	KNH_TFIELDN__T(ctx, FIELDN_err, "err");
	KNH_TFIELDN__T(ctx, FIELDN_first, "first");
	KNH_TFIELDN__T(ctx, FIELDN_flush, "flush");
	KNH_TFIELDN__T(ctx, FIELDN_formatted, "formatted");
	KNH_TFIELDN__T(ctx, FIELDN_gCMarked, "gCMarked");
	KNH_TFIELDN__T(ctx, FIELDN_hasMetaData, "hasMetaData");
	KNH_TFIELDN__T(ctx, FIELDN_in, "in");
	KNH_TFIELDN__T(ctx, FIELDN_index, "index");
	KNH_TFIELDN__T(ctx, FIELDN_indexOf, "indexOf");
	KNH_TFIELDN__T(ctx, FIELDN_init, "init");
	KNH_TFIELDN__T(ctx, FIELDN_initialCapacity, "initialCapacity");
	KNH_TFIELDN__T(ctx, FIELDN_insert, "insert");
	KNH_TFIELDN__T(ctx, FIELDN_isAbstract, "isAbstract");
	KNH_TFIELDN__T(ctx, FIELDN_isAspect, "isAspect");
	KNH_TFIELDN__T(ctx, FIELDN_isAutoFlush, "isAutoFlush");
	KNH_TFIELDN__T(ctx, FIELDN_isClass, "isClass");
	KNH_TFIELDN__T(ctx, FIELDN_isDebug, "isDebug");
	KNH_TFIELDN__T(ctx, FIELDN_isDerived, "isDerived");
	KNH_TFIELDN__T(ctx, FIELDN_isFatal, "isFatal");
	KNH_TFIELDN__T(ctx, FIELDN_isFinal, "isFinal");
	KNH_TFIELDN__T(ctx, FIELDN_isFormatted, "isFormatted");
	KNH_TFIELDN__T(ctx, FIELDN_isGCMarked, "isGCMarked");
	KNH_TFIELDN__T(ctx, FIELDN_isGenerated, "isGenerated");
	KNH_TFIELDN__T(ctx, FIELDN_isImmutable, "isImmutable");
	KNH_TFIELDN__T(ctx, FIELDN_isInterface, "isInterface");
	KNH_TFIELDN__T(ctx, FIELDN_isLocal, "isLocal");
	KNH_TFIELDN__T(ctx, FIELDN_isLogging, "isLogging");
	KNH_TFIELDN__T(ctx, FIELDN_isLossLess, "isLossLess");
	KNH_TFIELDN__T(ctx, FIELDN_isMetaExtensible, "isMetaExtensible");
	KNH_TFIELDN__T(ctx, FIELDN_isModified, "isModified");
	KNH_TFIELDN__T(ctx, FIELDN_isNullBase, "isNullBase");
	KNH_TFIELDN__T(ctx, FIELDN_isPartial, "isPartial");
	KNH_TFIELDN__T(ctx, FIELDN_isPrivate, "isPrivate");
	KNH_TFIELDN__T(ctx, FIELDN_isPublic, "isPublic");
	KNH_TFIELDN__T(ctx, FIELDN_isRelease, "isRelease");
	KNH_TFIELDN__T(ctx, FIELDN_isSignificant, "isSignificant");
	KNH_TFIELDN__T(ctx, FIELDN_isStatic, "isStatic");
	KNH_TFIELDN__T(ctx, FIELDN_isSynchronized, "isSynchronized");
	KNH_TFIELDN__T(ctx, FIELDN_isSynonym, "isSynonym");
	KNH_TFIELDN__T(ctx, FIELDN_isSystem, "isSystem");
	KNH_TFIELDN__T(ctx, FIELDN_isTemporal, "isTemporal");
	KNH_TFIELDN__T(ctx, FIELDN_isTotal, "isTotal");
	KNH_TFIELDN__T(ctx, FIELDN_isUnsigned, "isUnsigned");
	KNH_TFIELDN__T(ctx, FIELDN_isVarArgs, "isVarArgs");
	KNH_TFIELDN__T(ctx, FIELDN_isVirtual, "isVirtual");
	KNH_TFIELDN__T(ctx, FIELDN_k, "k");
	KNH_TFIELDN__T(ctx, FIELDN_key, "key");
	KNH_TFIELDN__T(ctx, FIELDN_keys, "keys");
	KNH_TFIELDN__T(ctx, FIELDN_lambda, "lambda");
	KNH_TFIELDN__T(ctx, FIELDN_len, "len");
	KNH_TFIELDN__T(ctx, FIELDN_m, "m");
	KNH_TFIELDN__T(ctx, FIELDN_modified, "modified");
	KNH_TFIELDN__T(ctx, FIELDN_n, "n");
	KNH_TFIELDN__T(ctx, FIELDN_name, "name");
	KNH_TFIELDN__T(ctx, FIELDN_new, "new");
	KNH_TFIELDN__T(ctx, FIELDN_new__array, "new:array");
	KNH_TFIELDN__T(ctx, FIELDN_new__init, "new:init");
	KNH_TFIELDN__T(ctx, FIELDN_new__offset, "new:offset");
	KNH_TFIELDN__T(ctx, FIELDN_new__slice, "new:slice");
	KNH_TFIELDN__T(ctx, FIELDN_next, "next");
	KNH_TFIELDN__T(ctx, FIELDN_o, "o");
	KNH_TFIELDN__T(ctx, FIELDN_offset, "offset");
	KNH_TFIELDN__T(ctx, FIELDN_opAdd, "opAdd");
	KNH_TFIELDN__T(ctx, FIELDN_opAdd__2, "opAdd:2");
	KNH_TFIELDN__T(ctx, FIELDN_opDiv, "opDiv");
	KNH_TFIELDN__T(ctx, FIELDN_opDiv__2, "opDiv:2");
	KNH_TFIELDN__T(ctx, FIELDN_opEq, "opEq");
	KNH_TFIELDN__T(ctx, FIELDN_opGt, "opGt");
	KNH_TFIELDN__T(ctx, FIELDN_opGte, "opGte");
	KNH_TFIELDN__T(ctx, FIELDN_opIn, "opIn");
	KNH_TFIELDN__T(ctx, FIELDN_opInstanceof, "opInstanceof");
	KNH_TFIELDN__T(ctx, FIELDN_opIsMapTo, "opIsMapTo");
	KNH_TFIELDN__T(ctx, FIELDN_opItr, "opItr");
	KNH_TFIELDN__T(ctx, FIELDN_opLShift, "opLShift");
	KNH_TFIELDN__T(ctx, FIELDN_opLogicalAnd, "opLogicalAnd");
	KNH_TFIELDN__T(ctx, FIELDN_opLogicalNot, "opLogicalNot");
	KNH_TFIELDN__T(ctx, FIELDN_opLogicalOr, "opLogicalOr");
	KNH_TFIELDN__T(ctx, FIELDN_opLogicalXor, "opLogicalXor");
	KNH_TFIELDN__T(ctx, FIELDN_opLt, "opLt");
	KNH_TFIELDN__T(ctx, FIELDN_opLte, "opLte");
	KNH_TFIELDN__T(ctx, FIELDN_opMod, "opMod");
	KNH_TFIELDN__T(ctx, FIELDN_opMul, "opMul");
	KNH_TFIELDN__T(ctx, FIELDN_opMul__2, "opMul:2");
	KNH_TFIELDN__T(ctx, FIELDN_opNeg, "opNeg");
	KNH_TFIELDN__T(ctx, FIELDN_opNeq, "opNeq");
	KNH_TFIELDN__T(ctx, FIELDN_opNext, "opNext");
	KNH_TFIELDN__T(ctx, FIELDN_opNot, "opNot");
	KNH_TFIELDN__T(ctx, FIELDN_opOffset, "opOffset");
	KNH_TFIELDN__T(ctx, FIELDN_opPrev, "opPrev");
	KNH_TFIELDN__T(ctx, FIELDN_opRShift, "opRShift");
	KNH_TFIELDN__T(ctx, FIELDN_opSeq, "opSeq");
	KNH_TFIELDN__T(ctx, FIELDN_opSlice, "opSlice");
	KNH_TFIELDN__T(ctx, FIELDN_opSub, "opSub");
	KNH_TFIELDN__T(ctx, FIELDN_opSub__2, "opSub:2");
	KNH_TFIELDN__T(ctx, FIELDN_opSubset, "opSubset");
	KNH_TFIELDN__T(ctx, FIELDN_out, "out");
	KNH_TFIELDN__T(ctx, FIELDN_pop, "pop");
	KNH_TFIELDN__T(ctx, FIELDN_print, "print");
	KNH_TFIELDN__T(ctx, FIELDN_println, "println");
	KNH_TFIELDN__T(ctx, FIELDN_property, "property");
	KNH_TFIELDN__T(ctx, FIELDN_query, "query");
	KNH_TFIELDN__T(ctx, FIELDN_random, "random");
	KNH_TFIELDN__T(ctx, FIELDN_readLine, "readLine");
	KNH_TFIELDN__T(ctx, FIELDN_refc, "refc");
	KNH_TFIELDN__T(ctx, FIELDN_remove, "remove");
	KNH_TFIELDN__T(ctx, FIELDN_replace, "replace");
	KNH_TFIELDN__T(ctx, FIELDN_replace__once, "replace:once");
	KNH_TFIELDN__T(ctx, FIELDN_s, "s");
	KNH_TFIELDN__T(ctx, FIELDN_second, "second");
	KNH_TFIELDN__T(ctx, FIELDN_size, "size");
	KNH_TFIELDN__T(ctx, FIELDN_split, "split");
	KNH_TFIELDN__T(ctx, FIELDN_startsWith, "startsWith");
	KNH_TFIELDN__T(ctx, FIELDN_t, "t");
	KNH_TFIELDN__T(ctx, FIELDN_term, "term");
	KNH_TFIELDN__T(ctx, FIELDN_this, "this");
	KNH_TFIELDN__T(ctx, FIELDN_toLower, "toLower");
	KNH_TFIELDN__T(ctx, FIELDN_toUpper, "toUpper");
	KNH_TFIELDN__T(ctx, FIELDN_trim, "trim");
	KNH_TFIELDN__T(ctx, FIELDN_uRN, "uRN");
	KNH_TFIELDN__T(ctx, FIELDN_urn, "urn");
	KNH_TFIELDN__T(ctx, FIELDN_v, "v");
	KNH_TFIELDN__T(ctx, FIELDN_value, "value");
	KNH_TFIELDN__T(ctx, FIELDN_vargs, "vargs");
	KNH_TFIELDN__T(ctx, FIELDN_w, "w");
	KNH_TFIELDN__T(ctx, FIELDN_write, "write");
	KNH_TFIELDN__T(ctx, FIELDN_x, "x");
/* ------------------------------------------------------------------------ */

	KNH_INITv(knh_tMethodField[MFN_Any_Any_], new_MethodField__1(ctx, KNH_FLAG_MF_VARARGS, TYPE_Any, TYPE_Any, FIELDN_o));
	KNH_INITv(knh_tMethodField[MFN_void_OutputStream_Any], new_MethodField__2(ctx, 0, TYPE_void, TYPE_OutputStream, FIELDN_w, TYPE_Any, FIELDN_o));
	KNH_INITv(knh_tMethodField[MFN_Any], new_MethodField__0(ctx, 0, TYPE_Any));
	KNH_INITv(knh_tMethodField[MFN_nThis_Int], new_MethodField__1(NULL, 0, NNTYPE_This, TYPE_Int, FIELDN_init));
	KNH_INITv(knh_tMethodField[MFN_nThis_Int_Any1], new_MethodField__2(NULL, 0, NNTYPE_This, TYPE_Int, FIELDN_init, TYPE_Any1, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_nThis_Any1_], new_MethodField__1(NULL, KNH_FLAG_MF_VARARGS, NNTYPE_This, TYPE_Any1, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_void_Any1], new_MethodField__1(NULL, 0, TYPE_void, TYPE_Any1, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_void_Any1_], new_MethodField__1(NULL, KNH_FLAG_MF_VARARGS, TYPE_void, TYPE_Any1, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nInt], new_MethodField__0(NULL, 0, NNTYPE_Int));
	KNH_INITv(knh_tMethodField[MFN_Any1_nInt], new_MethodField__1(NULL, 0, TYPE_Any1, NNTYPE_Int, FIELDN_index));
	KNH_INITv(knh_tMethodField[MFN_void_nInt_Any1], new_MethodField__2(NULL, 0, TYPE_void, NNTYPE_Int, FIELDN_index, TYPE_Any1, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_Any1], new_MethodField__0(NULL, 0, TYPE_Any1));
	KNH_INITv(knh_tMethodField[MFN_void_nInt], new_MethodField__1(NULL, 0, TYPE_void, NNTYPE_Int, FIELDN_n));
	KNH_INITv(knh_tMethodField[MFN_void], new_MethodField__0(NULL, 0, TYPE_void));
	KNH_INITv(knh_tMethodField[MFN_nThis_Int_Int], new_MethodField__2(NULL, 0, NNTYPE_This, TYPE_Int, FIELDN_s, TYPE_Int, FIELDN_e));
	KNH_INITv(knh_tMethodField[MFN_nBoolean_Any], new_MethodField__1(NULL, 0, NNTYPE_Boolean, TYPE_Any, FIELDN_another));
	KNH_INITv(knh_tMethodField[MFN_nBytes_Int], new_MethodField__1(NULL, 0, NNTYPE_Bytes, TYPE_Int, FIELDN_init));
	KNH_INITv(knh_tMethodField[MFN_nConnection_nString], new_MethodField__1(NULL, 0, NNTYPE_Connection, NNTYPE_String, FIELDN_urn));
	KNH_INITv(knh_tMethodField[MFN_ResultSet_nString], new_MethodField__1(NULL, 0, TYPE_ResultSet, NNTYPE_String, FIELDN_query));
	KNH_INITv(knh_tMethodField[MFN_Any_nString], new_MethodField__1(NULL, 0, TYPE_Any, NNTYPE_String, FIELDN_key));
	KNH_INITv(knh_tMethodField[MFN_void_nString_Any], new_MethodField__2(NULL, 0, TYPE_void, NNTYPE_String, FIELDN_key, TYPE_Any, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_void_String], new_MethodField__1(NULL, 0, TYPE_void, TYPE_String, FIELDN_enc));
	KNH_INITv(knh_tMethodField[MFN_nInt_nString], new_MethodField__1(NULL, 0, NNTYPE_Int, NNTYPE_String, FIELDN_term));
	KNH_INITv(knh_tMethodField[MFN_String_nInt], new_MethodField__1(NULL, 0, TYPE_String, NNTYPE_Int, FIELDN_index));
	KNH_INITv(knh_tMethodField[MFN_nDictMap_Int], new_MethodField__1(NULL, 0, NNTYPE_DictMap, TYPE_Int, FIELDN_initialCapacity));
	KNH_INITv(knh_tMethodField[MFN_void_nString_nAny], new_MethodField__2(NULL, 0, TYPE_void, NNTYPE_String, FIELDN_key, NNTYPE_Any, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_void_nString], new_MethodField__1(NULL, 0, TYPE_void, NNTYPE_String, FIELDN_key));
	KNH_INITv(knh_tMethodField[MFN_nDictSet_Int], new_MethodField__1(NULL, 0, NNTYPE_DictSet, TYPE_Int, FIELDN_initialCapacity));
	KNH_INITv(knh_tMethodField[MFN_Boolean_Any], new_MethodField__1(NULL, 0, TYPE_Boolean, TYPE_Any, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_void_nString_nInt], new_MethodField__2(NULL, 0, TYPE_void, NNTYPE_String, FIELDN_key, NNTYPE_Int, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_nFloat_nFloat], new_MethodField__1(NULL, 0, NNTYPE_Float, NNTYPE_Float, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nFloat], new_MethodField__0(NULL, 0, NNTYPE_Float));
	KNH_INITv(knh_tMethodField[MFN_nFloat_nFloat_], new_MethodField__1(NULL, KNH_FLAG_MF_VARARGS, NNTYPE_Float, NNTYPE_Float, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nBoolean_nFloat], new_MethodField__1(NULL, 0, NNTYPE_Boolean, NNTYPE_Float, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_Float], new_MethodField__0(NULL, 0, TYPE_Float));
	KNH_INITv(knh_tMethodField[MFN_Any2_Any1], new_MethodField__1(NULL, 0, TYPE_Any2, TYPE_Any1, FIELDN_key));
	KNH_INITv(knh_tMethodField[MFN_void_Any1_Any2], new_MethodField__2(NULL, 0, TYPE_void, TYPE_Any1, FIELDN_key, TYPE_Any2, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_nHashMap_Int], new_MethodField__1(NULL, 0, NNTYPE_HashMap, TYPE_Int, FIELDN_initialCapacity));
	KNH_INITv(knh_tMethodField[MFN_nHashMap_Any_], new_MethodField__1(NULL, KNH_FLAG_MF_VARARGS, NNTYPE_HashMap, TYPE_Any, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_Boolean_Any1], new_MethodField__1(NULL, 0, TYPE_Boolean, TYPE_Any1, FIELDN_key));
	KNH_INITv(knh_tMethodField[MFN_nIterator], new_MethodField__0(NULL, 0, NNTYPE_Iterator));
	KNH_INITv(knh_tMethodField[MFN_nInt_Any1], new_MethodField__1(NULL, 0, NNTYPE_Int, TYPE_Any1, FIELDN_key));
	KNH_INITv(knh_tMethodField[MFN_void_Any1_nInt], new_MethodField__2(NULL, 0, TYPE_void, TYPE_Any1, FIELDN_key, NNTYPE_Int, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_nHashSet_Int], new_MethodField__1(NULL, 0, NNTYPE_HashSet, TYPE_Int, FIELDN_initialCapacity));
	KNH_INITv(knh_tMethodField[MFN_String], new_MethodField__0(NULL, 0, TYPE_String));
	KNH_INITv(knh_tMethodField[MFN_nInt_nInt], new_MethodField__1(NULL, 0, NNTYPE_Int, NNTYPE_Int, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nInt_nInt_], new_MethodField__1(NULL, KNH_FLAG_MF_VARARGS, NNTYPE_Int, NNTYPE_Int, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nBoolean_nInt], new_MethodField__1(NULL, 0, NNTYPE_Boolean, NNTYPE_Int, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_nInt_Int], new_MethodField__1(NULL, 0, NNTYPE_Int, TYPE_Int, FIELDN_n));
	KNH_INITv(knh_tMethodField[MFN_nInt_nInt_Class], new_MethodField__2(NULL, 0, NNTYPE_Int, NNTYPE_Int, FIELDN_n, TYPE_Class, FIELDN_c));
	KNH_INITv(knh_tMethodField[MFN_Boolean_nInt], new_MethodField__1(NULL, 0, TYPE_Boolean, NNTYPE_Int, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_Boolean], new_MethodField__0(NULL, 0, TYPE_Boolean));
	KNH_INITv(knh_tMethodField[MFN_nString], new_MethodField__0(NULL, 0, NNTYPE_String));
	KNH_INITv(knh_tMethodField[MFN_nFloat_nNumber], new_MethodField__1(NULL, 0, NNTYPE_Float, NNTYPE_Number, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nFloat_nNumber_], new_MethodField__1(NULL, KNH_FLAG_MF_VARARGS, NNTYPE_Float, NNTYPE_Number, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nBoolean_nNumber], new_MethodField__1(NULL, 0, NNTYPE_Boolean, NNTYPE_Number, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nThis], new_MethodField__0(NULL, 0, NNTYPE_This));
	KNH_INITv(knh_tMethodField[MFN_nInt_Any], new_MethodField__1(NULL, 0, NNTYPE_Int, TYPE_Any, FIELDN_o));
	KNH_INITv(knh_tMethodField[MFN_Class], new_MethodField__0(NULL, 0, TYPE_Class));
	KNH_INITv(knh_tMethodField[MFN_This], new_MethodField__0(NULL, 0, TYPE_This));
	KNH_INITv(knh_tMethodField[MFN_void_nBytes_Int_Int], new_MethodField__3(NULL, 0, TYPE_void, NNTYPE_Bytes, FIELDN_buf, TYPE_Int, FIELDN_offset, TYPE_Int, FIELDN_len));
	KNH_INITv(knh_tMethodField[MFN_void_Any], new_MethodField__1(NULL, 0, TYPE_void, TYPE_Any, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_void_Any_], new_MethodField__1(NULL, KNH_FLAG_MF_VARARGS, TYPE_void, TYPE_Any, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nRange_Any1_Any1], new_MethodField__2(NULL, 0, NNTYPE_Range, TYPE_Any1, FIELDN_s, TYPE_Any1, FIELDN_e));
	KNH_INITv(knh_tMethodField[MFN_nRange_Any1_Int], new_MethodField__2(NULL, 0, NNTYPE_Range, TYPE_Any1, FIELDN_s, TYPE_Int, FIELDN_offset));
	KNH_INITv(knh_tMethodField[MFN_ResultSet], new_MethodField__0(NULL, 0, TYPE_ResultSet));
	KNH_INITv(knh_tMethodField[MFN_nBoolean_nString], new_MethodField__1(NULL, 0, NNTYPE_Boolean, NNTYPE_String, FIELDN_s));
	KNH_INITv(knh_tMethodField[MFN_nString_Any], new_MethodField__1(NULL, 0, NNTYPE_String, TYPE_Any, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nString_Any_], new_MethodField__1(NULL, KNH_FLAG_MF_VARARGS, NNTYPE_String, TYPE_Any, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nString_nString], new_MethodField__1(NULL, 0, NNTYPE_String, NNTYPE_String, FIELDN_t));
	KNH_INITv(knh_tMethodField[MFN_nString_nString_nString], new_MethodField__2(NULL, 0, NNTYPE_String, NNTYPE_String, FIELDN_o, NNTYPE_String, FIELDN_n));
	KNH_INITv(knh_tMethodField[MFN_nString_nInt], new_MethodField__1(NULL, 0, NNTYPE_String, NNTYPE_Int, FIELDN_n));
	KNH_INITv(knh_tMethodField[MFN_nString_String], new_MethodField__1(NULL, 0, NNTYPE_String, TYPE_String, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nString_Int_Int], new_MethodField__2(NULL, 0, NNTYPE_String, TYPE_Int, FIELDN_offset, TYPE_Int, FIELDN_len));
	KNH_INITv(knh_tMethodField[MFN_aString_String], new_MethodField__1(NULL, 0, ATYPE_String, TYPE_String, FIELDN_delim));
	KNH_INITv(knh_tMethodField[MFN_nInputStream], new_MethodField__0(NULL, 0, NNTYPE_InputStream));
	KNH_INITv(knh_tMethodField[MFN_void_InputStream], new_MethodField__1(NULL, 0, TYPE_void, TYPE_InputStream, FIELDN_in));
	KNH_INITv(knh_tMethodField[MFN_nOutputStream], new_MethodField__0(NULL, 0, NNTYPE_OutputStream));
	KNH_INITv(knh_tMethodField[MFN_void_OutputStream], new_MethodField__1(NULL, 0, TYPE_void, TYPE_OutputStream, FIELDN_out));
	KNH_INITv(knh_tMethodField[MFN_nTuple2_Any1_Any2], new_MethodField__2(NULL, 0, NNTYPE_Tuple2, TYPE_Any1, FIELDN_first, TYPE_Any2, FIELDN_second));
	KNH_INITv(knh_tMethodField[MFN_Any_nInt], new_MethodField__1(NULL, 0, TYPE_Any, NNTYPE_Int, FIELDN_index));
	KNH_INITv(knh_tMethodField[MFN_Boolean_Class], new_MethodField__1(NULL, 0, TYPE_Boolean, TYPE_Class, FIELDN_c));
	KNH_INITv(knh_tMethodField[MFN_nBoolean], new_MethodField__0(NULL, 0, NNTYPE_Boolean));
	KNH_INITv(knh_tMethodField[MFN_void_Boolean], new_MethodField__1(NULL, 0, TYPE_void, TYPE_Boolean, FIELDN_b));
	knh_konoha_initapis(ctx);
	knh_konohac_initapis(ctx);
	knh_naruto_initapis(ctx);
}

#ifdef __cplusplus
}
#endif
