/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#include<konoha/konoha_dev.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

/* ======================================================================== */
/* [flag] */

static 
METHOD knh__Object_isRelease(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Object_isRelease((knh_Object_t*)sfp[0].o));
}

static
METHOD knh__Object_isDebug(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, !(knh_Object_isDebug((knh_Object_t*)sfp[0].o)));
}

static 
METHOD knh__Object_isImmutable(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Object_isImmutable((knh_Object_t*)sfp[0].o));
}

static 
METHOD knh__Object_hasMetaData(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Object_hasMetaData((knh_Object_t*)sfp[0].o));
}

static 
METHOD knh__Object_isSynchronized(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Object_isSynchronized((knh_Object_t*)sfp[0].o));
}

static 
METHOD knh__Object_isModified(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Object_isModified((knh_Object_t*)sfp[0].o));
}

static
METHOD knh__Object_setModified(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_Object_setModified((knh_Object_t*)sfp[0].o, IS_TRUE(sfp[1].o));
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static 
METHOD knh__Object_isGCMarked(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Object_isGCMarked((knh_Object_t*)sfp[0].o));
}

static
METHOD knh__Object_setGCMarked(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_Object_setGCMarked((knh_Object_t*)sfp[0].o, IS_TRUE(sfp[1].o));
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static 
METHOD knh__Object_isFormatted(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Object_isFormatted((knh_Object_t*)sfp[0].o));
}

static
METHOD knh__Object_setFormatted(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_Object_setFormatted((knh_Object_t*)sfp[0].o, IS_TRUE(sfp[1].o));
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static 
METHOD knh__Class_isRelease(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_class_isRelease(knh_Class_cid(sfp[0].c)));
}

static
METHOD knh__Class_isDebug(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, !(knh_class_isDebug(knh_Class_cid(sfp[0].c))));
}

static 
METHOD knh__Class_isImmutable(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_class_isImmutable(knh_Class_cid(sfp[0].c)));
}

static 
METHOD knh__Class_isMetaExtensible(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_class_isMetaExtensible(knh_Class_cid(sfp[0].c)));
}

static 
METHOD knh__Class_isPrivate(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_class_isPrivate(knh_Class_cid(sfp[0].c)));
}

static
METHOD knh__Class_isPublic(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, !(knh_class_isPublic(knh_Class_cid(sfp[0].c))));
}

static 
METHOD knh__Class_isFinal(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_class_isFinal(knh_Class_cid(sfp[0].c)));
}

static 
METHOD knh__Class_isSystem(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_class_isSystem(knh_Class_cid(sfp[0].c)));
}

static 
METHOD knh__Class_isInterface(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_class_isInterface(knh_Class_cid(sfp[0].c)));
}

static 
METHOD knh__Method_isPublic(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Method_isPublic((knh_Method_t*)sfp[0].o));
}

static
METHOD knh__Method_isPrivate(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, !(knh_Method_isPrivate((knh_Method_t*)sfp[0].o)));
}

static 
METHOD knh__Method_isVirtual(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Method_isVirtual((knh_Method_t*)sfp[0].o));
}

static
METHOD knh__Method_isFinal(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, !(knh_Method_isFinal((knh_Method_t*)sfp[0].o)));
}

static 
METHOD knh__Method_isStatic(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Method_isStatic((knh_Method_t*)sfp[0].o));
}

static 
METHOD knh__Method_isClass(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Method_isClass((knh_Method_t*)sfp[0].o));
}

static 
METHOD knh__Method_isNullBase(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Method_isNullBase((knh_Method_t*)sfp[0].o));
}

static 
METHOD knh__Method_isVarArgs(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Method_isVarArgs((knh_Method_t*)sfp[0].o));
}

static 
METHOD knh__Method_isAspect(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Method_isAspect((knh_Method_t*)sfp[0].o));
}

static 
METHOD knh__Mapper_isInterface(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Mapper_isInterface((knh_Mapper_t*)sfp[0].o));
}

static 
METHOD knh__Mapper_isSignificant(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Mapper_isSignificant((knh_Mapper_t*)sfp[0].o));
}

static 
METHOD knh__Mapper_isFinal(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Mapper_isFinal((knh_Mapper_t*)sfp[0].o));
}

static 
METHOD knh__Mapper_isSynonym(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Mapper_isSynonym((knh_Mapper_t*)sfp[0].o));
}

static 
METHOD knh__Mapper_isLossLess(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Mapper_isLossLess((knh_Mapper_t*)sfp[0].o));
}

static 
METHOD knh__Mapper_isTotal(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Mapper_isTotal((knh_Mapper_t*)sfp[0].o));
}

static
METHOD knh__Mapper_isPartial(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, !(knh_Mapper_isPartial((knh_Mapper_t*)sfp[0].o)));
}

static 
METHOD knh__Mapper_isStatic(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Mapper_isStatic((knh_Mapper_t*)sfp[0].o));
}

static
METHOD knh__Mapper_isTemporal(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, !(knh_Mapper_isTemporal((knh_Mapper_t*)sfp[0].o)));
}

static 
METHOD knh__Mapper_isLocal(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Mapper_isLocal((knh_Mapper_t*)sfp[0].o));
}

static 
METHOD knh__Mapper_isDerived(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Mapper_isDerived((knh_Mapper_t*)sfp[0].o));
}

static 
METHOD knh__IntUnit_isUnsigned(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_IntUnit_isUnsigned((knh_IntUnit_t*)sfp[0].o));
}

static 
METHOD knh__OutputStream_isAutoFlush(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_OutputStream_isAutoFlush((knh_OutputStream_t*)sfp[0].o));
}

static
METHOD knh__OutputStream_setAutoFlush(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_OutputStream_setAutoFlush((knh_OutputStream_t*)sfp[0].o, IS_TRUE(sfp[1].o));
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static 
METHOD knh__Exception_isFatal(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Exception_isFatal((knh_Exception_t*)sfp[0].o));
}

static 
METHOD knh__Exception_isLogging(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Exception_isLogging((knh_Exception_t*)sfp[0].o));
}

static 
METHOD knh__Exception_isGenerated(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Exception_isGenerated((knh_Exception_t*)sfp[0].o));
}

/* ======================================================================== */
/* [method] */

static
METHOD knh__Array_clear(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void Array.clear()  */
	knh_Array_clear(
		ctx,
		(knh_Array_t*)sfp[0].o
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__Connection_close(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void Connection.close()  */
	knh_Connection_close(
		ctx,
		(knh_Connection_t*)sfp[0].o
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__Context_getProperty(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Any Context.getProperty(String! key)  */
	Object *rv = (Object*)knh_Context_getProperty(
		ctx,
		(knh_Context_t*)sfp[0].o,
		knh_String_tobytes((String*)sfp[1].o) /* String! sfp[1].o => knh_bytes_t key */
	);
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__Context_setProperty(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void Context.setProperty(String! key, Any value)  */
	knh_Context_setProperty(
		ctx,
		(knh_Context_t*)sfp[0].o,
		(String*)sfp[1].o /* String! sfp[1].o => String* key */,
		(Any*)sfp[2].o /* Any sfp[2].o => Any* value */
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__Context_setEncoding(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void Context.setEncoding(String enc)  */
	knh_Context_setEncoding(
		ctx,
		(knh_Context_t*)sfp[0].o,
		(String*)sfp[1].o /* String sfp[1].o => String* enc */
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__DictIdx_index(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Int! DictIdx.index(String! term)  */
	knh_index_t v = knh_DictIdx_index(
		ctx,
		(knh_DictIdx_t*)sfp[0].o,
		knh_String_tobytes((String*)sfp[1].o) /* String! sfp[1].o => knh_bytes_t v */
	);
	Object* rv = (Object*)new_Int(ctx, v) /* knh_index_t v => Int rv */;
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__DictIdx_add__fast(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Int! DictIdx.add::fast(String! term)  */
	knh_index_t v = knh_DictIdx_add__fast(
		ctx,
		(knh_DictIdx_t*)sfp[0].o,
		(String*)sfp[1].o /* String! sfp[1].o => String* term */
	);
	Object* rv = (Object*)new_Int(ctx, v) /* knh_index_t v => Int rv */;
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__DictIdx_add(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Int! DictIdx.add(String! term)  */
	knh_index_t v = knh_DictIdx_add(
		ctx,
		(knh_DictIdx_t*)sfp[0].o,
		(String*)sfp[1].o /* String! sfp[1].o => String* term */
	);
	Object* rv = (Object*)new_Int(ctx, v) /* knh_index_t v => Int rv */;
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__DictIdx_get__fast(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method String DictIdx.get::fast(Int! index)  */
	Object *rv = (Object*)knh_DictIdx_get__fast(
		(knh_DictIdx_t*)sfp[0].o,
		knh_Int_toint((Int*)sfp[1].o) /* Int! sfp[1].o => knh_int_t termid */
	);
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__DictIdx_get(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method String DictIdx.get(Int! index)  */
	Object *rv = (Object*)knh_DictIdx_get(
		(knh_DictIdx_t*)sfp[0].o,
		knh_Int_toint((Int*)sfp[1].o) /* Int! sfp[1].o => knh_int_t termid */
	);
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__DictIdx_clear(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void DictIdx.clear()  */
	knh_DictIdx_clear(
		ctx,
		(knh_DictIdx_t*)sfp[0].o
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__DictMap_new(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method DictMap! DictMap.new(Int initialCapacity)  */
	Object *rv = (Object*)knh_DictMap_new(
		ctx,
		(knh_DictMap_t*)sfp[0].o,
		knh_IntNULL_toint((Int*)sfp[1].o) /* Int sfp[1].o => knh_int_t initialCapacity */
	);
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__DictMap_get(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Any DictMap.get(String! key)  */
	Object *rv = (Object*)knh_DictMap_get(
		ctx,
		(knh_DictMap_t*)sfp[0].o,
		(String*)sfp[1].o /* String! sfp[1].o => String* key */
	);
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__DictMap_append(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void DictMap.append(String! key, Any! value)  */
	knh_DictMap_append(
		ctx,
		(knh_DictMap_t*)sfp[0].o,
		(String*)sfp[1].o /* String! sfp[1].o => String* key */,
		(Any*)sfp[2].o /* Any! sfp[2].o => Any* value */
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__DictMap_set(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void DictMap.set(String! key, Any value)  */
	knh_DictMap_set(
		ctx,
		(knh_DictMap_t*)sfp[0].o,
		(String*)sfp[1].o /* String! sfp[1].o => String* key */,
		(Any*)sfp[2].o /* Any sfp[2].o => Any* v */
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__DictMap_remove(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void DictMap.remove(String! key)  */
	knh_DictMap_remove(
		ctx,
		(knh_DictMap_t*)sfp[0].o,
		(String*)sfp[1].o /* String! sfp[1].o => String* key */
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__DictMap_clear(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void DictMap.clear()  */
	knh_DictMap_clear(
		ctx,
		(knh_DictMap_t*)sfp[0].o
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__DictSet_new(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method DictSet! DictSet.new(Int initialCapacity=0)  */
	Object *rv = (Object*)knh_DictSet_new(
		ctx,
		(knh_DictSet_t*)sfp[0].o,
		knh_IntNULL_toint((Int*)sfp[1].o) /* Int sfp[1].o => knh_int_t initialCapacity */
	);
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__DictSet_get(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Int! DictSet.get(String! key)  */
	knh_int_t v = knh_DictSet_get(
		(knh_DictSet_t*)sfp[0].o,
		(String*)sfp[1].o /* String! sfp[1].o => String* key */
	);
	Object* rv = (Object*)new_Int(ctx, v) /* knh_int_t v => Int rv */;
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__DictSet_opIn(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Boolean DictSet.opIn(Any value)  */
	knh_bool_t v = knh_DictSet_opIn(
		ctx,
		(knh_DictSet_t*)sfp[0].o,
		(Any*)sfp[1].o /* Any sfp[1].o => Any* value */
	);
	Object* rv = (Object*)new_Boolean(ctx, v) /* knh_bool_t v => Boolean rv */;
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__DictSet_set(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void DictSet.set(String! key, Int! value)  */
	knh_DictSet_set(
		ctx,
		(knh_DictSet_t*)sfp[0].o,
		(String*)sfp[1].o /* String! sfp[1].o => String* key */,
		(knh_uint_t)knh_Int_toint((Int*)sfp[2].o) /* Int! sfp[2].o => knh_uint_t value */
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__DictSet_add(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void DictSet.add(String! key)  */
	knh_DictSet_add(
		ctx,
		(knh_DictSet_t*)sfp[0].o,
		(String*)sfp[1].o /* String! sfp[1].o => String* key */
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__DictSet_clear(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void DictSet.clear()  */
	knh_DictSet_clear(
		ctx,
		(knh_DictSet_t*)sfp[0].o
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__HashMap_get(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Any2 HashMap.get(Any1 key)  */
	Object *rv = (Object*)knh_HashMap_get(
		ctx,
		(knh_HashMap_t*)sfp[0].o,
		knh_Object_hashCode(sfp[1].o),
		(Any*)sfp[1].o /* Any1 sfp[1].o => Any* kobj */
	);
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__HashMap_set(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void HashMap.set(Any1 key, Any2 value)  */
	knh_HashMap_set(
		ctx,
		(knh_HashMap_t*)sfp[0].o,
		knh_Object_hashCode(sfp[1].o),
		(Any*)sfp[1].o /* Any1 sfp[1].o => Any* kobj */,
		(Any*)sfp[2].o /* Any2 sfp[2].o => Any* value */
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__HashMap_remove(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void HashMap.remove(Any1 key)  */
	knh_HashMap_remove(
		ctx,
		(knh_HashMap_t*)sfp[0].o,
		knh_Object_hashCode(sfp[1].o),
		(Any*)sfp[1].o /* Any1 sfp[1].o => Any* kobj */
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__HashMap_new(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method HashMap! HashMap.new(Int initialCapacity=0)  */
	Object *rv = (Object*)knh_HashMap_new(
		ctx,
		(knh_HashMap_t*)sfp[0].o,
		(size_t)knh_IntNULL_toint((Int*)sfp[1].o) /* Int sfp[1].o => size_t initialCapacity */
	);
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__HashMap_new__init(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method[VARARGS] HashMap! HashMap.new::init(Any value)  */
	Object *rv = (Object*)knh_HashMap_new__init(
		ctx,
		(knh_HashMap_t*)sfp[0].o,
		knh_sfp_argc(ctx, sfp + 1),
		sfp + 1
	);
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__HashMap_opIn(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Boolean HashMap.opIn(Any1 key)  */
	knh_bool_t v = knh_HashMap_opIn(
		ctx,
		(knh_HashMap_t*)sfp[0].o,
		knh_Object_hashCode(sfp[1].o),
		(Any*)sfp[1].o /* Any1 sfp[1].o => Any* keyobj */
	);
	Object* rv = (Object*)new_Boolean(ctx, v) /* knh_bool_t v => Boolean rv */;
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__HashMap_keys(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Iterator! HashMap.keys()  */
	Object *rv = (Object*)knh_HashMap_keys(
		ctx,
		(knh_HashMap_t*)sfp[0].o
	);
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__HashSet_get(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Int! HashSet.get(Any1 key);  */
	knh_uint_t v = knh_HashSet_get(
		ctx,
		(knh_HashSet_t*)sfp[0].o,
		knh_Object_hashCode(sfp[1].o),
		(Object*)sfp[1].o /* Any1 sfp[1].o => Object* keyobj */
	);
	Object* rv = (Object*)new_Int(ctx, v) /* knh_uint_t v => Int rv */;
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__HashSet_set(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void HashSet.set(Any1 key, Int! value);  */
	knh_HashSet_set(
		ctx,
		(knh_HashSet_t*)sfp[0].o,
		knh_Object_hashCode(sfp[1].o),
		(Any*)sfp[1].o /* Any1 sfp[1].o => Any* keyobj */,
		(knh_uint_t)knh_Int_toint((Int*)sfp[2].o) /* Int! sfp[2].o => knh_uint_t value */
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__HashSet_add(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void HashSet.add(Any1 key)  */
	knh_HashSet_add(
		ctx,
		(knh_HashSet_t*)sfp[0].o,
		knh_Object_hashCode(sfp[1].o),
		(Any*)sfp[1].o /* Any1 sfp[1].o => Any* keyobj */
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__HashSet_remove(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void HashSet.remove(Any1 key)  */
	knh_HashSet_remove(
		ctx,
		(knh_HashSet_t*)sfp[0].o,
		knh_Object_hashCode(sfp[1].o),
		(Any*)sfp[1].o /* Any1 sfp[1].o => Any* keyobj */
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__HashSet_new(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method HashSet! HashSet.new(Int initialCapacity=0)  */
	Object *rv = (Object*)knh_HashSet_new(
		ctx,
		(knh_HashSet_t*)sfp[0].o,
		(size_t)knh_IntNULL_toint((Int*)sfp[1].o) /* Int sfp[1].o => size_t initialCapacity */
	);
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__HashSet_opIn(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Boolean HashSet.opIn(Any1 key)  */
	knh_bool_t v = knh_HashSet_opIn(
		ctx,
		(knh_HashSet_t*)sfp[0].o,
		knh_Object_hashCode(sfp[1].o),
		(Object*)sfp[1].o /* Any1 sfp[1].o => Object* keyobj */
	);
	Object* rv = (Object*)new_Boolean(ctx, v) /* knh_bool_t v => Boolean rv */;
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__InputStream_readLine(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method String InputStream.readLine()  */
	Object *rv = (Object*)knh_InputStream_readLine(
		ctx,
		(knh_InputStream_t*)sfp[0].o
	);
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__InputStream_close(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void InputStream.close()  */
	knh_InputStream_close(
		ctx,
		(knh_InputStream_t*)sfp[0].o
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__InputStream_setEncoding(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void InputStream.setEncoding(String enc)  */
	knh_InputStream_setEncoding(
		ctx,
		(knh_InputStream_t*)sfp[0].o,
		(String*)sfp[1].o /* String sfp[1].o => String* enc */
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__Method_isAbstract(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Boolean Method.isAbstract()  */
	knh_bool_t v = knh_Method_isAbstract(
		(knh_Method_t*)sfp[0].o
	);
	Object* rv = (Object*)new_Boolean(ctx, v) /* knh_bool_t v => Boolean rv */;
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__Method_getName(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method String! Method.getName()  */
	Object *rv = (Object*)knh_Method_getName(
		ctx,
		(knh_Method_t*)sfp[0].o
	);
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__Method_getURN(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method String! Method.getURN()  */
	Object *rv = (Object*)knh_Method_getURN(
		ctx,
		(knh_Method_t*)sfp[0].o
	);
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__Object_compareTo(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Int! Object.compareTo(Any o)  */
	int v = knh_Object_compareTo(
		(knh_Object_t*)sfp[0].o,
		(Object*)sfp[1].o /* Any sfp[1].o => Object* o2 */
	);
	Object* rv = (Object*)new_Int(ctx, (knh_int_t)v) /* int v => Int rv */;
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__OutputStream_flush(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void OutputStream.flush()  */
	knh_OutputStream_flush(
		ctx,
		(knh_OutputStream_t*)sfp[0].o
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__OutputStream_close(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void OutputStream.close()  */
	knh_OutputStream_close(
		ctx,
		(knh_OutputStream_t*)sfp[0].o
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__OutputStream_setEncoding(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void OutputStream.setEncoding(String enc)  */
	knh_OutputStream_setEncoding(
		ctx,
		(knh_OutputStream_t*)sfp[0].o,
		(String*)sfp[1].o /* String sfp[1].o => String* enc */
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__ResultSet_next(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method ResultSet ResultSet.next()  */
	Object *rv = (Object*)knh_ResultSet_next(
		ctx,
		(knh_ResultSet_t*)sfp[0].o
	);
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__String_equals(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Boolean! String.equals(String! s)  */
	knh_bool_t v = knh_String_equals(
		(knh_String_t*)sfp[0].o,
		knh_String_tobytes((String*)sfp[1].o) /* String! sfp[1].o => knh_bytes_t s */
	);
	Object* rv = (Object*)new_Boolean(ctx, v) /* knh_bool_t v => Boolean rv */;
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__String_startsWith(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Boolean! String.startsWith(String! s)  */
	knh_bool_t v = knh_String_startsWith(
		(knh_String_t*)sfp[0].o,
		knh_String_tobytes((String*)sfp[1].o) /* String! sfp[1].o => knh_bytes_t s */
	);
	Object* rv = (Object*)new_Boolean(ctx, v) /* knh_bool_t v => Boolean rv */;
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__String_endsWith(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Boolean! String.endsWith(String! s)  */
	knh_bool_t v = knh_String_endsWith(
		(knh_String_t*)sfp[0].o,
		knh_String_tobytes((String*)sfp[1].o) /* String! sfp[1].o => knh_bytes_t s */
	);
	Object* rv = (Object*)new_Boolean(ctx, v) /* knh_bool_t v => Boolean rv */;
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__System_getProperty(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Any System.getProperty(String! key)  */
	Object *rv = (Object*)knh_System_getProperty(
		ctx,
		(knh_System_t*)sfp[0].o,
		knh_String_tobytes((String*)sfp[1].o) /* String! sfp[1].o => knh_bytes_t key */
	);
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__System_setProperty(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method void System.setProperty(String! key, Any value)  */
	knh_System_setProperty(
		ctx,
		(knh_System_t*)sfp[0].o,
		(String*)sfp[1].o /* String! sfp[1].o => String* key */,
		(Any*)sfp[2].o /* Any sfp[2].o => Any* value */
	);
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

static
METHOD knh__Tuple2_get__fast(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Any Tuple2.get:fast(Int! index)  */
	Object *rv = (Object*)knh_Tuple2_get__fast(
		(knh_Tuple2_t*)sfp[0].o,
		knh_Int_toint((Int*)sfp[1].o) /* Int! sfp[1].o => knh_int_t index */
	);
	METHOD_RETURN(ctx, sfp, rv);
}

static
METHOD knh__Object_opInstanceof(Ctx *ctx, knh_sfp_t *sfp)
{
	/* method Boolean Object.opInstanceof(Class c)  */
	knh_bool_t v = knh_Object_opInstanceof(
		ctx,
		(knh_Object_t*)sfp[0].o,
		knh_Class_cid((Class*)sfp[1].o) /* Class sfp[1].o => knh_class_t c */
	);
	Object* rv = (Object*)new_Boolean(ctx, v) /* knh_bool_t v => Boolean rv */;
	METHOD_RETURN(ctx, sfp, rv);
}

/* ======================================================================== */
/* [TABLE] */

INLINE static
void KNH_TMAPPER_Array_Iterator(
	Ctx *ctx,
	knh_flag_t flag,
	knh_class_t scid,
	knh_class_t tcid,
	knh_Iterator_t* (*fmapfunc)(Ctx *, knh_Array_t*, knh_Mapper_t *),
	Object *mapopt) {
	KNH_TMAPPER(ctx, flag, scid, tcid, (f_mapper)fmapfunc, mapopt);
}

INLINE static
void KNH_TMAPPER_Iterator_Array(
	Ctx *ctx,
	knh_flag_t flag,
	knh_class_t scid,
	knh_class_t tcid,
	knh_Array_t* (*fmapfunc)(Ctx *, knh_Iterator_t*, knh_Mapper_t *),
	Object *mapopt) {
	KNH_TMAPPER(ctx, flag, scid, tcid, (f_mapper)fmapfunc, mapopt);
}

INLINE static
void KNH_TMAPPER_Boolean_String(
	Ctx *ctx,
	knh_flag_t flag,
	knh_class_t scid,
	knh_class_t tcid,
	knh_String_t* (*fmapfunc)(Ctx *, knh_Boolean_t*, knh_Mapper_t *),
	Object *mapopt) {
	KNH_TMAPPER(ctx, flag, scid, tcid, (f_mapper)fmapfunc, mapopt);
}

INLINE static
void KNH_TMAPPER_Bytes_String(
	Ctx *ctx,
	knh_flag_t flag,
	knh_class_t scid,
	knh_class_t tcid,
	knh_String_t* (*fmapfunc)(Ctx *, knh_Bytes_t*, knh_Mapper_t *),
	Object *mapopt) {
	KNH_TMAPPER(ctx, flag, scid, tcid, (f_mapper)fmapfunc, mapopt);
}

INLINE static
void KNH_TMAPPER_String_Bytes(
	Ctx *ctx,
	knh_flag_t flag,
	knh_class_t scid,
	knh_class_t tcid,
	knh_Bytes_t* (*fmapfunc)(Ctx *, knh_String_t*, knh_Mapper_t *),
	Object *mapopt) {
	KNH_TMAPPER(ctx, flag, scid, tcid, (f_mapper)fmapfunc, mapopt);
}

INLINE static
void KNH_TMAPPER_DictMap_Iterator(
	Ctx *ctx,
	knh_flag_t flag,
	knh_class_t scid,
	knh_class_t tcid,
	knh_Iterator_t* (*fmapfunc)(Ctx *, knh_DictMap_t*, knh_Mapper_t *),
	Object *mapopt) {
	KNH_TMAPPER(ctx, flag, scid, tcid, (f_mapper)fmapfunc, mapopt);
}

INLINE static
void KNH_TMAPPER_DictSet_Iterator(
	Ctx *ctx,
	knh_flag_t flag,
	knh_class_t scid,
	knh_class_t tcid,
	knh_Iterator_t* (*fmapfunc)(Ctx *, knh_DictSet_t*, knh_Mapper_t *),
	Object *mapopt) {
	KNH_TMAPPER(ctx, flag, scid, tcid, (f_mapper)fmapfunc, mapopt);
}

INLINE static
void KNH_TMAPPER_String_Float(
	Ctx *ctx,
	knh_flag_t flag,
	knh_class_t scid,
	knh_class_t tcid,
	knh_Float_t* (*fmapfunc)(Ctx *, knh_String_t*, knh_Mapper_t *),
	Object *mapopt) {
	KNH_TMAPPER(ctx, flag, scid, tcid, (f_mapper)fmapfunc, mapopt);
}

INLINE static
void KNH_TMAPPER_Float_String(
	Ctx *ctx,
	knh_flag_t flag,
	knh_class_t scid,
	knh_class_t tcid,
	knh_String_t* (*fmapfunc)(Ctx *, knh_Float_t*, knh_Mapper_t *),
	Object *mapopt) {
	KNH_TMAPPER(ctx, flag, scid, tcid, (f_mapper)fmapfunc, mapopt);
}

INLINE static
void KNH_TMAPPER_Int_Float(
	Ctx *ctx,
	knh_flag_t flag,
	knh_class_t scid,
	knh_class_t tcid,
	knh_Float_t* (*fmapfunc)(Ctx *, knh_Int_t*, knh_Mapper_t *),
	Object *mapopt) {
	KNH_TMAPPER(ctx, flag, scid, tcid, (f_mapper)fmapfunc, mapopt);
}

INLINE static
void KNH_TMAPPER_Float_Int(
	Ctx *ctx,
	knh_flag_t flag,
	knh_class_t scid,
	knh_class_t tcid,
	knh_Int_t* (*fmapfunc)(Ctx *, knh_Float_t*, knh_Mapper_t *),
	Object *mapopt) {
	KNH_TMAPPER(ctx, flag, scid, tcid, (f_mapper)fmapfunc, mapopt);
}

INLINE static
void KNH_TMAPPER_HashMap_Iterator(
	Ctx *ctx,
	knh_flag_t flag,
	knh_class_t scid,
	knh_class_t tcid,
	knh_Iterator_t* (*fmapfunc)(Ctx *, knh_HashMap_t*, knh_Mapper_t *),
	Object *mapopt) {
	KNH_TMAPPER(ctx, flag, scid, tcid, (f_mapper)fmapfunc, mapopt);
}

INLINE static
void KNH_TMAPPER_HashSet_Iterator(
	Ctx *ctx,
	knh_flag_t flag,
	knh_class_t scid,
	knh_class_t tcid,
	knh_Iterator_t* (*fmapfunc)(Ctx *, knh_HashSet_t*, knh_Mapper_t *),
	Object *mapopt) {
	KNH_TMAPPER(ctx, flag, scid, tcid, (f_mapper)fmapfunc, mapopt);
}

INLINE static
void KNH_TMAPPER_InputStream_String(
	Ctx *ctx,
	knh_flag_t flag,
	knh_class_t scid,
	knh_class_t tcid,
	knh_Iterator_t* (*fmapfunc)(Ctx *, knh_InputStream_t*, knh_Mapper_t *),
	Object *mapopt) {
	KNH_TMAPPER(ctx, flag, scid, tcid, (f_mapper)fmapfunc, mapopt);
}

INLINE static
void KNH_TMAPPER_String_Int(
	Ctx *ctx,
	knh_flag_t flag,
	knh_class_t scid,
	knh_class_t tcid,
	knh_Int_t* (*fmapfunc)(Ctx *, knh_String_t*, knh_Mapper_t *),
	Object *mapopt) {
	KNH_TMAPPER(ctx, flag, scid, tcid, (f_mapper)fmapfunc, mapopt);
}

INLINE static
void KNH_TMAPPER_Int_String(
	Ctx *ctx,
	knh_flag_t flag,
	knh_class_t scid,
	knh_class_t tcid,
	knh_String_t* (*fmapfunc)(Ctx *, knh_Int_t*, knh_Mapper_t *),
	Object *mapopt) {
	KNH_TMAPPER(ctx, flag, scid, tcid, (f_mapper)fmapfunc, mapopt);
}

INLINE static
void KNH_TMAPPER_Object_String(
	Ctx *ctx,
	knh_flag_t flag,
	knh_class_t scid,
	knh_class_t tcid,
	knh_String_t* (*fmapfunc)(Ctx *, knh_Object_t*, knh_Mapper_t *),
	Object *mapopt) {
	KNH_TMAPPER(ctx, flag, scid, tcid, (f_mapper)fmapfunc, mapopt);
}

INLINE static
void KNH_TMAPPER_Object_Iterator(
	Ctx *ctx,
	knh_flag_t flag,
	knh_class_t scid,
	knh_class_t tcid,
	knh_Iterator_t* (*fmapfunc)(Ctx *, knh_Object_t*, knh_Mapper_t *),
	Object *mapopt) {
	KNH_TMAPPER(ctx, flag, scid, tcid, (f_mapper)fmapfunc, mapopt);
}

/* ======================================================================== */
/* [package] */

void knh_konoha_initapis(Ctx *ctx)
{

	KNH_TMETHOD(ctx, 
		0, 
		knh__Array_new, NULL, /*delta*/0, 
		CLASS_Array, METHODN_new,
		MF_nThis_Int
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Array_new__array, NULL, /*delta*/0, 
		CLASS_Array, METHODN_new__array,
		MF_nThis_Int_Any1
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS, 
		knh__Array_new__init, NULL, /*delta*/0, 
		CLASS_Array, METHODN_new__init,
		MF_nThis_Any1_
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Array_add, NULL, /*delta*/0, 
		CLASS_Array, METHODN_add,
		MF_void_Any1
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS, 
		knh__Array_opLShift, NULL, /*delta*/0, 
		CLASS_Array, METHODN_opLShift,
		MF_void_Any1_
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Array_getSize, NULL, /*delta*/0, 
		CLASS_Array, METHODN_getSize,
		MF_nInt
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Array_get, NULL, /*delta*/0, 
		CLASS_Array, METHODN_get,
		MF_Any1_nInt
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Array_set, NULL, /*delta*/0, 
		CLASS_Array, METHODN_set,
		MF_void_nInt_Any1
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Array_pop, NULL, /*delta*/0, 
		CLASS_Array, METHODN_pop,
		MF_Any1
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Array_insert, NULL, /*delta*/0, 
		CLASS_Array, METHODN_insert,
		MF_void_nInt_Any1
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Array_remove, NULL, /*delta*/0, 
		CLASS_Array, METHODN_remove,
		MF_void_nInt
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Array_clear, NULL, /*delta*/0, 
		CLASS_Array, METHODN_clear,
		MF_void
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Array_set__opSubset, NULL, /*delta*/0, 
		CLASS_Array, METHODN_opSubset,
		MF_nThis_Int_Int
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Array_set__opSlice, NULL, /*delta*/0, 
		CLASS_Array, METHODN_opSlice,
		MF_nThis_Int_Int
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Array_set__opOffset, NULL, /*delta*/0, 
		CLASS_Array, METHODN_opOffset,
		MF_nThis_Int_Int
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Array__k, /*delta*/0, 
		CLASS_Array, METHODN__k,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Boolean_opEq, NULL, /*delta*/0, 
		CLASS_Boolean, METHODN_opEq,
		MF_nBoolean_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Boolean_opNeq, NULL, /*delta*/0, 
		CLASS_Boolean, METHODN_opNeq,
		MF_nBoolean_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Boolean__s, /*delta*/0, 
		CLASS_Boolean, METHODN__s,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Bytes_new, NULL, /*delta*/0, 
		CLASS_Bytes, METHODN_new,
		MF_nBytes_Int
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_BytesConv__k, /*delta*/0, 
		CLASS_BytesConv, METHODN__k,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Class__s, /*delta*/0, 
		CLASS_Class, METHODN__s,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Class__dump, /*delta*/0, 
		CLASS_Class, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_ClassMap__dump, /*delta*/0, 
		CLASS_ClassMap, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Connection_close, NULL, /*delta*/0, 
		CLASS_Connection, METHODN_close,
		MF_void
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Connection_new, NULL, /*delta*/0, 
		CLASS_Connection, METHODN_new,
		MF_nConnection_nString
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Connection_query, NULL, /*delta*/0, 
		CLASS_Connection, METHODN_query,
		MF_ResultSet_nString
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Context_getProperty, NULL, /*delta*/0, 
		CLASS_Context, METHODN_getProperty,
		MF_Any_nString
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Context_setProperty, NULL, /*delta*/0, 
		CLASS_Context, METHODN_setProperty,
		MF_void_nString_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Context_setEncoding, NULL, /*delta*/0, 
		CLASS_Context, METHODN_setEncoding,
		MF_void_String
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Context__dump, /*delta*/0, 
		CLASS_Context, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__DictIdx_index, NULL, /*delta*/0, 
		CLASS_DictIdx, METHODN_index,
		MF_nInt_nString
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__DictIdx_add__fast, NULL, /*delta*/0, 
		CLASS_DictIdx, METHODN_add__fast,
		MF_nInt_nString
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__DictIdx_add, NULL, /*delta*/0, 
		CLASS_DictIdx, METHODN_add,
		MF_nInt_nString
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__DictIdx_get__fast, NULL, /*delta*/0, 
		CLASS_DictIdx, METHODN_get__fast,
		MF_String_nInt
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__DictIdx_get, NULL, /*delta*/0, 
		CLASS_DictIdx, METHODN_get,
		MF_String_nInt
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__DictIdx_clear, NULL, /*delta*/0, 
		CLASS_DictIdx, METHODN_clear,
		MF_void
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_DictIdx__k, /*delta*/0, 
		CLASS_DictIdx, METHODN__k,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__DictMap_new, NULL, /*delta*/0, 
		CLASS_DictMap, METHODN_new,
		MF_nDictMap_Int
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__DictMap_get, NULL, /*delta*/0, 
		CLASS_DictMap, METHODN_get,
		MF_Any_nString
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__DictMap_append, NULL, /*delta*/0, 
		CLASS_DictMap, METHODN_append,
		MF_void_nString_nAny
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__DictMap_set, NULL, /*delta*/0, 
		CLASS_DictMap, METHODN_set,
		MF_void_nString_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__DictMap_remove, NULL, /*delta*/0, 
		CLASS_DictMap, METHODN_remove,
		MF_void_nString
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__DictMap_clear, NULL, /*delta*/0, 
		CLASS_DictMap, METHODN_clear,
		MF_void
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_DictMap__dump, /*delta*/0, 
		CLASS_DictMap, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__DictSet_new, NULL, /*delta*/0, 
		CLASS_DictSet, METHODN_new,
		MF_nDictSet_Int
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__DictSet_get, NULL, /*delta*/0, 
		CLASS_DictSet, METHODN_get,
		MF_nInt_nString
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__DictSet_opIn, NULL, /*delta*/0, 
		CLASS_DictSet, METHODN_opIn,
		MF_Boolean_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__DictSet_set, NULL, /*delta*/0, 
		CLASS_DictSet, METHODN_set,
		MF_void_nString_nInt
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__DictSet_add, NULL, /*delta*/0, 
		CLASS_DictSet, METHODN_add,
		MF_void_nString
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__DictSet_clear, NULL, /*delta*/0, 
		CLASS_DictSet, METHODN_clear,
		MF_void
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_DictSet__dump, /*delta*/0, 
		CLASS_DictSet, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Exception__s, /*delta*/0, 
		CLASS_Exception, METHODN__s,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Exception__dump, /*delta*/0, 
		CLASS_Exception, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Float_opAdd__2, NULL, /*delta*/0, 
		CLASS_Float, METHODN_opAdd__2,
		MF_nFloat_nFloat
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Float_opNg, NULL, /*delta*/0, 
		CLASS_Float, METHODN_opNeg,
		MF_nFloat
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Float_opSub__2, NULL, /*delta*/0, 
		CLASS_Float, METHODN_opSub__2,
		MF_nFloat_nFloat
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Float_opMul__2, NULL, /*delta*/0, 
		CLASS_Float, METHODN_opMul__2,
		MF_nFloat_nFloat
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Float_opDiv__2, NULL, /*delta*/0, 
		CLASS_Float, METHODN_opDiv__2,
		MF_nFloat_nFloat
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC, 
		knh__Float_opAdd, NULL, /*delta*/0, 
		CLASS_Float, METHODN_opAdd,
		MF_nFloat_nFloat_
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC, 
		knh__Float_opSub, NULL, /*delta*/0, 
		CLASS_Float, METHODN_opSub,
		MF_nFloat_nFloat_
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC, 
		knh__Float_opMul, NULL, /*delta*/0, 
		CLASS_Float, METHODN_opMul,
		MF_nFloat_nFloat_
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC, 
		knh__Float_opDiv, NULL, /*delta*/0, 
		CLASS_Float, METHODN_opDiv,
		MF_nFloat_nFloat_
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Float_opMod, NULL, /*delta*/0, 
		CLASS_Float, METHODN_opMod,
		MF_nFloat_nFloat
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Float_opEq, NULL, /*delta*/0, 
		CLASS_Float, METHODN_opEq,
		MF_nBoolean_nFloat
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Float_opNeq, NULL, /*delta*/0, 
		CLASS_Float, METHODN_opNeq,
		MF_nBoolean_nFloat
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Float_opLt, NULL, /*delta*/0, 
		CLASS_Float, METHODN_opLt,
		MF_nBoolean_nFloat
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Float_opLte, NULL, /*delta*/0, 
		CLASS_Float, METHODN_opLte,
		MF_nBoolean_nFloat
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Float_opGt, NULL, /*delta*/0, 
		CLASS_Float, METHODN_opGt,
		MF_nBoolean_nFloat
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Float_opGte, NULL, /*delta*/0, 
		CLASS_Float, METHODN_opGte,
		MF_nBoolean_nFloat
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Float_opNext, NULL, /*delta*/0, 
		CLASS_Float, METHODN_opNext,
		MF_nFloat
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Float_opPrev, NULL, /*delta*/0, 
		CLASS_Float, METHODN_opPrev,
		MF_nFloat
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_CLASS, 
		knh__Float_random, NULL, /*delta*/0, 
		CLASS_Float, METHODN_random,
		MF_Float
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Float__s, /*delta*/0, 
		CLASS_Float, METHODN__s,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Float__k, /*delta*/0, 
		CLASS_Float, METHODN__k,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Float__dump, /*delta*/0, 
		CLASS_Float, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__HashMap_get, NULL, /*delta*/0, 
		CLASS_HashMap, METHODN_get,
		MF_Any2_Any1
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__HashMap_set, NULL, /*delta*/0, 
		CLASS_HashMap, METHODN_set,
		MF_void_Any1_Any2
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__HashMap_remove, NULL, /*delta*/0, 
		CLASS_HashMap, METHODN_remove,
		MF_void_Any1
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__HashMap_new, NULL, /*delta*/0, 
		CLASS_HashMap, METHODN_new,
		MF_nHashMap_Int
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS, 
		knh__HashMap_new__init, NULL, /*delta*/0, 
		CLASS_HashMap, METHODN_new__init,
		MF_nHashMap_Any_
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__HashMap_opIn, NULL, /*delta*/0, 
		CLASS_HashMap, METHODN_opIn,
		MF_Boolean_Any1
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_HashMap__dump, /*delta*/0, 
		CLASS_HashMap, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__HashMap_keys, NULL, /*delta*/0, 
		CLASS_HashMap, METHODN_keys,
		MF_nIterator
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__HashSet_get, NULL, /*delta*/0, 
		CLASS_HashSet, METHODN_get,
		MF_nInt_Any1
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__HashSet_set, NULL, /*delta*/0, 
		CLASS_HashSet, METHODN_set,
		MF_void_Any1_nInt
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__HashSet_add, NULL, /*delta*/0, 
		CLASS_HashSet, METHODN_add,
		MF_void_Any1
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__HashSet_remove, NULL, /*delta*/0, 
		CLASS_HashSet, METHODN_remove,
		MF_void_Any1
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__HashSet_new, NULL, /*delta*/0, 
		CLASS_HashSet, METHODN_new,
		MF_nHashSet_Int
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__HashSet_opIn, NULL, /*delta*/0, 
		CLASS_HashSet, METHODN_opIn,
		MF_Boolean_Any1
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_HashSet__dump, /*delta*/0, 
		CLASS_HashSet, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__InputStream_readLine, NULL, /*delta*/0, 
		CLASS_InputStream, METHODN_readLine,
		MF_String
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__InputStream_close, NULL, /*delta*/0, 
		CLASS_InputStream, METHODN_close,
		MF_void
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__InputStream_setEncoding, NULL, /*delta*/0, 
		CLASS_InputStream, METHODN_setEncoding,
		MF_void_String
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_InputStream__dump, /*delta*/0, 
		CLASS_InputStream, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_InputStream__k, /*delta*/0, 
		CLASS_InputStream, METHODN__k,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Int64__dump, /*delta*/0, 
		CLASS_Int64, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opAdd__2, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opAdd__2,
		MF_nInt_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opNg, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opNeg,
		MF_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opSub__2, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opSub__2,
		MF_nInt_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opMul__2, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opMul__2,
		MF_nInt_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opDiv__2, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opDiv__2,
		MF_nInt_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC, 
		knh__Int_opAdd, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opAdd,
		MF_nInt_nInt_
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC, 
		knh__Int_opSub, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opSub,
		MF_nInt_nInt_
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC, 
		knh__Int_opMul, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opMul,
		MF_nInt_nInt_
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC, 
		knh__Int_opDiv, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opDiv,
		MF_nInt_nInt_
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opMod, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opMod,
		MF_nInt_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opEq, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opEq,
		MF_nBoolean_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opNeq, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opNeq,
		MF_nBoolean_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opLt, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opLt,
		MF_nBoolean_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opLte, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opLte,
		MF_nBoolean_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opGt, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opGt,
		MF_nBoolean_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opGte, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opGte,
		MF_nBoolean_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opLogicalAnd, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opLogicalAnd,
		MF_nInt_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opLogicalOr, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opLogicalOr,
		MF_nInt_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opLogicalXor, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opLogicalXor,
		MF_nInt_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opLogicalNot, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opLogicalNot,
		MF_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opLShift, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opLShift,
		MF_nInt_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opRShift, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opRShift,
		MF_nInt_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opNext, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opNext,
		MF_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Int_opPrev, NULL, /*delta*/0, 
		CLASS_Int, METHODN_opPrev,
		MF_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_NULLBASE|KNH_FLAG_MF_STATIC, 
		knh__Int_abs, NULL, /*delta*/0, 
		CLASS_Int, METHODN_abs,
		MF_nInt
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Int_random, NULL, /*delta*/0, 
		CLASS_Int, METHODN_random,
		MF_nInt_Int
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Int__s, /*delta*/0, 
		CLASS_Int, METHODN__s,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Int__x, /*delta*/0, 
		CLASS_Int, METHODN__x,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Int__bits, /*delta*/0, 
		CLASS_Int, METHODN__bits,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC|KNH_FLAG_MF_SMART, 
		knh__IntX_opAdd__2, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opAdd__2,
		MF_nInt_nInt_Class
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC|KNH_FLAG_MF_SMART, 
		knh__IntX_opSub__2, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opSub__2,
		MF_nInt_nInt_Class
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC|KNH_FLAG_MF_SMART, 
		knh__IntX_opMul__2, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opMul__2,
		MF_nInt_nInt_Class
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC|KNH_FLAG_MF_SMART, 
		knh__IntX_opDiv__2, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opDiv__2,
		MF_nInt_nInt_Class
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC|KNH_FLAG_MF_SMART, 
		knh__IntX_opAdd, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opAdd,
		MF_nInt_nInt_
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC|KNH_FLAG_MF_SMART, 
		knh__IntX_opSub, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opSub,
		MF_nInt_nInt_
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC|KNH_FLAG_MF_SMART, 
		knh__IntX_opMul, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opMul,
		MF_nInt_nInt_
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC|KNH_FLAG_MF_SMART, 
		knh__IntX_opDiv, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opDiv,
		MF_nInt_nInt_
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__IntX_opMod, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opMod,
		MF_nInt_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__IntX_opEq, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opEq,
		MF_Boolean_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__IntX_opNeq, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opNeq,
		MF_Boolean_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__IntX_opLt, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opLt,
		MF_nBoolean_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__IntX_opLte, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opLte,
		MF_nBoolean_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__IntX_opGt, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opGt,
		MF_nBoolean_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__IntX_opGte, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opGte,
		MF_nBoolean_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__IntX_opLogicalAnd, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opLogicalAnd,
		MF_nInt_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__IntX_opLogicalOr, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opLogicalOr,
		MF_nInt_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__IntX_opLogicalXor, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opLogicalXor,
		MF_nInt_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__IntX_opLogicalNot, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opLogicalNot,
		MF_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__IntX_opLShift, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opLShift,
		MF_nInt_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__IntX_opRShift, NULL, /*delta*/0, 
		CLASS_IntX, METHODN_opRShift,
		MF_nInt_nInt
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_IntX__s, /*delta*/0, 
		CLASS_IntX, METHODN__s,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_IntX__x, /*delta*/0, 
		CLASS_IntX, METHODN__x,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_IntX__bits, /*delta*/0, 
		CLASS_IntX, METHODN__bits,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_IntX__dump, /*delta*/0, 
		CLASS_IntX, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Iterator__dump, /*delta*/0, 
		CLASS_Iterator, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Mapper__k, /*delta*/0, 
		CLASS_Mapper, METHODN__k,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Method_isAbstract, NULL, /*delta*/0, 
		CLASS_Method, METHODN_isAbstract,
		MF_Boolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Method_getName, NULL, /*delta*/0, 
		CLASS_Method, METHODN_getName,
		MF_nString
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Method_getURN, NULL, /*delta*/0, 
		CLASS_Method, METHODN_getURN,
		MF_nString
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Method__s, /*delta*/0, 
		CLASS_Method, METHODN__s,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Method__k, /*delta*/0, 
		CLASS_Method, METHODN__k,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Method__dump, /*delta*/0, 
		CLASS_Method, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Nue__s, /*delta*/0, 
		CLASS_Nue, METHODN__s,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Nue__k, /*delta*/0, 
		CLASS_Nue, METHODN__k,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Number_opAdd__2, NULL, /*delta*/0, 
		CLASS_Number, METHODN_opAdd__2,
		MF_nFloat_nNumber
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Number_opSub__2, NULL, /*delta*/0, 
		CLASS_Number, METHODN_opSub__2,
		MF_nFloat_nNumber
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Number_opMul__2, NULL, /*delta*/0, 
		CLASS_Number, METHODN_opMul__2,
		MF_nFloat_nNumber
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Number_opDiv__2, NULL, /*delta*/0, 
		CLASS_Number, METHODN_opDiv__2,
		MF_nFloat_nNumber
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC, 
		knh__Number_opAdd, NULL, /*delta*/0, 
		CLASS_Number, METHODN_opAdd,
		MF_nFloat_nNumber_
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC, 
		knh__Number_opSub, NULL, /*delta*/0, 
		CLASS_Number, METHODN_opSub,
		MF_nFloat_nNumber_
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC, 
		knh__Number_opMul, NULL, /*delta*/0, 
		CLASS_Number, METHODN_opMul,
		MF_nFloat_nNumber_
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC, 
		knh__Number_opDiv, NULL, /*delta*/0, 
		CLASS_Number, METHODN_opDiv,
		MF_nFloat_nNumber_
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Number_opEq, NULL, /*delta*/0, 
		CLASS_Number, METHODN_opEq,
		MF_nBoolean_nNumber
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Number_opNeq, NULL, /*delta*/0, 
		CLASS_Number, METHODN_opNeq,
		MF_nBoolean_nNumber
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Number_opLt, NULL, /*delta*/0, 
		CLASS_Number, METHODN_opLt,
		MF_nBoolean_nNumber
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Number_opLte, NULL, /*delta*/0, 
		CLASS_Number, METHODN_opLte,
		MF_nBoolean_nNumber
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Number_opGt, NULL, /*delta*/0, 
		CLASS_Number, METHODN_opGt,
		MF_nBoolean_nNumber
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Number_opGte, NULL, /*delta*/0, 
		CLASS_Number, METHODN_opGte,
		MF_nBoolean_nNumber
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS, 
		knh__Object_new__init, NULL, /*delta*/0, 
		CLASS_Object, METHODN_new__init,
		MF_nThis_Any1_
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Object_getDefault, NULL, /*delta*/0, 
		CLASS_Object, METHODN_getDefault,
		MF_nThis
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Object_compareTo, NULL, /*delta*/0, 
		CLASS_Object, METHODN_compareTo,
		MF_nInt_Any
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Object_opEq, NULL, /*delta*/0, 
		CLASS_Object, METHODN_opEq,
		MF_Boolean_Any
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Object_opNeq, NULL, /*delta*/0, 
		CLASS_Object, METHODN_opNeq,
		MF_Boolean_Any
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Object_opLt, NULL, /*delta*/0, 
		CLASS_Object, METHODN_opLt,
		MF_Boolean_Any
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Object_opLte, NULL, /*delta*/0, 
		CLASS_Object, METHODN_opLte,
		MF_Boolean_Any
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Object_opGt, NULL, /*delta*/0, 
		CLASS_Object, METHODN_opGt,
		MF_Boolean_Any
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Object_opGte, NULL, /*delta*/0, 
		CLASS_Object, METHODN_opGte,
		MF_Boolean_Any
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Object_opNot, NULL, /*delta*/0, 
		CLASS_Object, METHODN_opNot,
		MF_Boolean
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Object_opSeq, NULL, /*delta*/0, 
		CLASS_Object, METHODN_opSeq,
		MF_Boolean_Any
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Object_opIsMapTo, NULL, /*delta*/0, 
		CLASS_Object, METHODN_opIsMapTo,
		MF_Boolean_Any
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Object_getClass, NULL, /*delta*/0, 
		CLASS_Object, METHODN_getClass,
		MF_Class
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Object_opItr, NULL, /*delta*/0, 
		CLASS_Object, METHODN_opItr,
		MF_This
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Object__s, /*delta*/0, 
		CLASS_Object, METHODN__s,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Object__k, /*delta*/0, 
		CLASS_Object, METHODN__k,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Object__dump, /*delta*/0, 
		CLASS_Object, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Object__empty, /*delta*/0, 
		CLASS_Object, METHODN__empty,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Object__refc, /*delta*/0, 
		CLASS_Object, METHODN__refc,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Object__addr, /*delta*/0, 
		CLASS_Object, METHODN__addr,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__OutputStream_flush, NULL, /*delta*/0, 
		CLASS_OutputStream, METHODN_flush,
		MF_void
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__OutputStream_close, NULL, /*delta*/0, 
		CLASS_OutputStream, METHODN_close,
		MF_void
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__OutputStream_write, NULL, /*delta*/0, 
		CLASS_OutputStream, METHODN_write,
		MF_void_nBytes_Int_Int
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__OutputStream_setEncoding, NULL, /*delta*/0, 
		CLASS_OutputStream, METHODN_setEncoding,
		MF_void_String
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__OutputStream_print, NULL, /*delta*/0, 
		CLASS_OutputStream, METHODN_print,
		MF_void_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__OutputStream_println, NULL, /*delta*/0, 
		CLASS_OutputStream, METHODN_println,
		MF_void_Any
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS, 
		knh__OutputStream_opLShift, NULL, /*delta*/0, 
		CLASS_OutputStream, METHODN_opLShift,
		MF_void_Any_
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_OutputStream__k, /*delta*/0, 
		CLASS_OutputStream, METHODN__k,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Range_new, NULL, /*delta*/0, 
		CLASS_Range, METHODN_new,
		MF_nRange_Any1_Any1
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Range_new__slice, NULL, /*delta*/0, 
		CLASS_Range, METHODN_new__slice,
		MF_nRange_Any1_Any1
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Range_new__offset, NULL, /*delta*/0, 
		CLASS_Range, METHODN_new__offset,
		MF_nRange_Any1_Int
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__ResultSet_next, NULL, /*delta*/0, 
		CLASS_ResultSet, METHODN_next,
		MF_ResultSet
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_ResultSet__dump, /*delta*/0, 
		CLASS_ResultSet, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Script__k, /*delta*/0, 
		CLASS_Script, METHODN__k,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Script__dump, /*delta*/0, 
		CLASS_Script, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__String_equals, NULL, /*delta*/0, 
		CLASS_String, METHODN_equals,
		MF_nBoolean_nString
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__String_startsWith, NULL, /*delta*/0, 
		CLASS_String, METHODN_startsWith,
		MF_nBoolean_nString
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__String_endsWith, NULL, /*delta*/0, 
		CLASS_String, METHODN_endsWith,
		MF_nBoolean_nString
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__String_indexOf, NULL, /*delta*/0, 
		CLASS_String, METHODN_indexOf,
		MF_nInt_nString
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC|KNH_FLAG_MF_NULLBASE, 
		knh__String_getSize, NULL, /*delta*/0, 
		CLASS_String, METHODN_getSize,
		MF_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC|KNH_FLAG_MF_NULLBASE, 
		knh__String_opAdd__2, NULL, /*delta*/0, 
		CLASS_String, METHODN_opAdd__2,
		MF_nString_Any
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC|KNH_FLAG_MF_NULLBASE, 
		knh__String_opAdd, NULL, /*delta*/0, 
		CLASS_String, METHODN_opAdd,
		MF_nString_Any_
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__String_opSub__2, NULL, /*delta*/0, 
		CLASS_String, METHODN_opSub__2,
		MF_nString_nString
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__String_replace__once, NULL, /*delta*/0, 
		CLASS_String, METHODN_replace__once,
		MF_nString_nString_nString
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__String_replace, NULL, /*delta*/0, 
		CLASS_String, METHODN_replace,
		MF_nString_nString_nString
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__String_opMul__2, NULL, /*delta*/0, 
		CLASS_String, METHODN_opMul__2,
		MF_nString_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC|KNH_FLAG_MF_NULLBASE, 
		knh__String_opMul, NULL, /*delta*/0, 
		CLASS_String, METHODN_opMul,
		MF_nString_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC|KNH_FLAG_MF_NULLBASE, 
		knh__String_opDiv__2, NULL, /*delta*/0, 
		CLASS_String, METHODN_opDiv__2,
		MF_nString_String
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC|KNH_FLAG_MF_NULLBASE, 
		knh__String_opDiv, NULL, /*delta*/0, 
		CLASS_String, METHODN_opDiv,
		MF_nString_String
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC|KNH_FLAG_MF_NULLBASE, 
		knh__String_opMod, NULL, /*delta*/0, 
		CLASS_String, METHODN_opMod,
		MF_nString_String
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__String_get, NULL, /*delta*/0, 
		CLASS_String, METHODN_get,
		MF_nString_nInt
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__String_opOffset, NULL, /*delta*/0, 
		CLASS_String, METHODN_opOffset,
		MF_nString_Int_Int
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__String_toLower, NULL, /*delta*/0, 
		CLASS_String, METHODN_toLower,
		MF_nString
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__String_toUpper, NULL, /*delta*/0, 
		CLASS_String, METHODN_toUpper,
		MF_nString
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__String_trim, NULL, /*delta*/0, 
		CLASS_String, METHODN_trim,
		MF_nString
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__String_split, NULL, /*delta*/0, 
		CLASS_String, METHODN_split,
		MF_aString_String
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_String__s, /*delta*/0, 
		CLASS_String, METHODN__s,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_String__k, /*delta*/0, 
		CLASS_String, METHODN__k,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__System_getProperty, NULL, /*delta*/0, 
		CLASS_System, METHODN_getProperty,
		MF_Any_nString
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__System_setProperty, NULL, /*delta*/0, 
		CLASS_System, METHODN_setProperty,
		MF_void_nString_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_System__dump, /*delta*/0, 
		CLASS_System, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__System_getIn, NULL, /*delta*/0, 
		CLASS_System, METHODN_getIn,
		MF_nInputStream
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__System_setIn, NULL, /*delta*/0, 
		CLASS_System, METHODN_setIn,
		MF_void_InputStream
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__System_getOut, NULL, /*delta*/0, 
		CLASS_System, METHODN_getOut,
		MF_nOutputStream
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__System_setOut, NULL, /*delta*/0, 
		CLASS_System, METHODN_setOut,
		MF_void_OutputStream
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__System_getErr, NULL, /*delta*/0, 
		CLASS_System, METHODN_getErr,
		MF_nOutputStream
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__System_setErr, NULL, /*delta*/0, 
		CLASS_System, METHODN_setErr,
		MF_void_OutputStream
	);

	KNH_TMETHOD(ctx, 
		KNH_FLAG_MF_STATIC, 
		knh__Tuple_new, NULL, /*delta*/0, 
		CLASS_Tuple2, METHODN_new,
		MF_nTuple2_Any1_Any2
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Tuple2_getSize, NULL, /*delta*/0, 
		CLASS_Tuple2, METHODN_getSize,
		MF_nInt
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Tuple2_get__fast, NULL, /*delta*/0, 
		CLASS_Tuple2, METHODN_get__fast,
		MF_Any_nInt
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Tuple2__dump, /*delta*/0, 
		CLASS_Tuple2, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Object_opInstanceof, NULL, /*delta*/0, 
		CLASS_Object, METHODN_opInstanceof,
		MF_Boolean_Class
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Object_isRelease, NULL, /*delta*/0, 
		CLASS_Object, METHODN_isRelease,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Object_isDebug, NULL, /*delta*/0, 
		CLASS_Object, METHODN_isDebug,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Object_isImmutable, NULL, /*delta*/0, 
		CLASS_Object, METHODN_isImmutable,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Object_hasMetaData, NULL, /*delta*/0, 
		CLASS_Object, METHODN_hasMetaData,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Object_isSynchronized, NULL, /*delta*/0, 
		CLASS_Object, METHODN_isSynchronized,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Object_isModified, NULL, /*delta*/0, 
		CLASS_Object, METHODN_isModified,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Object_setModified, NULL, /*delta*/0, 
		CLASS_Object, METHODN_setModified,
		MF_void_Boolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Object_isGCMarked, NULL, /*delta*/0, 
		CLASS_Object, METHODN_isGCMarked,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Object_setGCMarked, NULL, /*delta*/0, 
		CLASS_Object, METHODN_setGCMarked,
		MF_void_Boolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Object_isFormatted, NULL, /*delta*/0, 
		CLASS_Object, METHODN_isFormatted,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Object_setFormatted, NULL, /*delta*/0, 
		CLASS_Object, METHODN_setFormatted,
		MF_void_Boolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Class_isRelease, NULL, /*delta*/0, 
		CLASS_Class, METHODN_isRelease,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Class_isDebug, NULL, /*delta*/0, 
		CLASS_Class, METHODN_isDebug,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Class_isImmutable, NULL, /*delta*/0, 
		CLASS_Class, METHODN_isImmutable,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Class_isMetaExtensible, NULL, /*delta*/0, 
		CLASS_Class, METHODN_isMetaExtensible,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Class_isPrivate, NULL, /*delta*/0, 
		CLASS_Class, METHODN_isPrivate,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Class_isPublic, NULL, /*delta*/0, 
		CLASS_Class, METHODN_isPublic,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Class_isFinal, NULL, /*delta*/0, 
		CLASS_Class, METHODN_isFinal,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Class_isSystem, NULL, /*delta*/0, 
		CLASS_Class, METHODN_isSystem,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Class_isInterface, NULL, /*delta*/0, 
		CLASS_Class, METHODN_isInterface,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Method_isPublic, NULL, /*delta*/0, 
		CLASS_Method, METHODN_isPublic,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Method_isPrivate, NULL, /*delta*/0, 
		CLASS_Method, METHODN_isPrivate,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Method_isVirtual, NULL, /*delta*/0, 
		CLASS_Method, METHODN_isVirtual,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Method_isFinal, NULL, /*delta*/0, 
		CLASS_Method, METHODN_isFinal,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Method_isStatic, NULL, /*delta*/0, 
		CLASS_Method, METHODN_isStatic,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Method_isClass, NULL, /*delta*/0, 
		CLASS_Method, METHODN_isClass,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Method_isNullBase, NULL, /*delta*/0, 
		CLASS_Method, METHODN_isNullBase,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Method_isVarArgs, NULL, /*delta*/0, 
		CLASS_Method, METHODN_isVarArgs,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Method_isAspect, NULL, /*delta*/0, 
		CLASS_Method, METHODN_isAspect,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Mapper_isInterface, NULL, /*delta*/0, 
		CLASS_Mapper, METHODN_isInterface,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Mapper_isSignificant, NULL, /*delta*/0, 
		CLASS_Mapper, METHODN_isSignificant,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Mapper_isFinal, NULL, /*delta*/0, 
		CLASS_Mapper, METHODN_isFinal,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Mapper_isSynonym, NULL, /*delta*/0, 
		CLASS_Mapper, METHODN_isSynonym,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Mapper_isLossLess, NULL, /*delta*/0, 
		CLASS_Mapper, METHODN_isLossLess,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Mapper_isTotal, NULL, /*delta*/0, 
		CLASS_Mapper, METHODN_isTotal,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Mapper_isPartial, NULL, /*delta*/0, 
		CLASS_Mapper, METHODN_isPartial,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Mapper_isStatic, NULL, /*delta*/0, 
		CLASS_Mapper, METHODN_isStatic,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Mapper_isTemporal, NULL, /*delta*/0, 
		CLASS_Mapper, METHODN_isTemporal,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Mapper_isLocal, NULL, /*delta*/0, 
		CLASS_Mapper, METHODN_isLocal,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Mapper_isDerived, NULL, /*delta*/0, 
		CLASS_Mapper, METHODN_isDerived,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__IntUnit_isUnsigned, NULL, /*delta*/0, 
		CLASS_IntUnit, METHODN_isUnsigned,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__OutputStream_isAutoFlush, NULL, /*delta*/0, 
		CLASS_OutputStream, METHODN_isAutoFlush,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__OutputStream_setAutoFlush, NULL, /*delta*/0, 
		CLASS_OutputStream, METHODN_setAutoFlush,
		MF_void_Boolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Exception_isFatal, NULL, /*delta*/0, 
		CLASS_Exception, METHODN_isFatal,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Exception_isLogging, NULL, /*delta*/0, 
		CLASS_Exception, METHODN_isLogging,
		MF_nBoolean
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh__Exception_isGenerated, NULL, /*delta*/0, 
		CLASS_Exception, METHODN_isGenerated,
		MF_nBoolean
	);

	KNH_TMAPPER_Array_Iterator(ctx, 
		KNH_FLAG_MMF_TOTAL, 
		CLASS_Array, CLASS_Iterator,  
		knh_Array_Iterator, KNH_NULL
	);

	KNH_TMAPPER_Iterator_Array(ctx, 
		KNH_FLAG_MMF_TOTAL, 
		CLASS_Iterator, CLASS_Array,  
		knh_Iterator_Array, KNH_NULL
	);

	KNH_TMAPPER_Boolean_String(ctx, 
		KNH_FLAG_MMF_TOTAL, 
		CLASS_Boolean, CLASS_String,  
		knh_Boolean_String, KNH_NULL
	);

	KNH_TMAPPER_Bytes_String(ctx, 
		0, 
		CLASS_Bytes, CLASS_String,  
		knh_Bytes_String, KNH_NULL
	);

	KNH_TMAPPER_String_Bytes(ctx, 
		KNH_FLAG_MMF_TOTAL, 
		CLASS_String, CLASS_Bytes,  
		knh_String_Bytes, KNH_NULL
	);

	KNH_TMAPPER_DictMap_Iterator(ctx, 
		KNH_FLAG_MMF_TOTAL, 
		CLASS_DictMap, CLASS_Iterator,  
		knh_DictMap_Iterator, KNH_NULL
	);

	KNH_TMAPPER_DictSet_Iterator(ctx, 
		KNH_FLAG_MMF_TOTAL, 
		CLASS_DictSet, CLASS_Iterator,  
		knh_DictSet_Iterator, KNH_NULL
	);

	KNH_TMAPPER_String_Float(ctx, 
		0, 
		CLASS_String, CLASS_Float,  
		knh_String_Float, KNH_NULL
	);

	KNH_TMAPPER_Float_String(ctx, 
		KNH_FLAG_MMF_STATIC|KNH_FLAG_MMF_FINAL|KNH_FLAG_MMF_TOTAL, 
		CLASS_Float, CLASS_String,  
		knh_Float_String, KNH_NULL
	);

	KNH_TMAPPER_Int_Float(ctx, 
		KNH_FLAG_MMF_STATIC|KNH_FLAG_MMF_FINAL|KNH_FLAG_MMF_TOTAL, 
		CLASS_Int, CLASS_Float,  
		knh_Int_Float, KNH_NULL
	);

	KNH_TMAPPER_Float_Int(ctx, 
		KNH_FLAG_MMF_STATIC|KNH_FLAG_MMF_FINAL|KNH_FLAG_MMF_TOTAL, 
		CLASS_Float, CLASS_Int,  
		knh_Float_Int, KNH_NULL
	);

	KNH_TMAPPER_HashMap_Iterator(ctx, 
		KNH_FLAG_MMF_TOTAL, 
		CLASS_HashMap, CLASS_Iterator,  
		knh_HashMap_Iterator, KNH_NULL
	);

	KNH_TMAPPER_HashSet_Iterator(ctx, 
		KNH_FLAG_MMF_TOTAL, 
		CLASS_HashSet, CLASS_Iterator,  
		knh_HashSet_Iterator, KNH_NULL
	);

	KNH_TMAPPER_InputStream_String(ctx, 
		KNH_FLAG_MMF_TOTAL, 
		CLASS_InputStream, ICLASS_String,  
		knh_InputStream_String__, KNH_NULL
	);

	KNH_TMAPPER_String_Int(ctx, 
		KNH_FLAG_MMF_STATIC|KNH_FLAG_MMF_FINAL, 
		CLASS_String, CLASS_Int,  
		knh_String_Int, KNH_NULL
	);

	KNH_TMAPPER_Int_String(ctx, 
		KNH_FLAG_MMF_STATIC|KNH_FLAG_MMF_FINAL|KNH_FLAG_MMF_TOTAL, 
		CLASS_Int, CLASS_String,  
		knh_Int_String, KNH_NULL
	);

	KNH_TMAPPER_Object_String(ctx, 
		KNH_FLAG_MMF_TOTAL, 
		CLASS_Object, CLASS_String,  
		knh_Object_String, KNH_NULL
	);

	KNH_TMAPPER_Object_Iterator(ctx, 
		KNH_FLAG_MMF_TOTAL, 
		CLASS_Object, CLASS_Iterator,  
		knh_Object_Iterator, KNH_NULL
	);

}

#ifdef __cplusplus
}
#endif
