/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [constructor] */

/* ------------------------------------------------------------------------ */
/* @method Bytes! Bytes.new(Int init) */

METHOD knh__Bytes_new(Ctx *ctx, knh_sfp_t *sfp)
{
	Bytes *o = (Bytes*)sfp[0].o;
	size_t init = IS_NULL(sfp[1].o) ? 256 : (sfp[1].i)->value;
	KNH_ASSERT(o->buf == NULL);
	o->buf = knh_barray_malloc(ctx, init);
	o->size = init;
	knh_bzero(o->buf, init);
	METHOD_RETURN(ctx, sfp, o);
}

/* ------------------------------------------------------------------------ */
/* @method void Bytes.add(Int! value) */

METHOD knh__Bytes_add(Ctx *ctx, knh_sfp_t *sfp)
{
	Bytes *o = (Bytes*)sfp[0].o;
	if(!knh_Object_isImmutable(o)) {
		knh_Bytes_putc(ctx, o, (sfp[1].i)->value);
	}
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS] void Bytes.opLShift(Any1 v) */

METHOD knh__Bytes_opLShift(Ctx *ctx, knh_sfp_t *sfp)
{
	Bytes *o = (Bytes*)sfp[0].o;
	if(!knh_Object_isImmutable(o)) {
		knh_sfp_t *v = sfp + 1;
		knh_vargc_t ac = knh_sfp_argc(ctx, v);
		int i;
		for(i = 0; i < ac; i++) {
			knh_Bytes_putc(ctx, o, (v[i].i)->value);
		}
	}
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}

/* ------------------------------------------------------------------------ */
/* @method Int! Bytes.getSize() */

METHOD knh__Bytes_getSize(Ctx *ctx, knh_sfp_t *sfp)
{
	Bytes *o = (Bytes*)sfp[0].o;
	METHOD_RETURN(ctx, sfp, new_Int(ctx, o->size));
}

/* ------------------------------------------------------------------------ */
/* @method Int! Bytes.get(Int! index) */

METHOD knh__Bytes_get(Ctx *ctx, knh_sfp_t *sfp)
{
	Bytes *o = (Bytes*)sfp[0].o;
	size_t n2 = knh_array_index(ctx, (sfp[1].i)->value, o->size);
	METHOD_RETURN(ctx, sfp, new_Int(ctx, o->buf[n2]));
}

/* ------------------------------------------------------------------------ */
/* @method void Bytes.set(Int! index, Int! v) */

METHOD knh__Bytes_set(Ctx *ctx, knh_sfp_t *sfp)
{
	Bytes *o = (Bytes*)sfp[0].o;
	if(!knh_Object_isImmutable(o)) {
		size_t n2 = knh_array_index(ctx, (sfp[1].i)->value, o->size);
		o->buf[n2] = (sfp[2].i)->value;
	}
	METHOD_RETURN(ctx, sfp, KNH_VOID);
}


/* ======================================================================== */
/* [movabletext] */

//* @method void Bytes.%dump(OutputStream w, Any m) */
//
//void knh_Bytes__dump(Ctx *ctx, Bytes *b, OutputStream *w, Any *m)
//{
//	TODO();
//}


/* ======================================================================== */
/* [mapping] */

/* @map Bytes String */

String* knh_Bytes_String(Ctx *ctx, Bytes *o, Mapper *mpr)
{
	knh_bytes_t t = knh_Bytes_tobytes(o);
	if(!knh_bytes_checkENCODING(t)) {
		return (String*)KNH_NULL;
	}
	return new_String(ctx, t, NULL);
}

/* ------------------------------------------------------------------------ */
/* @map String Bytes! */

Bytes* knh_String_Bytes(Ctx *ctx, String *s, Mapper *map)
{
	Bytes *b = new_Bytes(ctx, knh_String_strlen(s) + 1);
	knh_Bytes_write(ctx, b, knh_String_tobytes(s));
	return b;
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
