/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [constructor] */

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [method] */

/* ======================================================================== */
/* [movabletext] */

/* ------------------------------------------------------------------------ */
/* @method void DictSet.%dump(OutputStream w, Any m) */

void knh_DictSet__dump(Ctx *ctx, DictSet *b, OutputStream *w, Any *m)
{
	knh_DictSet_sort(b);
	knh_putc(ctx, w, '{');
	size_t c;
	for(c = 0; c < DP(b)->size; c++) {
		if(c > 0) {
			knh_write_delim(ctx,w);
		}
		if(!knh_array_isdump(c)) {
			knh_write_dots(ctx, w);
			break;
		}
		knh_format(ctx, w, METHODN__s, UP(DP(b)->list[c].key), KNH_NULL);
		knh_putc(ctx, w, ':');	knh_putc(ctx, w, ' ');
		knh_write__i(ctx, w, DP(b)->list[c].value);
	}
	knh_putc(ctx, w, '}');
}

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [mapping] */

static
Object* knh_DictSet_key_next(Ctx *ctx, Iterator *it)
{
	DictSet *b = (DictSet*)knh_Iterator_source(it);
	size_t pos;
	for(pos = knh_Iterator_pos(it); pos < DP(b)->size; pos++) {
		if(DP(b)->list[pos].value != 0) {
			knh_Iterator_setpos(it,pos+1);
			return (Object*)DP(b)->list[pos].key;
		}
	}
	knh_Iterator_setpos(it,pos);
	return (Object*)KNH_NULL;
}

/* ------------------------------------------------------------------------ */
/* @map DictSet Iterator! */

Iterator* knh_DictSet_Iterator(Ctx *ctx, DictSet *o, Mapper *mpr)
{
	return new_Iterator(ctx, CLASS_String, UP(o), knh_DictSet_key_next);
}

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
