/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */
	
static size_t knh_runtimeSize = 0;

/* ------------------------------------------------------------------------ */

int knh_Runtime_isAllClosed(void)
{
	return (knh_runtimeSize == 0);
}

/* ======================================================================== */
/* [structs] */

void knh_Runtime_struct_init(Ctx *ctx, knh_Runtime_struct *b, int init, Object *cs) 
{
	b->runtime_id = 0;
	b->ctxcount = 0;
	KNH_INITv(b->tmetaHashMap, KNH_NULL /*new_HashMap(ctx, 0)*/);
	KNH_INITv(b->tnameSpaceDictMap, new_DictMap(ctx, 8));
	KNH_INITv(b->tmethodHashMap, KNH_NULL /* new_HashMap(ctx, KONOHA_TCLASS_SIZE * 2 + 1)*/);
	KNH_INITv(b->tmapperHashMap, KNH_NULL /*new_HashMap(ctx, KONOHA_TCLASS_SIZE * 2 + 1)*/);
}

/* ------------------------------------------------------------------------ */

#define _knh_Runtime_struct_copy  NULL

/* ------------------------------------------------------------------------ */

#define _knh_Runtime_struct_compare NULL

/* ------------------------------------------------------------------------ */

void knh_Runtime_struct_traverse(Ctx *ctx, knh_Runtime_struct *b, f_traverse gc)
{
	if(IS_SWEEP(gc)) {
		KNH_ASSERT(b->ctxcount == 0);
		knh_runtimeSize--;
		//DBG2_P("sweeping Runtime(%d)", (int)b->runtime_id);
	}
	gc(ctx, UP(b->tmetaHashMap));
	gc(ctx, UP(b->tmapperHashMap));
	gc(ctx, UP(b->tmethodHashMap));
	gc(ctx, UP(b->tnameSpaceDictMap));
}

/* ======================================================================== */
/* [constructors] */

Runtime* new_Runtime0(knh_uint_t runtime_id)
{
	Runtime *o = (Runtime*)new_Object_malloc(NULL, FLAG_Runtime, CLASS_Runtime, sizeof(knh_Runtime_struct));
	knh_Runtime_struct_init(NULL, DP(o), 0, NULL);
	DP(o)->runtime_id = runtime_id;
	knh_runtimeSize++;
	return o;
}

/* ------------------------------------------------------------------------ */

Object *knh_Runtime_fdefault(Ctx *ctx, knh_class_t cid)
{
	return (Object*)((Context*)ctx)->runtime;
}

/* ------------------------------------------------------------------------ */



#ifdef __cplusplus
}
#endif
