/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif

///* ======================================================================== */
///* [main] */

Stmt *knh_konohac_parse(Ctx *ctx, InputStream *in)
{
	KNH_LOPEN(ctx, 0);
	KNH_LPUSH(ctx, in);
	Token *tk = new_Token(ctx, 0, DP(in)->fileid, 0, knh_char_totoken('{'));
	KNH_LPUSH(ctx, tk);
	knh_Token_parse(ctx, tk, in);
	knh_Token_retokens(ctx, tk);
	DBG2_DUMP(ctx, tk, KNH_NULL, "tokens");
	Stmt *stmt = new_StmtINSTMT(ctx, tk); // new_StmtDONE(ctx);
	KNH_LCLOSE(ctx);
	return stmt; 
}

/* ------------------------------------------------------------------------ */

void knh_konohac_eval(Ctx *ctx, String *nsname, InputStream *in)
{
	/* try */
	KNH_LOPEN(ctx, 0);
	KNH_LPUSH(ctx, new_ExceptionHandler(ctx));          /* 0 */
	KNH_LPUSH(ctx, KNH_NULL);                           /* 1 Exception e */

	KNH_ASSERT(IS_ExceptionHandler(KNH_LOCALn(0)));
	VM_TRY_BEGIN(ctx, NPC, L_CATCH_EXCEPTION, KNH_LOCALn(0), KNH_LOCALn(1));

	/* body */
	KNH_LPUSH(ctx, in);
//	int ch;
//	while((ch = knh_InputStream_getc(ctx, in)) != EOF) {
//		putchar(ch);
//	}
//	putchar('\n');
	Stmt *stmt = knh_konohac_parse(ctx, in);
	KNH_LPUSH(ctx, stmt);
	DBG2_DUMP(ctx, stmt, KNH_NULL, "stmt");
	knh_konohac_compile(ctx, nsname, stmt, 1 /* isrun 1 */);
	KNH_LCLOSE(ctx);	
	return;
	
	/* catch */
	L_CATCH_EXCEPTION:;
	VM_TRY_END(ctx, (ExceptionHandler*)KNH_LOCALn(0));
	KNH_ASSERT(IS_Exception(KNH_LOCALn(1)));
	knh_format(ctx, KNH_STDOUT, METHODN__dump, KNH_LOCALn(1), KNH_NULL);
	KNH_LCLOSE(ctx);
	return;
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
