/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#ifndef KONOHA_MESSAGE__H
#define KONOHA_MESSAGE__H

#include<konoha/konoha_t.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */
#define KONOHA_LANG                     "en"
#define KONOHA_LANG__en                 0
#define KONOHA_LANG__ja                 1
#define KONOHA_LANG__debug              2
#define KONOHA_LANG_MAXSIZ              3

/* ------------------------------------------------------------------------ */
#define KMSG_NAME                       0
#define KMSG_ERRATA                     1
#define KMSG_ETIME                      2
#define KMSG_TYPEINF                    3
#define KMSG_ERROR                      4
#define KMSG_WARNING                    5
#define KMSG_INFO                       6
#define KMSG_ESYNTAX                    7
#define KMSG_EFORGET_PARENTHESIS        8
#define KMSG_EMISMATCH                  9
#define KMSG_WUNCLOSED                  10
#define KMSG_WASCII                     11
#define KMSG_WEOF                       12
#define KMSG_WSEMICOLON                 13
#define KMSG_IGSTMT                     14
#define KMSG_ETOKEN                     15
#define KMSG_ELENGTH                    16
#define KMSG_WCLASSN                    17
#define KMSG_WCONSTN                    18
#define KMSG_WCMETHODN                  19
#define KMSG_WNAME                      20
#define KMSG_WIGNORED                   21
#define KMSG_TEXPTN                     22
#define KMSG_TNSNAME                    23
#define KMSG_TFURN                      24
#define KMSG_TCURN                      25
#define KMSG_TNSCLASSN                  26
#define KMSG_TTYPEN                     27
#define KMSG_TMETHODN                   28
#define KMSG_TCLASSTN                   29
#define KMSG_TSTR                       30
#define KMSG_TVARN                      31
#define KMSG_TCLASSN                    32
#define KMSG_TARGS                      33
#define KMSG_TNAME                      34
#define KMSG_TCMETHODN                  35
#define KMSG_TMT                        36
#define KMSG_TANY                       37
#define KMSG_TSTMT1                     38
#define KMSG_TPEXPR                     39
#define KMSG_TCATCHPARAM                40
#define KMSG_ELVALUE                    41
#define KMSG_WTYPEINF                   42
#define KMSG_NOTHERECONST               43
#define KMSG_NOTHERECLASSCONST          44
#define KMSG_NNCONST                    45
#define KMSG_DUPCONST                   46
#define KMSG_ENEXTPREV                  47
#define KMSG_EEMPTYEXPR                 48
#define KMSG_ETRINARY                   49
#define KMSG_ETYPEOF                    50
#define KMSG_EDEFAULT                   51
#define KMSG_EPSTMT3                    52
#define KMSG_EPEACH                     53
#define KMSG_WLET                       54
#define KMSG_WEMPTYPEXPR                55
#define KMSG_WEMPTYARGS                 56
#define KMSG_WTRUEFALSE                 57
#define KMSG_USCRIPT                    58
#define KMSG_UUOPTION                   59
#define KMSG_UPACKAGE                   60
#define KMSG_UCONSTN                    61
#define KMSG_UVARN                      62
#define KMSG_USYSTEMVARN                63
#define KMSG_UCLASSN                    64
#define KMSG_UTAG                       65
#define KMSG_UTYPEN                     66
#define KMSG_UMETHODN                   67
#define KMSG_UFUNCN                     68
#define KMSG_ULABEL                     69
#define KMSG_UOP                        70
#define KMSG_UOP1                       71
#define KMSG_UOP2                       72
#define KMSG_UNEW                       73
#define KMSG_UMAP                       74
#define KMSG_INTOVERFLOW                75
#define KMSG_FLOATOVERFLOW              76
#define KMSG_INT64OVERFLOW              77
#define KMSG_ETOOFEWPARAMS              78
#define KMSG_WTOOMANYPARAMS             79
#define KMSG_EOP2                       80
#define KMSG_EOPCMP                     81
#define KMSG_EVOIDPARAM                 82
#define KMSG_ENULLPARAM                 83
#define KMSG_WNULLPARAM                 84
#define KMSG_ETYPEPARAM                 85
#define KMSG_EVOIDRETURN                86
#define KMSG_ENULLRETURN                87
#define KMSG_WNULLRETURN                88
#define KMSG_ETYPERETURN                89
#define KMSG_EVOIDLET                   90
#define KMSG_EVOID                      91
#define KMSG_ENULLLET                   92
#define KMSG_ENULL                      93
#define KMSG_WNULLLET                   94
#define KMSG_WNULL                      95
#define KMSG_ETYPELET                   96
#define KMSG_ETYPE                      97
#define KMSG_WDUPFUNCNAME               98
#define KMSG_USCLASSFUNC                99
#define KMSG_USNNTYPE                   100
#define KMSG_IGNNTYPE                   101
#define KMSG_EEXTENDS                   102
#define KMSG_EIMPLEMENTS                103
#define KMSG_DIFFDECL                   104
#define KMSG_DIFFCLASSN                 105
#define KMSG_DIFFNEWTYPE                106
#define KMSG_DIFFRTYPE                  107
#define KMSG_DIFFPSIZE                  108
#define KMSG_DIFFPTYPE                  109
#define KMSG_DIFFPNAME                  110
#define KMSG_TOOMANYVARS                111
#define KMSG_EOUTERLOOP                 112
#define KMSG_IGFIELDVALUE               113
#define KMSG_IGSCRIPTNAME               114
#define KMSG_IGFIELDNAME                115
#define KMSG_NORETURN                   116
#define KMSG_NORETURNVALUE              117
#define KMSG_IGRETURN                   118
#define KMSG_AHISTORIC                  119
#define KMSG_AOVERRIDE                  120
#define KMSG_EOVERRIDE                  121
#define KMSG_TOABSTRACT                 122
#define KMSG_WMAPFOREACH                123
#define KMSG_MAXSIZ                     124

/* ------------------------------------------------------------------------ */

/* ======================================================================== */
int knh_system_langid(char *lang);
int knh_system_setLang(char *lang);
int knh_message_type(int e);
char *knh_message_text(int e);
char *knh_message_tochar(int e);

#ifdef __cplusplus
}
#endif

/* ======================================================================== */

#endif/*KONOHA_MESSAGE__H*/
