/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#ifndef KONOHA_PROTO__H
#define KONOHA_PROTO__H

#include<konoha/gen/konoha_class_.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

/* ======================================================================== */
/* [PROTOTYPE] */
/* ../class/konoha/knh_AffineConv.c */
void knh_AffineConv_struct_init(Ctx *ctx, knh_AffineConv_struct *b, int init, Object *cs);
AffineConv *new_AffineConv(Ctx *ctx, knh_float_t fa, knh_float_t fb);
f_mapper knh_tmapper_faffine(knh_class_t scid, knh_class_t tcid);
void KNH_TAFFINE(Ctx *ctx, knh_class_t scid, knh_class_t tcid, knh_float_t scale, knh_float_t shift);
/* ../class/konoha/knh_Array.c */
knh_Array_t* new_Array0(Ctx *ctx, size_t capacity);
knh_Array_t* new_Array(Ctx *ctx, knh_class_t p1, size_t capacity);
Object** knh_Array_list(Array *o);
Object* knh_Array_last(Array *o);
void knh_Array_subclear(Ctx *ctx, Array *o, size_t n);
size_t knh_array_index(Ctx *ctx, knh_int_t n, size_t size);
void knh_Array_add(Ctx *ctx, Array *o, Any *value);
void knh_Array_remove(Ctx *ctx, Array *o, size_t n);
Any* knh_Array_pop(Ctx *ctx, Array *o);
/* ../class/konoha/knh_Array_api1.c */
METHOD knh__Array_new(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Array_new__array(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Array_new__init(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Array_add(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Array_opLShift(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Array_getSize(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Array_get(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Array_set(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Array_remove(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Array_pop(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Array_insert(Ctx *ctx, knh_sfp_t *sfp);
void knh_Array_clear(Ctx *ctx, Array *o);
METHOD knh__Array_set__opSubset(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Array_set__opSlice(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Array_set__opOffset(Ctx *ctx, knh_sfp_t *sfp);
knh_bool_t knh_array_isdump(size_t c);
void knh_Array__k(Ctx *ctx, Array *o, OutputStream *w, Any *m);
Iterator* knh_Array_Iterator(Ctx *ctx, Array *o, Mapper *mpr);
METHOD knh__Array_opItr(Ctx *ctx, knh_sfp_t *sfp);
Array* knh_Iterator_Array(Ctx *ctx, Iterator *o, Mapper *mpr);
Mapper *knh_tMapper_newIteratorArray(Ctx *ctx, knh_class_t icid, knh_class_t acid);
Mapper *knh_tMapper_newArrayIterator(Ctx *ctx, knh_class_t acid, knh_class_t icid);
/* ../class/konoha/knh_array_t.c */
size_t knh_barray_capacity(void *a);
knh_uchar_t *knh_barray_malloc(Ctx *ctx, size_t capacity);
void knh_barray_free(knh_uchar_t *a);
knh_uchar_t *knh_barray_resize(Ctx *ctx, knh_uchar_t *a, size_t newsize);
size_t knh_oarray_capacity(void *a);
size_t knh_oarray_opsize(void *a);
void knh_oarray_set_opsize(void *a, knh_short_t opsize);
int knh_oarray_op1(void *a);
void knh_oarray_setop1(void *a, knh_short_t op1);
int knh_oarray_op2(void *a);
void knh_oarray_setop2(void *a, knh_short_t op2);
Object** knh_oarray_malloc(Ctx *ctx, size_t capacity, Object *value);
Object **knh_oarray_resize(Ctx *ctx, Object **a, size_t newsize);
Object** knh_oarray_grow(Ctx *ctx, Object **a);
Object **knh_oarray_copy(Ctx *ctx, Object **a, size_t s, size_t offset);
void knh_oarray_traverse(Ctx *ctx, Object **a, f_traverse ftr);
void knh_oarray_free(Ctx *ctx, knh_Object_t **a);
size_t knh_array_capacity(void *a);
size_t knh_array_opsize(void *a);
void knh_array_set_opsize(void *a, knh_short_t opsize);
int knh_array_op1(void *a);
void knh_array_set_op1(void *a, knh_short_t op1);
int knh_array_op2(void *a);
void knh_array_set_op2(void *a, knh_short_t op2);
void *knh_array_malloc(Ctx *ctx, size_t capacity, size_t sizeofeach, void (*farrayinit)(Ctx *, void *), void (*farraytraverse)(Ctx*, void*, f_traverse));
void *knh_array_resize(Ctx *ctx, void *a, size_t newsize);
void knh_array_clear(Ctx *ctx, void *a);
void *knh_array_traverse(Ctx *ctx, void *a, f_traverse ftr);
void* knh_array_fcompare(void *a);
void knh_array_set_fcompare(void *a, int (*farraycompar)(const void *, const void *));
void knh_array_sort(void *a);
/* ../class/konoha/knh_Boolean_api1.c */
METHOD knh__Boolean_opEq(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Boolean_opNeq(Ctx *ctx, knh_sfp_t *sfp);
String* knh_Boolean_String(Ctx *ctx, knh_Boolean_t *o, Mapper *mpr);
void knh_Boolean__s(Ctx *ctx, Boolean *o, OutputStream *w, Any *m);
/* ../class/konoha/knh_Bytes.c */
Bytes* new_Bytes(Ctx *ctx, size_t capacity);
knh_bytes_t knh_Bytes_tobytes(Bytes *o);
knh_bytes_t knh_BytesNULL_tobytes(Bytes *o);
char *knh_BytesNULL_tochar(Bytes *o);
void knh_Bytes_clear(Bytes *o);
void knh_Bytes_putc(Ctx *ctx, Bytes *o, int ch);
void knh_Bytes_write(Ctx *ctx, Bytes *o, knh_bytes_t v);
void knh_Bytes_unputc(Bytes *o);
/* ../class/konoha/knh_BytesConv.c */
void knh_BytesConv_struct_init(Ctx *ctx, knh_BytesConv_struct *b, int init, Object *cs);
void knh_BytesConv_struct_traverse(Ctx *ctx, knh_BytesConv_struct *b, f_traverse ftr);
size_t knh_BytesConv_conv(Ctx *ctx, BytesConv *o, knh_bytes_t t, knh_Bytes_t *ba);
BytesConv* new_BytesConv(Ctx *ctx, String *name, f_bconv fbconv);
BytesConv* new_BytesConv__iconv(Ctx *ctx, char *from, char *to);
BytesConv* new_BytesConv__in(Ctx *ctx, char *from);
BytesConv* new_BytesConv__out(Ctx *ctx, char *to);
String *new_String__bconv(Ctx *ctx, knh_bytes_t t, BytesConv *bconv);
String *new_String__wbufconv(Ctx *ctx, knh_wbuf_t cb, BytesConv *bconv);
void knh_BytesConv__k(Ctx *ctx, BytesConv *o, OutputStream *w, Any *m);
/* ../class/konoha/knh_Bytes_api1.c */
METHOD knh__Bytes_new(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Bytes_add(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Bytes_opLShift(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Bytes_getSize(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Bytes_get(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Bytes_set(Ctx *ctx, knh_sfp_t *sfp);
String* knh_Bytes_String(Ctx *ctx, Bytes *o, Mapper *mpr);
Bytes* knh_String_Bytes(Ctx *ctx, String *s, Mapper *map);
/* ../class/konoha/knh_Bytes_byte_t.c */
size_t knh_size(size_t s);
knh_bytes_t new_bytes(char *c);
knh_bytes_t new_bytes__2(char *buf, size_t len);
knh_int_t knh_bytes_strcmp(knh_bytes_t v1, knh_bytes_t v2);
knh_int_t knh_bytes_strcasecmp(knh_bytes_t v1, knh_bytes_t v2);
knh_bool_t knh_bytes_equals(knh_bytes_t v1, knh_bytes_t v2);
knh_bool_t knh_bytes_startsWith(knh_bytes_t v1, knh_bytes_t v2);
knh_bool_t knh_bytes_endsWith(knh_bytes_t v1, knh_bytes_t v2);
knh_index_t knh_bytes_index(knh_bytes_t v, knh_int_t ch);
knh_index_t knh_bytes_rindex(knh_bytes_t v, knh_int_t ch);
knh_bytes_t knh_bytes_first(knh_bytes_t t, knh_int_t loc);
knh_bytes_t knh_bytes_last(knh_bytes_t t, knh_int_t loc);
char *knh_format_bytes(char *buf, size_t bufsiz, knh_bytes_t t);
knh_bytes_t knh_bytes_subset(knh_bytes_t t, size_t s, size_t e);
knh_bytes_t knh_bytes_offlen(knh_bytes_t t, size_t off, size_t len);
knh_bytes_t knh_bytes_trim(knh_bytes_t t, knh_int_t ch);
knh_int_t knh_bytes_toint(knh_bytes_t t);
knh_float_t knh_bytes_tofloat(knh_bytes_t t);
knh_int_t knh_bytes_toint64(knh_bytes_t t);
/* ../class/konoha/knh_Class.c */
knh_Class_t *new_Class__type(Ctx *ctx, knh_type_t type);
Object *knh_Class_fdefault(Ctx *ctx, knh_class_t cid);
knh_hcode_t knh_Class_hashCode(Class *o);
int knh_Class_compareTo(Class *o, Class *o2);
/* ../class/konoha/knh_ClassMap.c */
void knh_ClassMap_struct_init(Ctx *ctx, knh_ClassMap_struct *b, int init, Object *cs);
void knh_ClassMap_struct_traverse(Ctx *ctx, knh_ClassMap_struct *b, f_traverse gc);
ClassMap* new_ClassMap0(Ctx *ctx, knh_ushort_t capacity);
void knh_ClassMap_resize(Ctx *ctx, ClassMap *o, size_t newsize);
int knh_ClassMap_util_cmp(const Mapper *m1, const Mapper *m2);
void knh_ClassMap_sort(Ctx *ctx, ClassMap *o);
void knh_ClassMap_add(Ctx *ctx, ClassMap *o, Mapper *map);
void knh_ClassMap__dump(Ctx *ctx, ClassMap *o, OutputStream *w, Any *m);
/* ../class/konoha/knh_ClassStruct.c */
void knh_ClassStruct_struct_init(Ctx *ctx, knh_ClassStruct_struct *b, int init, Object *cs);
void knh_ClassStruct_struct_traverse(Ctx *ctx, knh_ClassStruct_struct *b, f_traverse gc);
ClassStruct* new_ClassStruct0(Ctx *ctx, knh_struct_t sid, int method_size);
void knh_ClassStruct_finit(Ctx *ctx, ClassStruct *o, knh_class_t self_cid, Object **v);
knh_index_t knh_Class_indexOfField(knh_class_t cid, knh_fieldn_t fn);
knh_index_t knh_Class_queryField(knh_class_t cid, knh_fieldn_t fnq);
knh_cfield_t *knh_Class_fieldAt(knh_class_t cid, size_t n);
void knh_Class_addMethod__fast(Ctx *ctx, knh_class_t cid, Method *mtd);
void knh_Class_addMethod(Ctx *ctx, knh_class_t cid, Method *mtd);
Method* knh_Class_getMethod__(Ctx *ctx, knh_class_t this_cid, knh_methodn_t mn, knh_bool_t gen);
void knh_cfield_dump(Ctx *ctx, knh_cfield_t *f, size_t offset, size_t fsize, OutputStream *w);
/* ../class/konoha/knh_Class_api1.c */
void knh_Class__s(Ctx *ctx, Class *o, OutputStream *w, Any *m);
void knh_Class__k(Ctx *ctx, Class *o, OutputStream *w, Any *m);
void knh_Class__dump(Ctx *ctx, Class *b, OutputStream *w, Any *m);
/* ../class/konoha/knh_Class_type_t.c */
knh_class_t knh_pmztype_toclass(Ctx *ctx, knh_type_t t, knh_class_t this_cid);
knh_type_t knh_pmztype_totype(Ctx *ctx, knh_type_t t, knh_class_t this_cid);
knh_class_t knh_class_Array(Ctx *ctx, knh_class_t p1);
knh_class_t knh_class_Iterator(Ctx *ctx, knh_class_t p1);
knh_class_t knh_pmzclass(Ctx *ctx, knh_class_t bcid, knh_class_t p1, knh_class_t p2);
knh_bool_t knh_bytes_isNotNullType(knh_bytes_t t);
char *TYPEQ(knh_type_t type);
char *knh_TYPEN(Ctx *ctx, knh_type_t type);
/* ../class/konoha/knh_Connection.c */
knh_db_drvapi_t * knh_System_getDataBaseDriver(Ctx *ctx, knh_bytes_t name);
void knh_Connection_struct_init(Ctx *ctx, knh_Connection_struct *b, int init, Object *cs);
void knh_Connection_struct_traverse(Ctx *ctx, knh_Connection_struct *b, f_traverse ftr);
void knh_Connection_open(Ctx *ctx, Connection *o, String *urn);
Connection* new_Connection(Ctx *ctx, String *urn);
void knh_Connection_close(Ctx *ctx, Connection *o);
/* ../class/konoha/knh_Connection_api1.c */
METHOD knh__Connection_new(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Connection_query(Ctx *ctx, knh_sfp_t *sfp);
/* ../class/konoha/knh_Connection__ubiql.c */
knh_connptr_t* knh_Connection_open__ubiql(Ctx *ctx, knh_bytes_t url, char *uname, char *upwd);
knh_bool_t knh_ResultSet_next__ubiql(Ctx *ctx, knh_rshdlr_t *rsptr, ResultSet *b);
void knh_ResultSet_free__ubiql(knh_rshdlr_t *rsptr);
ResultSet* knh_Connection_query__ubiql(Ctx *ctx, knh_connptr_t *conn, char *sql);
void knh_Connection_close__ubiql(Ctx *ctx, knh_connptr_t *conn);
/* ../class/konoha/knh_Context.c */
Object *knh_Context_fdefault(Ctx *ctx, knh_class_t cid);
void knh_Context_clearstack(Ctx *ctx);
/* ../class/konoha/knh_Context_api1.c */
Object* knh_Context_getProperty(Ctx *ctx, Context *b, knh_bytes_t key);
void knh_Context_setProperty(Ctx *ctx, Context *b, String *key, Any *value);
void knh_Context_setEncoding(Ctx *ctx, knh_Context_t *o, String *enc);
void knh_Context__dump(Ctx *ctx, Context *b, OutputStream *w, Any *m);
/* ../class/konoha/knh_Context_wbuf.c */
knh_bytes_t knh_Bytes_firstbyte(Bytes *o, size_t pos);
knh_bytes_t knh_Bytes_lastbyte(Bytes *o, size_t pos);
size_t knh_Bytes_lastsize(Bytes *o, size_t pos);
void knh_Bytes_subclear(Bytes *o, size_t pos);
String *new_String__wbuf(Ctx *ctx, knh_wbuf_t cb);
knh_wbuf_t knh_Context_wbuf(Ctx* ctx);
size_t knh_wbuf_size(knh_wbuf_t cb);
knh_bytes_t knh_wbuf_tobytes(knh_wbuf_t cb);
char *knh_wbuf_top(knh_wbuf_t cb);
void knh_wbuf_clear(knh_wbuf_t cb);
Bytes *knh_Context_openBConvBuf(Ctx* ctx);
void knh_Context_closeBConvBuf(Ctx* ctx, Bytes *ba);
void *knh_Context_mallocOnce(Ctx* ctx, size_t n);
void knh_Context_freeOnce(Ctx* ctx, void *p);
/* ../class/konoha/knh_DictIdx.c */
void knh_DictIdx_struct_init(Ctx *ctx, knh_DictIdx_struct *b, int init, Object *cs);
void knh_DictIdx_struct_traverse(Ctx *ctx, knh_DictIdx_struct *b, f_traverse gc);
DictIdx* new_DictIdx(Ctx *ctx, size_t initialCapacity, knh_int_t offset);
knh_index_t knh_DictIdx_index(Ctx *ctx, DictIdx *o, knh_bytes_t v);
knh_index_t knh_DictIdx_add__fast(Ctx *ctx, DictIdx *o, String *term);
knh_index_t knh_DictIdx_add(Ctx *ctx, DictIdx *o, String *term);
knh_index_t knh_DictIdx_add__b(Ctx *ctx, DictIdx *o, knh_bytes_t term);
String* knh_DictIdx_get__fast(DictIdx *o, knh_int_t termid);
String* knh_DictIdx_get(DictIdx *o, knh_int_t termid);
void knh_DictIdx_clear(Ctx *ctx, DictIdx *o);
void knh_DictIdx__k(Ctx *ctx, DictIdx *o, OutputStream *w, Any *m);
/* ../class/konoha/knh_DictMap.c */
void knh_DictMap_struct_init(Ctx *ctx, knh_DictMap_struct *b, int init, Object *cs);
void knh_DictMap_struct_copy(Ctx *ctx, knh_DictMap_struct *b, knh_DictMap_struct *b2);
void knh_DictMap_struct_traverse(Ctx *ctx, knh_DictMap_struct *b, f_traverse gc);
DictMap* new_DictMap(Ctx *ctx, knh_int_t capacity);
DictMap *knh_DictMap_new(Ctx *ctx, DictMap *o, knh_int_t initialCapacity);
void knh_DictMap_sort(DictMap *o);
knh_index_t knh_DictMap_index__b(DictMap *o, knh_bytes_t kv);
String* knh_DictMap_keyAt(DictMap *o, size_t n);
Object* knh_DictMap_valueAt(DictMap *o, size_t n);
String *new_String__DictMap(Ctx *ctx, DictMap *o, knh_bytes_t key);
Object *knh_DictMap_get__b(Ctx *ctx, DictMap *o, knh_bytes_t key);
Object *knh_DictMap_get(Ctx *ctx, DictMap *o, String *key);
void knh_DictMap_resize(Ctx *ctx, DictMap *o, size_t newsize);
void knh_DictMap_append(Ctx *ctx, DictMap *o, String *key, Any *value);
void knh_DictMap_set(Ctx *ctx, DictMap *o, String *key, Any *v);
void knh_DictMap_remove(Ctx *ctx, DictMap *o, String *key);
void knh_DictMap_clear(Ctx *ctx, DictMap *o);
Object *knh_DictMap_key_next(Ctx *ctx, Iterator *it);
Iterator* knh_DictMap_Iterator(Ctx *ctx, DictMap *o, Mapper *map);
void knh_DictMap__dump(Ctx *ctx, DictMap *o, OutputStream *w, Any *m);
/* ../class/konoha/knh_DictSet.c */
void knh_DictSet_struct_init(Ctx *ctx, knh_DictSet_struct *b, int init, Object *cs);
void knh_DictSet_struct_copy(Ctx *ctx, knh_DictSet_struct *b, knh_DictSet_struct *b2);
void knh_DictSet_struct_traverse(Ctx *ctx, knh_DictSet_struct *b, f_traverse gc);
DictSet *new_DictSet(Ctx *ctx, knh_int_t capacity);
DictSet* knh_DictSet_new(Ctx *ctx, DictSet *b, knh_int_t initialCapacity);
void knh_DictSet_sort(DictSet *b);
knh_index_t knh_DictSet_index__b(DictSet *b, knh_bytes_t kv);
String* knh_DictSet_key(DictSet *b, size_t n);
knh_uint_t knh_DictSet_value(DictSet *b, size_t n);
String *new_String__DictSet(Ctx *ctx, DictSet *o, knh_bytes_t key);
knh_uint_t knh_DictSet_get__b(DictSet *b, knh_bytes_t kv);
knh_int_t knh_DictSet_get(DictSet *b, String *key);
knh_bool_t knh_DictSet_opIn(Ctx *ctx, DictSet *b, Any *value);
void knh_DictSet_resize(Ctx *ctx, DictSet *b, size_t newsize);
void knh_DictSet_append(Ctx *ctx, DictSet *b, String *key, knh_uint_t value);
void knh_DictSet_set(Ctx *ctx, DictSet *b, String *key, knh_uint_t value);
void knh_DictSet_add(Ctx *ctx, DictSet *b, String *key);
void knh_DictSet_clear(Ctx *ctx, DictSet *b);
/* ../class/konoha/knh_DictSet_api1.c */
void knh_DictSet__dump(Ctx *ctx, DictSet *b, OutputStream *w, Any *m);
Iterator* knh_DictSet_Iterator(Ctx *ctx, DictSet *o, Mapper *mpr);
/* ../class/konoha/knh_Exception.c */
void knh_Exception_struct_init(Ctx *ctx, knh_Exception_struct *b, int init, Object *cs);
void knh_Exception_struct_traverse(Ctx *ctx, knh_Exception_struct *b, f_traverse gc);
Exception* new_Exception(Ctx *ctx, String *msg);
Exception* new_Exception__b(Ctx *ctx, knh_bytes_t msg);
Exception* new_Exception__Nue(Ctx *ctx, knh_Nue_t *nue);
/* ../class/konoha/knh_ExceptionHandler.c */
void knh_ExceptionHandler_struct_init(Ctx *ctx, knh_ExceptionHandler_struct *b, int init, Object *cs);
void knh_ExceptionHandler_struct_traverse(Ctx *ctx, knh_ExceptionHandler_struct *b, f_traverse gc);
ExceptionHandler* new_ExceptionHandler(Ctx *ctx);
Object *knh_ExceptionHandler_fdefault(Ctx *ctx, knh_class_t cid);
void knh_ExceptionHandler_longjmp(Ctx *ctx, ExceptionHandler *b, Exception *e);
Exception* knh_ExceptionHandler_getCaughtException(ExceptionHandler *b);
/* ../class/konoha/knh_Exception_api1.c */
void knh_Exception__s(Ctx *ctx, Exception *b, OutputStream *w, Any *m);
void knh_Exception__dump(Ctx *ctx, Exception *b, OutputStream *w, Any *m);
/* ../class/konoha/knh_Float.c */
Float* new_FloatX0(Ctx *ctx, knh_class_t cid, knh_float_t value);
Float* new_FloatX(Ctx *ctx, knh_class_t cid, knh_float_t value);
Float* new_FloatX__b(Ctx *ctx, knh_class_t cid, knh_bytes_t t);
Object *knh_Float_cspec(Ctx *ctx);
Object *knh_Float_fdefault(Ctx *ctx, knh_class_t cid);
int knh_Float_compareTo(Float *o, Float *o2);
char *knh_format_Float(char *buf, size_t bufsiz, Float *o);
knh_float_t knh_float_max(knh_float_t a, knh_float_t b);
knh_float_t knh_float_min(knh_float_t a, knh_float_t b);
/* ../class/konoha/knh_FloatUnit.c */
void knh_FloatUnit_struct_init(Ctx *ctx, knh_FloatUnit_struct *b, int init, Object *cs);
void knh_FloatUnit_struct_traverse(Ctx *ctx, knh_FloatUnit_struct *b, f_traverse gc);
FloatUnit *new_FloatUnit(Ctx *ctx, knh_flag_t flag, knh_class_t cid, String *urn, String *tag, knh_float_t min, knh_float_t max, knh_float_t defvalue, knh_float_t step);
void knh_FloatUnit_initId(Ctx *ctx, FloatUnit *b, knh_flag_t flag, knh_class_t cid, String *urn, String *tag);
void knh_FloatUnit_initStep(Ctx *ctx, FloatUnit *b, knh_float_t step);
void knh_FloatUnit_initMinMax(Ctx *ctx, FloatUnit *b, knh_float_t min, knh_float_t max);
void knh_FloatUnit_initDefaultValue(Ctx *ctx, FloatUnit *b, knh_float_t v);
/* ../class/konoha/knh_Float_api1.c */
METHOD knh__Float_opAdd__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Float_opNg(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Float_opSub__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Float_opMul__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Float_opDiv__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Float_opAdd(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Float_opSub(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Float_opMul(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Float_opDiv(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Float_opMod(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Float_opEq(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Float_opNeq(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Float_opLt(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Float_opLte(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Float_opGt(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Float_opGte(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Float_opNext(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Float_opPrev(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Float_random(Ctx *ctx, knh_sfp_t *sfp);
Float* knh_String_Float(Ctx *ctx, String *s, Mapper *mpr);
String* knh_Float_String(Ctx *ctx, Float *o, Mapper *mpr);
Float* knh_Int_Float(Ctx *ctx, Int *o, Mapper *mpr);
Int* knh_Float_Int(Ctx *ctx, Float *o, Mapper *mpr);
void knh_Float__s(Ctx *ctx, Float *b, OutputStream *w, Any *m);
void knh_Float__k(Ctx *ctx, Float *b, OutputStream *w, Any *m);
void knh_Float__bits(Ctx *ctx, Float *o, OutputStream *w, Any *m);
void knh_Float__dump(Ctx *ctx, Float *b, OutputStream *w, Any *m);
/* ../class/konoha/knh_HashMap.c */
void knh_HashMap_struct_init(Ctx *ctx, knh_HashMap_struct *b, int init, Object *cs);
knh_hashmapentry_t *new_hashmapentry(Ctx *ctx, HashMap *o);
size_t knh_hashmapentry_capacity(Ctx *ctx, HashMap *o);
knh_hashmapentry_t *knh_hashmapentry_at(HashMap *o, size_t n);
void knh_HashMap_struct_traverse(Ctx *ctx, knh_HashMap_struct *b, f_traverse ftr);
HashMap* new_HashMap(Ctx *ctx, char *name, size_t capacity);
Object *knh_HashMap_get__hcode(Ctx *ctx, HashMap *o, knh_hcode_t hcode);
void knh_HashMap_set__hcode(Ctx *ctx, HashMap *o, knh_hcode_t hcode, Any *value);
void knh_HashMap_remove__hcode(Ctx *ctx, HashMap *o, knh_hcode_t hcode);
void knh_HashMap_clear(Ctx *ctx, HashMap *o);
/* ../class/konoha/knh_HashMap_api1.c */
METHOD knh__HashMap_new(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__HashMap_get(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__HashMap_opIn(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__HashMap_remove(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__HashMap_set(Ctx *ctx, knh_sfp_t *sfp);
void knh_HashMap__k(Ctx *ctx, HashMap *o, OutputStream *w, Any *m);
void knh_HashMap__dump(Ctx *ctx, HashMap *o, OutputStream *w, Any *m);
Iterator* knh_HashMap_Iterator(Ctx *ctx, HashMap *o, Mapper *mpr);
METHOD knh__HashMap_opItr(Ctx *ctx, knh_sfp_t *sfp);
/* ../class/konoha/knh_HashSet.c */
void knh_HashSet_struct_init(Ctx *ctx, knh_HashSet_struct *b, int init, Object *cs);
void knh_HashSet_struct_traverse(Ctx *ctx, knh_HashSet_struct *b, f_traverse ftr);
HashSet* new_HashSet(Ctx *ctx, char *name, size_t capacity);
knh_uint_t knh_HashSet_get__hcode(Ctx *ctx, HashSet *o, knh_hcode_t hcode);
void knh_HashSet_set__hcode(Ctx *ctx, HashSet *o, knh_hcode_t hcode, knh_uint_t value);
void knh_HashSet_add__hcode(Ctx *ctx, HashSet *o, knh_hcode_t hcode);
void knh_HashSet_remove__hcode(Ctx *ctx, HashSet *o, knh_hcode_t hcode);
void knh_HashSet_clear(Ctx *ctx, HashSet *o);
/* ../class/konoha/knh_InputStream.c */
void KNHINIT init_InputStream(Ctx *ctx);
void knh_InputStream_struct_init(Ctx *ctx, knh_InputStream_struct *b, int init, Object *cs);
void knh_InputStream_struct_traverse(Ctx *ctx, knh_InputStream_struct *b, f_traverse gc);
Object *knh_InputStream_open(Ctx *ctx, InputStream *o, String *urn);
int knh_InputStream_getc(Ctx *ctx, InputStream *b);
size_t knh_InputStream_read(Ctx *ctx, InputStream *b, char *buf, size_t bufsiz);
String* knh_InputStream_readLine(Ctx *ctx, InputStream *b);
void knh_InputStream_close(Ctx *ctx, InputStream *b);
InputStream *new_InputStream__FILE(Ctx *ctx, FILE *fp);
InputStream *new_InputStream__Bytes(Ctx *ctx, Bytes *ba, size_t s, size_t e);
/* ../class/konoha/knh_InputStream_api1.c */
METHOD knh__InputStream_new(Ctx *ctx, knh_sfp_t *sfp);
void knh_InputStream_setEncoding(Ctx *ctx, InputStream *o, String *enc);
void knh_InputStream__dump(Ctx *ctx, InputStream *b, OutputStream *w, Any *m);
Iterator* knh_InputStream_String__(Ctx *ctx, InputStream *o, Mapper *mpr);
void knh_InputStream__k(Ctx *ctx, InputStream *o, OutputStream *w, Any *m);
/* ../class/konoha/knh_Int.c */
Int* new_IntX0(Ctx *ctx, knh_class_t cid, knh_int_t value);
Int *new_IntX(Ctx *ctx, knh_class_t cid, knh_int_t value);
Int *new_IntX__b(Ctx *ctx, knh_class_t cid, knh_bytes_t t);
Object *knh_Int_cspec(Ctx *ctx);
Object *knh_Int_fdefault(Ctx *ctx, knh_class_t cid);
Object *knh_IntX_fdefault(Ctx *ctx, knh_class_t cid);
knh_hcode_t knh_Int_hashCode(Int *o);
int knh_Int_compareTo(Int *o, Int *o2);
char *knh_format_Int(char *buf, size_t bufsiz, Int *n);
knh_int_t knh_int_max(knh_int_t a, knh_int_t b);
knh_int_t knh_int_min(knh_int_t a, knh_int_t b);
knh_uint_t knh_uint_max(knh_uint_t a, knh_uint_t b);
knh_uint_t knh_uint_min(knh_uint_t a, knh_uint_t b);
knh_int_t knh_IntNULL_toint(Int *v);
/* ../class/konoha/knh_Int64.c */
Int64* new_Int64X__fast(Ctx *ctx, knh_class_t cid, knh_int64_t value);
Int64* new_Int64X(Ctx *ctx, knh_class_t cid, knh_int64_t value);
knh_int64_t knh_int64_max(knh_int64_t a, knh_int64_t b);
knh_int64_t knh_int64_min(knh_int64_t a, knh_int64_t b);
knh_uint64_t knh_uint64_max(knh_uint64_t a, knh_uint64_t b);
knh_uint64_t knh_uint64_min(knh_uint64_t a, knh_uint64_t b);
void knh_Int64__dump(Ctx *ctx, Int64 *b, OutputStream *w, Any *m);
/* ../class/konoha/knh_IntUnit.c */
void knh_IntUnit_struct_init(Ctx *ctx, knh_IntUnit_struct *b, int init, Object *cs);
void knh_IntUnit_struct_traverse(Ctx *ctx, knh_IntUnit_struct *b, f_traverse gc);
IntUnit *new_IntUnit(Ctx *ctx, knh_flag_t flag, knh_class_t cid, String *urn, String *tag, knh_int_t min, knh_int_t max, knh_int_t defvalue, knh_int_t bf_start, knh_int_t bf_end);
void knh_IntUnit_initId(Ctx *ctx, IntUnit *b, knh_flag_t flag, knh_class_t cid, String *urn, String *tag);
void knh_IntUnit_initMinMax(Ctx *ctx, IntUnit *b, knh_int_t min, knh_int_t max);
void knh_IntUnit_init_bfarray(Ctx *ctx, IntUnit *b, knh_int_t bf_start, knh_int_t bf_end);
void knh_IntUnit_initDefaultValue(Ctx *ctx, IntUnit *b, knh_int_t v);
/* ../class/konoha/knh_IntX_api1.c */
METHOD knh__IntX_opAdd__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opSub__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opMul__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opDiv__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opAdd(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opSub(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opMul(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opDiv(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opMod(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opEq(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opNeq(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opLt(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opLte(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opGt(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opGte(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opLogicalAnd(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opLogicalOr(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opLogicalXor(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opLogicalNot(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opLShift(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__IntX_opRShift(Ctx *ctx, knh_sfp_t *sfp);
void knh_IntX__s(Ctx *ctx, Int *b, OutputStream *w, Any *m);
void knh_IntX__x(Ctx *ctx, Int *b, OutputStream *w, Any *m);
void knh_IntX__bits(Ctx *ctx, Int *b, OutputStream *w, Any *m);
void knh_IntX__dump(Ctx *ctx, Int *b, OutputStream *w, Any *m);
/* ../class/konoha/knh_Int_api1.c */
METHOD knh__Int_opAdd__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opNg(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opSub__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opMul__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opDiv__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opAdd(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opSub(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opMul(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opDiv(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opMod(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opEq(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opNeq(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opLt(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opLte(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opGt(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opGte(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opLogicalAnd(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opLogicalOr(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opLogicalXor(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opLogicalNot(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opLShift(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opRShift(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opNext(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_opPrev(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_abs(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Int_random(Ctx *ctx, knh_sfp_t *sfp);
Int* knh_String_Int(Ctx *ctx, String *o, Mapper *mpr);
String* knh_Int_String(Ctx *ctx, Int *o, Mapper *mpr);
void knh_Int__s(Ctx *ctx, Int *b, OutputStream *w, Any *m);
void knh_Int__x(Ctx *ctx, Int *b, OutputStream *w, Any *m);
void knh_write_bits(Ctx *ctx, OutputStream *w, knh_uint_t n, int bits);
void knh_Int__bits(Ctx *ctx, Int *b, OutputStream *w, Any *m);
/* ../class/konoha/knh_Iterator.c */
void knh_Iterator_struct_init(Ctx *ctx, knh_Iterator_struct *b, int init, Object *cs);
void knh_Iterator_struct_copy(Ctx *ctx, knh_Iterator_struct *b, knh_Iterator_struct *b2);
void knh_Iterator_struct_traverse(Ctx *ctx, knh_Iterator_struct *b, f_traverse gc);
Iterator* new_Iterator(Ctx *ctx, knh_class_t p1, Any *source, f_next fnext);
Object *knh_Iterator_slice(Ctx *ctx, Iterator *o);
/* ../class/konoha/knh_Iterator_api1.c */
void knh_Iterator__dump(Ctx *ctx, Iterator *o, OutputStream *w, Any *m);
/* ../class/konoha/knh_LRUHashMap.c */
void knh_LRUHashMap_struct_init(Ctx *ctx, knh_LRUHashMap_struct *b, int init, Object *cs);
void knh_LRUHashMap_struct_traverse(Ctx *ctx, knh_LRUHashMap_struct *b, f_traverse ftr);
LRUHashMap* new_LRUHashMap(Ctx *ctx, char *name, size_t capacity);
Object *knh_LRUHashMap_get__hcode(Ctx *ctx, LRUHashMap *o, knh_hcode_t hcode);
void knh_LRUHashMap_set__hcode(Ctx *ctx, LRUHashMap *o, knh_hcode_t hcode, Any *value);
void knh_LRUHashMap_clear(Ctx *ctx, LRUHashMap *o);
/* ../class/konoha/knh_Mapper.c */
void knh_Mapper_struct_init(Ctx *ctx, knh_Mapper_struct *b, int init, Object *cs);
void knh_Mapper_struct_traverse(Ctx *ctx, knh_Mapper_struct *b, f_traverse ftr);
Mapper* new_Mapper(Ctx *ctx, knh_flag_t flag, knh_class_t scid, knh_class_t tcid, f_mapper fmap, Object *mapdata);
Object *knh_Mapper_fmapmap(Ctx *ctx, Object *s, Mapper *mpr);
Mapper* new_MapMap(Ctx *ctx, Mapper *m1, Mapper *m2);
Object *knh_Mapper_execMap(Ctx *ctx, Mapper *o, Object *sub);
void knh_Mapper__k(Ctx *ctx, Mapper *o, OutputStream *w, Any *m);
/* ../class/konoha/knh_Method.c */
void knh_Method_struct_init(Ctx *ctx, knh_Method_struct *b, int init, Object *cs);
void knh_Method_struct_copy(Ctx *ctx, knh_Method_struct *b, knh_Method_struct *b2);
void knh_Method_struct_traverse(Ctx *ctx, knh_Method_struct *b, f_traverse gc);
knh_bool_t knh_Method_isAbstract(Method *o);
Method* new_Method(Ctx *ctx, knh_flag_t flag, knh_class_t cid, knh_methodn_t mn, f_method func);
knh_hcode_t knh_Method_hashCode(Method *o);
int knh_Method_compareTo(Method *o, Method *o2);
void knh_Method_toAbstract(Ctx *ctx, Method *o);
void knh_ClassStruct_toAbstractAll(Ctx *ctx, ClassStruct *o);
METHOD knh_Method_fNoSuchMethod(Ctx *ctx, knh_sfp_t *sfp);
knh_bool_t knh_Method_isNoSuchMethod(Method *o);
Method* new_Method__NoSuchMethod(Ctx *ctx, knh_class_t cid, knh_methodn_t mn);
knh_bool_t knh_methodn_isNew(knh_methodn_t mn);
knh_bool_t knh_Method_isNew(Method *o);
knh_bool_t knh_methodn_isOp(knh_methodn_t mn);
String* knh_Method_getName(Ctx *ctx, Method *o);
String* knh_Method_getURN(Ctx *ctx, Method *o);
void knh_Method__s(Ctx *ctx, Method *o, OutputStream *w, Any *m);
void knh_Method__k(Ctx *ctx, Method *o, OutputStream *w, Any *m);
void knh_Method__dump(Ctx *ctx, Method *o, OutputStream *w, Any *m);
/* ../class/konoha/knh_MethodField.c */
void knh_MethodField_struct_init(Ctx *ctx, knh_MethodField_struct *b, int init, Object *cs);
void knh_MethodField_struct_copy(Ctx *ctx, knh_MethodField_struct *b, knh_MethodField_struct *b2);
void knh_MethodField_struct_traverse(Ctx *ctx, knh_MethodField_struct *b, f_traverse gc);
MethodField* new_MethodField(Ctx *ctx, knh_flag_t flag, size_t size);
MethodField *new_MethodField__0(Ctx *ctx, knh_flag_t flag, knh_type_t rtype);
MethodField *new_MethodField__1(Ctx *ctx, knh_flag_t flag, knh_type_t rtype, knh_type_t t1, knh_fieldn_t fn1);
MethodField *new_MethodField__2(Ctx *ctx, knh_flag_t flag, knh_type_t rtype, knh_type_t t1, knh_fieldn_t fn1, knh_type_t t2, knh_fieldn_t fn2);
MethodField *new_MethodField__3(Ctx *ctx, knh_flag_t flag, knh_type_t rtype, 		knh_type_t t1, knh_fieldn_t fn1, knh_type_t t2, knh_fieldn_t fn2, knh_type_t t3, knh_fieldn_t fn3);
MethodField *new_MethodField__4(Ctx *ctx, knh_flag_t flag, knh_type_t rtype, 		knh_type_t t1, knh_fieldn_t fn1, knh_type_t t2, knh_fieldn_t fn2, 		knh_type_t t3, knh_fieldn_t fn3, knh_type_t t4, knh_fieldn_t fn4);
knh_hcode_t knh_methodfield_hcode(knh_type_t r, knh_type_t a0, knh_type_t a1);
knh_hcode_t knh_MethodField_hcode(MethodField *o);
void knh_MethodField_setVarArgs(MethodField *o);
knh_bool_t knh_MethodField_isVarArgs(MethodField *o);
knh_type_t knh_MethodField_rtype(MethodField *o);
size_t knh_MethodField_psize(MethodField *o);
knh_type_t knh_MethodField_ptype(MethodField *o, size_t n);
knh_mfield_t knh_MethodField_pfields(MethodField *o, size_t n);
knh_mfield_t knh_MethodField_lastfield(MethodField *o);
/* ../class/konoha/knh_NameSpace.c */
void knh_NameSpace_struct_init(Ctx *ctx, knh_NameSpace_struct *b, int init, Object *cs);
void knh_NameSpace_struct_traverse(Ctx *ctx, knh_NameSpace_struct *b, f_traverse ftr);
NameSpace* new_NameSpace(Ctx *ctx, NameSpace *parent, String *nsname);
void knh_NameSpace_setClass(Ctx *ctx, NameSpace *o, String *name, knh_class_t c);
knh_class_t knh_NameSpace_getClass(Ctx *ctx, NameSpace *o, knh_bytes_t name);
void knh_NameSpace_setLocalName(Ctx *ctx, NameSpace *o, knh_class_t cid);
char* knh_Context_CLASSN(Ctx *ctx, knh_class_t cid);
void knh_NameSpace_import(Ctx *ctx, NameSpace *o, knh_bytes_t p);
knh_type_t knh_NameSpace_getType(Ctx *ctx, NameSpace *o, knh_bytes_t name);
knh_class_t knh_tclass_classURN(Ctx *ctx, knh_class_t bcid, knh_bytes_t urn);
knh_class_t knh_tclass_loadURN(Ctx *ctx, knh_class_t bcid, knh_bytes_t urn);
knh_type_t knh_NameSpace_tagcid(Ctx *ctx, NameSpace *o, knh_class_t bcid, knh_bytes_t tag);
void knh_NameSpace_setFuncClass(Ctx *ctx, NameSpace *o, knh_methodn_t mn, knh_class_t c);
knh_class_t knh_NameSpace_getFuncClass(Ctx *ctx, NameSpace *o, knh_bytes_t funcname);
void knh_NameSpace_addLocalConst(Ctx *ctx, NameSpace *o, String *name, Object *value);
knh_bool_t knh_NameSpace_existsLocalConst(Ctx *ctx, NameSpace *o, knh_bytes_t name);
Object* knh_NameSpace_getLocalConst(Ctx *ctx, NameSpace *o, knh_bytes_t name);
void knh_NameSpace_loaded(Ctx *ctx, NameSpace *o, knh_fileid_t fileid);
knh_bool_t knh_NameSpace_isLoaded(Ctx *ctx, NameSpace *o, knh_fileid_t fileid);
/* ../class/konoha/knh_Nue.c */
Object *new_Nue(Ctx *ctx, String *msg);
Object *knh_Nue_fdefault(Ctx *ctx, knh_class_t cid);
int knh_Nue_compareTo(Nue *o, Nue *o2);
/* ../class/konoha/knh_Nue_api1.c */
void knh_Nue__s(Ctx *ctx, Nue *b, OutputStream *w, Any *m);
void knh_Nue__k(Ctx *ctx, Nue *b, OutputStream *w, Any *m);
/* ../class/konoha/knh_Number.c */
knh_int_t knh_Number_toint(Any *o);
knh_int64_t knh_Number_toint64(Any *o);
knh_float_t knh_Number_tofloat(Any *o);
knh_int_t knh_Int_toint(Int *o);
knh_float_t knh_Int_tofloat(Int *o);
knh_int64_t knh_Int_toint64(Int *o);
knh_int_t knh_Float_toint(Float *o);
knh_float_t knh_Float_tofloat(Float *o);
knh_int64_t knh_Float_toint64(Float *o);
knh_int_t knh_Int64_toint(Int64 *o);
knh_float_t knh_Int64_tofloat(Int64 *o);
knh_int64_t knh_Int64_toint64(Int64 *o);
/* ../class/konoha/knh_Number_api1.c */
METHOD knh__Number_opAdd__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Number_opSub__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Number_opMul__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Number_opDiv__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Number_opAdd(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Number_opSub(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Number_opMul(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Number_opDiv(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Number_opEq(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Number_opNeq(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Number_opLt(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Number_opLte(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Number_opGt(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Number_opGte(Ctx *ctx, knh_sfp_t *sfp);
/* ../class/konoha/knh_Object.c */
Object *new_Object__init(Ctx *ctx, knh_flag_t flag, knh_class_t cid);
Object *knh_Object_copy(Ctx *ctx, Object *b);
knh_hcode_t knh_Object_hashCode(Object *o);
knh_bytes_t knh_Object_tobytes(Ctx *ctx, Object *o);
String* knh_Object_String(Ctx *ctx, Object *o, Mapper *map);
/* ../class/konoha/knh_Object_api1.c */
METHOD knh__Object_new__init(Ctx *ctx, knh_sfp_t *sfp);
int knh_Object_compareTo(Object *o1, Object *o2);
knh_bool_t knh_Object_equals(Object *o1, Object *o2);
METHOD knh__Object_opEq(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Object_opNeq(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Object_opLt(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Object_opLte(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Object_opGt(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Object_opGte(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Object_opNot(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Object_opSeq(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Object_opIsMapTo(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Object_getClass(Ctx *ctx, knh_sfp_t *sfp);
Iterator* knh_Object_Iterator(Ctx *ctx, Object *o, Mapper *mpr);
METHOD knh__Object_opItr(Ctx *ctx, knh_sfp_t *sfp);
void knh_Object__s(Ctx *ctx, Object *b, OutputStream *w, Any *m);
void knh_Object__k(Ctx *ctx, Object *o, OutputStream *w, Any *m);
void knh_Object__dump(Ctx *ctx, Object *b, OutputStream *w, Any *m);
void knh_Object__empty(Ctx *ctx, Object *b, OutputStream *w, Any *m);
void knh_Object__refc(Ctx *ctx, Object *o, OutputStream *w, Any *m);
void knh_Object__addr(Ctx *ctx, Object *b, OutputStream *w, Any *m);
/* ../class/konoha/knh_OutputStream.c */
void knh_OutputStream_struct_init(Ctx *ctx, knh_OutputStream_struct *b, int init, Object *cs);
void knh_OutputStream_struct_traverse(Ctx *ctx, knh_OutputStream_struct *b, f_traverse gc);
OutputStream * new_OutputStream(Ctx *ctx, String *urn, knh_outptr_t *outptr, knh_outptr_drvapi_t drv);
void knh_OutputStream_putc(Ctx *ctx, OutputStream *o, int ch);
void knh_OutputStream_write(Ctx *ctx, OutputStream *o, knh_bytes_t buf);
void knh_OutputStream_flush(Ctx *ctx, OutputStream *o);
void knh_OutputStream_close(Ctx *ctx, OutputStream *o);
void knh_OutputStream_indent_inc(Ctx *ctx, OutputStream *o);
void knh_OutputStream_indent_dec(Ctx *ctx, OutputStream *o);
void knh_OutputStream_write_indent(Ctx *ctx, OutputStream *o);
void knh_OutputStream_print_(Ctx *ctx, OutputStream *o, knh_bytes_t str, knh_bool_t isnl);
OutputStream *new_OutputStream__FILE(Ctx *ctx, FILE *fp);
OutputStream *new_OutputStream__Bytes(Ctx *ctx, Bytes *ba);
/* ../class/konoha/knh_OutputStream_api1.c */
METHOD knh__OutputStream_write(Ctx *ctx, knh_sfp_t *sfp);
void knh_OutputStream_setEncoding(Ctx *ctx, OutputStream *o, String *enc);
METHOD knh__OutputStream_print(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__OutputStream_println(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__OutputStream_opLShift(Ctx *ctx, knh_sfp_t *sfp);
void knh_OutputStream__k(Ctx *ctx, OutputStream *o, OutputStream *w, Any *m);
/* ../class/konoha/knh_OutputStream_write.c */
void knh_write__s(Ctx *ctx, OutputStream *w, char *s);
void knh_write__p(Ctx *ctx, OutputStream *w, void *ptr);
void knh_write__ifmt(Ctx *ctx, OutputStream *w, char *fmt, knh_int_t n);
void knh_write__ffmt(Ctx *ctx, OutputStream *w, char *fmt, knh_float_t n);
void knh_write__flag(Ctx *ctx, OutputStream *w, knh_flag_t flag);
void knh_write__type(Ctx *ctx, OutputStream *w, knh_type_t type);
void knh_write__class(Ctx *ctx, OutputStream *w, knh_class_t cid);
void knh_write__expt(Ctx *ctx, OutputStream *w, knh_expt_t cid);
void knh_write__mn(Ctx *ctx, OutputStream *w, knh_methodn_t mn);
void knh_format(Ctx *ctx, OutputStream *w, knh_methodn_t mn, Any *x, Any *m);
String* knh_Object_movableText(Ctx *ctx, Object *b, knh_methodn_t mn, Any *m);
METHOD knh_fmethod_movableText(Ctx *ctx, knh_sfp_t *sfp);
/* ../class/konoha/knh_Range.c */
Range *new_Range(Ctx *ctx, Object *start, Object *end);
/* ../class/konoha/knh_Range_api1.c */
METHOD knh__Range_new(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Range_new__slice(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Range_new__offset(Ctx *ctx, knh_sfp_t *sfp);
/* ../class/konoha/knh_Regex.c */
void KNHINIT init_Regex(Ctx *ctx);
Regex *new_Regex(Ctx *ctx, String *pattern);
void knh_Regex__s(Ctx *ctx, Regex *o, OutputStream *w, Any *m);
/* ../class/konoha/knh_ResultSet.c */
void knh_ResultSet_struct_init(Ctx *ctx, knh_ResultSet_struct *b, int init, Object *cs);
void knh_ResultSet_struct_traverse(Ctx *ctx, knh_ResultSet_struct *b, f_traverse ftr);
ResultSet *knh_ResultSet_next(Ctx *ctx, ResultSet *o);
void knh_ResultSet_initTargetClass(ResultSet *o, knh_class_t tcid);
knh_index_t knh_ResultSet_index(Ctx *ctx, ResultSet *o, knh_bytes_t name);
String *knh_ResultSet_getName(Ctx *ctx, ResultSet *o, size_t n);
knh_type_t knh_ResultSet_get_type(Ctx *ctx, ResultSet *o, size_t n);
knh_int_t knh_ResultSet_get__int(Ctx *ctx, ResultSet *o, size_t n);
knh_float_t knh_ResultSet_get__float(Ctx *ctx, ResultSet *o, size_t n);
knh_int64_t knh_ResultSet_get__int64(Ctx *ctx, ResultSet *o, size_t n);
void knh_ResultSet__dump(Ctx *ctx, ResultSet *o, OutputStream *w, Any *m);
/* ../class/konoha/knh_Runtime.c */
int knh_Runtime_isAllClosed(void);
void knh_Runtime_struct_init(Ctx *ctx, knh_Runtime_struct *b, int init, Object *cs);
void knh_Runtime_struct_traverse(Ctx *ctx, knh_Runtime_struct *b, f_traverse gc);
Runtime* new_Runtime0(knh_uint_t runtime_id);
Object *knh_Runtime_fdefault(Ctx *ctx, knh_class_t cid);
/* ../class/konoha/knh_Script.c */
Script *knh_NameSpace_getScript(Ctx *ctx, NameSpace *ns);
void knh_Script__k(Ctx *ctx, Script *o, OutputStream *w, Any *m);
void knh_Script__dump(Ctx *ctx, Script *o, OutputStream *w, Any *m);
/* ../class/konoha/knh_Socket_utils.c */
char * knh_bytes_urlencode(knh_bytes_t s, char *buf, size_t bufsiz);
char * knh_bytes_urldecode(knh_bytes_t s, char *buf, size_t bufsiz);
char * knh_bytes_urlhost(knh_bytes_t url, char *buf, size_t bufsiz);
int knh_bytes_urlport(knh_bytes_t url, int defport);
char * knh_bytes_urlpath(knh_bytes_t url, char *buf, size_t bufsiz);
/* ../class/konoha/knh_String.c */
knh_hcode_t knh_string_hash(knh_uchar_t *buf, knh_size_t len);
void knh_String_checkASCII(String *o);
String *new_String(Ctx *ctx, knh_bytes_t t, String *orign);
String *new_String0(Ctx *ctx, knh_bytes_t t, String *orign);
String *new_StringX__fast(Ctx *ctx, knh_class_t cid, knh_bytes_t t, String *orign);
String *new_StringX__FormatException(Ctx *ctx, knh_class_t cid, knh_bytes_t t, String *orign);
String *new_StringX(Ctx *ctx, knh_class_t cid, knh_bytes_t t, String *orign);
Object *knh_String_fdefault(Ctx *ctx, knh_class_t cid);
knh_hcode_t knh_String_hashCode(String *o);
int knh_String_compareTo(String *o, String *o2);
char *knh_StringNULL_tochar(String *o);
knh_bytes_t knh_String_tobytes(String *o);
knh_bytes_t knh_StringNULL_tobytes(String *o);
/* ../class/konoha/knh_StringUnit.c */
void knh_StringUnit_struct_init(Ctx *ctx, knh_StringUnit_struct *b, int init, Object *cs);
void knh_StringUnit_struct_traverse(Ctx *ctx, knh_StringUnit_struct *b, f_traverse gc);
StringUnit *new_StringUnit(Ctx *ctx, knh_flag_t flag, knh_class_t cid, String *urn, String *tag);
Object *knh_String_cspec(Ctx *ctx);
Object *knh_StringX_fdefault(Ctx *ctx, knh_class_t cid);
/* ../class/konoha/knh_String_api1.c */
knh_bool_t knh_String_equals(String *o, knh_bytes_t s);
knh_bool_t knh_String_startsWith(String *b, knh_bytes_t s);
knh_bool_t knh_String_endsWith(String *b, knh_bytes_t s);
METHOD knh__String_indexOf(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__String_getSize(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__String_opAdd__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__String_opAdd(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__String_opSub__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__String_replace(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__String_opMul__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__String_opMul(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__String_opDiv__2(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__String_opDiv(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__String_opMod(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__String_contains(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__String_get(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__String_opOffset(Ctx *ctx, knh_sfp_t *sfp);
String* new_String_bconv(Ctx *ctx, String *s, f_bconv bconv);
size_t bconv__toLower(Ctx *ctx, BytesConv *o, knh_bytes_t t, knh_Bytes_t *ba);
METHOD knh__String_toLower(Ctx *ctx, knh_sfp_t *sfp);
size_t bconv__toUpper(Ctx *ctx, BytesConv *o, knh_bytes_t t, knh_Bytes_t *ba);
METHOD knh__String_toUpper(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__String_trim(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__String_split(Ctx *ctx, knh_sfp_t *sfp);
void knh_String__s(Ctx *ctx, String *b, OutputStream *w, Any *m);
void knh_String__k(Ctx *ctx, String *o, OutputStream *w, Any *m);
/* ../class/konoha/knh_String_mbytes.c */
knh_bool_t knh_bytes_checkENCODING(knh_bytes_t s);
size_t knh_bytes_mlen(knh_bytes_t s);
knh_bytes_t knh_bytes_mofflen(knh_bytes_t m, size_t moff, size_t mlen);
/* ../class/konoha/knh_System.c */
Object *knh_System_fdefault(Ctx *ctx, knh_class_t cid);
char * knh_bytes_nzenvkey(knh_bytes_t t, char *buf, size_t bufsiz);
Any* knh_System_getProperty(Ctx *ctx, System *o, knh_bytes_t key);
void knh_System_setProperty(Ctx *ctx, System *o, String *key, Any *value);
knh_bool_t konoha_initcheck(void);
/* ../class/konoha/knh_System_api1.c */
METHOD knh__System_getIn(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__System_setIn(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__System_getOut(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__System_setOut(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__System_getErr(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__System_setErr(Ctx *ctx, knh_sfp_t *sfp);
void knh_System__k(Ctx *ctx, System *o, OutputStream *w, Any *m);
/* ../class/konoha/knh_Tuple2.c */
Tuple2 *new_Tuple2(Ctx *ctx, Object *first, Object *second);
/* ../class/konoha/knh_Tuple2_api1.c */
METHOD knh__Tuple_new(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Tuple2_getSize(Ctx *ctx, knh_sfp_t *sfp);
Object *knh_Tuple2_get__fast(Tuple2 *b, knh_int_t index);
void knh_Tuple2__dump(Ctx *ctx, Tuple2 *b, OutputStream *w, Any *m);
/* ../class/konohac/knh_Compiler.c */
void knh_Compiler_struct_init(Ctx *ctx, knh_Compiler_struct *b, int init, Object *cs);
void knh_Compiler_struct_traverse(Ctx *ctx, knh_Compiler_struct *b, f_traverse gc);
Compiler* knh_Context_getCompiler(Ctx *ctx);
NameSpace *knh_Context_getNameSpace(Ctx *ctx);
NameSpace *knh_Context_setNameSpace(Ctx *ctx, String *nsname);
NameSpace *knh_Context_switchNameSpace(Ctx *ctx, NameSpace *newns);
Script *knh_Compiler_getScript(Ctx *ctx, Compiler *o);
void knh_Stmt_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns);
void knh_Stmt_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_Stmt_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t t, int level);
void knh_Stmt_names(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_Stmt_cmpls(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_konohac_compile(Ctx *ctx, String *nsname, Stmt *stmt_head, int isrun);
void knh_Compiler_startCompilation(Ctx *ctx, Compiler *cpr, Stmt *stmt);
void knh_Compiler_clear(Ctx *ctx, Compiler *cpr);
void knh_Compiler_stopCompilation(Ctx *ctx, Compiler *cpr);
void knh_Compiler_endCompilation(Ctx *ctx, Compiler *cpr);
void *knh_Compiler_asmmalloc(Ctx *ctx, Compiler *cpr, size_t size);
/* ../class/konohac/knh_KLRCode.c */
void knh_KLRCode_struct_init(Ctx *ctx, knh_KLRCode_struct *b, int init, Object *cs);
void knh_KLRCode_struct_copy(Ctx *ctx, knh_KLRCode_struct *b, knh_KLRCode_struct *b2);
void knh_KLRCode_struct_traverse(Ctx *ctx, knh_KLRCode_struct *b, f_traverse gc);
KLRCode* new_KLRCode(Ctx *ctx, knh_fileid_t fileid, knh_bytes_t elf, knh_bytes_t dwarf);
void knh_Method_setKLRCode(Ctx *ctx, Method *mtd, KLRCode *code);
knh_bytes_t knh_KLRCode_tobytes(KLRCode *o);
/* ../class/konohac/knh_konohac.c */
Stmt *knh_konohac_parse(Ctx *ctx, InputStream *in);
void knh_konohac_eval(Ctx *ctx, String *nsname, InputStream *in);
/* ../class/konohac/knh_parser_StmtEXPR.c */
Stmt* new_StmtLETEXPR(Ctx *ctx, knh_tokens_t *tc);
void knh_Stmt_add_EXPR(Ctx *ctx, Stmt *stmt_b, knh_tokens_t *tc);
Token *new_TokenCLASSN(Ctx *ctx, Token *tk, knh_bytes_t name);
Token *new_TokenCONSTN(Ctx *ctx, Token *tk, knh_bytes_t name);
Stmt* new_StmtFUNCEXPR(Ctx *ctx, knh_tokens_t *tc);
Stmt *new_StmtINSTMT(Ctx *ctx, Token *tk);
Term *new_TermPEXPR(Ctx *ctx, Token *tk);
void knh_Stmt_add_PEXPR(Ctx *ctx, Stmt *stmt_b, knh_tokens_t *tc);
Term *new_TermEXPR(Ctx *ctx, knh_tokens_t *tc, int lr);
void knh_Stmt_add_EXPRs(Ctx *ctx, Stmt *stmt_b, knh_tokens_t *tc);
/* ../class/konohac/knh_parser_StmtSTMT.c */
knh_bool_t knh_Token_isVARN(Token *tk);
knh_bool_t knh_Token_isNSNAME(Token *tk);
knh_bool_t knh_Token_isNSCLASSN(Token *tk);
knh_bool_t knh_Token_isCLASSN(Token *tk);
knh_bool_t knh_Token_isMETHODN(Token *tk);
knh_bool_t knh_Token_isCLASSTN(Token *tk);
knh_bool_t knh_Token_isCURN(Token *tk);
knh_bool_t knh_Token_isEXPTN(Token *tk);
knh_bool_t knh_Token_isFURN(Token *tk);
knh_bool_t knh_Token_isANY(Token *tk);
void knh_Stmt_add_SEMICOLON(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_ASIS(Ctx *ctx, Stmt *o);
void knh_Stmt_add_STEXT(Ctx *ctx, Stmt *o, knh_tokens_t *tc, knh_bytes_t stext);
void knh_Stmt_add_S(Ctx *ctx, Stmt *o, knh_token_t tt, String *ts);
void knh_Stmt_add_WITH(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_PRAGMA(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
Stmt *new_StmtUENUM(Ctx *ctx, knh_tokens_t *tc);
Stmt *new_StmtUVOCAB(Ctx *ctx, knh_tokens_t *tc);
Stmt *new_StmtUFUNC(Ctx *ctx, knh_tokens_t *tc);
Stmt *new_StmtUMAPMAP(Ctx *ctx, knh_tokens_t *tc);
Stmt *new_StmtUSING(Ctx *ctx, knh_tokens_t *tc);
void knh_Stmt_add_EXTENDS(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_ANY_(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_ELSE(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_CLASSTNs(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_PSTMT3(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_STMT1(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_CATCH(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_CMETHOD(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_PARAMs(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
Stmt *new_StmtMETHOD(Ctx *ctx, knh_tokens_t *tc);
void knh_Stmt_add_PEACH(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
/* ../class/konohac/knh_parser_Token.c */
	 void knh_Token_parse(Ctx *ctx, Token *tk, InputStream *in);
String *new_String__NAME(Ctx *ctx, knh_bytes_t tname);
Token *new_Token__name(Ctx *ctx, knh_flag_t flag, knh_fileid_t fileid, knh_line_t line, knh_bytes_t t);
void knh_Token_retokens(Ctx *ctx, Token *o);
knh_token_t knh_char_totoken(int ch);
/* ../class/konohac/knh_perror.c */
void knh_perrata(Ctx *ctx, knh_fileid_t fileid, int line, char *oldt, char *newt);
void knh_Token_perrata(Ctx *ctx, Token *o, char *newtoken);
void knh_perror(Ctx *ctx, knh_fileid_t fileid, int line, int pe, char *msg);
void knh_Token_perror(Ctx *ctx, Token *o, int pe);
void knh_tokens_perror(Ctx *ctx, knh_tokens_t *tc, int pe);
void knh_Stmt_perror(Ctx *ctx, Stmt *b, knh_tokens_t *tc, int pe);
Stmt *new_StmtERR(Ctx *ctx, knh_tokens_t *tc);
void knh_Compiler_perror(Ctx *ctx, Compiler *cpr, int pe, char *msg);
void knh_notice_TypeInf(Ctx *ctx, knh_fileid_t fileid, int line, char *msg, knh_type_t type);
/* ../class/konohac/knh_Stmt.c */
void knh_Stmt_struct_init(Ctx *ctx, knh_Stmt_struct *b, int init, Object *cs);
void knh_Stmt_struct_traverse(Ctx *ctx, knh_Stmt_struct *b, f_traverse gc);
Stmt* new_Stmt(Ctx *ctx, knh_flag_t flag, knh_stmt_t stt);
Stmt* new_StmtDONE(Ctx *ctx);
void knh_Stmt_done(Ctx *ctx, Stmt *o);
void knh_Stmt_add(Ctx *ctx, Stmt *o, Term *tm);
void knh_Stmt_add_ERR(Ctx *ctx, Stmt *o, Token *tk);
Stmt *knh_Stmt_tail(Stmt *o);
void knh_Stmt_tail_append(Ctx *ctx, Stmt *o, Stmt *stmt);
void knh_Stmt__s(Ctx *ctx, Stmt *o, OutputStream *w, Any *m);
void knh_Stmt__dump(Ctx *ctx, Stmt *o, OutputStream *w, Any *m);
/* ../class/konohac/knh_StmtCLASS.c */
void knh_class_addInterface(Ctx *ctx, knh_class_t cid, knh_class_t icid);
void knh_StmtCLASS_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtCLASS_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtCLASS_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
/* ../class/konohac/knh_StmtDEBUG.c */
	 void knh_Stmt_toERR(Ctx *ctx, Stmt *stmt, String *msg);
	 void knh_StmtERR_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
	 void knh_StmtPRINT_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtASSERT_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
/* ../class/konohac/knh_StmtDECLLET.c */
Stmt *new_StmtDONE_type(Ctx *ctx, knh_type_t type);
void knh_Token_setSFPIDX(Token *tk, int idx, knh_type_t type);
void knh_TokenNAME_typing(Ctx *ctx, Token *tk, Compiler *cpr);
void knh_StmtDECL_toLET(Ctx *ctx, Stmt *stmt);
void knh_StmtDECL_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtLET_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtLET_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtLETMULTI_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
knh_fieldn_t knh_tName_getFieldnOnStack(Ctx *ctx, int level);
void knh_StmtFOREACH_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtFOREACH_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
/* ../class/konohac/knh_StmtEXPR.c */
void knh_Stmt_setType(Stmt *stmt, knh_type_t type);
knh_bool_t knh_Term_isTyped(Term *tm);
knh_type_t knh_Term_get_type(Term *tm);
knh_type_t knh_Term_get_cid(Term *tm);
Term *knh_StmtCALL1_typing(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_class_t reqc);
knh_methodn_t knh_Token_tomethodn(Ctx *ctx, Token *o);
Term *knh_StmtOP_typing(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_class_t reqc);
Term *knh_Stmt_typing(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_class_t reqc);
void knh_Stmt_terms_typing(Ctx *ctx, Stmt *stmt, size_t n, Compiler *cpr, NameSpace *ns, knh_class_t reqc);
void KNH_ASM_THROWERR__T(Ctx *ctx, Compiler *cpr, char *text);
void KNH_ASM_THROWERR__S(Ctx *ctx, Compiler *cpr, String *msg);
void knh_Stmt_terms_cmpl_(Ctx *ctx, Stmt *stmt, int n, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level, int push);
void knh_StmtCALL1_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtCALL_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtOP_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtNEW_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtMT_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtMAPCAST_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
/* ../class/konohac/knh_StmtIFLOOP.c */
knh_short_t knh_Compiler_labelId(Ctx *ctx, Compiler *cpr, knh_bytes_t label);
void KNH_ASM_LABEL__b(Ctx *ctx, Compiler *cpr, knh_bytes_t t);
String *knh_Compiler_lstack_label(Ctx *ctx, Compiler *cpr);
void knh_Stmt_cmpl_beforeLABEL(Ctx *ctx, Stmt *stmt, Compiler *cpr, int level);
void knh_Stmt_cmpl_afterLABEL(Ctx *ctx, Stmt *stmt, Compiler *cpr, int level);
void knh_StmtIF_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns,int level);
void knh_StmtIF_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtALT_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtAND_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtOR_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtTRINARY_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtWHILE_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtWHILE_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtDO_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtDO_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtCONTINUE_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtBREAK_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtGOTO_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtFOR_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtFOR_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
/* ../class/konohac/knh_StmtMETA.c */
knh_bool_t knh_Stmt_hasMeta(Stmt *o);
void knh_StmtMETA_add_prestmt(Ctx *ctx, Stmt *o, knh_tokens_t *tc, int start);
void knh_StmtMETA_add(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_StmtMETA_dump(Ctx *ctx, Stmt *o, OutputStream *w, Any *m);
knh_flag_t knh_Stmt_metaflag__class(Ctx *ctx, Stmt *o);
knh_flag_t knh_Stmt_metaflag__method(Ctx *ctx, Stmt *o);
knh_flag_t knh_Stmt_metaflag__field(Ctx *ctx, Stmt *b);
knh_flag_t knh_Stmt_metaflag__new(Ctx *ctx, Stmt *b);
knh_bool_t knh_StmtMETA_istime(Stmt *o);
knh_flag_t knh_StmtMETA_flagPRINT(Ctx *ctx, Stmt *o);
knh_bool_t knh_StmtMETA_isHistoric(Stmt *o);
knh_bool_t knh_StmtMETA_isOverride(Stmt *o);
/* ../class/konohac/knh_StmtMETHOD.c */
void knh_Compiler_initDecl(Ctx *ctx, Compiler *cpr);
void knh_Compiler_initThisVariable(Ctx *ctx, Compiler *cpr, knh_class_t this_cid);
void knh_Stmt_run(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns);
void knh_StmtMETHOD_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtMETHOD_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtRETURN_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
void knh_StmtFORMAT_name(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtFORMAT_cmpl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, knh_type_t reqt, int level);
/* ../class/konohac/knh_StmtUSING.c */
void knh_StmtIMPORT_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtUIMPORT_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtUALIAS_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtUVOCAB_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtUENUM_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtUUNIT_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtUFUNC_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtUMAPMAP_decl(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
void knh_StmtUALIAS(Ctx *ctx, Stmt *stmt, Compiler *cpr, NameSpace *ns, int level);
/* ../class/konohac/knh_Stmt_const.c */
Term* knh_Stmt_const(Ctx *ctx, Stmt *b, knh_class_t reqc, NameSpace *ns);
/* ../class/konohac/knh_Term.c */
knh_type_t knh_Term_type(Term *tm);
Token *knh_Term_firstToken(Term *tm);
int knh_Term_isASIS(Term *tm);
int knh_Term_isCONST(Term *tm);
Object *knh_Term_constValue(Ctx *ctx, Term *tm, knh_class_t reqc);
Object *knh_Term_constValueNULL(Ctx *ctx, Term *tm, knh_class_t reqc);
int knh_Term_isERR(Term *tm);
void knh_Token_setERR(Ctx *ctx, Token *tk, String *msg);
/* ../class/konohac/knh_Token.c */
void knh_Token_struct_init(Ctx *ctx, knh_Token_struct *b, int init, Object *cs);
void knh_Token_struct_traverse(Ctx *ctx, knh_Token_struct *b, f_traverse gc);
Token* new_Token(Ctx *ctx, knh_flag_t flag, knh_fileid_t fileid, knh_line_t line, knh_token_t tt);
Token *new_Token__text(Ctx *ctx, Token *ftk, knh_bytes_t text);
void knh_Token_setFL(Token *o, Any *fln);
Token *new_TokenASIS(Ctx *ctx, Any *fln);
Token *new_TokenCID(Ctx *ctx, Any *fln, knh_class_t cid);
Token *new_TokenMN(Ctx *ctx, Any *fln, knh_methodn_t mn);
Token *new_TokenFN(Ctx *ctx, Any *fln, knh_fieldn_t fn);
Token *new_Token__S(Ctx *ctx, Any *fln, knh_token_t tt, String *t);
void knh_Token_tc(Token *o, knh_tokens_t *tc);
void knh_Token_tokens_add(Ctx *ctx, Token *o, Token *tk);
void knh_Token_tokens_empty(Ctx *ctx, Token *o);
char *knh_Token_tochar(Token *o);
knh_bytes_t knh_Token_tobytes(Token *o);
void knh_Token__s(Ctx *ctx, Token *o, OutputStream *w, Any *m);
void knh_Token__dump(Ctx *ctx, Token *o, OutputStream *w, Any *m);
/* ../class/konohac/knh_tokens_t.c */
Token* knh_tokens_curToken(knh_tokens_t *tc);
Token* knh_tokens_prevToken(knh_tokens_t *tc);
int knh_tokens_count(knh_tokens_t *tc, knh_token_t tt);
void knh_tokens_nextStmt(knh_tokens_t *tc);
void knh_tokens_stepFirstStmt(Ctx *ctx, knh_tokens_t *tc, knh_tokens_t *sub, int needsSEMICOLON);
void knh_tokens_ignore(Ctx *ctx, knh_tokens_t *tc);
void knh_tokens_stepFirstEXPR(Ctx *ctx, knh_tokens_t *tc, knh_token_t tt, knh_tokens_t *sub);
void knh_tokens_stepFirstEMPTYEXPR(Ctx *ctx, knh_tokens_t *tc, knh_token_t tt, knh_tokens_t *sub);
void knh_tokens_stepFirstComma(Ctx *ctx, knh_tokens_t *tc, knh_tokens_t *sub);
String *knh_tokens_toString(Ctx *ctx, knh_tokens_t *tc);
/* ../class/konohac/knh_Token_const.c */
Token* new_TokenCONST(Ctx *ctx, Any *fln, Any *data);
void knh_Token_setCONST(Ctx *ctx, Token *o, Any *data);
void knh_Token_toCONST(Token *o);
knh_type_t knh_Token_totype(Ctx *ctx, Token *o, knh_class_t defc, NameSpace *ns);
knh_class_t knh_Token_toclass(Ctx *ctx, Token *o, knh_class_t defc, NameSpace *ns);
int knh_Token_isLCONSTN(Token *tk);
void knh_Token_setLCONST(Ctx *ctx, Token *tk, NameSpace *ns);
knh_bool_t knh_Token_isSystemVariable(Token *tk);
void knh_Token_constSystemVariable(Ctx *ctx, Token *tk, Compiler *cpr);
Token *knh_Token_const(Ctx *ctx, Token *o, knh_class_t reqc, NameSpace *ns);
/* ../konoha/deps/btron/system__btron.c */
char* ALT_getenv(const char *name);
void *ALT_dlopen(const char* path, int mode);
void *ALT_dlsym(void* handle, const char* symbol);
const char *ALT_dlerror();
int ALT_dlclose(void* handle);
/* ../konoha/deps/cygwin/filesystem__cygwin.c */
char * knh_format_ospath(char *buf, size_t bufsiz, knh_bytes_t path);
char * knh_format_homepath(char *buf, size_t bufsiz);
/* ../konoha/deps/linux/filesystem__linux.c */
char * knh_format_ospath(char *buf, size_t bufsiz, knh_bytes_t path);
char * knh_format_homepath(char *buf, size_t bufsiz);
/* ../konoha/deps/macosx/filesystem__macosx.c */
char * knh_format_ospath(char *buf, size_t bufsiz, knh_bytes_t path);
char * knh_format_homepath(char *buf, size_t bufsiz);
/* ../konoha/deps/tk/file__tk.c */
char * knh_file_ospath(Ctx *ctx, knh_bytes_t path, char *buf, size_t bufsiz);
char * knh_file_knhpath(Ctx *ctx, knh_bytes_t path, char *buf, size_t bufsiz);
char *knh_file_getInstalledHomePath(char *buf, size_t bufsiz);
/* ../konoha/deps/win32/filesystem__win32.c */
char * knh_format_ospath(char *buf, size_t bufsiz, knh_bytes_t path);
char * knh_format_homepath(char *buf, size_t bufsiz);
/* ../konoha/deps/win32/system__win32.c */
void *ALT_dlopen(const char* path, int mode);
void *ALT_dlsym(void* handle, const char* symbol);
const char *ALT_dlerror();
int ALT_dlclose(void* handle);
/* ../konoha/knhapi/konoha_api.c */
/* ../konoha/knhapi/konoha_pkgapi.c */
void konoha_addConst(Ctx *ctx, char *name, Object *o);
/* ../konoha/knhapi/konoha_shell.c */
METHOD knh__Script_eval(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Script_isCompleteStatement(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Script_readline(Ctx *ctx, knh_sfp_t *sfp);
METHOD knh__Script_addHistory(Ctx *ctx, knh_sfp_t *sfp);
/* ../konoha/konoha.c */
int main(int argc, char **argv);
/* ../konoha/utils/utils_file.c */
char * knh_format_parentpath(char *buf, size_t bufsiz, knh_bytes_t path, int n);
char * knh_format_nzpath(char *buf, size_t bufsiz, knh_bytes_t path);
char * knh_format_catpath(char *buf, size_t bufsiz, knh_bytes_t path, knh_bytes_t file);
/* ../konoha/vm/knh_tClass.c */
void knh_tClass_init0(void);
void knh_tClass_traverse(Ctx *ctx, f_traverse f);
knh_class_t knh_tClass_newId(Ctx *ctx);
size_t knh_tClass_size(void);
int IS_cid(knh_class_t cid);
void KNH_TCLASS_NAME(Ctx *ctx, knh_class_t cid, String *lname);
String *knh_tClass_name(knh_class_t cid);
Object *knh_tClass_defaultValue(Ctx *ctx, knh_class_t cid);
knh_class_t KNH_TCLASS__T(Ctx *ctx, knh_flag_t flag, char *text, knh_class_t cid, knh_struct_t sid, knh_class_t supcid, knh_Object_t *cspec, f_default fdefault, int method_size);
void KNH_TCLASS_DEFAULT(Ctx *ctx, knh_class_t cid, Object *value, f_default fdefault);
void KNH_TCLASS_PARAM(Ctx *ctx, knh_class_t cid, knh_class_t p1, knh_class_t p2);
knh_class_t KNH_TPMZCLASS(Ctx *ctx, knh_class_t cid, String *name, knh_class_t bcid, knh_class_t p1, knh_class_t p2);
void KNH_ACLASS(Ctx *ctx, knh_class_t cid, knh_class_t p1);
void KNH_ICLASS(Ctx *ctx, knh_class_t cid, knh_class_t p1);
knh_class_t KNH_XCLASS(Ctx *ctx, knh_class_t cid, knh_class_t bcid, void *func);
/* ../konoha/vm/knh_tConst.c */
knh_bool_t knh_tConst_exists(Ctx *ctx, knh_bytes_t name);
Object *knh_tConst_value(Ctx *ctx, knh_bytes_t name);
knh_bool_t knh_tClass_addClassConst(Ctx *ctx, knh_class_t cid, knh_bytes_t name, Object *value);
void KNH_TCONST(Ctx *ctx, String *name, Object *value);
void KNH_TCONST__T(Ctx *ctx, char *name, Object *value);
Object *knh_tConst_systemValue(Ctx *ctx, int n);
/* ../konoha/vm/knh_tContext.c */
void knh_tContext_init0(void);
knh_Context_t *new_Context0(Runtime *runtime, size_t stacksize);
void knh_Context_traverse(Ctx *ctx, knh_Context_t *o, f_traverse ftr);
void knh_tContext_traverse(Ctx* ctx, f_traverse f);
/* ../konoha/vm/knh_tMapper.c */
void KNH_TMAPPER(Ctx *ctx, knh_flag_t flag, knh_type_t stype, knh_type_t ttype, f_mapper fmap, Object *mapdata);
Object* knh_Mapper_fInterface(Ctx *ctx, Object *o, Mapper *mpr);
Object* knh_Mapper_fNull(Ctx *ctx, Object *o, Mapper *mpr);
knh_bool_t knh_Mapper_isNoSuchMapping(Mapper *o);
Mapper *knh_tMapper_find(Ctx *ctx, knh_class_t scid, knh_class_t tcid);
/* ../konoha/vm/knh_tName.c */
void KNH_TFIELDN__T(Ctx *ctx, knh_fieldn_t fn, char *text);
String *knh_tfieldn_name(knh_fieldn_t fn);
knh_fieldn_t knh_tName_get_fnq(Ctx *ctx, knh_bytes_t tname, knh_fieldn_t def);
String *new_String__mn(Ctx *ctx, knh_methodn_t mn);
knh_methodn_t knh_tName_getMethodn(Ctx *ctx, knh_bytes_t tname, knh_methodn_t def);
char * knh_format_methodn(char *buf, size_t bufsiz, knh_methodn_t mn);
char * knh_format_methodparam(char *buf, size_t bufsiz, knh_methodn_t mn, int n);
char * knh_format_cmethodn(char *buf, size_t bufsiz, knh_class_t cid, knh_methodn_t mn);
knh_fileid_t knh_tName_getFileId(Ctx *ctx, knh_bytes_t t);
String *knh_tfileid_name(knh_fileid_t fileid);
/* ../konoha/vm/knh_tObject.c */
void *knh_malloc(Ctx *ctx, size_t size);
void knh_free(void *block, size_t size);
void *DBG2_malloc(Ctx *ctx, size_t size);
void DBG2_free(void *p, size_t size);
knh_Object_t *new_PObject__NNctx(Ctx *ctx, knh_flag_t flag, knh_class_t bcid, knh_class_t cid);
knh_Object_t *new_PObject0(Ctx *ctx, knh_flag_t flag, knh_class_t bcid, knh_class_t cid);
knh_Object_t *new_ObjectX_malloc(Ctx *ctx, knh_flag_t flag, knh_class_t bcid, knh_class_t cid, size_t size);
Object *new_Object(Ctx *ctx, knh_flag_t flag, knh_class_t cid);
void knh_Object_RCsweep(Ctx *ctx, Object *o);
void knh_Object_free(Ctx *ctx, knh_Object_t *o);
void knh_Object_traverse(Ctx *ctx, knh_Object_t *o, f_traverse ftr);
Object *new_Nue__T(Ctx *ctx, char *text);
knh_String_t *new_StringX__T(Ctx *ctx, knh_class_t cid, char *text);
void KNH_TSTATICOBJ(knh_Object_t **varaddr);
void knh_tObject_init0(void);
void knh_tObject_traverse(Ctx *ctx, f_traverse ftr);
/* ../konoha/vm/knh_tPackage.c */
void KNH_TDRVAPI(Ctx *ctx, char *alias, knh_drvapi_t* p);
knh_drvapi_t *knh_System_getDRVAPI(Ctx *ctx, int type, knh_bytes_t name);
void KNH_TSTATICLIB__T(Ctx *ctx, char *text, void *func);
int knh_System_using(Ctx *ctx, knh_bytes_t name);
NameSpace *knh_Runtime_getNameSpace(Ctx *ctx, knh_bytes_t name);
/* ../konoha/vm/knh_tStruct.c */
int IS_sid(knh_struct_t sid);
void knh_tStruct_init0(void);
void knh_tStruct_traverse(Ctx *ctx, f_traverse f);
knh_struct_t KNH_TSTRUCT(Ctx *ctx, 		knh_struct_t sid, size_t size, char *name, 		f_tStruct_init f0, f_tStruct_copy f1, /* f_tStruct_compare f2,*/ f_tStruct_traverse f3, 		f_hashCode f4, f_compareTo f5);
char *knh_tstruct_name(knh_struct_t sid);
/* ../konoha/vm/konoha_call.c */
void knh_stackf_locals(Ctx *ctx, size_t n);
knh_vargc_t knh_sfp_argc(Ctx *ctx, knh_sfp_t *varg);
Array *knh_sfp_toArray(Ctx *ctx, knh_sfp_t *varg);
void knh_stackf_new(Ctx *ctx, Object **mtdp);
void knh_sfp_typecheck__DCALL(Ctx *ctx, knh_sfp_t *mbp);
void knh_sfp_typecheck__MCALL(Ctx *ctx, knh_sfp_t *mbp);
void knh_sfp_dump(Ctx *ctx, knh_sfp_t *sfp);
/* ../konoha/vm/konoha_ext.c */
void knh_srand(knh_uint_t seed);
knh_uint_t knh_rand();
/* ../konoha/vm/konoha_locale.c */
char *konoha_encoding();
/* ../konoha/vm/konoha_print.c */
void knh_sfp_print(Ctx *ctx, knh_sfp_t *sfp, knh_flag_t flag, Object *s, knh_methodn_t mn, Object *o);
int knh_verbose(void);
/* ../konoha/vm/konoha_sync.c */
void knh_Object_lock(Ctx *ctx, Object *o);
void knh_Object_unlock(Ctx *ctx, Object *o);
/* ../konoha/vm/konoha_throwcatch.c */
void knh_konohavm_throwException(Ctx *ctx, Exception *e);
/* ../konoha/vm/konoha_time.c */
double knh_gettime();
/* ../konoha/vm/konoha_tmethod.c */
void KNH_TMETHOD(Ctx *ctx, knh_flag_t tflag, f_method func, void *optfunc, knh_ushort_t delta, knh_class_t cid, knh_methodn_t mn, MethodField *mf);
Method *knh_Method_ufind(Ctx *ctx, knh_class_t cid, knh_methodn_t mn);
Method *knh_tMethod_findMT(Ctx *ctx, knh_class_t cid, knh_methodn_t mn);
/* ../konoha/vm/konoha_typesystem.c */
knh_bool_t knh_class_instanceof(knh_class_t scid, knh_class_t tcid);
knh_bool_t knh_Object_opInstanceof(Ctx *ctx, Object *o, knh_class_t c);
knh_bool_t knh_Object_opTypeOf(Ctx *ctx, Object *o, knh_type_t t);
knh_bool_t knh_class_isSynonym(Ctx *ctx, knh_class_t scid, knh_class_t tcid);
Object * knh_Object_opAs(Ctx *ctx, Object *o, knh_class_t tcid);
Object *knh_Object_opAs__type(Ctx *ctx, Object *o, knh_type_t reqt, Object *def);
Exception* new_Exception__type(Ctx *ctx, Object *value, knh_type_t spec_type);

#ifdef __cplusplus
}
#endif

/* ======================================================================== */

#endif/*KONOHA_PROTO__H*/
