/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#include<konoha/konoha_dev.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

static int local_lang = 1;

/* ------------------------------------------------------------------------ */

static char* knh_system_lang[] = {
    "en",
    "ja",
    "debug"
};

int knh_system_langid(char *lang)
{
    int i;
    for(i = 0; i < KONOHA_LANG_MAXSIZ; i++) {
        if(knh_strcmp(knh_system_lang[i], lang) == 0) return i;
    }
    return local_lang;
}

/* ------------------------------------------------------------------------ */

int knh_system_setLang(char *lang)
{
    local_lang = knh_system_langid(lang);
    return local_lang;
}

/* ------------------------------------------------------------------------ */

static int knh_message_typedata[] = {
    /* KMSG_NAME */ 0,
    /* KMSG_ERRATA */ 0,
    /* KMSG_ETIME */ 0,
    /* KMSG_TYPEINF */ 0,
    /* KMSG_ERROR */ 0,
    /* KMSG_WARNING */ 0,
    /* KMSG_INFO */ 0,
    /* KMSG_ESYNTAX */ 1,
    /* KMSG_EFORGET_PARENTHESIS */ 2,
    /* KMSG_EMISMATCH */ 1,
    /* KMSG_WUNCLOSED */ 2,
    /* KMSG_WASCII */ 3,
    /* KMSG_WEOF */ 3,
    /* KMSG_WSEMICOLON */ 2,
    /* KMSG_IGSTMT */ 4,
    /* KMSG_ETOKEN */ 2,
    /* KMSG_ELENGTH */ 2,
    /* KMSG_WCLASSN */ 3,
    /* KMSG_WCONSTN */ 3,
    /* KMSG_WCMETHODN */ 3,
    /* KMSG_WNAME */ 3,
    /* KMSG_WIGNORED */ 3,
    /* KMSG_TEXPTN */ 1,
    /* KMSG_TNSNAME */ 1,
    /* KMSG_TFURN */ 1,
    /* KMSG_TCURN */ 1,
    /* KMSG_TNSCLASSN */ 1,
    /* KMSG_TTYPEN */ 1,
    /* KMSG_TMETHODN */ 1,
    /* KMSG_TCLASSTN */ 1,
    /* KMSG_TSTR */ 1,
    /* KMSG_TVARN */ 1,
    /* KMSG_TCLASSN */ 1,
    /* KMSG_TARGS */ 1,
    /* KMSG_TNAME */ 1,
    /* KMSG_TCMETHODN */ 1,
    /* KMSG_TMT */ 1,
    /* KMSG_TANY */ 1,
    /* KMSG_TSTMT1 */ 1,
    /* KMSG_TPEXPR */ 1,
    /* KMSG_TCATCHPARAM */ 1,
    /* KMSG_ELVALUE */ 1,
    /* KMSG_WTYPEINF */ 4,
    /* KMSG_NOTHERECONST */ 1,
    /* KMSG_NOTHERECLASSCONST */ 1,
    /* KMSG_NNCONST */ 1,
    /* KMSG_DUPCONST */ 1,
    /* KMSG_ENEXTPREV */ 1,
    /* KMSG_EEMPTYEXPR */ 1,
    /* KMSG_ETRINARY */ 1,
    /* KMSG_ETYPEOF */ 1,
    /* KMSG_EDEFAULT */ 1,
    /* KMSG_EPSTMT3 */ 1,
    /* KMSG_EPEACH */ 1,
    /* KMSG_WLET */ 4,
    /* KMSG_WEMPTYPEXPR */ 3,
    /* KMSG_WEMPTYARGS */ 3,
    /* KMSG_WTRUEFALSE */ 4,
    /* KMSG_USCRIPT */ 4,
    /* KMSG_UUOPTION */ 4,
    /* KMSG_UPACKAGE */ 4,
    /* KMSG_UCONSTN */ 4,
    /* KMSG_UVARN */ 4,
    /* KMSG_USYSTEMVARN */ 4,
    /* KMSG_UCLASSN */ 4,
    /* KMSG_UTAG */ 4,
    /* KMSG_UTYPEN */ 4,
    /* KMSG_UMETHODN */ 4,
    /* KMSG_UFUNCN */ 4,
    /* KMSG_ULABEL */ 4,
    /* KMSG_UOP */ 2,
    /* KMSG_UOP1 */ 2,
    /* KMSG_UOP2 */ 2,
    /* KMSG_UNEW */ 2,
    /* KMSG_UMAP */ 2,
    /* KMSG_INTOVERFLOW */ 4,
    /* KMSG_FLOATOVERFLOW */ 4,
    /* KMSG_INT64OVERFLOW */ 4,
    /* KMSG_ETOOFEWPARAMS */ 2,
    /* KMSG_WTOOMANYPARAMS */ 3,
    /* KMSG_EOP2 */ 2,
    /* KMSG_EOPCMP */ 4,
    /* KMSG_EVOIDPARAM */ 3,
    /* KMSG_ENULLPARAM */ 3,
    /* KMSG_WNULLPARAM */ 3,
    /* KMSG_ETYPEPARAM */ 3,
    /* KMSG_EVOIDRETURN */ 3,
    /* KMSG_ENULLRETURN */ 3,
    /* KMSG_WNULLRETURN */ 3,
    /* KMSG_ETYPERETURN */ 3,
    /* KMSG_EVOIDLET */ 3,
    /* KMSG_EVOID */ 3,
    /* KMSG_ENULLLET */ 3,
    /* KMSG_ENULL */ 3,
    /* KMSG_WNULLLET */ 3,
    /* KMSG_WNULL */ 3,
    /* KMSG_ETYPELET */ 3,
    /* KMSG_ETYPE */ 3,
    /* KMSG_WDUPFUNCNAME */ 5,
    /* KMSG_USCLASSFUNC */ 2,
    /* KMSG_USNNTYPE */ 2,
    /* KMSG_IGNNTYPE */ 2,
    /* KMSG_EEXTENDS */ 2,
    /* KMSG_EIMPLEMENTS */ 2,
    /* KMSG_DIFFDECL */ 2,
    /* KMSG_DIFFCLASSN */ 4,
    /* KMSG_DIFFNEWTYPE */ 4,
    /* KMSG_DIFFRTYPE */ 2,
    /* KMSG_DIFFPSIZE */ 2,
    /* KMSG_DIFFPTYPE */ 2,
    /* KMSG_DIFFPNAME */ 4,
    /* KMSG_TOOMANYVARS */ 2,
    /* KMSG_EOUTERLOOP */ 4,
    /* KMSG_IGFIELDVALUE */ 3,
    /* KMSG_IGSCRIPTNAME */ 3,
    /* KMSG_IGFIELDNAME */ 3,
    /* KMSG_NORETURN */ 2,
    /* KMSG_NORETURNVALUE */ 1,
    /* KMSG_IGRETURN */ 4,
    /* KMSG_AHISTORIC */ 2,
    /* KMSG_AOVERRIDE */ 2,
    /* KMSG_EOVERRIDE */ 2,
    /* KMSG_TOABSTRACT */ 4,
    /* KMSG_WMAPFOREACH */ 4,
    0
};

int knh_message_type(int e)
{
    DEBUG_ASSERT(e<KMSG_MAXSIZ);
    return knh_message_typedata[e];
}

/* ------------------------------------------------------------------------ */

static char* knh_message_data[] = {
    /* KMSG_NAME */ 
        /* en */ "Konoha",
        /* ja */ "木の葉",
        "NAME",
    
    /* KMSG_ERRATA */ 
        /* en */ "ERRATA",
        /* ja */ "訂正",
        "ERRATA",
    
    /* KMSG_ETIME */ 
        /* en */ "Elapsed Time",
        /* ja */ "実行時間",
        "ETIME",
    
    /* KMSG_TYPEINF */ 
        /* en */ "type inferencing",
        /* ja */ "型推論",
        "TYPEINF",
    
    /* KMSG_ERROR */ 
        /* en */ "error",
        /* ja */ "エラー",
        "ERROR",
    
    /* KMSG_WARNING */ 
        /* en */ "warning",
        /* ja */ "警告",
        "WARNING",
    
    /* KMSG_INFO */ 
        /* en */ "info",
        /* ja */ "通知",
        "INFO",
    
    /* KMSG_ESYNTAX */ 
        /* en */ "Syntax Error",
        /* ja */ "文法間違いを直してください",
        "ESYNTAX",
    
    /* KMSG_EFORGET_PARENTHESIS */ 
        /* en */ NULL,
        /* ja */ "{の前で括弧を閉じ忘れています",
        "EFORGET_PARENTHESIS",
    
    /* KMSG_EMISMATCH */ 
        /* en */ NULL,
        /* ja */ "括弧の対応をあわせてください",
        "EMISMATCH",
    
    /* KMSG_WUNCLOSED */ 
        /* en */ NULL,
        /* ja */ "閉じてください",
        "WUNCLOSED",
    
    /* KMSG_WASCII */ 
        /* en */ NULL,
        /* ja */ "ASCII文字（半角）をお使いください",
        "WASCII",
    
    /* KMSG_WEOF */ 
        /* en */ NULL,
        /* ja */ "行の途中でファイルが終端しています",
        "WEOF",
    
    /* KMSG_WSEMICOLON */ 
        /* en */ "Add ';' at the end of the statement.",
        /* ja */ "文末にはセミコロン(;)を追加してください",
        "WSEMICOLON",
    
    /* KMSG_IGSTMT */ 
        /* en */ NULL,
        /* ja */ "無効果なステートメントなため無視されました",
        "IGSTMT",
    
    /* KMSG_ETOKEN */ 
        /* en */ NULL,
        /* ja */ "名前でも演算子でもありません",
        "ETOKEN",
    
    /* KMSG_ELENGTH */ 
        /* en */ NULL,
        /* ja */ "名前の長さを短くしてください",
        "ELENGTH",
    
    /* KMSG_WCLASSN */ 
        /* en */ NULL,
        /* ja */ "正しいクラス名に修正してください",
        "WCLASSN",
    
    /* KMSG_WCONSTN */ 
        /* en */ NULL,
        /* ja */ "正しい定数名に修正してください",
        "WCONSTN",
    
    /* KMSG_WCMETHODN */ 
        /* en */ NULL,
        /* ja */ "正しいクラスメソッド名に修正してください",
        "WCMETHODN",
    
    /* KMSG_WNAME */ 
        /* en */ NULL,
        /* ja */ "正しい名前に修正してください",
        "WNAME",
    
    /* KMSG_WIGNORED */ 
        /* en */ NULL,
        /* ja */ "次の字句は無視されました",
        "WIGNORED",
    
    /* KMSG_TEXPTN */ 
        /* en */ NULL,
        /* ja */ "正しい例外名を与えてください",
        "TEXPTN",
    
    /* KMSG_TNSNAME */ 
        /* en */ NULL,
        /* ja */ "正しい名前空間名を与えてください",
        "TNSNAME",
    
    /* KMSG_TFURN */ 
        /* en */ NULL,
        /* ja */ "スクリプトファイル(*.k)のパスを与えてください",
        "TFURN",
    
    /* KMSG_TCURN */ 
        /* en */ NULL,
        /* ja */ "クラス名かURNを与えてください",
        "TCURN",
    
    /* KMSG_TNSCLASSN */ 
        /* en */ NULL,
        /* ja */ "正しい名前空間付きのクラス名を与えてください",
        "TNSCLASSN",
    
    /* KMSG_TTYPEN */ 
        /* en */ NULL,
        /* ja */ "正しい型名を与えてください",
        "TTYPEN",
    
    /* KMSG_TMETHODN */ 
        /* en */ NULL,
        /* ja */ "正しいメソッド名を与えてください",
        "TMETHODN",
    
    /* KMSG_TCLASSTN */ 
        /* en */ NULL,
        /* ja */ "正しいクラス名（タグ付き）を与えてください",
        "TCLASSTN",
    
    /* KMSG_TSTR */ 
        /* en */ NULL,
        /* ja */ "正しい文字列を与えてください",
        "TSTR",
    
    /* KMSG_TVARN */ 
        /* en */ NULL,
        /* ja */ "正しい変数名を与えてください",
        "TVARN",
    
    /* KMSG_TCLASSN */ 
        /* en */ NULL,
        /* ja */ "正しいクラス名を与えてください",
        "TCLASSN",
    
    /* KMSG_TARGS */ 
        /* en */ NULL,
        /* ja */ "正しくパラメータをあたえてください",
        "TARGS",
    
    /* KMSG_TNAME */ 
        /* en */ NULL,
        /* ja */ "正しい名前を与えてください",
        "TNAME",
    
    /* KMSG_TCMETHODN */ 
        /* en */ NULL,
        /* ja */ "正しいクラス名付きメソッド名を与えてください",
        "TCMETHODN",
    
    /* KMSG_TMT */ 
        /* en */ NULL,
        /* ja */ "正しいフォーマッタ名を与えてください",
        "TMT",
    
    /* KMSG_TANY */ 
        /* en */ NULL,
        /* ja */ "正しいトークンを与えてください",
        "TANY",
    
    /* KMSG_TSTMT1 */ 
        /* en */ NULL,
        /* ja */ "正しく行をはじめてください",
        "TSTMT1",
    
    /* KMSG_TPEXPR */ 
        /* en */ NULL,
        /* ja */ "正しく条件式を与えてください",
        "TPEXPR",
    
    /* KMSG_TCATCHPARAM */ 
        /* en */ NULL,
        /* ja */ "catch文のパラメータを与えてください",
        "TCATCHPARAM",
    
    /* KMSG_ELVALUE */ 
        /* en */ NULL,
        /* ja */ "代入可能な変数名を与えてください",
        "ELVALUE",
    
    /* KMSG_WTYPEINF */ 
        /* en */ NULL,
        /* ja */ "型推論ができませんでした．Any型を使います",
        "WTYPEINF",
    
    /* KMSG_NOTHERECONST */ 
        /* en */ NULL,
        /* ja */ "定数が定義できるのはスクリプトかクラス内のみです",
        "NOTHERECONST",
    
    /* KMSG_NOTHERECLASSCONST */ 
        /* en */ NULL,
        /* ja */ "この位置ではクラス名を付きで定数は定義できません",
        "NOTHERECLASSCONST",
    
    /* KMSG_NNCONST */ 
        /* en */ NULL,
        /* ja */ "左辺に定数を与えてください",
        "NNCONST",
    
    /* KMSG_DUPCONST */ 
        /* en */ NULL,
        /* ja */ "同じ定数名で再定義することはできません",
        "DUPCONST",
    
    /* KMSG_ENEXTPREV */ 
        /* en */ NULL,
        /* ja */ "--演算,++演算が評価できない式です",
        "ENEXTPREV",
    
    /* KMSG_EEMPTYEXPR */ 
        /* en */ NULL,
        /* ja */ "正しい式をあたえてください",
        "EEMPTYEXPR",
    
    /* KMSG_ETRINARY */ 
        /* en */ NULL,
        /* ja */ "三項演算子のtrueとfalseの式はコロン(:)で区切ってください",
        "ETRINARY",
    
    /* KMSG_ETYPEOF */ 
        /* en */ NULL,
        /* ja */ "組み込み関数 typeof() に正しく引数を与えてください",
        "ETYPEOF",
    
    /* KMSG_EDEFAULT */ 
        /* en */ NULL,
        /* ja */ "組み込み関数 default() に正しく引数を与えてください",
        "EDEFAULT",
    
    /* KMSG_EPSTMT3 */ 
        /* en */ NULL,
        /* ja */ "正しくfor(stmt;expr;stmt) 文を書いてください",
        "EPSTMT3",
    
    /* KMSG_EPEACH */ 
        /* en */ NULL,
        /* ja */ "foreach(.. from .. where..) 文を書いてください",
        "EPEACH",
    
    /* KMSG_WLET */ 
        /* en */ NULL,
        /* ja */ "条件式では代入を使わないでください",
        "WLET",
    
    /* KMSG_WEMPTYPEXPR */ 
        /* en */ NULL,
        /* ja */ "空っぽの条件式では困ります",
        "WEMPTYPEXPR",
    
    /* KMSG_WEMPTYARGS */ 
        /* en */ NULL,
        /* ja */ "引数を与えてください",
        "WEMPTYARGS",
    
    /* KMSG_WTRUEFALSE */ 
        /* en */ NULL,
        /* ja */ "Booleanの定数には、trueかfalseを用いましょう",
        "WTRUEFALSE",
    
    /* KMSG_USCRIPT */ 
        /* en */ NULL,
        /* ja */ "スクリプトファイルが開けません",
        "USCRIPT",
    
    /* KMSG_UUOPTION */ 
        /* en */ NULL,
        /* ja */ "サポート外のusingオプションが利用されました",
        "UUOPTION",
    
    /* KMSG_UPACKAGE */ 
        /* en */ "You're attempting to use an uninstalled package",
        /* ja */ "未インストールのパッケージを利用しようとしました",
        "UPACKAGE",
    
    /* KMSG_UCONSTN */ 
        /* en */ NULL,
        /* ja */ "未定義の定数を使用しました",
        "UCONSTN",
    
    /* KMSG_UVARN */ 
        /* en */ NULL,
        /* ja */ "未宣言の変数を使用しました",
        "UVARN",
    
    /* KMSG_USYSTEMVARN */ 
        /* en */ NULL,
        /* ja */ "未定義のシステム変数を使用しました",
        "USYSTEMVARN",
    
    /* KMSG_UCLASSN */ 
        /* en */ NULL,
        /* ja */ "未定義のクラス名を使用しました",
        "UCLASSN",
    
    /* KMSG_UTAG */ 
        /* en */ NULL,
        /* ja */ "未定義のクラスタグを使用しました",
        "UTAG",
    
    /* KMSG_UTYPEN */ 
        /* en */ NULL,
        /* ja */ "未定義の型を使用しました",
        "UTYPEN",
    
    /* KMSG_UMETHODN */ 
        /* en */ NULL,
        /* ja */ "定義されていないメソッドを使用しました",
        "UMETHODN",
    
    /* KMSG_UFUNCN */ 
        /* en */ NULL,
        /* ja */ "定義されていない関数メソッドを使用しました",
        "UFUNCN",
    
    /* KMSG_ULABEL */ 
        /* en */ NULL,
        /* ja */ "未定義のラベルを用いました",
        "ULABEL",
    
    /* KMSG_UOP */ 
        /* en */ NULL,
        /* ja */ "定義されていない演算子を用いました",
        "UOP",
    
    /* KMSG_UOP1 */ 
        /* en */ NULL,
        /* ja */ "この演算子は、単項演算子です",
        "UOP1",
    
    /* KMSG_UOP2 */ 
        /* en */ NULL,
        /* ja */ "この演算子は、２項演算子です",
        "UOP2",
    
    /* KMSG_UNEW */ 
        /* en */ NULL,
        /* ja */ "定義されていないコンストラクタを用いました",
        "UNEW",
    
    /* KMSG_UMAP */ 
        /* en */ NULL,
        /* ja */ "マッピングは定義されていません",
        "UMAP",
    
    /* KMSG_INTOVERFLOW */ 
        /* en */ NULL,
        /* ja */ "整数(Int)の最大値もしくは最小値を超えました",
        "INTOVERFLOW",
    
    /* KMSG_FLOATOVERFLOW */ 
        /* en */ NULL,
        /* ja */ "浮動点少数(Float)の最大値もしくは最小値を超えました",
        "FLOATOVERFLOW",
    
    /* KMSG_INT64OVERFLOW */ 
        /* en */ NULL,
        /* ja */ "64ビット整数の最大値もしくは最小値を超えました",
        "INT64OVERFLOW",
    
    /* KMSG_ETOOFEWPARAMS */ 
        /* en */ NULL,
        /* ja */ "与えられた引数の数が少な過ぎます",
        "ETOOFEWPARAMS",
    
    /* KMSG_WTOOMANYPARAMS */ 
        /* en */ NULL,
        /* ja */ "与えられた引数の数が多過ぎます",
        "WTOOMANYPARAMS",
    
    /* KMSG_EOP2 */ 
        /* en */ NULL,
        /* ja */ "この演算子は、2項演算子専用です",
        "EOP2",
    
    /* KMSG_EOPCMP */ 
        /* en */ NULL,
        /* ja */ "型が異なるため比較することはできません",
        "EOPCMP",
    
    /* KMSG_EVOIDPARAM */ 
        /* en */ NULL,
        /* ja */ "メソッド引数にはvoid型のメソッド（関数）を用いることはできません",
        "EVOIDPARAM",
    
    /* KMSG_ENULLPARAM */ 
        /* en */ NULL,
        /* ja */ "次のメソッド引数で必ずNull例外が発生します",
        "ENULLPARAM",
    
    /* KMSG_WNULLPARAM */ 
        /* en */ NULL,
        /* ja */ "次のメソッド引数においてNull例外が発生する可能性があります",
        "WNULLPARAM",
    
    /* KMSG_ETYPEPARAM */ 
        /* en */ NULL,
        /* ja */ "次のメソッド引数の型が一致しません",
        "ETYPEPARAM",
    
    /* KMSG_EVOIDRETURN */ 
        /* en */ NULL,
        /* ja */ "return文の戻り値としてvoid型のメソッド（関数）を使うことはできません",
        "EVOIDRETURN",
    
    /* KMSG_ENULLRETURN */ 
        /* en */ NULL,
        /* ja */ "このメソッドではnullをreturnすることはできません",
        "ENULLRETURN",
    
    /* KMSG_WNULLRETURN */ 
        /* en */ NULL,
        /* ja */ "return時にNull例外が発生する可能性があります",
        "WNULLRETURN",
    
    /* KMSG_ETYPERETURN */ 
        /* en */ NULL,
        /* ja */ "return文の型が一致しません",
        "ETYPERETURN",
    
    /* KMSG_EVOIDLET */ 
        /* en */ NULL,
        /* ja */ "void型のメソッド（関数）を代入することはできません",
        "EVOIDLET",
    
    /* KMSG_EVOID */ 
        /* en */ NULL,
        /* ja */ "void型のメソッド（関数）を用いることはできません",
        "EVOID",
    
    /* KMSG_ENULLLET */ 
        /* en */ NULL,
        /* ja */ "Nullを代入することはできません",
        "ENULLLET",
    
    /* KMSG_ENULL */ 
        /* en */ NULL,
        /* ja */ "Nullは与えられません",
        "ENULL",
    
    /* KMSG_WNULLLET */ 
        /* en */ NULL,
        /* ja */ "代入時にNull例外が発生する可能性があります",
        "WNULLLET",
    
    /* KMSG_WNULL */ 
        /* en */ NULL,
        /* ja */ "Null例外が発生する可能性があります",
        "WNULL",
    
    /* KMSG_ETYPELET */ 
        /* en */ NULL,
        /* ja */ "代入の右辺と左辺式の型が一致しません",
        "ETYPELET",
    
    /* KMSG_ETYPE */ 
        /* en */ NULL,
        /* ja */ "型が一致しません",
        "ETYPE",
    
    /* KMSG_WDUPFUNCNAME */ 
        /* en */ NULL,
        /* ja */ "スタティック関数名とメソッド名が重複しています",
        "WDUPFUNCNAME",
    
    /* KMSG_USCLASSFUNC */ 
        /* en */ NULL,
        /* ja */ "与えられたクラスはクラス関数をサポートしていません",
        "USCLASSFUNC",
    
    /* KMSG_USNNTYPE */ 
        /* en */ NULL,
        /* ja */ "与えられたクラスではNonNull属性は使えません",
        "USNNTYPE",
    
    /* KMSG_IGNNTYPE */ 
        /* en */ NULL,
        /* ja */ "NonNull属性は無視されました",
        "IGNNTYPE",
    
    /* KMSG_EEXTENDS */ 
        /* en */ NULL,
        /* ja */ "finalクラスを拡張することはできません",
        "EEXTENDS",
    
    /* KMSG_EIMPLEMENTS */ 
        /* en */ NULL,
        /* ja */ "インターフェースとして実装するためには、@Interfaceが必要です",
        "EIMPLEMENTS",
    
    /* KMSG_DIFFDECL */ 
        /* en */ NULL,
        /* ja */ "既に別の型で宣言されています",
        "DIFFDECL",
    
    /* KMSG_DIFFCLASSN */ 
        /* en */ NULL,
        /* ja */ "class 文のクラス名とメソッドのクラス名が異なります",
        "DIFFCLASSN",
    
    /* KMSG_DIFFNEWTYPE */ 
        /* en */ NULL,
        /* ja */ "コンストラクタ(new メソッド）のクラスが異なります",
        "DIFFNEWTYPE",
    
    /* KMSG_DIFFRTYPE */ 
        /* en */ NULL,
        /* ja */ "既存のメソッドと戻り値の型が一致しません",
        "DIFFRTYPE",
    
    /* KMSG_DIFFPSIZE */ 
        /* en */ NULL,
        /* ja */ "既存のメソッドと引数の数が一致しません",
        "DIFFPSIZE",
    
    /* KMSG_DIFFPTYPE */ 
        /* en */ NULL,
        /* ja */ "既存のメソッドと引数の型が一致しません",
        "DIFFPTYPE",
    
    /* KMSG_DIFFPNAME */ 
        /* en */ NULL,
        /* ja */ "既存のメソッドと引数名が異なります",
        "DIFFPNAME",
    
    /* KMSG_TOOMANYVARS */ 
        /* en */ NULL,
        /* ja */ "変数を多く宣言しすぎました",
        "TOOMANYVARS",
    
    /* KMSG_EOUTERLOOP */ 
        /* en */ NULL,
        /* ja */ "ループの内側でないため無視されます",
        "EOUTERLOOP",
    
    /* KMSG_IGFIELDVALUE */ 
        /* en */ NULL,
        /* ja */ "フィールド変数の初期値は定数のみ認められます",
        "IGFIELDVALUE",
    
    /* KMSG_IGSCRIPTNAME */ 
        /* en */ NULL,
        /* ja */ "ここではスクリプト変数を新たに宣言することはできません",
        "IGSCRIPTNAME",
    
    /* KMSG_IGFIELDNAME */ 
        /* en */ NULL,
        /* ja */ "ここではフィールド変数を新たに宣言することはできません",
        "IGFIELDNAME",
    
    /* KMSG_NORETURN */ 
        /* en */ NULL,
        /* ja */ "return文がありません",
        "NORETURN",
    
    /* KMSG_NORETURNVALUE */ 
        /* en */ NULL,
        /* ja */ "return文に正しい戻り値を与えてください",
        "NORETURNVALUE",
    
    /* KMSG_IGRETURN */ 
        /* en */ NULL,
        /* ja */ "return文のパラメータは無視されました",
        "IGRETURN",
    
    /* KMSG_AHISTORIC */ 
        /* en */ NULL,
        /* ja */ "このステートメントを使用するためには@Historicが必要です",
        "AHISTORIC",
    
    /* KMSG_AOVERRIDE */ 
        /* en */ NULL,
        /* ja */ "再定義しなおすときは@Overrideが必要です",
        "AOVERRIDE",
    
    /* KMSG_EOVERRIDE */ 
        /* en */ NULL,
        /* ja */ "オーバーライドは許可されていません",
        "EOVERRIDE",
    
    /* KMSG_TOABSTRACT */ 
        /* en */ NULL,
        /* ja */ "コンパイルが中断されたため、抽象メソッドとして定義されました",
        "TOABSTRACT",
    
    /* KMSG_WMAPFOREACH */ 
        /* en */ NULL,
        /* ja */ "foreach 文においてMapキャストが必要となります",
        "WMAPFOREACH",
    
};

char *knh_message_text(int e)
{
    char *msg;
    DEBUG_ASSERT(e<KMSG_MAXSIZ);
    msg = knh_message_data[e * (KONOHA_LANG_MAXSIZ) + local_lang];
    if(msg != NULL) return msg;
    return knh_message_data[e * (KONOHA_LANG_MAXSIZ) + KONOHA_LANG__debug];
}

/* ------------------------------------------------------------------------ */

char *knh_message_tochar(int e)
{
    DEBUG_ASSERT(e<KMSG_MAXSIZ);
    return knh_message_data[e * (KONOHA_LANG_MAXSIZ) + KONOHA_LANG__debug];
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
