/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#define KNH_PACKAGE "math"

#include<konoha.h>

#ifdef KNH_USING_MATH
#include<math.h>    /* @using math -lm */
#endif

#ifdef __cplusplus
extern "C" {
#endif


/* ======================================================================== */
/* [method] */

#ifdef KNH_USING_MATH

/* ------------------------------------------------------------------------ */
/* @method Float! Math.sin(Float! v) */

static
METHOD knh__Math_sin(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN(ctx, sfp, new_Float(ctx, (knh_float_t)sin((double)(sfp[1].f)->value)));
}

/* ------------------------------------------------------------------------ */
/* @method Float! Math.abs(Float! v) */

static
METHOD knh__Math_abs(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN(ctx, sfp, new_Float(ctx, (knh_float_t)fabs((double)(sfp[1].f)->value)));
}

#endif/*KNH_USING_MATH*/

/* ======================================================================== */
/* [KNHAPI] */

void KNHAPI knhmath_traverse(Ctx *ctx, f_traverse ftr)
{

}

/* ------------------------------------------------------------------------ */

int KNHAPI knhmath_init(Ctx *ctx)
{
	fprintf(stderr, "loading math..");
#ifdef KNH_USING_MATH
	konoha_addVirtualClass(ctx, "Math", 8);
	konoha_addMethod(ctx, "Float! Math.abs(Float! v)", knh__Math_abs);
	konoha_addMethod(ctx, "float Math.sin(float v)", knh__Math_sin);
	konoha_addFloatConst(ctx, "Math.PI", (knh_float_t)M_PI);
	konoha_addFloatConst(ctx, "Math.E", (knh_float_t)M_E);
	return 1;
#else/*KNH_USING_MATH*/
	KNH_WARNING(ctx, "package[math] Needs -DKNH_USING_MATH");
	return 0;
#endif/*KNH_USING_MATH*/
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif

