/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [constructor] */

/* @method OutputStream OutputStream.new(String! urn, String mode) */

METHOD knh__OutputStream_new(Ctx *ctx, knh_sfp_t *sfp)
{
	OutputStream *o = (OutputStream*)sfp[0].o;
	KNH_RETURN(ctx, sfp, knh_OutputStream_open(ctx, o, sfp[1].s, sfp[2].s));
}

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */
/* @method void OutputStream.write(Bytes! buf, Int offset, Int len) */

METHOD knh__OutputStream_write(Ctx *ctx, knh_sfp_t *sfp)
{
	OutputStream *o = (OutputStream*)sfp[0].o;
	knh_bytes_t buf = knh_Bytes_tobytes((Bytes*)sfp[1].o);
	size_t s = IS_NULL(sfp[2].o) ? 0 : knh_array_index(ctx, ARG_int(sfp[2]), buf.len);
	if(IS_NULL(sfp[3].o)) {
		size_t len = buf.len - s;
		DP(o)->apis.fwrite(ctx, DP(o)->outptr, (char*)(buf.buf + s), len);
		DP(o)->size += len;
	}
	else {
		size_t len = (sfp[3].i)->value;
		if(s + len > buf.len) {
			len = buf.len - s;
		}
		DP(o)->apis.fwrite(ctx, DP(o)->outptr, (char*)(buf.buf + s), len);
		DP(o)->size += len;
	}
}

/* ------------------------------------------------------------------------ */
/* @method void OutputStream.setEncoding(String enc) */

void knh_OutputStream_setEncoding(Ctx *ctx, OutputStream *o, String *enc)
{
	if(IS_NULL(enc)) {
		KNH_SETv(ctx, DP(o)->enc, TS_ENCODING);
		KNH_SETv(ctx, DP(o)->bconv, KNH_NULL);
	}
	else if(knh_bytes_strcasecmp(knh_String_tobytes(enc), STEXT(KONOHA_ENCODING)) == 0) {
		KNH_SETv(ctx, DP(o)->enc, TS_ENCODING);
		KNH_SETv(ctx, DP(o)->bconv, KNH_NULL);
	}
	else {
		BytesConv *bout = new_BytesConv__out(ctx, knh_String_tochar(enc));
		if(IS_NULL(bout)) {
			KNH_SETv(ctx, DP(o)->enc, TS_ENCODING);
			KNH_WARNING(ctx, "unsupported character encoding: %s", knh_String_tochar(enc));
		}
		else {
			KNH_SETv(ctx, DP(o)->enc, enc);
		}
		KNH_SETv(ctx, DP(o)->bconv, bout);
	}
}

/* ------------------------------------------------------------------------ */
/* @method void OutputStream.print(Any v) */

METHOD knh__OutputStream_print(Ctx *ctx, knh_sfp_t *sfp)
{
	if(IS_bString(sfp[1].o)) {
		knh_OutputStream_print_(ctx, (OutputStream*)sfp[0].o, knh_String_tobytes(sfp[1].s), 0);
	}
	else {
		knh_format(ctx, (OutputStream*)sfp[0].o, METHODN__s, sfp[1].o, KNH_NULL);
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */
/* @method void OutputStream.println(Any v) */

METHOD knh__OutputStream_println(Ctx *ctx, knh_sfp_t *sfp)
{
	if(IS_bString(sfp[1].o)) {
		knh_OutputStream_print_(ctx, (OutputStream*)sfp[0].o, knh_String_tobytes(sfp[1].s), 1);
	}
	else {
		knh_format(ctx, (OutputStream*)sfp[0].o, METHODN__s, sfp[1].o, KNH_NULL);
		knh_write_EOL(ctx, (OutputStream*)sfp[0].o);
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS] void OutputStream.opLshift(Any v) */

METHOD knh__OutputStream_opLshift(Ctx *ctx, knh_sfp_t *sfp)
{
	OutputStream *out = (OutputStream*)sfp[0].o;
	knh_sfp_t *v = sfp + 1;
	knh_vargc_t ac = knh_sfp_argc(ctx, v);
	size_t i;
	for(i = 0; i < ac; i++) {
		if(IS_bString(v[i].o)) {
			if(v[i].s == TS_EOL) {
				knh_write_EOL(ctx, out);
			}
			else if(v[i].s == TS_BEGIN) {
				DP(out)->indent++;
			}
			else if(v[i].s == TS_END) {
				DP(out)->indent--;
			}
			else {
				knh_OutputStream_print_(ctx, out, knh_String_tobytes(v[i].s), 0);
			}
		}
		else {
			knh_format(ctx, out, METHODN__s, v[i].o, KNH_NULL);
		}
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ======================================================================== */
/* [mapping] */

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [movabletext] */

/* ------------------------------------------------------------------------ */
/* @method void OutputStream.%k(OutputStream w, String m) */

void knh_OutputStream__k(Ctx *ctx, OutputStream *o, OutputStream *w, String *m)
{
	knh_putc(ctx, w, '\'');
	knh_print(ctx, w, knh_String_tobytes(DP(o)->urn));
	knh_putc(ctx, w, '\'');
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
