/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

#ifndef KONOHAC_ERROR_BUFSIZ
#define KONOHAC_ERROR_BUFSIZ 512
#endif

/* ======================================================================== */
/* [perrata] */

void
knh_perrata(Ctx *ctx, knh_fileid_t fileid, int line, char *oldt, char *newt)
{
	char buf[512];
	OutputStream *w = KNH_STDERR;
	knh_snprintf(buf, sizeof(buf), "\t%s:%d (%s): ", FILEIDN(fileid), line, knh_message_text(KMSG_ERRATA));
	knh_print(ctx, w, B(buf));
	knh_write__s(ctx, w, oldt);
	knh_write__s(ctx, w, " ==> ");
	knh_write__s(ctx, w, newt);
	knh_write_EOL(ctx, w);
}

#define _KNH_PERRATA_(ctx, f, l, msgo, msgn)    knh_perrata(ctx, f, l, msgo, msgn)
#define _KNH_PERRATA(ctx, tk, msg)  knh_perrata(ctx, (tk)->fileid, (tk)->line, knh_Token_tochar(tk), msg)

/* ------------------------------------------------------------------------ */

void
knh_Token_perrata(Ctx *ctx, Token *o, char *newtoken)
{
	knh_perrata(ctx, SP(o)->fileid, SP(o)->line, knh_Token_tochar(o), newtoken);
}

/* ======================================================================== */
/* [perror] */

void
knh_perror(Ctx *ctx, knh_fileid_t fileid, int line, int pe, char *msg)
{
	char buf[512];
	OutputStream *w = KNH_STDERR;
#ifdef KNH_DBGMODE
	knh_snprintf(buf, sizeof(buf), " - [%s:%d]:%s(%d) ", FILEIDN(fileid), line, knh_message_tochar(pe), knh_message_type(pe));
#else
	switch(knh_message_type(pe)) {
	case 1:
		knh_snprintf(buf, sizeof(buf), " - [%s:%d]:(%s) ", FILEIDN(fileid), line, knh_message_text(KMSG_ERROR));
		break;
	case 3:
		if(!knh_Context_isCompiling(ctx)) return;
		knh_snprintf(buf, sizeof(buf), " - [%s:%d]:(%s) ", FILEIDN(fileid), line, knh_message_text(KMSG_INFO));
		break;
	default:
		if(!knh_Context_isCompiling(ctx)) return;
		knh_snprintf(buf, sizeof(buf), " - [%s:%d]:(%s) ", FILEIDN(fileid), line, knh_message_text(KMSG_WARNING));
		break;
	}
#endif
	knh_write__s(ctx, w, buf);
	if(msg == NULL || msg[0] == 0) {
		knh_println(ctx, w, B(knh_message_text(pe)));
	}
	else {
		knh_print(ctx, w, B(knh_message_text(pe)));
		knh_write__s(ctx, w, ": ");
		knh_println(ctx, w, B(msg));
	}
}

/* ------------------------------------------------------------------------ */

void
knh_Token_perror(Ctx *ctx, Token *o, int pe)
{
	knh_perror(ctx, SP(o)->fileid, (int)SP(o)->line, pe, knh_Token_tochar(o));
	if(knh_message_type(pe) == 1) {
		SP(o)->tt = TT_ERR;
	}
}

///* ------------------------------------------------------------------------ */
//
//void
//knh_tokens_perror(Ctx *ctx, knh_tokens_t *tc, int pe)
//{
//	Token *tk = knh_tokens_curToken(tc);
//	knh_perror(ctx, SP(tk)->fileid, (int)SP(tk)->line, pe, knh_Token_tochar(tk));
//}

/* ------------------------------------------------------------------------ */

void knh_Stmt_tokens_perror(Ctx *ctx, Stmt *o, knh_tokens_t *tc, int pe)
{
	Token *tk = knh_tokens_curToken(tc);
	knh_perror(ctx, SP(tk)->fileid, (int)SP(tk)->line, pe, knh_Token_tochar(tk));
	SP(tk)->tt = TT_ERR;
	knh_Stmt_add(ctx, o, TM(tk));
	knh_tokens_nextStmt(tc);
}

/* ------------------------------------------------------------------------ */

Stmt *new_StmtERR(Ctx *ctx, knh_tokens_t *tc)
{
	Stmt *stmt = new_Stmt(ctx, 0, STT_ERR);
	knh_Stmt_add(ctx, stmt, TM(knh_tokens_curToken(tc)));
	knh_tokens_nextStmt(tc);
	return stmt;
}

/* ------------------------------------------------------------------------ */

void knh_Stmt_perror(Ctx *ctx, Stmt *o, int pe, Token *tk)
{
	if(tk == NULL || !IS_Token(tk)) {
		knh_perror(ctx, SP(o)->fileid, (int)SP(o)->line, pe, NULL);
		if(knh_message_type(pe) == 1) {
			SP(o)->stt = STT_ERR;
		}
	}
	else {
		knh_Token_perror(ctx, tk, pe);
		SP(tk)->tt = TT_ERR;
		knh_Stmt_add(ctx, o, TM(tk));
	}
}

/* ======================================================================== */
/* [Compiler] */

void
knh_Compiler_perror(Ctx *ctx, Compiler *cpr, int pe, char *msg)
{
	knh_perror(ctx, DP(cpr)->fileid, (int)DP(cpr)->line, pe, msg);
	if(knh_message_type(pe) == 1) {
		knh_Compiler_setCancelled(cpr, 1);
	}
}

/* ------------------------------------------------------------------------ */

void
knh_Compiler_assert(Ctx *ctx, Compiler *cpr, int c)
{
	knh_perror(ctx, DP(cpr)->fileid, (int)DP(cpr)->line, KMSG_EABORT, NULL);
	knh_Compiler_setCancelled(cpr, 1);
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
