/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [constructor] */

/* ------------------------------------------------------------------------ */
/* @method This! DictSet.new(Int n) */

METHOD knh__DictSet_new(Ctx *ctx, knh_sfp_t *sfp)
{
	DictSet *o = (DictSet*)sfp[0].o;
	size_t init = IS_NULL(sfp[1].o) ? KNH_DICTMAP_INITSIZE: ARG_int(sfp[1]);
	if(init > 0) {
		o->_list = knh_dictset_malloc(ctx, init);
		o->size = 0;
	}
	KNH_RETURN(ctx, sfp, o);
}

/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */
/* @method void DictSet.add(String! key) */

METHOD knh__DictSet_add(Ctx *ctx, knh_sfp_t *sfp)
{
	DictSet *o = (DictSet*)sfp[0].o;
	if(!knh_Object_isImmutable(o)) {
		knh_DictSet_add(ctx, o, sfp[1].s);
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */
/* @method Int! DictSet.get(String! key) */

METHOD knh__DictSet_get(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, knh_DictSet_get(ctx, (DictSet*)sfp[0].o, sfp[1].s));
}

/* ------------------------------------------------------------------------ */
/* @method Boolean! DictSet.opHas(String! key) */

METHOD knh__DictSet_opHas(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Boolean(ctx, sfp, IS_NOTNULL(knh_DictSet_get__b((DictSet*)sfp[0].o, knh_String_tobytes(sfp[1].s))));
}

/* ------------------------------------------------------------------------ */
/* @method void DictSet.set(String! key, Int! value) */

METHOD knh__DictSet_set(Ctx *ctx, knh_sfp_t *sfp)
{
	DictSet *o = (DictSet*)sfp[0].o;
	if(!knh_Object_isImmutable(o)) {
		knh_DictSet_set(ctx, o, sfp[1].s, ARG_int(sfp[2]));
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */
/* @method void DictSet.remove(String! key) */

METHOD knh__DictSet_remove(Ctx *ctx, knh_sfp_t *sfp)
{
	DictSet *o = (DictSet*)sfp[0].o;
	if(!knh_Object_isImmutable(o)) {
		knh_DictSet_remove(ctx, o, sfp[1].s);
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */
/* @method void DictSet.clear() */

METHOD knh__DictSet_clear(Ctx *ctx, knh_sfp_t *sfp)
{
	DictSet *o = (DictSet*)sfp[0].o;
	if(!knh_Object_isImmutable(o)) {
		knh_DictSet_clear(ctx, o);
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ======================================================================== */
/* @method Int! DictSet.getSize() */

METHOD knh__DictSet_getSize(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, knh_DictSet_size((DictSet*)sfp[0].o));
}

/* ------------------------------------------------------------------------ */

#define OPSUBSET   0
#define OPSUBSETE  1
#define OPOFFSET   2

METHOD knh__DictSet_subset(Ctx *ctx, knh_sfp_t *sfp, int mode)
{
	DictSet *o = (DictSet*)sfp[0].o;
	size_t i, s = 0, e = o->size;
	if(IS_NOTNULL(sfp[1].o)) {
		knh_bytes_t cs = knh_String_tobytes(sfp[1].s);
		for(i = 0; i < o->size; i++) {
			knh_bytes_t ks = knh_String_tobytes(knh_DictSet_keyAt(o, i));
			if(knh_bytes_strcmp(cs, ks) <= 0) {
				s = i;
			}
			else {
				break;
			}
		}
	}
	if(IS_NOTNULL(sfp[2].o)) {
		if(mode == OPSUBSETE) {
			knh_bytes_t cs = knh_String_tobytes(sfp[2].s);
			for(i = s; i < o->size; i++) {
				knh_bytes_t ks = knh_String_tobytes(knh_DictSet_keyAt(o, i));
				if(knh_bytes_strcmp(ks, cs) <= 0) {
					continue;
				}
				else {
					e = i;
					break;
				}
			}
		}
		else if(mode == OPSUBSET) {
			knh_bytes_t cs = knh_String_tobytes(sfp[2].s);
			for(i = s; i < o->size; i++) {
				knh_bytes_t ks = knh_String_tobytes(knh_DictSet_keyAt(o, i));
				if(knh_bytes_strcmp(ks, cs) < 0) {
					continue;
				}
				else {
					e = i;
					break;
				}
			}
		}
		else {
			e = s + ARG_int(sfp[2]);
			if(!(e < o->size)) {
				e = o->size;
			}
			else if(e < s) {
				e = s;
			}
		}
	}
	{
		DictSet *d = new_DictSet(ctx, e - s);
		for(i = s; i < e; i++) {
			knh_DictSet_append(ctx, d, knh_DictSet_keyAt(o, i), knh_DictSet_valueAt(o, i));
		}
		KNH_RETURN(ctx, sfp, d);
	}
}

/* ------------------------------------------------------------------------ */
/* @method This! DictSet.opSubsete(String s, String e) */

METHOD knh__DictSet_opSubsete(Ctx *ctx, knh_sfp_t *sfp)
{
	knh__DictSet_subset(ctx, sfp, OPSUBSETE);
}

/* ------------------------------------------------------------------------ */
/* @method This! DictSet.opSubset(String s, String e) */

METHOD knh__DictSet_opSubset(Ctx *ctx, knh_sfp_t *sfp)
{
	knh__DictSet_subset(ctx, sfp, OPSUBSET);
}

/* ------------------------------------------------------------------------ */
/* @method This! DictSet.opOffset(String s, Int! n) */

METHOD knh__DictSet_opOffset(Ctx *ctx, knh_sfp_t *sfp)
{
	knh__DictSet_subset(ctx, sfp, OPOFFSET);
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS] void DictSet.opLshift(String v) @VARARGS */

METHOD knh__DictSet_opLshift(Ctx *ctx, knh_sfp_t *sfp)
{
	DictSet *o = (DictSet*)sfp[0].o;
	if(!knh_Object_isImmutable(o)) {
		knh_sfp_t *v = sfp + 1;
		knh_vargc_t ac = knh_sfp_argc(ctx, v);
		int i;
		for(i = 0; i < ac; i++) {
			if(IS_NULL(v[1].o)) continue;
			knh_DictSet_append(ctx, o, v[i].s, 1);
		}
		knh_DictSet_sort(o);
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [mapping] */

/* ======================================================================== */
/* [iterators] */

/* ------------------------------------------------------------------------ */
/* @map DictSet Iterator! */

Iterator* knh_DictSet_Iterator(Ctx *ctx, DictSet *o, Mapper *mpr)
{
	knh_DictSet_sort(o);
	return new_Iterator(ctx, CLASS_String, UP(o), knh_DictMap_key_next);
}

/* ------------------------------------------------------------------------ */
/* @map DictSet String..! */

Iterator* knh_DictSet_String__(Ctx *ctx, DictSet *o, Mapper *mpr)
{
	knh_DictSet_sort(o);
	return new_Iterator(ctx, CLASS_String, UP(o), knh_DictMap_key_next);
}

/* ------------------------------------------------------------------------ */
/* @method String.. DictSet.opItr() */

METHOD knh__DictSet_opItr(Ctx *ctx, knh_sfp_t *sfp)
{
	DictSet *o = (DictSet*)sfp[0].o;
	knh_DictSet_sort(o);
	KNH_RETURN(ctx, sfp, new_Iterator(ctx, CLASS_String, UP(o), knh_DictMap_key_next));
}

/* ------------------------------------------------------------------------ */
/* @map String.. DictSet! */

DictSet* knh_String___DictSet(Ctx *ctx, Iterator *o, Mapper *mpr)
{
	DictSet *d = new_DictSet(ctx, 8);
	String *v = (String*)(o->fnext_1(ctx, o));
	while(IS_NOTNULL(v)) {
		knh_DictSet_add(ctx, d, v);
	}
	return d;
}

/* ======================================================================== */
/* [movabletext] */

/* ------------------------------------------------------------------------ */
/* @method void DictSet.%k(OutputStream w, String m) */

void knh_DictSet__k(Ctx *ctx, DictSet *o, OutputStream *w, String *m)
{
	knh_DictSet_sort(o);
	knh_putc(ctx, w, '{');
	size_t c;
	for(c = 0; c < o->size; c++) {
		if(c > 0) {
			knh_write_delim(ctx, w);
		}
		knh_write(ctx, w, knh_String_tobytes(o->list[c].key));
//		knh_putc(ctx, w, ':');	knh_putc(ctx, w, ' ');
//		knh_format(ctx, w, METHODN__k, o->list[c].value, KNH_NULL);
	}
	knh_putc(ctx, w, '}');
}

/* ------------------------------------------------------------------------ */
/* @method void DictSet.%dump(OutputStream w, String m) */

void knh_DictSet__dump(Ctx *ctx, DictSet *o, OutputStream *w, String *m)
{
	knh_DictSet_sort(o);
	knh_putc(ctx, w, '{');
	size_t c;
	for(c = 0; c < o->size; c++) {
		if(c > 0) {
			knh_write_delim(ctx, w);
		}
		knh_write(ctx, w, knh_String_tobytes(o->list[c].key));
		knh_putc(ctx, w, ':');	knh_putc(ctx, w, ' ');
		knh_write__i(ctx, w, o->list[c].value);
	}
	knh_putc(ctx, w, '}');
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif

