/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [constructor] */

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */
/* @method Int! ResultSet.getSize(Any! n) */

METHOD knh__ResultSet_getSize(Ctx *ctx, knh_sfp_t *sfp)
{
	ResultSet *o = (ResultSet*)sfp[0].o;
	KNH_RETURN_Int(ctx, sfp, DP(o)->column_size);
}

/* ------------------------------------------------------------------------ */
/* @method String! ResultSet.getName(Int! n) */

METHOD knh__ResultSet_getName(Ctx *ctx, knh_sfp_t *sfp)
{
	ResultSet *o = (ResultSet*)sfp[0].o;
	size_t n = ARG_size(sfp[1]);
	String *v = TS_EMPTY;
	if(n < DP(o)->column_size) {
		v = knh_ResultSet_getName(ctx, o, n);
	}
	else {
		KNH_THROW_OUTOFINDEX(ctx, ARG_integer(sfp[1]), DP(o)->column_size);
	}
	KNH_RETURN(ctx, sfp, v);
}

/* ------------------------------------------------------------------------ */

knh_integer_t knh_ResultSet_getInt(Ctx *ctx, ResultSet *o, size_t n)
{
	KNH_ASSERT(n < DP(o)->column_size);
	char *p = knh_Bytes_tochar(DP(o)->databuf) + DP(o)->column[n].start;
	switch(DP(o)->column[n].ctype) {
	case knh_ResultSet_CTYPE__null :
		return 0;
	case knh_ResultSet_CTYPE__integer :
		return (knh_integer_t)(*((knh_integer_t*)p));
	case knh_ResultSet_CTYPE__float :
		return (knh_integer_t)(*((knh_float_t*)p));
	case knh_ResultSet_CTYPE__bytes :
		TODO();
//		return knh_bytes_toint(B2(p, DP(o)->column[n].len));
	}
	return 0;
}

/* ------------------------------------------------------------------------ */
/* @method Int ResultSet.getInt(Any! n) */

METHOD knh__ResultSet_getInt(Ctx *ctx, knh_sfp_t *sfp)
{
	ResultSet *o = (ResultSet*)sfp[0].o;
	size_t n;
	void *v = NULL;
	if(IS_bInt(sfp[1].o)) {
		n = ARG_size(sfp[1]);
		if(!(n < DP(o)->column_size)) {
			KNH_THROW_OUTOFINDEX(ctx, ARG_integer(sfp[1]), DP(o)->column_size);
			v = KNH_NULL;
			goto L_RETURN;
		}
	}
	else if(IS_bString(sfp[1].o)) {
		int loc = knh_ResultSet_findColumn(ctx, o, knh_String_tobytes(sfp[1].s));
		if(loc == -1) {
			v = KNH_NULL;
			goto L_RETURN;
		}
		n = (size_t)loc;
	}
	else {
		v = KNH_NULL;
		goto L_RETURN;
	}

	char *p = knh_Bytes_tochar(DP(o)->databuf) + DP(o)->column[n].start;
	switch(DP(o)->column[n].ctype) {
	case knh_ResultSet_CTYPE__null :
		v = KNH_NULL;
	case knh_ResultSet_CTYPE__integer :
		v = new_Int(ctx, (knh_integer_t)(*((knh_integer_t*)p)));
	case knh_ResultSet_CTYPE__float :
		v = new_Int(ctx, (knh_integer_t)(*((knh_float_t*)p)));
	default:
		v = KNH_NULL;
	}
	L_RETURN:;
	KNH_ASSERT(v != NULL);
	KNH_RETURN(ctx, sfp, v);
}

/* ------------------------------------------------------------------------ */

knh_float_t knh_ResultSet_getFloat(Ctx *ctx, ResultSet *o, size_t n)
{
	KNH_ASSERT(n < DP(o)->column_size);
	char *p = knh_Bytes_tochar(DP(o)->databuf) + DP(o)->column[n].start;
	switch(DP(o)->column[n].ctype) {
	case knh_ResultSet_CTYPE__null :
		return 0.0;
	case knh_ResultSet_CTYPE__integer :
		return (knh_float_t)(*((knh_integer_t*)p));
	case knh_ResultSet_CTYPE__float :
		return (knh_float_t)(*((knh_float_t*)p));
	case knh_ResultSet_CTYPE__bytes :
		TODO();
//		return knh_bytes_tofloat(B2(p, DP(o)->column[n].len));
	}
	return 0.0;
}

/* ------------------------------------------------------------------------ */
/* @method Float ResultSet.getFloat(Any! n) */

METHOD knh__ResultSet_getFloat(Ctx *ctx, knh_sfp_t *sfp)
{
	ResultSet *o = (ResultSet*)sfp[0].o;
	size_t n;
	void *v = NULL;
	if(IS_bInt(sfp[1].o)) {
		n = ARG_size(sfp[1]);
		if(!(n < DP(o)->column_size)) {
			KNH_THROW_OUTOFINDEX(ctx, ARG_integer(sfp[1]), DP(o)->column_size);
			v = KNH_NULL;
			goto L_RETURN;
		}
	}
	else if(IS_bString(sfp[1].o)) {
		int loc = knh_ResultSet_findColumn(ctx, o, knh_String_tobytes(sfp[1].s));
		if(loc == -1) {
			v = KNH_NULL;
			goto L_RETURN;
		}
		n = (size_t)loc;
	}
	else {
		v = KNH_NULL;
		goto L_RETURN;
	}

	char *p = knh_Bytes_tochar(DP(o)->databuf) + DP(o)->column[n].start;
	switch(DP(o)->column[n].ctype) {
	case knh_ResultSet_CTYPE__null :
		v = KNH_NULL;
	case knh_ResultSet_CTYPE__integer :
		v = new_Float(ctx, (knh_float_t)(*((knh_integer_t*)p)));
	case knh_ResultSet_CTYPE__float :
		v = new_Float(ctx, (knh_float_t)(*((knh_float_t*)p)));
	default:
		v = KNH_NULL;
	}
	L_RETURN:;
	KNH_ASSERT(o != NULL);
	KNH_RETURN(ctx, sfp, o);
}

/* ------------------------------------------------------------------------ */

String* knh_ResultSet_getString(Ctx *ctx, ResultSet *o, size_t n)
{
	KNH_ASSERT(n < DP(o)->column_size);
	char *p = knh_Bytes_tochar(DP(o)->databuf) + DP(o)->column[n].start;
	switch(DP(o)->column[n].ctype) {
	case knh_ResultSet_CTYPE__null :
		return (String*)KNH_NULL;
	case knh_ResultSet_CTYPE__integer :
		return new_String__integer(ctx, (knh_integer_t)(*((knh_integer_t*)p)));
	case knh_ResultSet_CTYPE__float :
		return new_String__float(ctx, (knh_float_t)(*((knh_float_t*)p)));
	case knh_ResultSet_CTYPE__text :
		return new_String(ctx, B2(p, DP(o)->column[n].len), NULL);
	}
	return (String*)KNH_NULL;
}

/* ------------------------------------------------------------------------ */
/* @method String ResultSet.getString(Any! n) */

METHOD knh__ResultSet_getString(Ctx *ctx, knh_sfp_t *sfp)
{
	ResultSet *o = (ResultSet*)sfp[0].o;
	size_t n;
	void *v = NULL;
	if(IS_bInt(sfp[1].o)) {
		n = ARG_size(sfp[1]);
		if(!(n < DP(o)->column_size)) {
			KNH_THROW_OUTOFINDEX(ctx, ARG_integer(sfp[1]), DP(o)->column_size);
			v = KNH_NULL;
			goto L_RETURN;
		}
	}
	else if(IS_bString(sfp[1].o)) {
		int loc = knh_ResultSet_findColumn(ctx, o, knh_String_tobytes(sfp[1].s));
		if(loc == -1) {
			v = KNH_NULL;
			goto L_RETURN;
		}
		n = (size_t)loc;
	}
	else {
		v = KNH_NULL;
		goto L_RETURN;
	}

	v = knh_ResultSet_getString(ctx, o, n);

	L_RETURN:;
	KNH_ASSERT(v != NULL);
	KNH_RETURN(ctx, sfp, v);
}

/* ------------------------------------------------------------------------ */
/* @method Any ResultSet.get(Any! n) */

METHOD knh__ResultSet_get(Ctx *ctx, knh_sfp_t *sfp)
{
	ResultSet *o = (ResultSet*)sfp[0].o;
	size_t n;
	void *v = NULL;
	if(IS_bInt(sfp[1].o)) {
		n = ARG_size(sfp[1]);
		if(!(n < DP(o)->column_size)) {
			KNH_THROW_OUTOFINDEX(ctx, ARG_integer(sfp[1]), DP(o)->column_size);
			v = KNH_NULL;
			goto L_RETURN;
		}
	}
	else if(IS_bString(sfp[1].o)) {
		int loc = knh_ResultSet_findColumn(ctx, o, knh_String_tobytes(sfp[1].s));
		if(loc == -1) {
			v = KNH_NULL;
			goto L_RETURN;
		}
		n = (size_t)loc;
	}

	char *p = knh_Bytes_tochar(DP(o)->databuf) + DP(o)->column[n].start;
	switch(DP(o)->column[n].ctype) {
	case knh_ResultSet_CTYPE__null :
		v = KNH_NULL;
	case knh_ResultSet_CTYPE__integer :
		v = new_Int(ctx, (knh_integer_t)(*((knh_integer_t*)p)));
	case knh_ResultSet_CTYPE__float :
		v = new_Float(ctx, (knh_float_t)(*((knh_float_t*)p)));
	case knh_ResultSet_CTYPE__text :
		v = new_String(ctx, B2(knh_Bytes_tochar(DP(o)->databuf) + DP(o)->column[n].start, DP(o)->column[n].len), NULL);
	case knh_ResultSet_CTYPE__bytes :
	{
		Bytes *ba = new_Bytes(ctx, DP(o)->column[n].len);
		knh_Bytes_write(ctx, ba, B2(knh_Bytes_tochar(DP(o)->databuf) + DP(o)->column[n].start, DP(o)->column[n].len));
		v = ba;
	}
	default:
		v = KNH_NULL;
	}
	L_RETURN:;
	KNH_ASSERT(v != NULL);
	KNH_RETURN(ctx, sfp, v);
}

/* ------------------------------------------------------------------------ */
/* @method void ResultSet.%dump(OutputStream w, String m) */

void knh_ResultSet__dump(Ctx *ctx, ResultSet *o, OutputStream *w, String *m)
{
	knh_putc(ctx, w, '{');
	size_t n;
	for(n = 0; n < DP(o)->column_size; n++) {
		if(n > 0) {
			knh_write_delim(ctx,w);
		}
		knh_write(ctx, w, knh_String_tobytes(DP(o)->column[n].name));
		knh_printf(ctx, w, "(%d): ", (int)n);
		char *p = knh_Bytes_tochar(DP(o)->databuf) + DP(o)->column[n].start;
		switch(DP(o)->column[n].ctype) {
			case knh_ResultSet_CTYPE__null :
				knh_write(ctx, w, STEXT("null"));
				break;
			case knh_ResultSet_CTYPE__integer :
				knh_write_integerfmt(ctx, w, KNH_INTEGER_FMT, (knh_integer_t)(*((knh_integer_t*)p)));
				break;
			case knh_ResultSet_CTYPE__float :
				knh_write__f(ctx, w, (knh_float_t)(*((knh_float_t*)p)));
				break;
			case knh_ResultSet_CTYPE__text :
				knh_write(ctx, w, B2(p, DP(o)->column[n].len));
				break;
			case knh_ResultSet_CTYPE__bytes :
				knh_printf(ctx, w, "BLOB(%dbytes)", DP(o)->column[n].len);
				break;
		}
	}
	knh_putc(ctx, w, '}');
}

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [mapping] */

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [movabletext] */

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
