/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include<konoha.h>
#define KNH_PKGNAME "cgi"

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */

static
size_t bconv__toEncodedURL(Ctx *ctx, BytesConv *o, knh_bytes_t in, knh_Bytes_t *out)
{
   size_t size = in.len;
   size_t i;
   for(i = 0; i < size; i++){
      char c = in.buf[i];
      if(c == ' '){
	 knh_Bytes_putc(ctx, out, '+');
      }else if(('A' <= c && c <= 'Z') ||
	       ('a' <= c && c <= 'z') ||
	       ('0' <= c && c <= '9') ||
	       (c == '@') ||
	       (c == '*') ||
	       (c == '-') ||
	       (c == '.') ||
	       (c == '_') ||
	       (c == '(') ||
	       (c == ')') ||
	       (c == '!') ||
	       (c == ';') ||
	       (c == '/')){
	 knh_Bytes_putc(ctx, out, c);
      }else{
	 knh_Bytes_putc(ctx, out, '%');
	 int j;
	 for(j = 0; j < 2; j++){
	    int a = ((0x0f << 4) & (c << (4 * j))) >> 4;
	    int b;
	    if(0x0a <= a && a <= 0x0f){
	       b = a - 0x0a + 'a';
	    }else if(0 <= a && a <= 9){
	       b = a + '0';
	    }else{
	       return -1;
	    }
	    knh_Bytes_putc(ctx, out, b);
	 }
      }
   }
   return in.len;
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] String! String.toEncodedURL() */

static
METHOD knh__String_toEncodedURL(Ctx *ctx, knh_sfp_t *sfp)
{
   KNH_RETURN(ctx, sfp, new_String_bconv(ctx, sfp[0].s, bconv__toEncodedURL));
}

/* ------------------------------------------------------------------------ */

static
size_t bconv__toDecodedURL(Ctx *ctx, BytesConv *o, knh_bytes_t in, knh_Bytes_t *out)
{
   size_t i, size = in.len;
   for(i=0; i < size; i++) {
      char c = in.buf[i];
      if(c == '+'){
	 knh_Bytes_putc(ctx, out, ' ');
      }else if(('A' <= c && c <= 'Z') ||
	       ('a' <= c && c <= 'z') ||
	       ('0' <= c && c <= '9') ||
	       (c == '@') ||
	       (c == '*') ||
	       (c == '-') ||
	       (c == '.') ||
	       (c == '_') ||
	       (c == '(') ||
	       (c == ')') ||
	       (c == '!') ||
	       (c == ';') ||
	       (c == '/')){
	 knh_Bytes_putc(ctx, out, c);
      }else if(c == '%'){
	 int j;
	 int a = 0;
	 for(j=0; j < 2; j++){
	    c = in.buf[++i];
	    int b;
	    if('0' <= c && c <= '9'){
	       b = c - '0';
	    }else if('a' <= c && c <= 'f'){
	       b = c - 'a' + 0x0a;
	    }else if('A' <= c && c <= 'F'){
	       b = c - 'A' + 0x0a;
	    }else{
	       return -1;
	    }
	    a = (a << 4) + b;
	 }
	 knh_Bytes_putc(ctx, out, a);
      }
   }
   return in.len;
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] String! String.toDecodedURL() */

static
METHOD knh__String_toDecodedURL(Ctx *ctx, knh_sfp_t *sfp)
{
   KNH_RETURN(ctx, sfp, new_String_bconv(ctx, sfp[0].s, bconv__toDecodedURL));
}

/* ======================================================================== */
/* [KNHAPI] */

KNHAPI(int) knhcgi_init(Ctx *ctx)
{
   KNH_NOTICE(ctx, "loading cgi..");
   konoha_addMethod(ctx, "@Const String! String.toEncodedURL()", knh__String_toEncodedURL);
   konoha_addMethod(ctx, "@Const String! String.toDecodedURL()", knh__String_toDecodedURL);
   return 1;
}

/* ------------------------------------------------------------------------ */

KNHAPI(void) knhcgi_traverse(Ctx *ctx, knh_ftraverse ftr)
{
   if(konoha_issweep(ftr)) {

   }
}

/* ------------------------------------------------------------------------ */

static knh_pkgmeta_t PKGDATA = {
   KONOHA_BUILDID, /* Don't change this */
   KNH_PKGNAME,    /* package name (not NULL) */
   "1.0",  /* package version (not NULL) */
   NULL,   /* additional information */
   KONOHA_URLBASE "package.cgi", /* URL */
   knhcgi_init,
   knhcgi_traverse,
   NULL
};

KNHAPI(knh_pkgmeta_t*) knhcgi_load(Ctx *ctx)
{
   return &(PKGDATA);
}
   
/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
