/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#define KNH_TCLASS_C
#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [macros] */

/* ------------------------------------------------------------------------ */

void KNH_ACLASS(Ctx *ctx, knh_class_t cid, knh_class_t p1)
{
	char buf[CLASSNAME_BUFSIZ];
	knh_snprintf(buf, sizeof(buf), "%s[]", CLASSN(p1));
	konoha_addGenericsClass(ctx, cid, new_String(ctx, B(buf), NULL), CLASS_Array, p1, CLASS_Nue);
}

/* ------------------------------------------------------------------------ */

void KNH_ICLASS(Ctx *ctx, knh_class_t cid, knh_class_t p1)
{
	char buf[CLASSNAME_BUFSIZ];
	knh_snprintf(buf, sizeof(buf), "%s..", CLASSN(p1));
	konoha_addGenericsClass(ctx, cid, new_String(ctx, B(buf), NULL), CLASS_Iterator, p1, CLASS_Nue);
}

/* ======================================================================== */
/* [SPEC] */

static
Object *knh_tClass_fdefault__CSPEC(Ctx *ctx, knh_class_t cid)
{
	ClassSpec *cs = (ClassSpec*)ctx->tClass[cid].cspec;
	return UP(DP(cs)->defvalue);
}

/* ------------------------------------------------------------------------ */

knh_class_t
KNH_XCLASS(Ctx *ctx, knh_class_t cid, knh_class_t bcid, ClassSpec *cs)
{
	if(cid == CLASS_newid) {
		cid = knh_tClass_newId(ctx);
	}else {
		if(!(cid < ctx->share->tClassSize)) {
			ctx->share->tClassSize = cid + 1;
		}
	}

	char bufcn[CLASSNAME_BUFSIZ];
	knh_snprintf(bufcn, sizeof(bufcn), KNH_CLASSSPEC_FMT, CLASSN(bcid), knh_String_tochar(DP(cs)->urn));
	konoha_setClassName(ctx, cid, new_String(ctx, B(bufcn), NULL));
	DP(cs)->cid = cid;

	ctx->tClass[cid].bcid   = bcid;
	ctx->tClass[cid].supcid = bcid;

	if(bcid == CLASS_Int) bcid = CLASS_IntX;
	else if(bcid == CLASS_Float) bcid = CLASS_FloatX;
	else if(bcid == CLASS_String) bcid = CLASS_StringX;

	DBG2_P("%s\n\tcopying from %s", bufcn, CLASSN(bcid));
	ctx->tClass[cid].cflag  = ctx->tClass[bcid].cflag;
	ctx->tClass[cid].oflag  = ctx->tClass[bcid].oflag;
	ctx->tClass[cid].offset = ctx->tClass[bcid].offset;

	ctx->tClass[cid].sid  = ctx->tClass[bcid].sid;
	ctx->tClass[cid].size = ctx->tClass[bcid].size;
	ctx->tClass[cid].bsize  = ctx->tClass[bcid].bsize;

	KNH_ASSERT(ctx->tClass[cid].cstruct == NULL);
	KNH_INITv(ctx->tClass[cid].cstruct, ctx->tClass[bcid].cstruct);

	if(ctx->tClass[cid].cmap == NULL) {
		KNH_INITv(ctx->tClass[cid].cmap, new_ClassMap0(ctx, 4));
	}
	else {
		KNH_ASSERT(IS_ClassMap(ctx->tClass[cid].cmap));
	}
	KNH_ASSERT(ctx->tClass[cid].cspec == NULL);
	KNH_INITv(ctx->tClass[cid].cspec, cs);
	ctx->tClass[cid].fdefault = knh_tClass_fdefault__CSPEC;
	return cid;
}

/* ------------------------------------------------------------------------ */

knh_class_t konoha_getcid(Ctx *ctx, char *lname)
{
	DBG2_P("lname='%s'", lname);
	return knh_NameSpace_getClass(ctx, knh_rootNameSpace, B(lname));
}

/* ------------------------------------------------------------------------ */

knh_class_t konoha_findcid(Ctx *ctx, knh_bytes_t lname)
{
	DBG2_P("lname='%s'", lname.buf);
	knh_class_t cid = knh_NameSpace_getClass(ctx, knh_rootNameSpace, lname);
	if(cid != CLASS_unknown) {
		return cid;
	}
	if(knh_bytes_endsWith(lname, STEXT("[]"))) {
		lname.len -= 2;
		cid = knh_NameSpace_getClass(ctx, knh_rootNameSpace, lname);
		if(cid == CLASS_unknown || knh_class_isPrivate(cid)) {
			return CLASS_Array;
		}
		return knh_class_Array(ctx, cid);
	}
	if(knh_bytes_endsWith(lname, STEXT(".."))) {
		lname.len -= 2;
		cid = knh_NameSpace_getClass(ctx, knh_rootNameSpace, lname);
		if(cid == CLASS_unknown || knh_class_isPrivate(cid)) {
			return CLASS_Iterator;
		}
		return knh_class_Iterator(ctx, cid);
	}
	if(lname.buf[lname.len-1] == '}') {
		knh_index_t loc = knh_bytes_index(lname, '{');
		if(loc != -1) {
			knh_bytes_t urn = knh_bytes_last(lname, loc+1); urn.len -= 1;
			urn = knh_Runtime_aliasURN(ctx, urn);
			knh_class_t bcid = knh_NameSpace_getClass(ctx, knh_rootNameSpace, knh_bytes_first(lname, loc));
			DBG2_P("cid=%d,%s", bcid, CLASSN(bcid));
			ClassSpec *cs = (ClassSpec*)konoha_getClassSpec(ctx, bcid, urn);
			if(IS_NOTNULL(cs)) {
				KNH_SETv(ctx, DP(cs)->urn, new_String(ctx, urn, NULL));
				return KNH_XCLASS(ctx, DP(cs)->cid, bcid, cs);
			}
			return bcid;
		}
	}
	return cid;
}

/* ------------------------------------------------------------------------ */


#ifdef __cplusplus
}
#endif
