/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [macros] */

#define _CLASS_newid          ((knh_class_t)-1)
#define _CLASS_unknown        ((knh_class_t)-2)

#define _knh_Class_cid(c)     (knh_class_t)(c)->cid
#define _KNH_FLAG_CF2OF(f)        (f)
#define _knh_Class_isGenerics(cid)    (ctx->tClass[cid].p1 != CLASS_Nue)

/* ------------------------------------------------------------------------ */

#define _KNH_FLAG_SF_FIELD          KNH_FLAG_T1

#define _STRUCT_ISFIELD(sid)        ((sid & KNH_FLAG_SF_FIELD) == KNH_FLAG_SF_FIELD)
#define _BSIZE_TOSID(bsize)         (((knh_struct_t)bsize)|KNH_FLAG_SF_FIELD)
#define _STRUCT_FIELD(bsize)        (((knh_struct_t)bsize)|KNH_FLAG_SF_FIELD)
#define _STRUCT_FIELDSIZE(sid)      (sid & (~KNH_FLAG_SF_FIELD))
#define _STRUCT_UNMASK(sid)         (sid & (~KNH_FLAG_SF_FIELD))

#define _KNH_ASSERT_sid(sid)   KNH_ASSERT(((knh_struct_t)sid) < ctx->share->tStructSize)

/* ======================================================================== */
/* [tClass] */

knh_class_t knh_tClass_newId(Ctx *ctx)
{
	knh_class_t newid;
	KNH_LOCK(ctx, ctx->tableLock);
	if(!(ctx->share->tClassSize < KNH_TCLASS_SIZE)) {
		KNH_UNLOCK(ctx, ctx->tableLock);
		KNH_EXIT("Enlarge KNH_TCLASS_SIZE %d", KNH_TCLASS_SIZE);
		return CLASS_unknown;
	}
	newid = ctx->share->tClassSize;
	ctx->share->tClassSize++;
	KNH_UNLOCK(ctx, ctx->tableLock);
	return newid;
}

#define _KNH_ASSERT_cid(cid)    KNH_ASSERT(cid < ctx->share->tClassSize)

/* ------------------------------------------------------------------------ */

static knh_Class_t *new_Class(Ctx *ctx, knh_class_t cid)
{
	knh_Class_t *o = (knh_Class_t*)new_hObject(ctx, FLAG_Class, CLASS_Class, CLASS_Class);
	o->cid = cid;
	o->type = cid;
	return o;
}

/* ------------------------------------------------------------------------ */

void konoha_setClassName(Ctx *ctx, knh_class_t cid, String *lname)
{
	KNH_ASSERT_cid(cid);
	KNH_ASSERT(ctx->tClass[cid].class_cid == NULL);
	KNH_INITv(ctx->tClass[cid].class_cid, new_Class(ctx, cid));
	KNH_INITv(ctx->tClass[cid].lname, lname);
	//DBG2_P("lname='%s'", knh_String_tochar(lname));
	knh_NameSpace_setClass(ctx, knh_rootNameSpace, lname, cid);
	{
		knh_bytes_t n = knh_String_tobytes(lname);
		knh_index_t idx = knh_bytes_index(n, '{');
		if(idx != -1) {
			KNH_INITv(ctx->tClass[cid].sname, lname);
			return;
		}
		if(knh_bytes_endsWith(n, STEXT(".."))) {
			n.len -= 2;
			idx = knh_bytes_rindex(n, '.');
			n.len += 2;
		}
		else {
			idx = knh_bytes_rindex(n, '.');
		}
		if(idx == -1) {
			KNH_INITv(ctx->tClass[cid].sname, lname);
		}
		else {
			KNH_INITv(ctx->tClass[cid].sname, new_String(ctx, knh_bytes_last(n, idx + 1), lname));
		}
	}
}

/* ------------------------------------------------------------------------ */
/* [name] */

#define _CLASSN(cid)   knh_tClass_CLASSN(ctx, cid)
#define _CLASSNo(o)    knh_tClass_CLASSN(ctx, knh_Object_cid(o))

char *knh_tClass_CLASSN(Ctx *ctx, knh_class_t cid)
{
	DBG2_ASSERT(cid < ctx->share->tClassSize);
	if(knh_String_startsWith(ctx->tClass[cid].lname, STEXT("konoha."))) {
		return knh_String_tochar(ctx->tClass[cid].sname);
	}
	else {
		return knh_String_tochar(ctx->tClass[cid].lname);
	}
}

/* ------------------------------------------------------------------------ */
/* [default] */

static
knh_Object_t *knh_fdefault__CONST(Ctx *ctx, knh_class_t cid)
{
	return ctx->tClass[cid].cspec;
}

/* ------------------------------------------------------------------------ */

static
knh_Object_t *knh_fdefault__INIT(Ctx *ctx, knh_class_t cid)
{
	//DBG2_P("%s", CLASSN(cid));
	KNH_ASSERT(IS_NULL(ctx->tClass[cid].cspec));
	Object *v = new_Object_init(ctx, ctx->tClass[cid].oflag | KNH_FLAG_OF_IMMUTABLE, cid, 0);
	KNH_SETv(ctx, ctx->tClass[cid].cspec, v);
	ctx->tClass[cid].fdefault = knh_fdefault__CONST;
	return ctx->tClass[cid].cspec;
}

/* ------------------------------------------------------------------------ */

void konoha_setClassDefaultValue(Ctx *ctx, knh_class_t cid, Object *value, knh_fdefault fdefault)
{
	KNH_ASSERT_cid(cid);
	if(ctx->tClass[cid].cspec == NULL) {
		KNH_INITv(ctx->tClass[cid].cspec, value);
	}
	else {
		KNH_SETv(ctx, ctx->tClass[cid].cspec, value);
	}
	if(fdefault == NULL) {
		if(IS_NULL(value) && cid != CLASS_Nue) {
			fdefault = knh_fdefault__INIT;
		}
		else {
			fdefault = knh_fdefault__CONST;
		}
	}
	ctx->tClass[cid].fdefault = fdefault;
}

/* ------------------------------------------------------------------------ */

#define _KNH_DEF(ctx, cid)  konoha_getClassDefaultValue(ctx, cid)

Object *konoha_getClassDefaultValue(Ctx *ctx, knh_class_t cid)
{
	KNH_ASSERT_cid(cid);
	return ctx->tClass[cid].fdefault(ctx, cid);
}

/* ------------------------------------------------------------------------ */

#define _KNH_DEF(ctx, cid)  konoha_getClassDefaultValue(ctx, cid)

Object *konoha_getDefaultValue(Ctx *ctx, knh_type_t type)
{
	if(IS_NNTYPE(type)) {
		knh_class_t cid = CLASS_type(type);
		KNH_ASSERT_cid(cid);
		return ctx->tClass[cid].fdefault(ctx, cid);
	}
	else {
		return KNH_NULL;
	}
}

/* ======================================================================== */
/* [PARAM] */

void konoha_setClassParam(Ctx *ctx, knh_class_t cid, knh_class_t p1, knh_class_t p2)
{
	KNH_ASSERT_cid(cid);
	//KNH_ASSERT(ctx->tClass[cid].p1 == CLASS_Nue);
	ctx->tClass[cid].p1 = p1;
	ctx->tClass[cid].p2 = p2;
	if(!knh_class_isCyclic(cid)) {
		if(knh_class_isCyclic(p1) || knh_class_isCyclic(p2)) {
			knh_class_setCyclic(cid, 1);
		}
	}
}

/* ------------------------------------------------------------------------ */

knh_class_t
konoha_addGenericsClass(Ctx *ctx, knh_class_t cid, String *name, knh_class_t bcid, knh_class_t p1, knh_class_t p2)
{
	if(cid == CLASS_newid) {
		cid = knh_tClass_newId(ctx);
	}else {
		if(!(cid < ctx->share->tClassSize)) {
			ctx->share->tClassSize = cid + 1;
		}
	}
	knh_tClass_t *TC = (knh_tClass_t*)(&ctx->tClass[cid]);
	KNH_ASSERT(bcid < cid);
	KNH_ASSERT(ctx->tClass[cid].class_cid == NULL);

	TC->cflag  = ctx->tClass[bcid].cflag;
	TC->oflag  = ctx->tClass[bcid].oflag;

	TC->sid    = ctx->tClass[bcid].sid;

	TC->bcid   = bcid;
	TC->supcid = ctx->tClass[bcid].supcid;
	//TC->supcid = bcid;

	TC->offset = ctx->tClass[bcid].offset;

	TC->size = ctx->tClass[bcid].size;
	TC->bsize  = ctx->tClass[bcid].bsize;

	konoha_setClassName(ctx, cid, name);
	KNH_INITv(TC->cstruct, ctx->tClass[bcid].cstruct);
	KNH_INITv(TC->cmap, new_ClassMap0(ctx, 0));
	konoha_setClassDefaultValue(ctx, cid, KNH_NULL, NULL);
	konoha_setClassParam(ctx, cid, p1, p2);
	return cid;
}

/* ======================================================================== */
/* [ClassStruct] */

//#define _knh_tstruct_isNative(sid)   (sid < KONOHA_TSTRUCT_SIZE)

ClassStruct* new_ClassStruct0(Ctx *ctx, int field_size, int method_size)
{
	knh_ClassStruct_t* cs = (knh_ClassStruct_t*)new_Object_bcid(ctx, CLASS_ClassStruct, field_size);
	KNH_SETv(ctx, cs->methods, new_Array0(ctx, method_size));
	return cs;
}

/* ------------------------------------------------------------------------ */
/* [field] */

knh_index_t knh_Class_indexOfField(Ctx *ctx, knh_class_t cid, knh_fieldn_t fn)
{
	L_TAIL:;
	KNH_ASSERT_cid(cid);
	{
		knh_index_t idx = -1;
		ClassStruct *cs = ctx->tClass[cid].cstruct;
		if(cs->fields != NULL) {
			for(idx = 0; idx < cs->fsize; idx++) {
				if(cs->fields[idx].fn == fn) {
					return ctx->tClass[cid].offset + idx;
				}
			}
			idx = -1;
		}
		if(ctx->tClass[cid].offset == 0) return -1;
		cid = ctx->tClass[cid].supcid;
	}
	goto L_TAIL;
}

/* ------------------------------------------------------------------------ */

knh_index_t knh_Class_queryField(Ctx *ctx, knh_class_t cid, knh_fieldn_t fnq)
{
	knh_fieldn_t fn = FIELDN_UNMASK(fnq);
	L_TAIL:;
	KNH_ASSERT_cid(cid);
	{
		ClassStruct *cs = ctx->tClass[cid].cstruct;
		knh_index_t idx = -1;
		if(FIELDN_IS_SUPER(fnq)) {
			fnq = fn;
			goto L_SUPER;
		}
		if(cs->fields != NULL) {
			for(idx = 0; idx < cs->fsize; idx++) {
				if(cs->fields[idx].fn == fn) {
					return ctx->tClass[cid].offset + idx;
				}
			}
			idx = -1;
		}
		L_SUPER:;
		if(ctx->tClass[cid].offset == 0) return -1;
		cid = ctx->tClass[cid].supcid;
		goto L_TAIL;
	}
}

/* ------------------------------------------------------------------------ */

knh_cfield_t *knh_Class_fieldAt(Ctx *ctx, knh_class_t cid, size_t n)
{
	KNH_ASSERT_cid(cid);
	KNH_ASSERT(0 <= n && n < ctx->tClass[cid].size);
	L_TAIL:;
	{
		ClassStruct *cs = ctx->tClass[cid].cstruct;;
		size_t offset = ctx->tClass[cid].offset;
		if(offset <= n) {
			if(cs->fields == NULL) {
				return NULL;
			}
			else {
				return &(cs->fields[n - offset]);
			}
		}
		KNH_ASSERT_cid(cid);
		cid = ctx->tClass[cid].supcid;
	}
	goto L_TAIL;
}


/* ------------------------------------------------------------------------ */
/* [movabletext] */

void knh_cfield_dump(Ctx *ctx, knh_cfield_t *f, size_t offset, size_t fsize, OutputStream *w)
{
	size_t idx = 0;
	for(idx = 0; idx < fsize; idx++) {
		if(f[idx].fn == FIELDN_NONAME) {
			knh_printf(ctx, w, "[%d] -\n", (offset+idx));
			continue;
		}
		knh_printf(ctx, w, "[%d] %F %T %N = %O\n", (offset+idx), f[idx].flag, f[idx].type, f[idx].fn, f[idx].value);
	}
}

/* ======================================================================== */
/* [ClassMap] */

ClassMap* new_ClassMap0(Ctx *ctx, knh_ushort_t capacity)
{
	if(capacity < KNH_FASTMALLOC_SIZE) capacity = KNH_FASTMALLOC_BSIZE;
	knh_ClassMap_t *o = (knh_ClassMap_t*)new_Object_bcid(ctx, CLASS_ClassMap, capacity);
	knh_ClassMap_setSorted(o, 1);
	return o;
}


/* ------------------------------------------------------------------------ */

int knh_ClassMap_isDefault(Ctx *ctx, ClassMap *o)
{
	return (o == ctx->tClass[CLASS_Any].cmap);
}

/* ------------------------------------------------------------------------ */

void knh_tClass_readyClassMap(Ctx *ctx, knh_class_t cid)
{
	KNH_ASSERT_cid(cid);
	KNH_ASSERT(cid != CLASS_Any);
	if(ctx->tClass[cid].cmap == ctx->tClass[CLASS_Any].cmap) {
		KNH_SETv(ctx, ctx->tClass[cid].cmap, new_ClassMap0(ctx, 4));
	}
}

/* ------------------------------------------------------------------------ */

void knh_ClassMap_resize(Ctx *ctx, ClassMap *o, size_t newsize)
{
	Mapper **newlist = (Mapper**)KNH_MALLOC(ctx, newsize * sizeof(Mapper*));
	knh_bzero(newlist, newsize);
	knh_int_t i;
	for(i = 0; i < DP(o)->size; i++) {
		newlist[i] = DP(o)->maplist[i];
	}
	KNH_FREE(ctx, DP(o)->maplist, DP(o)->capacity * sizeof(Mapper*));
	DP(o)->maplist = newlist;
	DP(o)->capacity = newsize;
}

/* ------------------------------------------------------------------------ */

int
knh_ClassMap_util_cmp(const Mapper *m1, const Mapper *m2)
{
	int res = DP(m1)->flag - DP(m2)->flag;
	return (res == 0) ? DP(m2)->tcid - DP(m1)->tcid : res;
}

/* ------------------------------------------------------------------------ */

void knh_ClassMap_sort(Ctx *ctx, ClassMap *o)
{
	if(!knh_ClassMap_isSorted(o)) {
		knh_qsort(DP(o)->maplist, DP(o)->size, sizeof(Mapper*),
					(int (*)(const void*, const void*))knh_ClassMap_util_cmp);
		knh_ClassMap_setSorted(o, 1);
	}
}

/* ------------------------------------------------------------------------ */

void knh_ClassMap_add(Ctx *ctx, ClassMap *o, Mapper *map)
{
	KNH_ASSERT(!knh_ClassMap_isDefault(ctx, o));
	if(DP(o)->size == DP(o)->capacity) {
		knh_ClassMap_resize(ctx, o, DP(o)->capacity + 8);
	}
	KNH_ASSERT(DP(o)->maplist[DP(o)->size] == NULL);
	KNH_INITv(DP(o)->maplist[DP(o)->size], map);
	DP(o)->size++;
}

/* ======================================================================== */
/* [movabletext] */

/* @method void ClassMap.%dump(OutputStream w, String m) */

void knh_ClassMap__dump(Ctx *ctx, ClassMap *o, OutputStream *w, String *m)
{
	int i;
	for(i = 0; i < DP(o)->size; i++) {
		knh_printf(ctx, w, "[%d]\t", i);
		knh_Mapper__k(ctx, DP(o)->maplist[i], w, m);
		knh_write_EOL(ctx, w);
	}
}

/* ======================================================================== */

void knh_ClassMap__man(Ctx *ctx, ClassMap *o, OutputStream *w, knh_class_t cid)
{
//	if(knh_ClassMap_isDefault(o)) {
//		return;
//	}
	int i;
	int hasCaption = 0, from = 0;
	L_TAIL:;
	knh_ClassMap_sort(ctx, o);
	for(i = 0; i < DP(o)->size; i++) {
		if(hasCaption == 0) {
			knh_printf(ctx, w, "%s\n", knh_message_text(KMSG_MAPPING));
			hasCaption = 1;
		}
		if(from == 0) {
			knh_write_TAB(ctx, w);
			knh_write_cid(ctx, w, cid);
			knh_write_EOL(ctx, w);
			from = 1;
		}
		Mapper *mpr = DP(o)->maplist[i];
		knh_write_TAB(ctx, w); knh_write_TAB(ctx, w);
		if(knh_Mapper_isSynonym(mpr)) {
			knh_write__s(ctx, w, "=== ");
		}
		else if(knh_Mapper_isTotal(mpr)) {
			knh_write__s(ctx, w, "==> ");
		}
		else {
			knh_write__s(ctx, w, "--> ");
		}
		knh_write_cid(ctx, w, DP(mpr)->tcid);
		knh_write_EOL(ctx, w);
	}
	if(ctx->tClass[cid].supcid != CLASS_Object) {
		cid = ctx->tClass[cid].supcid;
		o = ctx->tClass[cid].cmap;
		from = 0;
		goto L_TAIL;
	}
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
