/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2006-2010, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Team konohaken@googlegroups.com
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU Lesser General Public License 3.0 (with K_UNDER_LGPL)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

#include "konoha_t.h"

#ifndef KONOHA_VM_H_
#define KONOHA_VM_H_

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* KCODE */
/* ======================================================================== */
#define rshift(rbp, x_) (&rbp[x_])
#define R_NEXTIDX (K_NEXTIDX)
#define Rd_(x)    (rshift(rbp,x)->data)
#define Ri_(x)    (rshift(rbp,x)->ivalue)
#define Rf_(x)    (rshift(rbp,x)->fvalue)
#define Rb_(x)    (rshift(rbp,x)->bvalue)
#define Ro_(x)    (rshift(rbp,x)->o)
#define Rh_(x)    (rshift(rbp,x)->hdr)
#define Rba_(x)   (rshift(rbp,x)->ba)
#define Ra_(x)    (rshift(rbp,x)->a)
#define Rx_(x)    (rshift(rbp,x)->ox)

#define SFP(rbp)  ((knh_sfp_t*)(rbp))
#define SFPIDX(n) ((n)/2)
#define RBP(sfp)  ((knh_rbp_t*)(sfp))

#define PC_NEXT(pc)   pc+1
#define PC_PREV(pc)   pc-1


/* [HALT] */

#define KLR0_HALT(ctx) {\
		pc--;\
		THROW_Halt(ctx, SFP(rbp), "HALT"); \
		goto L_RETURN;\
	}\

/* [MOV, SET] */

#define klr_mov(ctx, v1, v2) {\
		Object *v1_ = (Object*)v1;\
		Object *v2_ = (Object*)v2;\
		knh_Object_RCinc(v2_);\
		knh_Object_RCdec(v1_);\
		if(knh_Object_isRC0(v1_)) {\
			knh_Object_free(ctx, v1_);\
		}\
		v1 = v2_;\
	}\

#define KLR_OSET(ctx, a, v) {\
	klr_mov(ctx, Ro_(a), v);\
}\

#define KLR3_OSET2(ctx, a, v, v2) {\
	KLR_OSET(ctx, a, v);\
	klr_mov(ctx, Ro_(a+R_NEXTIDX), v2);\
}\

#define KLR3_OSET3(ctx, a, v, v2, v3) {\
	KLR3_OSET2(ctx, a, v, v2);\
	klr_mov(ctx, Ro_(a+R_NEXTIDX+R_NEXTIDX), v3);\
}\

#define KLR3_OSET4(ctx, a, v, v2, v3, v4) {\
	KLR3_OSET3(ctx, a, v, v2, v3);\
	klr_mov(ctx, Ro_(a+R_NEXTIDX+R_NEXTIDX+R_NEXTIDX), v4);\
}\

#define KLR_NSET(ctx, a, n) {\
	Rd_(a) = n;\
}\

#define KLR3_NSET2(ctx, a, n, n2) {\
	KLR_NSET(ctx, a, n);\
	Rd_(a+R_NEXTIDX) = n2;\
}\

#define KLR3_NSET3(ctx, a, n, n2, n3) {\
	KLR3_NSET2(ctx, a, n, n2);\
	Rd_(a+R_NEXTIDX+R_NEXTIDX) = n3;\
}\

#define KLR3_NSET4(ctx, a, n, n2, n3, n4) {\
	KLR3_NSET3(ctx, a, n, n2, n3);\
	Rd_(a+R_NEXTIDX+R_NEXTIDX+R_NEXTIDX) = n4;\
}\

#define KLR_OMOV(ctx, a, b) { \
	klr_mov(ctx, Ro_(a), Ro_(b));\
}\

#define KLR_NMOV(ctx, a, b) {\
	Rd_(a) = Rd_(b);\
}\

#define KLR_ONMOV(ctx, a, b, c, d) {\
	KLR_OMOV(ctx, a, b);\
	KLR_NMOV(ctx, c, d);\
}\

#define KLR2_OOMOV(ctx, a, b, c, d) {\
	KLR_OMOV(ctx, a, b);\
	KLR_OMOV(ctx, c, d);\
}\

#define KLR2_NNMOV(ctx, a, b, c, d) {\
	KLR_NMOV(ctx, a, b);\
	KLR_NMOV(ctx, c, d);\
}\

#define KLR_SWAP(ctx, a, b) {\
	knh_sfp_t temp = sfp[(a)];\
	sfp[(a)] = sfp[(b)];\
	sfp[(b)] = temp;\
}\

#define KLR_UNBOX(ctx, a, b, cid) {\
		rbp[a].data = knh_Object_data(rbp[b].o);\
	}\

#define RX_(x)   (rbp[x.i].ox)->fields[x.n]
#define RXi_(x)   (*((knh_int_t*)(&(rbp[x.i].ox)->fields[x.n])))
#define RXf_(x)   (*((knh_float_t*)(&(rbp[x.i].ox)->fields[x.n])))
#define RXb_(x)   (*((knh_bool_t*)(&(rbp[x.i].ox)->fields[x.n])))

#define KLR_OMOVx(ctx, a, b) {\
		knh_Object_t *v_ = RX_(b);\
		klr_mov(ctx, rbp[a].o, v_);\
	}\

#define KLR_iMOVx(ctx, a, b)    rbp[a].ivalue = RXi_(b)
#define KLR_fMOVx(ctx, a, b)    rbp[a].fvalue = RXf_(b);
#define KLR_bMOVx(ctx, a, b)    rbp[a].bvalue = RXb_(b)

#define KLR_XMOV(ctx, a, b)     klr_mov(ctx, RX_(a), rbp[b].o)
#define KLR_XMOVx(ctx, a, b)    klr_mov(ctx, RX_(a), RX_(b))
#define KLR_XOSET(ctx, a, b)    klr_mov(ctx, RX_(a), b)

#define KLR_XIMOV(ctx, a, b)   RXi_(a) = rbp[b].ivalue
#define KLR_XFMOV(ctx, a, b)   RXf_(a) = rbp[b].fvalue
#define KLR_XBMOV(ctx, a, b)   RXb_(a) = rbp[b].bvalue

/* ------------------------------------------------------------------------ */
/* [CALL] */

#define KLR_CHKSTACK(ctx, n) \
		if(unlikely(SFP(rbp + n) > ctx->stacktop)) {\
			rbp = RBP(knh_stack_initexpand(ctx, SFP(rbp), n));\
		}\

#define KLR2_SCALL(ctx, rtnidx, thisidx, espshift, mtdO) { \
		knh_Method_t *mtd_ = mtdO;\
		knh_sfp_t *sfp_ = SFP(rbp + thisidx); \
		sfp_[K_SHIFTIDX].shift = thisidx; \
		sfp_[K_PCIDX].pc = PC_NEXT(pc);\
		sfp_[K_MTDIDX].mtdNC = mtd_;\
		klr_setesp(ctx, SFP(rbp + espshift));\
		(mtd_)->fcall_1(ctx, sfp_, K_RTNIDX); \
	} \

#define klr_Ffcall    knh_Fmethod

#define KLR2_FASTCALL0(ctx, c, thisidx, rix, fcall, mtdO) { \
		fcall(ctx, SFP(rbp + thisidx), (long)rix);\
	} \

/* ------------------------------------------------------------------------- */
/* VCALL */
#define KLR2_VCALL(ctx, rtnidx, thisidx, espshift, mtdO) { \
		knh_Method_t *mtd_ = mtdO;\
		knh_opline_t *opN = PC_NEXT(pc);\
		klr_setesp(ctx, SFP(rbp + espshift));\
		vshift = thisidx;\
		rbp = rbp + thisidx;\
		vpc = opN;\
		if(unlikely(SFP(rbp) > ctx->stacktop)) {\
			rbp = RBP(knh_stack_initexpand(ctx, SFP(rbp), 0));\
		}\
		rbp[K_SHIFTIDX2].shift = thisidx;\
		rbp[K_PCIDX2].pc = opN;\
		rbp[K_MTDIDX2].mtdNC = mtd_;\
		pc = (mtd_)->pc_start;\
		GOTO_PC(pc); \
	} \

#define KLR2_VCALL_(ctx, rtnidx, thisidx, espshift, mtdO) { \
		knh_Method_t *mtd_ = mtdO;\
		knh_opline_t *opN = PC_NEXT(pc);\
		klr_setesp(ctx, SFP(rbp + espshift));\
		vshift = thisidx;\
		rbp = rbp + thisidx;\
		vpc = opN;\
		rbp[K_SHIFTIDX2].shift = thisidx;\
		rbp[K_PCIDX2].pc = opN;\
		rbp[K_MTDIDX2].mtdNC = mtd_;\
		pc = (mtd_)->pc_start;\
		GOTO_PC(pc); \
	} \

#define KLR2_JMP_(ctx, PC, JUMP)   KLR_RET(ctx)

#define KLR_RET(ctx) {\
		rbp = rbp - vshift; \
		pc = (knh_opline_t*)vpc; \
		vshift = rbp[K_SHIFTIDX2].shift;\
		vpc = rbp[K_PCIDX2].pc;\
		GOTO_PC(pc);\
	}\

typedef knh_Method_t* (*klr_Fmethod)(Ctx *, knh_sfp_t *, int, knh_Method_t*);

#define KLR_LOADMTD(ctx, thisidx, fmtd, mtdO) { \
		knh_Method_t *mtd_ = fmtd(ctx, SFP(rbp), SFPIDX(thisidx), mtdO);\
		if(mtd_ != mtdO) { \
			((klr_LOADMTD_t*)op)->mtdNC = mtd_;\
		}\
		klr_setmtdNC(ctx, rbp[thisidx+K_MTDIDX2], mtd_);\
	} \

#define KLR_CALL(ctx, rtnidx, thisidx, espshift) { \
		vshift = thisidx;\
		klr_setesp(ctx, SFP(rbp + espshift));\
		rbp = rbp + vshift;\
		vpc = PC_NEXT(pc);\
		rbp[K_SHIFTIDX2].shift = vshift;\
		rbp[K_PCIDX2].pc = vpc;\
		pc = (rbp[K_MTDIDX2].mtdNC)->pc_start;\
		GOTO_PC(pc); \
	} \

#define KLR0_FUNCCALL(ctx) { \
		(rbp[K_MTDIDX2].mtdNC)->fcall_1(ctx, SFP(rbp), K_RTNIDX);\
		KLR_RET(ctx);\
	} \


#define KLR0_VEXEC(ctx) {\
		vpc = PC_NEXT(pc);\
		pc = (rbp[K_MTDIDX2].mtdNC)->pc_start;\
		rbp[K_SHIFTIDX2].shift = 0;\
		rbp[K_PCIDX2].pc = (knh_opline_t*)vpc;\
		GOTO_PC(pc); \
	}\

#define KLR0_YEILD(ctx, espidx) {\
		klr_setesp(ctx, SFP(rbp+espidx));\
		goto L_RETURN;\
	}\

#define KLR0_ENTER(ctx) {\
		vpc = PC_NEXT(pc);\
		pc = (rbp[K_MTDIDX2].mtdNC)->pc_start;\
		rbp[K_SHIFTIDX2].shift = 0;\
		rbp[K_PCIDX2].pc = (knh_opline_t*)vpc;\
		GOTO_PC(pc); \
	}\


#define KLR0_EXIT(ctx) {\
		pc = NULL; \
		goto L_RETURN;\
	}\

typedef void (*klr_Fth)(Ctx *ctx, knh_opline_t *pc, void**);

#define KLR0_THCODE(ctx, th) { \
		th(ctx, pc, OPJUMP); \
		pc = PC_NEXT(pc);\
		goto L_RETURN; \
	}\

/* ------------------------------------------------------------------------- */

#define KLR_iCAST(ctx, c, a) {\
		rbp[c].ivalue = (knh_int_t)Rf_(a); \
	}\

#define KLR_fCAST(ctx, c, a) {\
		rbp[c].fvalue = (knh_float_t)Ri_(a); \
	}\

#define KLR_SCAST(ctx, rtnidx, trlidx, rix, trl)  { \
		knh_Translator_t *trl_ = trl;\
		/*TODO klr_settrlNC(ctx, rbp[trlidx], trl_);*/\
		(trl_)->ftcast_1(ctx, SFP(rbp+trlidx), rix); \
	} \

#define KLR_TCAST(ctx, rtnidx, trlidx, rix, trl)  { \
		knh_Translator_t *trl_ = trl; \
		knh_sfp_t *sfp_ = SFP(rbp+trlidx);\
		knh_class_t scid = SP(trl_)->scid, this_cid = knh_Object_cid(sfp_[0].o);\
		if(this_cid != scid) {\
			trl_ = knh_findTranslator(ctx, scid, SP(trl)->tcid);\
			KNH_SETv(ctx, ((klr_TCAST_t*)op)->cast, trl_);\
		}\
		/*TODO klr_settrlNC(ctx, rbp[trlidx], trl_);*/\
		(trl_)->ftcast_1(ctx, sfp_, rix);\
	} \

#define KLR_ACAST(ctx, rtnidx, trlidx, cid, trl) {\
	knh_Translator_t *trl_ = trl;\
	knh_class_t tcid = SP(trl_)->tcid, this_cid = knh_Object_cid(rbp[trlidx].o);\
	if((tcid != cid) || (!(tcid != this_cid) && !knh_class_instanceof(ctx, this_cid, tcid))) {\
		knh_class_t scid = SP(trl_)->scid;\
		if(this_cid != scid) {\
			trl_ = knh_findTranslator(ctx, this_cid, cid);\
			KNH_SETv(ctx, ((klr_ACAST_t*)op)->cast, trl_);\
		}\
		/*TODO klr_settrlNC(ctx, rbp[trlidx], trl_);*/\
			(trl_)->ftcast_1(ctx, SFP(rbp+trlidx), SFPIDX(trlidx - rtnidx));\
	}\
}

typedef void (*klr_Ftr)(Ctx *, knh_sfp_t *, knh_sfpidx_t, knh_class_t);

#define KLR_TR(Ctx, c, a, rix, cid, f) { \
		f(ctx, SFP(rbp + a), (long)rix, (knh_class_t)cid);\
	}\

/* ======================================================================== */

#define KLR_JMP(ctx, PC, JUMP) {\
		PC; \
		goto JUMP; \
	}\

#define KLR_ONCE(ctx, PC, JUMP) { \
		((klr_ONCE_t*)op)->opcode = OPCODE_JMP;\
	}\

#define KLR_bNUL(ctx, c, a)  Rb_(c) = IS_NULL(rbp[a].o)
#define KLR_bNN(ctx, c, a)   Rb_(c) = IS_NOTNULL(rbp[a].o)

#define KLR_JMPF(ctx, PC, JUMP, n) \
	if(Rb_(n)) {\
	}else{ \
		KLR_JMP(ctx, PC, JUMP); \
	} \

typedef int (*klr_Fchk)(Ctx *, knh_sfp_t *, int n);

#define KLR_DYJMP(ctx, PC, JUMP, n, fcheck) \
	if(fcheck(ctx, SFP(rbp), SFPIDX(n))) { \
		KLR_JMP(ctx, PC, JUMP); \
	} \

/* ------------------------------------------------------------------------- */

#define KLR_NEXT(ctx, PC, JUMP, rtnidx, ib, rix) { \
		knh_sfp_t *itrsfp_ = SFP(rbp + ib); \
		DBG_ASSERT(IS_bIterator(itrsfp_[0].it));\
		if(!((itrsfp_[0].it)->fnext_1(ctx, itrsfp_, rix))) { \
			KLR_JMP(ctx, PC, JUMP); \
		} \
	} \

typedef int (*klr_Fnext)(Ctx *, knh_sfp_t *, int, knh_class_t);

/* ------------------------------------------------------------------------- */

//#define NPC  /* for KNH_TRY */

#define KLR_TRY(ctx, PC, JUMP, hn)  {\
		knh_ExceptionHandler_t* _hdr = rbp[hn].hdr; \
		if(!IS_ExceptionHandler(_hdr)) { \
			_hdr = new_(ExceptionHandler); \
			klr_mov(ctx, rbp[hn].o, _hdr); \
		} \
		_hdr = knh_ExceptionHandler_setjmp(ctx, _hdr); \
		/** asm("int3"); gdb info r **/\
		if(_hdr == NULL) {\
			_hdr = rbp[hn].hdr;\
			/*fprintf(stderr, "TRY ctx=%p, hdr=%p, stack=%p,%p\n", ctx, _hdr, __builtin_frame_address(0));*/\
			DP(_hdr)->pc  = PC_NEXT(pc); \
			DP(_hdr)->vpc = (knh_opline_t*)vpc; \
			DP(_hdr)->op  = op;\
			SP(_hdr)->sfpidx = (SFP(rbp) - ctx->stack); \
			SP(_hdr)->espidx = (ctx->esp - ctx->stack); \
			SP(_hdr)->vshift = vshift; \
		} else {\
			/*KNH_P("CATCH ctx=%p, hdr=%p, stack=%p\n", ctx, _hdr, __builtin_frame_address(0), DP(_hdr)->frame_address);*/\
			pc = DP(_hdr)->pc; \
			vpc = DP(_hdr)->vpc; \
			rbp = RBP(ctx->stack + SP(_hdr)->sfpidx);\
			klr_setesp(ctx, (ctx->stack + SP(_hdr)->espidx));\
			vshift = SP(_hdr)->vshift; \
			op = DP(_hdr)->op;\
			KLR_JMP(ctx, PC, JUMP);\
		}\
	} \

#define KLR_TRYEND(ctx, hn)  {\
		knh_ExceptionHandler_t* _hdr = rbp[hn].hdr; \
		DBG_ASSERT(IS_ExceptionHandler(_hdr)); \
		DP(_hdr)->return_address = NULL;\
		DP(_hdr)->frame_address  = NULL;\
	} \


#define KLR_THROW2(ctx, start) { \
		if(IS_Exception(ctx->e)) {\
			knh_throw(ctx, sfp, start); \
		}\
	} \

#define KLR_THROW(ctx, start) { \
		knh_throw(ctx, SFP(rbp), SFPIDX(start)); \
	} \


#define KLR_CATCH(ctx, PC, JUMP, en, emsg) { \
		if(knh_Exception_isa(ctx, ctx->e, emsg)) { \
			DBG_P("CATHING .."); \
			klr_mov(ctx, rbp[en].o, ctx->e); \
			KNH_SETv(ctx, ((knh_Context_t*)ctx)->e, KNH_NULL);\
		} \
		else { \
			KLR_JMP(ctx, PC, JUMP); \
		} \
	} \

/* ------------------------------------------------------------------------ */

struct klr_P_t;
typedef void (*klr_Fprint)(Ctx *, knh_sfp_t*, struct klr_P_t*);
#define KLR_P(ctx, fprint, flag, msg, fmt, n) fprint(ctx, SFP(rbp), op)

typedef void (*klr_Fprobe)(Ctx *, knh_sfp_t*, knh_sfpidx_t n, knh_opline_t *pc);

#define KLR0_PROBE(ctx, fprobe, n) { \
		fprobe(ctx, SFP(rbp), n, PC_PREV(pc));\
	}\

/* ------------------------------------------------------------------------ */

#define KLR_bNOT(ctx, c, a)     Rb_(c) = !(Rb_(a))

#define KLR3_iINC(ctx, a)       Ri_(a)++
#define KLR3_iDEC(ctx, a)       Ri_(a)--

#define KLR_iNEG(ctx, c, a)     Ri_(c) = -(Ri_(a))
#define KLR_iADD(ctx, c, a, b)  Ri_(c) = (Ri_(a) + Ri_(b))
#define KLR_iADDn(ctx, c, a, n) Ri_(c) = (Ri_(a) + n)
#define KLR_iSUB(ctx, c, a, b)  Ri_(c) = (Ri_(a) - Ri_(b))
#define KLR_iSUBn(ctx, c, a, n) Ri_(c) = (Ri_(a) - n)
#define KLR_iMUL(ctx, c, a, b)  Ri_(c) = (Ri_(a) * Ri_(b))
#define KLR_iMULn(ctx, c, a, n) Ri_(c) = (Ri_(a) * n)
#define KLR_iDIV(ctx, c, a, b)  { \
		SYSLOG_iZERODIV(ctx, sfp, Ri_(b)); \
		Ri_(c) = (Ri_(a) / Ri_(b)); \
	} \

#define KLR_iDIVn(ctx, c, a, n)  Ri_(c) = (Ri_(a) / n)
#define KLR_iMOD(ctx, c, a, b)  { \
		SYSLOG_iZERODIV(ctx, sfp, Ri_(b)); \
		Ri_(c) = (Ri_(a) % Ri_(b)); \
	} \

#define KLR_iMODn(ctx, c, a, n)  Ri_(c) = (Ri_(a) % n)

#define KLR_iEQ(ctx, c, a, b)  Rb_(c) = (Ri_(a) == Ri_(b));
#define KLR_iEQn(ctx, c, a, n)  Rb_(c) = (Ri_(a) == n);
#define KLR_iNEQ(ctx, c, a, b)  Rb_(c) = (Ri_(a) != Ri_(b));
#define KLR_iNEQn(ctx, c, a, n)  Rb_(c) = (Ri_(a) != n);
#define KLR_iLT(ctx, c, a, b)  Rb_(c) = (Ri_(a) < Ri_(b));
#define KLR_iLTn(ctx, c, a, n)  Rb_(c) = (Ri_(a) < n);
#define KLR_iLTE(ctx, c, a, b)  Rb_(c) = (Ri_(a) <= Ri_(b));
#define KLR_iLTEn(ctx, c, a, n)  Rb_(c) = (Ri_(a) <= n);
#define KLR_iGT(ctx, c, a, b)  Rb_(c) = (Ri_(a) > Ri_(b));
#define KLR_iGTn(ctx, c, a, n)  Rb_(c) = (Ri_(a) > n);
#define KLR_iGTE(ctx, c, a, b)  Rb_(c) = (Ri_(a) >= Ri_(b));
#define KLR_iGTEn(ctx, c, a, n)  Rb_(c) = (Ri_(a) >= n);

#define KLR_iANDn(ctx, c, a, n)  Ri_(c) = (Ri_(a) & (n))
#define KLR_iORn(ctx, c, a, n)   Ri_(c) = (Ri_(a) | (n))
#define KLR_iXORn(ctx, c, a, n)  Ri_(c) = (Ri_(a) ^ (n))
#define KLR_iLSFTn(ctx, c, a, n) Ri_(c) = (Ri_(a) << (n))
#define KLR_iRSFTn(ctx, c, a, n) Ri_(c) = (Ri_(a) >> (n))

#define KLR_iAND(ctx, c, a, b)   KLR_iANDn( ctx, c, a, Ri_(b))
#define KLR_iOR(ctx, c, a, b)    KLR_iORn(  ctx, c, a, Ri_(b))
#define KLR_iXOR(ctx, c, a, b)   KLR_iXORn( ctx, c, a, Ri_(b))
#define KLR_iLSFT(ctx, c, a, b)  KLR_iLSFTn(ctx, c, a, Ri_(b))
#define KLR_iRSFT(ctx, c, a, b)  KLR_iRSFTn(ctx, c, a, Ri_(b))


#define BR_(EXPR, PC, JUMP) if(EXPR) {} else {KLR_JMP(ctx, PC, JUMP); }

#define KLR3_bJNUL(ctx, PC, JUMP, a)    BR_(IS_NULL(rbp[a].o), PC, JUMP)
#define KLR3_bJNN(ctx, PC, JUMP, a)     BR_(IS_NOTNULL(rbp[a].o), PC, JUMP)


#define KLR3_bJNOT(ctx, PC, JUMP, a)     BR_(!Rb_(a), PC, JUMP)
#define KLR3_iJEQ(ctx, PC, JUMP, a, b)   BR_((Ri_(a) == Ri_(b)), PC, JUMP)
#define KLR3_iJEQn(ctx, PC, JUMP, a, n)  BR_((Ri_(a) == n), PC, JUMP)
#define KLR3_iJNEQ(ctx, PC, JUMP, a, b)  BR_((Ri_(a) != Ri_(b)), PC, JUMP)
#define KLR3_iJNEQn(ctx, PC, JUMP, a, n) BR_((Ri_(a) != n), PC, JUMP)
#define KLR3_iJLT(ctx, PC, JUMP, a, b)   BR_((Ri_(a) < Ri_(b)), PC, JUMP)
#define KLR3_iJLTn(ctx, PC, JUMP, a, n)  BR_((Ri_(a) < n), PC, JUMP)
#define KLR3_iJLTE(ctx, PC, JUMP, a, b)  BR_((Ri_(a) <= Ri_(b)), PC, JUMP)
#define KLR3_iJLTEn(ctx, PC, JUMP, a, n) BR_((Ri_(a) <= n), PC, JUMP)
#define KLR3_iJGT(ctx, PC, JUMP, a, b)   BR_((Ri_(a) > Ri_(b)), PC, JUMP)
#define KLR3_iJGTn(ctx, PC, JUMP, a, n)  BR_((Ri_(a) > n), PC, JUMP)
#define KLR3_iJGTE(ctx, PC, JUMP, a, b)  BR_((Ri_(a) >= Ri_(b)), PC, JUMP)
#define KLR3_iJGTEn(ctx, PC, JUMP, a, n) BR_((Ri_(a) >= n), PC, JUMP)

/* ------------------------------------------------------------------------ */

#define KLR_fNEG(ctx, c, a)     Rf_(c) = -(Rf_(a))
#define KLR_fADD(ctx, c, a, b)  Rf_(c) = (Rf_(a) + Rf_(b))
#define KLR_fADDn(ctx, c, a, n) Rf_(c) = (Rf_(a) + n)
#define KLR_fSUB(ctx, c, a, b)  Rf_(c) = (Rf_(a) - Rf_(b))
#define KLR_fSUBn(ctx, c, a, n) Rf_(c) = (Rf_(a) - n)
#define KLR_fMUL(ctx, c, a, b)  Rf_(c) = (Rf_(a) * Rf_(b))
#define KLR_fMULn(ctx, c, a, n) Rf_(c) = (Rf_(a) * n)
#define KLR_fDIV(ctx, c, a, b)  { \
		SYSLOG_fZERODIV(ctx, sfp, Rf_(b)); \
		Rf_(c) = (Rf_(a) / Rf_(b)); \
	} \

#define KLR_fDIVn(ctx, c, a, n)  Rf_(c) = (Rf_(a) / n)

#define KLR_fEQ(ctx, c, a, b) Rb_(c) = (Rf_(a) == Rf_(b))
#define KLR_fEQn(ctx, c, a, n) Rb_(c) = (Rf_(a) == n)
#define KLR_fNEQ(ctx, c, a, b)  Rb_(c) = (Rf_(a) != Rf_(b))
#define KLR_fNEQn(ctx, c, a, n)  Rb_(c) = (Rf_(a) != n)
#define KLR_fLT(ctx, c, a, b)  Rb_(c) = (Rf_(a) < Rf_(b))
#define KLR_fLTn(ctx, c, a, n)  Rb_(c) = (Rf_(a) < n)

#define KLR_fLTE(ctx, c, a, b)  Rb_(c) = (Rf_(a) <= Rf_(b))
#define KLR_fLTEn(ctx, c, a, n) Rb_(c) = (Rf_(a) <= n)
#define KLR_fGT(ctx, c, a, b)  Rb_(c) = (Rf_(a) > Rf_(b))
#define KLR_fGTn(ctx, c, a, n)  Rb_(c) = (Rf_(a) > n)
#define KLR_fGTE(ctx, c, a, b)  Rb_(c) = (Rf_(a) >= Rf_(b))
#define KLR_fGTEn(ctx, c, a, n)  Rb_(c) = (Rf_(a) >= n)

#define KLR3_fJEQ(ctx, PC, JUMP, a, b)   BR_((Rf_(a) == Rf_(b)), PC, JUMP)
#define KLR3_fJEQn(ctx, PC, JUMP, a, n)  BR_((Rf_(a) == n), PC, JUMP)
#define KLR3_fJNEQ(ctx, PC, JUMP, a, b)  BR_((Rf_(a) != Rf_(b)), PC, JUMP)
#define KLR3_fJNEQn(ctx, PC, JUMP, a, n) BR_((Rf_(a) != n), PC, JUMP)
#define KLR3_fJLT(ctx, PC, JUMP, a, b)   BR_((Rf_(a) < Rf_(b)), PC, JUMP)
#define KLR3_fJLTn(ctx, PC, JUMP, a, n)  BR_((Rf_(a) < n), PC, JUMP)
#define KLR3_fJLTE(ctx, PC, JUMP, a, b)  BR_((Rf_(a) <= Rf_(b)), PC, JUMP)
#define KLR3_fJLTEn(ctx, PC, JUMP, a, n) BR_((Rf_(a) <= n), PC, JUMP)
#define KLR3_fJGT(ctx, PC, JUMP, a, b)   BR_((Rf_(a) > Rf_(b)), PC, JUMP)
#define KLR3_fJGTn(ctx, PC, JUMP, a, n)  BR_((Rf_(a) > n), PC, JUMP)
#define KLR3_fJGTE(ctx, PC, JUMP, a, b)  BR_((Rf_(a) >= Rf_(b)), PC, JUMP)
#define KLR3_fJGTEn(ctx, PC, JUMP, a, n) BR_((Rf_(a) >= n), PC, JUMP)

/* ------------------------------------------------------------------------ */

#define klr_array_index(ctx, n, size)   (size_t)n
#define klr_array_check(n, size) \
	if(unlikely(n >= size)) THROW_OutOfRange(ctx, SFP(rbp), n, size)

#define KLR_BGETIDXn(ctx, cidx, aidx, N) {\
		knh_bytes_t b_ = BA_tobytes(rbp[aidx].ba);\
		size_t n_ = klr_array_index(ctx, N, b_.len);\
		klr_array_check(n_, b_.len);\
		rbp[cidx].ivalue = b_.ustr[n_];\
	}\

#define KLR_BGETIDX(ctx, cidx, aidx, nidx) KLR_BGETIDXn(ctx, cidx, aidx, rbp[nidx].ivalue)

#define KLR_BSETIDXn(ctx, cidx, aidx, N, vidx) {\
		knh_bytes_t b_ = BA_tobytes(rbp[aidx].ba);\
		size_t n_ = klr_array_index(ctx, N, b_.len);\
		klr_array_check(n_, b_.len);\
		b_.ubuf[n_] = (knh_uchar_t)rbp[vidx].ivalue;\
		rbp[cidx].ivalue = rbp[vidx].ivalue;\
	}\

#define KLR_BSETIDX(ctx, cidx, aidx, nidx, vidx) KLR_BSETIDXn(ctx, cidx, aidx, rbp[nidx].ivalue, vidx)

#define KLR_OGETIDXn(ctx, cidx, aidx, N) {\
		knh_Array_t *a_ = rbp[aidx].a;\
		size_t n_ = klr_array_index(ctx, N, knh_Array_size(a_));\
		klr_array_check(n_, knh_Array_size(a_));\
		Object *v_ = (a_)->list[n_];\
		klr_mov(ctx, rbp[cidx].o, v_);\
	}\

#define KLR_OGETIDX(ctx, cidx, aidx, nidx) KLR_OGETIDXn(ctx, cidx, aidx, rbp[nidx].ivalue)

#define KLR_OSETIDXn(ctx, cidx, aidx, N, vidx) {\
		knh_Array_t *a_ = rbp[aidx].a;\
		size_t n_ = klr_array_index(ctx, N, knh_Array_size(a_));\
		klr_array_check(n_, knh_Array_size(a_));\
		klr_mov(ctx, (a_)->list[n_], rbp[vidx].o);\
		klr_mov(ctx, rbp[cidx].o, rbp[vidx].o);\
	}\

#define KLR_OSETIDX(ctx, cidx, aidx, nidx, vidx) KLR_OSETIDXn(ctx, cidx, aidx, rbp[nidx].ivalue, vidx)

#define KLR_NGETIDXn(ctx, cidx, aidx, N) {\
		knh_Array_t *a_ = rbp[aidx].a;\
		size_t n_ = klr_array_index(ctx, N, knh_Array_size(a_));\
		klr_array_check(n_, knh_Array_size(a_));\
		rbp[cidx].data = (a_)->nlist[n_];\
	}\

#define KLR_NGETIDX(ctx, cidx, aidx, nidx) KLR_NGETIDXn(ctx, cidx, aidx, rbp[nidx].ivalue)

#define KLR_NSETIDXn(ctx, cidx, aidx, N, vidx) {\
		knh_Array_t *a_ = rbp[aidx].a;\
		size_t n_ = klr_array_index(ctx, N, knh_Array_size(a_));\
		klr_array_check(n_, knh_Array_size(a_));\
		rbp[cidx].data = (a_)->nlist[n_] = rbp[vidx].data;\
	}\

#define KLR_NSETIDX(ctx, cidx, aidx, nidx, vidx) KLR_NSETIDXn(ctx, cidx, aidx, rbp[nidx].ivalue, vidx)

/* ------------------------------------------------------------------------ */

#ifdef KONOHA_ON_WINDOWS
#define KLR_NOP(ctx)
#else
#define KLR_NOP(ctx)  asm("nop")
#endif

/* ------------------------------------------------------------------------ */
/* OPCODEs for SSA */
#define KLR_PHI(ctx, a, b, c, type)
/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif

#endif /*KONOHA_VM_H_*/
