/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qdir.h>
#include <qscrollview.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qfileinfo.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kdebug.h>
#include <kconfig.h>
#include <kstandarddirs.h>
#include <kglobal.h>
#include <kmessagebox.h>

#include "dlgfilenew.h"
#include "kkview.h"

dlgFileNew::dlgFileNew( QWidget* parent, const char* name )
	: KDialogBase( KDialogBase::IconList, i18n("Select Template"), Ok|Cancel, Ok, parent, name )
{
	readDir();
	resize( configDialogSize( "dlgFileNew" ) );
}

dlgFileNew::~dlgFileNew()
{
	saveDialogSize( "dlgFileNew" );
}

QString dlgFileNew::filename()
{
	return m_filename[activePageIndex()];
}

void dlgFileNew::readDir()
{
	QString path = "";
	QStringList list = KGlobal::dirs()->findAllResources( "data", KGlobal::instance()->instanceName() + "/templates/*.kk" );
	qHeapSort( list );
	for( QStringList::Iterator it = list.begin(); it != list.end(); ++it )
	{
		readFile( *it );
	}
}

void dlgFileNew::readFile( const QString &filename )
{
	QFileInfo info( filename );
	m_filename.append( info.filePath() );
	QVBox* page = addVBoxPage( info.baseName(), info.baseName(), DesktopIcon( "kreetingkard" ) );
	KKView* view = new KKView( page, true );
	view->preview( filename );
}

void dlgFileNew::slotOk()
{
	if( activePageIndex() > m_filename.count() - 1 )
	{
		KMessageBox::error( this, i18n( "Please select template." ) );
		return;
	}
	KDialogBase::slotOk();
}

