/***************************************************************************
 *   Copyright (C) 2004 by Kazuki Ohta                                     *
 *   mover@hct.zaq.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _CONTACT_XML_H_
#define _CONTACT_XML_H_

#include <qptrlist.h>
#include <qstring.h>

class QDomDocument;
class QDomElement;

class KKContactData;

/**
 * This class is for managing ContactXML( http://www.contactxml.org/ )
 */
class ContactXML {
public:
	static ContactXML& instance()
	{
		static ContactXML cxml;
		return cxml;
	}

	// read
	QPtrList<KKContactData> readContactXML( const QString &filename );

	// write
	bool writeContactXML( const QString &filename, QPtrList<KKContactData> &datas );

private:
	ContactXML(){}
	~ContactXML(){}

	// read
	KKContactData* parseItem( const QDomElement &element );	

	// write
	void buildContactXMLItem( QDomDocument &doc, QDomElement &root, const KKContactData &data );
};

#endif /* Not def: _CONTACT_XML_H_ */
