/***************************************************************************
 *   Copyright (C) 2004 by Kazuki Ohta                                     *
 *   mover@hct.zaq.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKADDRESSBOOK_DIALOG_H_
#define _KKADDRESSBOOK_DIALOG_H_

#include <qptrlist.h>
#include <qvaluelist.h>

#include <kdialogbase.h>
#include <klistview.h>

class KKContactData;
class KKContactQuickSearchLine;
class KKContactDataView;
class KKView;

class QSplitter;
class QToolButton;
class QListViewItem;
class QWidgetStack;

class KAction;
class KTextBrowser;

class KKAddressBookDialog : public KDialogBase
{
	Q_OBJECT

public:
	KKAddressBookDialog( const QString &filename, QWidget *parent = 0, const char *name = 0 );
	virtual ~KKAddressBookDialog();

protected:
	void setupWidgets();

	void addContactData( const KKContactData & );
	void removeContactData( const KKContactData * );

	void readData( const QString &filename );
	bool saveData( const QString &filename );

	void writeConfig();
	void readConfig();

private slots:
	void createNewContact();
	void modifyContact();	
	void removeSelectedContactItem();
	void setupGroup();

	void slotSelectionChanged( QListViewItem *item );

	/*
	void configureKeyBindings();
	void configureToolbars();
	void newToolbarConfig();
	*/

protected:
	QString m_filename;
	
	QPtrList<KKContactData> contactDataList;
	
	QSplitter *mMainSplitter;
	KKContactQuickSearchLine *mQuickSearchLine;	
	KListView *mContactListView;
	QToolButton *newContactButton;
	QToolButton *modifyContactButton;
	QToolButton *removeContactButton;
	QToolButton *setGroupButton;
	KKContactDataView *mContactDataView;	

};

class KKContactListViewItem : public KListViewItem {
public:
	KKContactListViewItem( KListView *mContactListView, const KKContactData *d )
		: KListViewItem( mContactListView )
	{
		data = d;
        }

	const KKContactData *contactData() const { return data; }
protected:
	const KKContactData *data;
};

class KKContactDataView : public QWidget
{
	Q_OBJECT

public:
	KKContactDataView( QWidget *parent = 0, const char *name = 0 );
	~KKContactDataView();

	void setData( const KKContactData &data, const QString &templatefile );
	void clearView();

protected:
	KTextBrowser *m_textbrowser;
	KKView *m_previewwidget;
};

#endif /* Not def: _KKADDRESSBOOK_DIALOG_H_ */
