/***************************************************************************
 *   Copyright (C) 2004 by Kazuki Ohta                                     *
 *   mover@hct.zaq.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKCONTACT_QUICK_SEARCHLINE_H_
#define _KKCONTACT_QUICK_SEARCHLINE_H_

#include <klineedit.h>

class QListViewItem;

class KComboBox;
class KListView;
class KActionCollection;

/**
 * This class comes From kdelibs/kdeui/klistviewsearchline.h
 * because KListViewSearchLine isn't included before KDE3.3 (aka, KDE3.2, KDE3.1, ...)
 */
class KKContactQuickSearchLineBase : public KLineEdit
{
	Q_OBJECT

public:
	KKContactQuickSearchLineBase(QWidget *parent = 0, KListView *listView = 0, const char *name = 0);

	KKContactQuickSearchLineBase(QWidget *parent, const char *name);

	virtual ~KKContactQuickSearchLineBase();

	bool caseSensitive() const;

	QValueList<int> searchColumns() const;

	bool keepParentsVisible() const;

	KListView *listView() const;

public slots:
	virtual void updateSearch(const QString &s = QString::null);

	void setCaseSensitive(bool cs);
	void setKeepParentsVisible(bool v);
	void setSearchColumns(const QValueList<int> &columns);
	void setListView(KListView *lv);

protected:
	virtual bool itemMatches(const QListViewItem *item, const QString &s) const;
	virtual QPopupMenu *createPopupMenu();

protected slots:
	void queueSearch(const QString &search);
	void activateSearch();

private:
	void checkItemParentsNotVisible();
	bool checkItemParentsVisible(QListViewItem *item);

private slots:
	void itemAdded(QListViewItem *item) const;
	void listViewDeleted();
	void searchColumnsMenuActivated(int);

private:
	class KKContactQuickSearchLineBasePrivate;
	KKContactQuickSearchLineBasePrivate *d;
};

class KKContactQuickSearchLine : public KKContactQuickSearchLineBase
{
	Q_OBJECT
public:
	KKContactQuickSearchLine( QWidget *parent,
                                  KListView *listView,
                                  const char *name = 0 );
	virtual ~KKContactQuickSearchLine();

	void updateGroups();
	
public slots:
	void reset();
	void slotGroupChanged( int );

protected:
	virtual bool itemMatches( const QListViewItem *item, const QString &s ) const;

private:
	KComboBox *mGroupCombo;
	int mSelectedGroupIndex;
};

#endif /* _KKCONTACT_QUICK_SEARCHLINE_H_ */
