/***************************************************************************
 *   Copyright (C) 2004 by Kazuki Ohta                                     *
 *   mover@hct.zaq.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkprintdialog.h"
#include "kkcontactdata.h"
#include "contactxml.h"
#include "kkaddressbookglobalconfig.h"
#include "../kkdoc.h"
#include "../kkitem.h"

#include <qframe.h>
#include <qlistview.h>
#include <qlayout.h>
#include <qheader.h>
#include <qmap.h>
#include <qstringlist.h>
#include <qpainter.h>

#include <klistview.h>
#include <kprinter.h>
#include <klocale.h>
#include <kdebug.h>

KKPrintDialog::KKPrintDialog( KKDoc* document, const QString &filename, QWidget *parent, const char *name )
	: KDialogBase( KDialogBase::Plain, i18n("Print"), Ok|Cancel, Ok, parent, name ),
	  m_doc( document ),
	  m_filename( filename )
{
	contactDataList.setAutoDelete( true );
	contactDataList.clear();

	readData();
	setupWidgets();

	resize( configDialogSize( "KKPrintDialog" ) );
}

KKPrintDialog::~KKPrintDialog()
{
	if( !contactDataList.isEmpty() )
		contactDataList.clear();

	saveDialogSize( "KKPrintDialog" );
}

void KKPrintDialog::readData()
{
	contactDataList = ContactXML::instance().readContactXML( m_filename );
}


void KKPrintDialog::setupWidgets()
{
	QFrame *page = plainPage();
	(new QVBoxLayout( page ))->setAutoAdd( true );

        // setup listview
	m_PrintListView = new KListView( page );
        m_PrintListView->addColumn( "" );
        m_PrintListView->header()->hide();
        m_PrintListView->setRootIsDecorated( true );
        m_PrintListView->setFullWidth( true );
        m_PrintListView->setSortColumn( -1 );
        m_PrintListView->setAllColumnsShowFocus( true );

        // setup parent items
	QMap<QString, QCheckListItem*> groupItems;

	QStringList groupList = KKAddressBookGlobalConfig::readGroupList();
	QStringList::ConstIterator it = groupList.begin();
	const QStringList::ConstIterator end = groupList.end();
	for (; it != end; ++it) {
		QCheckListItem *item = new QCheckListItem( m_PrintListView, (*it), QCheckListItem::CheckBoxController );
		groupItems[(*it)] = item;
	}

	for( KKContactData *contactData	= contactDataList.first(); contactData; contactData = contactDataList.next() )
	{
		QCheckListItem *parentItem = groupItems[contactData->getGroup()];

		if( parentItem )
			new KKPrintCheckListItem( parentItem,
						  contactData->getFullname(),
						  contactData );
		else
			kdDebug() << "no such group : " << contactData->getGroup() << endl;
	}

	setMainWidget( m_PrintListView );
}

void KKPrintDialog::slotOk()
{
	if( print() )
		KDialogBase::slotOk();
}

bool KKPrintDialog::print()
{
	KPrinter printer;

	printer.setDocName( "KreetingKard" );
	printer.setPageSize( KPrinter::A6 );
	printer.setFullPage( true );

	KKItem* item = (KKItem*)m_doc->selectedItems().first();
	if( !item ) item = (KKItem*)m_doc->firstChild();
	if( item->parent() != NULL ) item = (KKItem*)item->parent();
	printer.setOrientation( ( item->orientation() == Horizontal ) ?  KPrinter::Landscape : KPrinter::Portrait );

	if( !printer.setup( this ) ) return false;
	printer.setColorMode( KPrinter::Color );

	bool newPage = false;
	QPainter p;
	p.begin( &printer );

	QListViewItem *parent = m_PrintListView->firstChild();
	for( ; parent; parent = parent->nextSibling() )
	{
		QListViewItem *child = parent->firstChild();
		for( ; child; child = child->nextSibling() )
		{
			if( ((QCheckListItem*)child)->isOn() )
			{
				if( newPage )
				{
					printer.newPage();
				}
				else
				{
					newPage = true;
				}
				m_doc->print( p, ((KKPrintCheckListItem*)child)->contactData() );
			}
		}
	}
	p.end();

	return true;
}
