/***************************************************************************
 *   Copyright (C) 2004 by Kazuki Ohta                                     *
 *   mover@hct.zaq.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KK_PRINT_DIALOG_H_
#define _KK_PRINT_DIALOG_H_

#include <qptrlist.h>

#include <kdialogbase.h>
#include <klistview.h>

class QString;

class KKContactData;
class KKDoc;

class KKPrintDialog : public KDialogBase
{
	Q_OBJECT

public:
	KKPrintDialog( KKDoc* document, const QString &filename, QWidget *parent = 0, const char *name = 0 );
	~KKPrintDialog();

protected:
	void setupWidgets();
	void readData();

	bool print();	

public slots:
	void slotOk();
	

protected:
	KKDoc *m_doc;
	QString m_filename;

	QPtrList<KKContactData> contactDataList;
	
	KListView *m_PrintListView;
	
};

class KKPrintCheckListItem : public QCheckListItem
{
public:
	KKPrintCheckListItem( QCheckListItem *parent, const QString &label, const KKContactData *data )
		: QCheckListItem( parent, label, QCheckListItem::CheckBoxController )
		, m_data( data )
	{
	}

	const KKContactData *contactData() const { return m_data; }

protected:
	const KKContactData *m_data;			  
};

#endif /* Not def: _KK_PRINT_DIALOG_H_ */
