/***************************************************************************
 *   Copyright (C) 2004 by Kazuki Ohta                                     *
 *   mover@hct.zaq.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <stdlib.h>

#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kdebug.h>
#include <klocale.h>
#include <kuniqueapplication.h>

#include "kkaddressbookdialog.h"

static const char description[] =
	I18N_NOOP("Address Management tool for KreetingKard");

static const char version[] = "0.1.0";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    KCmdLineLastOption
};

class KKAddressBookApp : public KUniqueApplication {
public:
    KKAddressBookApp()
        : KUniqueApplication( "KKAddressBook" )
    {
        mMainWin = new KKAddressBookDialog;
	setMainWidget( mMainWin );
	mMainWin->show();
    }
    ~KKAddressBookApp() {}

    int newInstance();

private:
    KKAddressBookDialog *mMainWin;
};

int KKAddressBookApp::newInstance()
{
    /*
    if( isRestored() )
    {
        RESTORE(KKAddressBookDialog)
    }
    else
    {
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        args->clear();
    }
    */

    return KUniqueApplication::newInstance();
}

int main( int argc, char *argv[] )
{
	KLocale::setMainCatalogue( "kkaddressbook" );

	KAboutData about( "kkaddressbook", I18N_NOOP("KreetingKard AddressBook"), version, description,
                   KAboutData::License_GPL, "(C) 2004 Kazuki Ohta", 0, 0, "mover@hct.zaq.ne.jp" );
	about.addAuthor( "Kazuki Ohta", 0, "mover@hct.zaq.ne.jp" );

	KCmdLineArgs::init( argc, argv, &about );
	KCmdLineArgs::addCmdLineOptions( options );
	KKAddressBookApp::addCmdLineOptions();

	if( !KKAddressBookApp::start() )
	{
		kdDebug() << "Cannot load multiple kkaddressbook" << endl;
		exit(0);
	}

	KKAddressBookApp app;
	return app.exec();
}
