/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KKCMDBASE_H
#define KKCMDBASE_H

#include <qmap.h>
#include <qptrlist.h>
#include <qlistview.h>

#include <kcommand.h>
#include <klocale.h>
#include <kdebug.h>

#include "kkdoc.h"
#include "kkitem.h"

class KKCmdBase : public QObject, public KCommand
{
	Q_OBJECT
public:
	KKCmdBase( KKDoc* doc );
	virtual void execute();
	virtual void unexecute();
	QString name() const;
	bool valid() const{ return m_items.count() != 0; }
	void begin();
	void end();
	QPtrList<KKItem>& items() { return m_items; }

signals:
	void executed();
	void unexecuted();

protected:
	KKDoc* document() const{ return m_doc; }
	virtual QString propertyName() = 0;
	virtual void execute( KKItem* item ) = 0;
	virtual void unexecute( KKItem* item ) = 0;
	virtual void begin( KKItem* item ) = 0;
	virtual bool end( KKItem* item ) = 0;

private:
	KKDoc* m_doc;
	void setName( const QString &name );
	QString m_name;
	QPtrList<KKItem> m_items;
};


#endif //KKCMDBASE_H
