/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkcmdinsert.h"

KKCmdInsert::KKCmdInsert( KKDoc* doc )
	: KKCmdBase( doc )
{
	connect( this, SIGNAL( executed() ), doc, SIGNAL( inserted() ) );
	connect( this, SIGNAL( unexecuted() ), doc, SIGNAL( removed() ) );
}

void KKCmdInsert::execute( KKItem* item )
{
	m_parent[item]->insertItem( item );
	document()->insertByCommand( m_parent[item], item );
}

void KKCmdInsert::unexecute( KKItem* item )
{
	m_parent[item]->takeItem( item );
	document()->removeByCommand( m_parent[item], item );
}

void KKCmdInsert::begin( KKItem* item )
{
	m_parent[item] = item->parent();
}

bool KKCmdInsert::end( KKItem* )
{
	return true;
}

QString KKCmdInsert::propertyName()
{
	return i18n( "insert" );
}
