/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KKPROPERTY_H
#define KKPROPERTY_H

#include <qmap.h>
#include <qimage.h>

#include <klistview.h>


class KKDoc;
class KKPropertyItemBase;

class KKProperty : public KListView
{
	Q_OBJECT
public:
	KKProperty( QWidget* parent = 0, const char* name = 0 );
	~KKProperty();
	KKDoc* document() const{ return m_doc; }

public slots:
	void setDocument( KKDoc* doc );
	void rename( QListViewItem* item, int c );

protected slots:
	void doneEditing( QListViewItem* item, int row );

protected:
// 	void focusOutEvent( QFocusEvent* e );

private:
	KKDoc* m_doc;
	QMap<QString,KKPropertyItemBase*> m_properties;

private slots:
	void selectionChanged();
};

#endif //KKPROPERTY_H
