/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkpropertyitembool.h"

KKPropertyItemBool::KKPropertyItemBool( KKPropertyItemBase* parent, const QString &text )
	: KKPropertyItemBase( parent, text )
{
	setupWidgetBool();
}

KKPropertyItemBool::KKPropertyItemBool( KKProperty* parent, const QString &text )
	: KKPropertyItemBase( parent, text )
{
	setupWidgetBool();
}

KKPropertyItemBool::~KKPropertyItemBool()
{
}

void KKPropertyItemBool::setupWidgetBool()
{
	hbox = new QHBox( viewport() );
	chkEnabled = new QCheckBox( "", hbox );
	chkEnabled->setFixedSize( 16, 16 );

	cbxBool = new KComboBox( hbox );
	cbxBool->insertItem( i18n( "True" ) );
	cbxBool->insertItem( i18n( "False" ) );
	connect( cbxBool, SIGNAL( returnPressed( const QString& ) ), this, SLOT( accept() ) );
	connect( chkEnabled, SIGNAL( toggled( bool ) ), cbxBool, SLOT( setEnabled( bool ) ) );
	setVisible( false );
}

void KKPropertyItemBool::start()
{
	KKPropertyItemBase::start();
	chkEnabled->setChecked( !text( 1 ).isEmpty() );
	cbxBool->setEnabled( chkEnabled->isChecked() );
	if( chkEnabled->isChecked() )
	{
		cbxBool->setCurrentText( text( 1 ) );
	}
	cbxBool->setFocus();
}

void KKPropertyItemBool::accept()
{
	if( !cbxBool->isVisible() ) return;
	if( cbxBool->currentText() != text( 1 ) && chkEnabled->isChecked() )
	{
		setProperty( cbxBool->currentItem() == 0 );
	}
	KKPropertyItemBase::accept();
}

void KKPropertyItemBool::reset()
{
	KKPropertyItemBase::reset();
	QPtrList<QListViewItem> selectedItems = document()->selectedItems();
	if( selectedItems.isEmpty() )
	{
		setVisible( false );
		return;
	}
	else
	{
		setVisible( true );
	}
	int index = property( ((KKItem*)selectedItems.first()) ) ? 1 : 0;
	for( KKItem* item = (KKItem*)selectedItems.next(); item; item = (KKItem*)selectedItems.next() )
	{
		if( ( index == 1 ) != property( item ) )
		{
			index = -1;
			break;
		}
	}
	switch( index )
	{
		case -1:
			setText( 1, "" );
			break;
		case 0:
			setText( 1, i18n( "False" ) );
			break;
		case 1:
			setText( 1, i18n( "True" ) );
			break;
	}
	chkEnabled->setChecked( index != -1 );
	if( document()->selectedItems().count() > 1 ) chkEnabled->show(); else chkEnabled->hide();
}
