/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkpropertyitemorientation.h"

KKPropertyItemOrientation::KKPropertyItemOrientation( KKProperty* parent, const QString &text )
	: KKPropertyItemBase( parent, text )
{
	cbxOrientation = new KComboBox( viewport() );
	cbxOrientation->insertItem( i18n( "Landscape" ) );
	cbxOrientation->insertItem( i18n( "Portrait" ) );
	connect( cbxOrientation, SIGNAL( returnPressed( const QString& ) ), this, SLOT( accept() ) );
	setVisible( false );
}

KKPropertyItemOrientation::~KKPropertyItemOrientation()
{
}

void KKPropertyItemOrientation::start()
{
	KKPropertyItemBase::start();
	cbxOrientation->setCurrentText( text( 1 ) );
	cbxOrientation->setFocus();
}

void KKPropertyItemOrientation::accept()
{
	if( !cbxOrientation->isVisible() ) return;
	if( cbxOrientation->currentText() != text( 1 ) )
	{
		document()->setOrientation( (Orientation)cbxOrientation->currentItem() );
	}
	KKPropertyItemBase::accept();
}

void KKPropertyItemOrientation::reset()
{
	KKPropertyItemBase::reset();
	QPtrList<QListViewItem> selectedItems = document()->selectedItems();
	if( selectedItems.isEmpty() || selectedItems.first()->parent() )
	{
		setVisible( false );
		return;
	}
	else
	{
		setVisible( true );
	}
	switch( ((KKItem*)selectedItems.first())->orientation() )
	{
		case Horizontal:
			setText( 1, i18n( "Landscape" ) );
			break;
		case Vertical:
			setText( 1, i18n( "Portrait" ) );
			break;
	}
}
