/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkpropertyitemtextcolor.h"

KKPropertyItemTextColor::KKPropertyItemTextColor( KKPropertyItemBase* parent, const QString &text )
	: KKPropertyItemBase( parent, text )
{
	hbox = new QHBox( viewport() );
	chkEnabled = new QCheckBox( "", hbox );
	chkEnabled->setFixedSize( 16, 16 );

	btnColor = new KColorButton( hbox );
	connect( btnColor, SIGNAL( changed ( const QColor& ) ), this, SLOT( accept() ) );
	connect( chkEnabled, SIGNAL( toggled( bool ) ), btnColor, SLOT( setEnabled( bool ) ) );
	setVisible( false );
}

KKPropertyItemTextColor::~KKPropertyItemTextColor()
{
}

void KKPropertyItemTextColor::start()
{
	KKPropertyItemBase::start();
	chkEnabled->setChecked( !text( 1 ).isEmpty() );
	btnColor->setEnabled( chkEnabled->isChecked() );
	if( chkEnabled->isChecked() )
	{
		btnColor->setColor( QColor( text( 1 ) ) );
	}
	btnColor->setFocus();
}

void KKPropertyItemTextColor::accept()
{
	if( !btnColor->isVisible() ) return;
	if( btnColor->color().name() != text( 1 ) && chkEnabled->isChecked() )
	{
		document()->setTextColor( btnColor->color() );
	}
	KKPropertyItemBase::accept();
}

void KKPropertyItemTextColor::reset()
{
	KKPropertyItemBase::reset();
	QColor* color = NULL;
	QPtrList<QListViewItem> selectedItems = document()->selectedItems();
	if( selectedItems.isEmpty() )
	{
		setVisible( false );
		return;
	}
	else
	{
		setVisible( ((KKItem*)selectedItems.first())->parent() != NULL );
	}
	color = new QColor( ((KKItem*)selectedItems.first())->textColor() );
	for( KKItem* item = (KKItem*)selectedItems.next(); item; item = (KKItem*)selectedItems.next() )
	{
		if( color != NULL && *color != item->textColor() )
		{
			color = NULL;
			break;
		}
	}
	chkEnabled->setChecked( color );
	if( document()->selectedItems().count() > 1 ) chkEnabled->show(); else chkEnabled->hide();
	setText( 1, color ? color->name() : "" );
	if( color ) delete color;
}
