/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkpropertyitemtextorientation.h"

KKPropertyItemTextOrientation::KKPropertyItemTextOrientation( KKPropertyItemBase* parent, const QString &text )
	: KKPropertyItemBase( parent, text )
{
	hbox = new QHBox( viewport() );
	chkEnabled = new QCheckBox( "", hbox );
	chkEnabled->setFixedSize( 16, 16 );

	cbxOrientation = new KComboBox( hbox );
	cbxOrientation->insertItem( i18n( "Horizontal" ) );
	cbxOrientation->insertItem( i18n( "Vertical" ) );
	connect( cbxOrientation, SIGNAL( returnPressed( const QString& ) ), this, SLOT( accept() ) );
	connect( chkEnabled, SIGNAL( toggled( bool ) ), cbxOrientation, SLOT( setEnabled( bool ) ) );
	setVisible( false );
}

KKPropertyItemTextOrientation::~KKPropertyItemTextOrientation()
{
}

void KKPropertyItemTextOrientation::start()
{
	KKPropertyItemBase::start();
	chkEnabled->setChecked( !text( 1 ).isEmpty() );
	cbxOrientation->setEnabled( chkEnabled->isChecked() );
	if( chkEnabled->isChecked() )
	{
		cbxOrientation->setCurrentText( text( 1 ) );
	}
	cbxOrientation->setFocus();
}

void KKPropertyItemTextOrientation::accept()
{
	if( !cbxOrientation->isVisible() ) return;
	if( cbxOrientation->currentText() != text( 1 ) && chkEnabled->isChecked() )
	{
		document()->setTextOrientation( (Orientation)cbxOrientation->currentItem() );
	}
	KKPropertyItemBase::accept();
}

void KKPropertyItemTextOrientation::reset()
{
	KKPropertyItemBase::reset();
	int orientation = -1;
	QPtrList<QListViewItem> selectedItems = document()->selectedItems();
	if( selectedItems.isEmpty() )
	{
		setVisible( false );
		return;
	}
	else
	{
		setVisible( ((KKItem*)selectedItems.first())->parent() != NULL );
	}
	orientation = ((KKItem*)selectedItems.first())->textOrientation();
	for( KKItem* item = (KKItem*)selectedItems.next(); item; item = (KKItem*)selectedItems.next() )
	{
		if( orientation != -1 && orientation != item->textOrientation() )
		{
			orientation = -1;
			break;
		}
	}
	switch( orientation )
	{
		case -1:
			setText( 1, "" );
			break;
		case Horizontal:
			setText( 1, i18n( "Horizontal" ) );
			break;
		case Vertical:
			setText( 1, i18n( "Vertical" ) );
			break;
	}
	chkEnabled->setChecked( orientation != -1 );
	if( document()->selectedItems().count() > 1 ) chkEnabled->show(); else chkEnabled->hide();
}
