/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kksizehandlerwidget.h"

KKSizeHandlerWidget::KKSizeHandlerWidget( int x, int y, QWidget *parent, const char *name )
	: QWidget(parent, name)
{
	m_x = x;
	m_y = y;
	m_drag = false;
	resize( 4, 4 );
	setPaletteBackgroundColor( Qt::darkBlue );
	switch( y )
	{
		case 0:
			switch( x )
			{
				case 0:
					setCursor( sizeFDiagCursor );
					break;
				case 1:
					setCursor( sizeVerCursor );
					break;
				case 2:
					setCursor( sizeBDiagCursor );
					break;
			}
			break;
		case 1:
			switch( x )
			{
				case 0:
					setCursor( sizeHorCursor );
					break;
				case 1:
					// Nothing
					break;
				case 2:
					setCursor( sizeHorCursor );
					break;
			}
			break;
		case 2:
			switch( x )
			{
				case 0:
					setCursor( sizeBDiagCursor );
					break;
				case 1:
					setCursor( sizeVerCursor );
					break;
				case 2:
					setCursor( sizeFDiagCursor );
					break;
			}
			break;
	}
}

KKSizeHandlerWidget::~KKSizeHandlerWidget()
{
}

void KKSizeHandlerWidget::mousePressEvent( QMouseEvent* e )
{
	if( ( e->button() & LeftButton ) != LeftButton ) return;
	m_drag = true;
	m_pos = e->pos();
	emit start();
	e->accept();
}

void KKSizeHandlerWidget::mouseMoveEvent( QMouseEvent* e )
{
	if( !m_drag ) return;
	emit moving( m_x, m_y, e->pos() - m_pos );
	e->accept();
}

void KKSizeHandlerWidget::mouseReleaseEvent( QMouseEvent* e )
{
	if( !m_drag ) return;
	m_drag = false;
	emit end();
	e->accept();
}
