/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KKSIZEHANDLERWIDGET_H
#define KKSIZEHANDLERWIDGET_H

#include <qwidget.h>

class KKSizeHandlerWidget : public QWidget
{
	Q_OBJECT
public:
	KKSizeHandlerWidget( int x, int y, QWidget *parent = 0, const char *name = 0 );
	~KKSizeHandlerWidget();

signals:
	void start();
	void moving( int x, int y, QPoint );
	void end();

protected:
	void mousePressEvent( QMouseEvent* e );
	void mouseMoveEvent( QMouseEvent* e );
	void mouseReleaseEvent( QMouseEvent* e );

private:
	int m_x, m_y;
	QPoint m_pos;
	bool m_drag;
};

#endif //KKSIZEHANDLERWIDGET_H
