/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qfile.h>
#include <qtextcodec.h>
#include <qfileinfo.h>

#include <kdebug.h>
#include <klocale.h>
#include <kapplication.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <kio/netaccess.h>
#include <kmessagebox.h>
#include <kprogress.h>
#include <kapplication.h>

#include "zipcode.h"

ZipCode::ZipCode()
{
	m_datafile = locateLocal( "data", KGlobal::instance()->instanceName() + "/" + DATAFILE );
}
bool ZipCode::readData( bool reload )
{
	if( !empty() && !reload ) return true;
	QFile file( m_datafile );
	if( !file.open( IO_ReadOnly ) ){
		return false;
	}

	QTextStream ts( &file );
	QStringList list;
	while( !ts.atEnd() )
	{
		kapp->processEvents();
		QStringList fields = QStringList::split( '\t', ts.readLine() );
		instance()[fields[0]] = fields[1];
	}
	return true;
}

bool ZipCode::update( QWidget* parent )
{
	QString tmpfile, csvfile;
	KProgressDialog* dlgProgress = new KProgressDialog( parent, "", i18n( "ZipCode Update" ), "Test", true );
	dlgProgress->setAllowCancel( false );
	dlgProgress->progressBar()->setTotalSteps( 47 );
	dlgProgress->setLabel( i18n( "download zipcode archive" ) );
	dlgProgress->show();

	if( !KIO::NetAccess::download( URL, tmpfile, parent ) )
	{
		delete dlgProgress;
		KMessageBox::sorry( parent, KIO::NetAccess::lastErrorString() );
		return false;
	}
	dlgProgress->setLabel( i18n( "expand zipcode archive" ) );
	KProcess *proc = new KProcess();
	*proc << "lha" << "xq2" << tmpfile;
	proc->start();
	while( proc->isRunning() )
	{
		kapp->processEvents();
	}
	KIO::NetAccess::removeTempFile( tmpfile );

	QFile org( "ken_all.csv" );
	QFile local( m_datafile );
	if( !org.open( IO_ReadOnly ) ){
		delete dlgProgress;
		KMessageBox::sorry( parent, i18n( "Could not open %1" ).arg( org.name() ) );
		return false;
	}
	if( !local.open( IO_WriteOnly ) ){
		delete dlgProgress;
		KMessageBox::sorry( parent, i18n( "Could not open %1" ).arg( m_datafile ) );
		org.close();
		return false;
	}

	clear();
	QTextStream in( &org );
	QTextStream out( &local );
	in.setCodec( QTextCodec::codecForName("Shift-JIS") );

	QString pref = QString::null;
	int i = -1;
	while( !in.atEnd() )
	{
// 		if( dlgProgress->wasCancelled() ) break;
		QStringList fields = QStringList::split( ',', in.readLine() );
		QString code = fields[2].replace( "\"", "" );
		instance()[code] = fields[6] + fields[7];
		if( fields[8] == QString::fromUtf8( "\"以下に掲載がない場合\"" ) )
		{
			// exception
		}
		else if( fields[8].find( QString::fromUtf8( "（" ) ) != -1 )
		{
			// exception
		}
		else
		{
			instance()[code] += fields[8];
		}
		instance()[code] = instance()[code].replace( "\"", "" );
		out << code << '\t' << instance()[code] << endl;
		if( pref != fields[6] )
		{
			pref = fields[6];
			dlgProgress->setLabel( fields[6].replace( "\"", "" ) );
			kapp->processEvents();
			dlgProgress->progressBar()->setProgress( i++ );
		}
	}
	org.close();
	local.close();
	org.remove();
	delete dlgProgress;
	return true;
}


ZipCode::~ZipCode()
{
}
