/***************************************************************************
                          exeDlg.h  -  description
                             -------------------
    begin                :   2 22 2003
    copyright            : (C) 2003 by K.Kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef EXEDLG_H
#define EXEDLG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qlist.h>

// include files for KDE
#include <kprocess.h>
#include <kdialog.h>
#include <qdatetime.h>

// forward declaration
class VarTbl;
class CronTbl;
class AnacTbl;
class AtTbl;
class UserTbl;

class QTextEdit;
class QPushButton;
class KTempFile;
class FrameLabel;

/**
  * Execute Dialog
  */
class ExeDlg : public KDialog
{
  Q_OBJECT
  public:
    /** Constructor */
    ExeDlg( CronTbl* cr );
    ExeDlg( AnacTbl* an, int flg );
    ExeDlg( AtTbl* at );

    /** Destructor */
    ~ExeDlg();

  private:

    /** Initialize Dialog */
    void initDialog( const QString& shell );
    /** Get Evnrionment */
    QString getUserVar( const QString& name );
    /** Save Environment */
    void clearEnv();
    /** Restore Environment */
    void restoreEnv();
    /** unset Environment */
    void unsetEnv( const QString& e );

    /** Shell Process */
    KShellProcess*  process;

    /** Widgets */
    QTextEdit*      outEdit;    // stdout View
    QTextEdit*      errEdit;    // stderr View
    QPushButton*    okBtn;      // OK
    QPushButton*    killBtn;    // Kill Button
    FrameLabel*     clockLbl;   // Processor Time Label
    FrameLabel*     timeLbl;    // Elappsed Time Label
    QTime           sTime;      // Start Time

    QString         inpStr;

    /** User Information */
    UserTbl*   userTbl;

    /** At Execute Shell File */
    KTempFile*  tempFile;

    /** Environment for Save */
    char  **env;

  protected slots:
    /** stdout Callback */
    void slotStdout(KProcess*,char*,int);
    /** stderr Callback */
    void slotStderr(KProcess*,char*,int);
    /** Exit Callback */
    void slotExit(KProcess*);
    /** Kill Action */
    void slotKill();

};

#endif // EXEDLG_H
