/***************************************************************************
                          kroneko.cpp  -  description
                             -------------------
    begin                :   2  8 00:43:28 JST 2003
    copyright            : (C) 2003 by kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//using namespace std;
//#include <iostream>

// include files for QT
#include <qdir.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qprogressbar.h>
#include <qtabwidget.h>
#include <qmessagebox.h>
//#include <qlistview.h>

// include files for KDE
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <kaccel.h>

// application specific includes
#include "docTables.h"
#include "kroneconfig.h"
#include "option.h"
#include "system.h"
#include "confDlg.h"
#include "kronekoview.h"
#include "kronekodoc.h"
#include "clockView.h"
#include "listTabs.h"
#include "kroneko.h"
#include "runeDlg.h"
#include "viewTabs.h"

extern Option* g_Option;
extern bool    g_ViewMode;

#define ID_STATUS_MSG 1
#define ID_STATUS_TOTAL 2
#define ID_STATUS_USER 3

KronekoApp::KronekoApp(QWidget* , const char* name):KMainWindow(0, name)
{
  config=kapp->config();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initStatusBar();
  initActions();
  initDocument();

  readOptions();

  initView();
  if ( ! g_ViewMode ) fileSave->setEnabled(false);

  if ( g_Option->runeOfDay ){
    rune = new RuneDlg( g_Option->runeOfDay, this, "" );
    rune->show();
    rune->raise();
  }else{
    rune = NULL;
  }

  ///////////////////////////////////////////////////////////////////
  // disable actions at startup
  doc->start();
}

KronekoApp::~KronekoApp()
{

}

void KronekoApp::initActions()
{
  fileQuit = KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection());
  fileQuit->setStatusText(i18n("Quits the application"));
  viewToolBar = KStdAction::showToolbar(this, SLOT(slotViewToolBar()), actionCollection());
  viewStatusBar = KStdAction::showStatusbar(this, SLOT(slotViewStatusBar()), actionCollection());
  if ( ! g_ViewMode ){
    fileSave = KStdAction::save(this, SLOT(slotFileSave()), actionCollection());
    fileSave->setStatusText(i18n("Saves the actual document"));
    fileSave->setWhatsThis ( i18n( "<em>Save All Modified Data</em><p>Update All Task from Modified Data.</p>" ) );
    fileNewCron = new KAction(i18n("New &Cron"), QIconSet( IconFile( "cronnew" ) ), 0, this,
        SLOT(slotFileNewCron()), actionCollection(), "file_new_cron");
    fileNewCron->setWhatsThis ( i18n( "<em>New Cron</em><p>Enable edit <b>New Cron</b> data from template.<br>Edit Page(Cron) will be available.</p>" ) );
    if ( System::uid() == 0 ){                                                                                         
      fileNewAnac = new KAction(i18n("New an&Acron"), QIconSet( IconFile( "anacnew" ) ), 0, this,
          SLOT(slotFileNewAnac()), actionCollection(), "file_new_anac");
      fileNewAnac->setWhatsThis ( i18n( "<em>New Anacron</em><p>Enable edit <b>New Anacron</b> data from template.<br>Edit Page(Anacron) will be available.</p>" ) );
    }
    fileNewAt = new KAction(i18n("New a&T"), QIconSet( IconFile( "atnew" ) ), 0, this,
        SLOT(slotFileNewAt()), actionCollection(), "file_new_at");
    fileNewAt->setWhatsThis ( i18n( "<em>New At</em><p>Enable edit <b>New At</b> data from template.<br>Edit Page(At) will be available.</p>" ) );
    fileEdit = new KAction(i18n("&Edit Select"), QIconSet( IconFile( "editsel" ) ), 0, this,
        SLOT(slotFileEdit()), actionCollection(), "file_edit");
    fileEdit->setWhatsThis ( i18n( "<em>Edit Selected Task</em><p>Edit currently selected task of List Page.</p>" ) );
    fileTime = new KAction(i18n("Edit Ti&me"), QIconSet( IconFile( "editime" ) ), 0, this,
        SLOT(slotFileTime()), actionCollection(), "file_time");
    fileTime->setWhatsThis ( i18n( "<em>Edit Time</em><p>Edit currently selected time of List Page.</p>" ) );
  }

  fileReload = new KAction(i18n("&Reload"),  QIconSet( IconFile( "reload" ) ), KStdAccel::key(KStdAccel::Reload), this,
      SLOT(slotFileReload()), actionCollection(), "file_reload");
  fileReload->setWhatsThis ( i18n( "<em>Reload All Data</em><p>Reload All Cron, Anacron, At and log Data.<br><b>Any modified data be canceled.</b></p>" ) );
#ifndef CRON_DILLON
  fileLogReload = new KAction(i18n("&Log Reload"),  QIconSet( IconFile( "logreload" ) ), SHIFT+Key_F5, this,
      SLOT(slotFileLogReload()), actionCollection(), "file_logreload");
  fileLogReload->setWhatsThis ( i18n( "<em>Reload Log Data</em><p>Reload Log Data. And Update Log List View.</p>" ) );
  runeTip = new KAction(i18n("Rune of Today"), SmallIconSet( "idea" ), 0, this,
      SLOT(slotRuneOfToday()), actionCollection(), "rune_of_today" );
#endif
  fileDetail = new KAction(i18n("Statistic &Information"),  QIconSet( IconFile( "detail" ) ), CTRL+Key_I, this,
      SLOT(slotFileDetail()), actionCollection(), "file_detail");
  fileDetail->setWhatsThis ( i18n( "<em>Statistic Information</em><p>Display Statistic Information.</p>" ) );
  fileRemExe = new KToggleAction(i18n("&Display to Execute List"), QIconSet( IconFile( "remove" ) ), 0, this,
        SLOT(slotFileRemExe()), actionCollection(), "file_remexe");
  fileRemExe->setWhatsThis ( i18n( "<em>Display to Execute List</em><p>Display Selected Task to Execute List</p>" ) );
  setPreferences = KStdAction::preferences(this, SLOT(slotPreferences()), actionCollection(), "preferences" );
  setPreferences->setWhatsThis ( i18n( "<em>Set Preferences</em><p>Set preferences of Kroneko action.</p>" ) );


  viewToolBar->setStatusText(i18n("Enables/disables the toolbar"));
  viewStatusBar->setStatusText(i18n("Enables/disables the statusbar"));

  // use the absolute path to your kronekoui.rc file for testing purpose in createGUI();
  KStandardDirs kdir;

  // Add Install Position
  kdir.addPrefix( "/usr/local/kde/" );
  kdir.addPrefix( System::uHome() + "/" );
  QString hs = getenv( "HOME" );
  kdir.addPrefix( hs + "/" );
  createGUI( kdir.findResource("data", "kroneko/kronekoui.rc" ) );

}


void KronekoApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
  // TODO: add your own items you need for displaying current application status.
  statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG);
  statusBar()->setItemAlignment( ID_STATUS_MSG, AlignLeft );
  statusBar()->insertFixedItem(" ", ID_STATUS_USER, true );
  statusBar()->insertFixedItem(" ", ID_STATUS_TOTAL, true );
  statusProgress = new QProgressBar( statusBar() );
  statusProgress->setPercentageVisible( false );
  statusProgress->setTotalSteps( 100 );
  statusProgress->setProgress( -1 );
  statusProgress->setFixedHeight( 15 );
  statusProgress->setMaximumWidth( 80 );
  statusBar()->addWidget( statusProgress, 1, true  );
}

void KronekoApp::initDocument()
{
  doc = new KronekoDoc(this);
}

void KronekoApp::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // create the main widget here that is managed by KTMainWindow's view-region and
  // connect the widget to your document to display document contents.

  view = new KronekoView(this);
//  doc->addView(view);
  doc->setView(view);
  setCentralWidget(view);	
  setCaption( System::uName() ,false);
}

void KronekoApp::saveOptions()
{	


  // kroneko General Configure
  config->setGroup("General Options");
  config->writeEntry("Geometry", size());
  config->writeEntry("Show Toolbar", viewToolBar->isChecked());
  config->writeEntry("Show Statusbar",viewStatusBar->isChecked());
  config->writeEntry("ToolBarPos", (int) toolBar("mainToolBar")->barPos());

  config->setGroup("General Configure");
  config->writeEntry( "Use AT", g_Option->useAt );
  config->writeEntry( "Use ANACRON", g_Option->useAnacron );
#ifndef CRON_DILLON
  config->writeEntry( "Use System Cron", g_Option->useSyscron );
#endif
  if ( rune ){
    config->writeEntry( "Rune Of Day", rune->runOnStart );
  }
  config->writeEntry( "Use Sound", g_Option->useSound );
  config->writeEntry( "Execute List Num", g_Option->exeListMax );
  config->writeEntry( "Use Max Date", g_Option->useExeDay );
  config->writeEntry( "Max Date", g_Option->exeDayMax );
#ifndef CRON_DILLON
  config->writeEntry( "Log List Num", g_Option->logListMax );
#endif
  config->writeEntry( "Clock Image", g_Option->clockImage );
  config->writeEntry( "Log File",g_Option->logFile );
  config->writeEntry( "Sound Time", g_Option->soundSec );
  config->writeEntry( "Sound Name",g_Option->soundName );
  config->writeEntry( "Rest Mode", g_Option->restMode );
  config->writeEntry( "Power On Time", g_Option->ponTime.toString( "hh:mm:ss" ) );
  config->writeEntry( "Power On Weekday", g_Option->ponWeekDay );
  config->writeEntry( "Log List Auto", g_Option->autoModLog );

  // 'cron' Configure
  config->setGroup( "cron Configure" );
  config->writeEntry( "Use Leretal", g_Option->cronLiteral );
  config->writeEntry( "cron Path", g_Option->cronPath );
  config->writeEntry( "cron Spool Path", g_Option->cronPathSpool );
#ifndef CRON_DILLON
  config->writeEntry( "Allow File Path", g_Option->cronFileAllow );
  config->writeEntry( "Deny File Path", g_Option->cronFileDeny );
  config->writeEntry( "System crontab Path", g_Option->cronFileSys );
#endif

  // 'anacron' Configure
  config->setGroup( "anacron Configure" );
  config->writeEntry( "Display Execute", g_Option->anacListDisp );
  config->writeEntry( "anacrontab Path", g_Option->anacFileSys );
  config->writeEntry( "anacron Spool Path", g_Option->anacPathSpool );

  // 'at' Configure
  config->setGroup( "at Configure" );
  config->writeEntry( "Display Execute", g_Option->atDispExe );
  config->writeEntry( "at Path", g_Option->atPath );
  config->writeEntry( "New Time", g_Option->atNewTime );
  config->writeEntry( "New Mail", g_Option->atNewMail );

  // set Template
  TmplFile( "CronHead" ).writeText( g_Option->cronNewHead );
  TmplFile( "CronCommand" ).writeText( g_Option->cronNewCmnd );
  TmplFile( "AnacHead" ).writeText( g_Option->anacNewHead );
  TmplFile( "AnacCommand" ).writeText( g_Option->anacNewCmnd );
  TmplFile( "AtCommand" ).writeText( g_Option->atNewCmnd );
}


void KronekoApp::readOptions()
{

  config->setGroup("General Options");

  // bar status settings
  bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
  viewToolBar->setChecked(bViewToolbar);
  slotViewToolBar();

  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
  viewStatusBar->setChecked(bViewStatusbar);
  slotViewStatusBar();


  // bar position settings
  KToolBar::BarPosition toolBarPos;
  toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos", KToolBar::Top);
  toolBar("mainToolBar")->setBarPos(toolBarPos);
	
  QSize size=config->readSizeEntry("Geometry");
  if(size.isEmpty()) size = QSize(790, 550);
  resize( size );
  
  // kroneko General Configure
  config->setGroup("General Configure");
  g_Option->useAt = config->readBoolEntry( "Use AT", true );
  g_Option->useAnacron = config->readBoolEntry( "Use ANACRON", true );
#ifndef CRON_DILLON
  g_Option->useSyscron = config->readBoolEntry( "Use System Cron", true );
#endif
  g_Option->useSound = config->readBoolEntry( "Use Sound", false );
  if ( System::getCommand( SOUND_CMD ) == "" ) g_Option->useSound = false;
  g_Option->ponWeekDay = config->readBoolEntry( "Power On Weekday", true );
  g_Option->runeOfDay = config->readBoolEntry( "Rune Of Day", true );
  g_Option->exeListMax = config->readNumEntry( "Execute List Num", 500 );
  g_Option->useExeDay = config->readBoolEntry( "Use Max Date", false );
  g_Option->exeDayMax = config->readNumEntry( "Max Date", 365 );
#ifndef CRON_DILLON
  g_Option->logListMax = config->readNumEntry( "Log List Num", 500 );
#endif
  if ( g_Option->exeListMax == 0 ) g_Option->exeListMax = 500;
  g_Option->clockImage = config->readEntry( "Clock Image", "clock2" );
  g_Option->logFile = config->readEntry( "Log File", LOG_PATH );
  g_Option->soundSec = config->readNumEntry( "Sound Time", 10 );
  g_Option->soundName = config->readEntry( "Sound Name", "sound1" );
  g_Option->restMode = config->readNumEntry( "Rest Mode", 1 );
  g_Option->ponTime = QTime::fromString( config->readEntry( "Power On Time", "09:00:00" ), Qt::ISODate );
  g_Option->autoModLog = config->readBoolEntry( "Log List Auto", true );

  // 'cron' Configure
  config->setGroup( "cron Configure" );
  g_Option->cronLiteral = config->readBoolEntry( "Use Leretal", true );
  g_Option->cronPath = config->readEntry( "Path", CRONEXE_PATH );
#ifdef CRON_DILLON
  g_Option->cronPathSpool = config->readEntry( "cron Spool Path", "/var/spool/cron/crontabs" );
#else
  g_Option->cronPathSpool = config->readEntry( "cron Spool Path", CRONSPOOL_PATH );
  g_Option->cronFileAllow = config->readEntry( "Allow File Path", CRONALLOW_FILE );
  g_Option->cronFileDeny = config->readEntry( "Deny File Path", CRONDENY_FILE );
  g_Option->cronFileSys = config->readEntry( "System crontab Path", SYSCRON_FILE );
#endif

  // 'anacron' Configure
  config->setGroup( "anacron Configure" );
  g_Option->anacListDisp = config->readBoolEntry( "Display Execute", true );
  g_Option->anacFileSys = config->readEntry( "anacrontab Path", SYSANAC_FILE );
  g_Option->anacPathSpool = config->readEntry( "anacron Spool Path", ANACSPOOL_PATH );

  // 'at' Configure
  config->setGroup( "at Configure" );
  g_Option->atDispExe = config->readBoolEntry( "Display Execute", true );
  g_Option->atPath = config->readEntry( "at Path", ATETC_PATH );
  g_Option->atNewMail = config->readBoolEntry( "New Mail", false );
  g_Option->atNewTime = config->readNumEntry( "New Time", 60 );
  g_Option->atFileAllow = g_Option->atPath + "/at.allow";
  g_Option->atFileDeny = g_Option->atPath + "/at.deny";

  // New command template
  g_Option->cronNewHead = TmplFile( "CronHead" ).readText();
  g_Option->cronNewCmnd = TmplFile( "CronCommand" ).readText();
  g_Option->anacNewHead = TmplFile( "AnacHead" ).readText();
  g_Option->anacNewCmnd = TmplFile( "AnacCommand" ).readText();
  g_Option->atNewCmnd = TmplFile( "AtCommand" ).readText();

  // 'cron' Allow/Deny/All Setting
#ifdef CRONONLYROOT
  if ( System::access( g_Option->cronFileAllow ) &  FILE_EXIST  ){
    g_Option->cronUser = ALLOW_USER;
  }else if ( System::access( g_Option->cronFileDeny ) & FILE_EXIST ){
    if ( QFile( g_Option->cronFileDeny ).size() == 0 ){
      g_Option->cronUser = ALL_USER;
    }else{
      g_Option->cronUser = DENY_USER;
    }
  }else{
    g_Option->cronUser = DENY_USER;
  }
#else
  if ( System::access( g_Option->cronFileAllow ) & FILE_EXIST ){
    g_Option->cronUser = ALLOW_USER;
  }else if ( System::access( g_Option->cronFileDeny ) & FILE_EXIST ){
    g_Option->cronUser = DENY_USER;
  }else{
    g_Option->cronUser = ALL_USER;
  }
#endif

  // 'at' Allow/Deny/All Setting
  if ( System::access( g_Option->atFileAllow ) & FILE_EXIST ){
    g_Option->atUser = ALLOW_USER;
  }else if ( System::access( g_Option->atFileDeny ) & FILE_EXIST ){
    if ( QFile( g_Option->atFileDeny ).size() == 0 ){
      g_Option->atUser = ALL_USER;
    }else{
      g_Option->atUser = DENY_USER;
    }
  }else{
    g_Option->atUser = DENY_USER;
  }
  
  // Use/Not Use Anacron
  if ( ! g_ViewMode ){
    if ( System::getCommand( "anacron" ) == "" ) g_Option->useAnacron = false;
    if ( System::isAnacWritable() ){
      if ( g_Option->useAnacron ){
        fileNewAnac->setEnabled(true);
      }else{
        fileNewAnac->setEnabled(false);
      }
    }

  // Use/Not Use At
    fileNewAt->setEnabled(g_Option->useAt);
  }

#ifndef CRON_DILLON
  // Reload Log List
  if ( ! ( System::access( g_Option->logFile ) & CAN_READ )  ){
    fileLogReload->setEnabled(false);
  }
#endif
  
}


bool KronekoApp::queryExit()
{
  bool ret;
  if ( doc->running() ){
    doc->pStart( RUN_EXIT );
    ret = false;
  }else{
    saveOptions();
    ret = true;
  }
  return ret;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KronekoApp::slotFileSave()
{

  if ( QMessageBox::information( this,
      i18n("Save Data"), i18n("Are you sure to save all data ?"),
      QMessageBox::Ok, QMessageBox::Cancel ) == QMessageBox::Ok ){
    slotStatusMsg(i18n("Saving file..."));
    doc->saveCron();
    if ( System::isAnacWritable() ) doc->saveAnac();
    doc->saveAt();
    doc->resetFlag();
    if ( !g_ViewMode ) fileSave->setEnabled(false);
#ifdef CRON_DILLON
      doc->pStart( RUN_LIST_EXEC  );
#else
    if ( g_Option->autoModLog ){
      doc->pStart( RUN_LIST_EXEC|RUN_LIST_LOG  );
    }else{
      doc->pStart( RUN_LIST_EXEC  );
    }
#endif
  }
}

void KronekoApp::slotFileNewCron()
{
  doc->newCron();
}

void KronekoApp::slotFileNewAnac()
{
  doc->newAnac();
}

void KronekoApp::slotFileNewAt()
{
  doc->newAt();
}

void KronekoApp::slotFileEdit()
{
  doc->editSelect();
}

void KronekoApp::slotFileTime()
{
  doc->editTime();
}

void KronekoApp::slotFileReload()
{
  if ( ! doc->checkModify() ||
       ( QMessageBox::information( this,
           i18n("Reload"), i18n("Data Not Modified.\nReload All Data?"),
           QMessageBox::Ok, QMessageBox::Cancel ) == QMessageBox::Ok ) ){
    slotStatusMsg(i18n("Reloading Data..."));
    if ( !g_ViewMode ) fileSave->setEnabled(false);
#ifdef CRON_DILLON
    doc->pStart( RUN_INIT );
#else
    doc->pStart( RUN_INIT|RUN_LIST_LOG );
#endif
  }
}


/*
 * Reload Log Data
 */
void KronekoApp::slotFileLogReload()
{
#ifndef CRON_DILLON
  doc->pStart( RUN_LIST_LOG );
#endif
}

/*
 * Statistic Information
 */
void KronekoApp::slotFileDetail()
{
  doc->dspDetail();
}

void KronekoApp::slotFileQuit()
{

  if ( doc->checkModify() ){
    if ( QMessageBox::information( this,
        i18n("Quit"), i18n("Data Not Modified.\nQuit kroneko ?"),
        QMessageBox::Ok, QMessageBox::Cancel ) == QMessageBox::Cancel ){
        return;
    }
  }

  slotStatusMsg(i18n("Exiting..."));

  if ( doc->running() ){
    doc->pStart( RUN_EXIT );
    return;
  }

  saveOptions();

  // close the first window, the list makes the next one the first again.
  // This ensures that queryClose() is called on each window to ask for closing
#if 0    //  w-h-y
  KMainWindow* w;
  if(memberList)
  {
    for(w=memberList->first(); w!=0; w=memberList->first())
    {
      // only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
      // the window and the application stay open.
      if(!w->close())
	break;
    }
  }
#endif
 close();
}

void KronekoApp::slotPreferences()
{
  ConfDlg* dlg = new ConfDlg();
  int ret = dlg->exec();
  if ( ret == QDialog::Accepted ){
    if ( dlg->chgFlag & CHG_ANAC ){
      if ( ! g_ViewMode ){
        if ( System::isAnacWritable() ){
          if ( g_Option->useAnacron ){
            view->viewTab->insertTab( (QWidget*)view->anacEditWgt, IconFile("anacedit"),  "Anacron", 3 );
          }else{
            view->viewTab->removePage( (QWidget*)view->anacEditWgt );
          }
          if ( g_Option->useAnacron ){ 
            fileNewAnac->setEnabled(true);
          }else{
            fileNewAnac->setEnabled(false);
          }
        }
      }
    }
    if ( dlg->chgFlag & CHG_AT ){
      if ( ! g_ViewMode ){
        if ( System::atEnable()){
          int idx = 4;
          if ( ! g_Option->useAnacron ) idx = 3;
          view->viewTab->insertTab( (QWidget*)view->atEditWgt, IconFile("atedit"),  "At", idx );
        }else{
          view->viewTab->removePage( (QWidget*)view->atEditWgt );
        }
        fileNewAt->setEnabled(g_Option->useAt);
      }
    }
    if ( dlg->chgFlag & CHG_CLOCK ){
      doc->view->clockWgt->clockView->iniFrame( true );
      doc->dspView();
    }
    if ( dlg->chgFlag & (CHG_CRON|CHG_ANAC|CHG_AT) ){
      doc->pStart( RUN_INIT);
    }else{
      if ( dlg->chgFlag & CHG_LIST ){
        doc->pStart( RUN_INIT );
      }
      if ( dlg->chgFlag & CHG_ELIST ){
        doc->pStart( RUN_LIST_EXEC);
      }
    }
#ifndef CRON_DILLON
    if( dlg->chgFlag & CHG_LLIST ){
      if ( System::access( g_Option->logFile ) & CAN_READ  ){
        if ( ! view->logListEnable ){
          view->listTab->insertTab( view->logLvw, IconFile("listicon"), i18n( "Log" ) );
          view->logListEnable = true;
        }
        doc->pStart( RUN_LIST_LOG);
      }else{
        if ( view->logListEnable ){
          view->listTab->removePage( (QWidget*)view->logLvw );
          view->logListEnable = false;
        }
      }
    }
#endif
  }
  delete dlg;
}

void KronekoApp::slotFileRemExe()
{
  doc->dispExe( fileRemExe->isChecked() );
}

void KronekoApp::slotViewToolBar()
{
  slotStatusMsg(i18n("Toggling toolbar..."));
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  if(!viewToolBar->isChecked())
  {
    toolBar("mainToolBar")->hide();
  }
  else
  {
    toolBar("mainToolBar")->show();
  }		

  slotStatusMsg(i18n("Ready."));
}

void KronekoApp::slotViewStatusBar()
{
  slotStatusMsg(i18n("Toggle the statusbar..."));
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  if(!viewStatusBar->isChecked())
  {
    statusBar()->hide();
  }
  else
  {
    statusBar()->show();
  }

  slotStatusMsg(i18n("Ready."));
}


void KronekoApp::slotStatusMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG);
}

void KronekoApp::slotStatusMsgTotal()
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  QString s;
  KronekoView *v = doc->view;
#ifdef CRON_DILLON
  s.sprintf( " Total:%d Execute:%d ", v->stngLvw->childCount(),
                                      v->execLvw->childCount() );
#else
  if ( v->logLvw ){
    s.sprintf( " Total:%d Execute:%d Log:%d ", v->stngLvw->childCount(),
                                               v->execLvw->childCount(),
                                               v->logLvw->childCount() );
  }else{
    s.sprintf( " Total:%d Execute:%d ", v->stngLvw->childCount(),
                                        v->execLvw->childCount() );
  }
#endif
  statusBar()->changeItem(s, ID_STATUS_TOTAL);
  statusBar()->setItemFixed(ID_STATUS_TOTAL);
}

void KronekoApp::slotStatusMsgUser( const QString& u, int u_t, int e_t, int s_t )
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  QString s;
  s.sprintf( " %s Total:%d Exeute:%d(%d) ", (const char *)u, u_t, s_t, e_t );
  statusBar()->changeItem(s, ID_STATUS_USER);
  statusBar()->setItemFixed(ID_STATUS_USER);

}

void KronekoApp::slotProgressBar( int pgs )
{

  statusProgress->setProgress( pgs );

}



void KronekoApp::slotRuneOfToday()
{

  if ( rune == NULL ) rune = new RuneDlg( g_Option->runeOfDay, this, "" );
  rune->show();
//  rune->raise();

}

